#ifndef _MPxDragAndDropBehavior
#define _MPxDragAndDropBehavior
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxDragAndDropBehavior
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES

#include <maya/MStatus.h>
#include <maya/MTypes.h>
#include <maya/MObject.h>
#include <maya/MPlug.h>

// ****************************************************************************
// DECLARATIONS

class MString;

// ****************************************************************************
// CLASS DECLARATION (MPxDragAndDropBehavior)

//! \ingroup OpenMayaUI MPx
//! \brief Drag and Drop Behavior
/*!

  This is the base class for user defined drag and drop behaviors.
  This class allows a plugin to override the behavior of drag and drop
  connections from nodes in the hyperGraph/hyperShade to other nodes
  or other UI. These behaviors are defined by the type of relationship
  that is trying to be resolved. These are connectAttrToAttr(),
  connectAttrToNode(), connectNodeToAttr(), connectNodeToNode().  In
  order for the overridden methods to be executed the
  shouldBeUsedFor() method must be overridden in order to decide which
  behavior to use given the source and destination node.
*/
class OPENMAYAUI_EXPORT MPxDragAndDropBehavior
{
public:
	MPxDragAndDropBehavior();
	virtual ~MPxDragAndDropBehavior();

	MPxDragAndDropBehavior( void * init );

	virtual bool shouldBeUsedFor( MObject &sourceNode, MObject &destinationNode,
								  MPlug &sourcePlug, MPlug &destinationPlug);

	virtual MStatus connectAttrToAttr( MPlug &sourcePlug, MPlug &destinationPlug, bool force );

	virtual MStatus connectAttrToNode( MPlug &sourcePlug, MObject &destinationNode, bool force );

	virtual MStatus connectNodeToAttr( MObject &sourceNode, MPlug &destinationPlug, bool force );

	virtual MStatus connectNodeToNode( MObject &sourceNode, MObject &destinationNode, bool force );

protected:

private:
	void   setData( void* );
	virtual const char*	className() const;
	void * 	data;

};

#endif /* __cplusplus */
#endif /* _MPxDragAndDropBehavior */
