#ifndef _MPxFileTranslator
#define _MPxFileTranslator
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxFileTranslator
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MString.h>
#include <maya/MTypes.h>
#include <maya/MFileObject.h>

// ****************************************************************************
// CLASS DECLARATION (MPxFileTranslator)

//! \ingroup OpenMaya MPx
//! \brief Base Class for creating Maya File Translators. 
/*!
  This class provides the connection to Maya by which user written file
  translators can be added as plug-ins.

  This class provides a base class from which one derives in order to
  implement Maya "File Translator Plug-Ins."  A file translator
  plug-in allows Maya to read or write 3rd party file formats.

  The identifyFile method is called whenever Maya's file save or
  restore dialogs are run, and identifyFile uses the filename and
  first few bytes of the file to determine whether it is of a type
  supported by the translator.  If it is, then Maya will display the
  file with the "name" and "icon" specified as arguments to
  MFnPlugin::registerFileTranslator.

  If an attempt is made to read the file, the "reader" method in the
  derived class is called, if an attempt is made to write the file,
  the "writer" method is called.
*/
class OPENMAYA_EXPORT MPxFileTranslator
{

public:

	//! How the translator identifies this file
	enum MFileKind {
		kIsMyFileType,		//!< Translator understands how to read/write this file
		kCouldBeMyFileType,	//!< Translator is not best available to read/write this file
		kNotMyFileType		//!< Translator does not understand how to read/write this file
	};

	//! Type of file access
	enum FileAccessMode {
		kUnknownAccessMode,			//!< Unknown file access mode
		kOpenAccessMode,			//!< Import data into new scene
		kReferenceAccessMode,		//!< Reference data into current scene
		kImportAccessMode,			//!< Import data into current scene
		kSaveAccessMode,			//!< Save data
		kExportAccessMode,			//!< Export data
		kExportActiveAccessMode		//!< Export active (selected) data
	};

						MPxFileTranslator ();
	virtual				~MPxFileTranslator ();
	virtual MStatus		reader ( const MFileObject& file,
								 const MString& optionsString,
								 FileAccessMode mode);
	virtual MStatus		writer ( const MFileObject& file,
								 const MString& optionsString,
								 FileAccessMode mode);
	virtual bool		haveReadMethod () const;
	virtual bool		haveWriteMethod () const;
	virtual bool		haveNamespaceSupport () const;
	virtual bool		haveReferenceMethod () const;
	virtual MString     defaultExtension () const;
	virtual MString     filter () const;
	virtual bool        canBeOpened () const;
	virtual MPxFileTranslator::MFileKind identifyFile (	const MFileObject& file,
								const char* buffer, short size) const;
	static MPxFileTranslator::FileAccessMode fileAccessMode();

protected:
// No protected members

private:
	void*				data;
};

#endif /* __cplusplus */
#endif /* _MPxFileTranslator */
