#ifndef _MPxGlBuffer
#define _MPxGlBuffer
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxGlBuffer
//
// ****************************************************************************
//
// CLASS DESCRIPTION (MPxGlBuffer)
//
//  MPxGlBuffer allows the user to create OpenGL buffers that Maya
//	can draw into.  The base class as is defined will create a hardware
//	accellerated off-screen buffer for use on SGI hardware.
//
//  To create a custom buffer, derive from this class and override at
//	least the open, close, drawable, and context classes.  The customized
//	buffer may also require a constructor and destructor to initialize and
//	free its storage correctly.
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

#if defined(__unix) || defined(LINUX)
#include <GL/glx.h>
#endif

// ****************************************************************************
// DECLARATIONS

class MString;
class M3dView;

// ****************************************************************************
// CLASS DECLARATION (MPxGlBuffer)

//! \ingroup OpenMayaUI MPx
//! \brief Base class for user defined GL buffers 
/*!
This is the base class for user defined GL buffers, however; it is seldom
necessary to derive from this class.  It is generally suficient to directly use
it. In cases where creating a child class is desirable, it will only work if
<b>every </b> overridden method calls the parent method at some point in its execution.

There are two basic ways to use this class, to draw to a pbuffer and to draw to an external window:

To draw to a pbuffer:

<ol>
<li> set setDoubleBuffer() to true if a double buffered pbuffer is desired.
<li> use open() to create the pbuffer
<li> use M3dView:refresh() to have Maya draw to the pbuffer.
<li> (optionally) use attributeList(), visual(), display(), drawable() and context() to find out information
   about the configuration of the pbuffer or to do additional drawing to it.
<li> use close() to destroy the pbuffer
</ol>

To draw to an externally defined window:

<ol>
<li> set setDoubleBuffer() to true if a double buffered drawable will be used.
<li> set setUseExternalDrawable() to true
<li> (optionally) use attributeList() to get the appropriate attribute list, use the resulting list to choose a visual and
   call setVisual() to tell Maya about that visual.
<li> (optionally) use setDisplay() to tell Maya what display to use when creating the context
<li> create a drawable X window
<li> call setDrawable() to tell Maya about the drawable.
<li> call open() to create the context
<li> use M3dView:refresh() to have Maya draw to the window
<li> (optionally) use attributeList(), visual(), display(), drawable() and context() to find out information
   about the configuration of the window or to do additional drawing to it.
<li> use close() to destroy the context
</ol>

Note: It is usually a good idea to use the MPxGlBuffer( M3dView &view ) form of the constructor to insure
that the context created is done so correctly.

NOTE: This class only works with the Linux version of Maya.
*/
class OPENMAYAUI_EXPORT MPxGlBuffer
{
public:
	MPxGlBuffer();
	MPxGlBuffer( M3dView &view );
	virtual ~MPxGlBuffer();

#if defined(__unix) || defined(LINUX)
	virtual	MStatus			open( short width, short height,
								  GLXContext shareCtx = NULL );
	virtual GLXDrawable	    drawable( MStatus * ReturnStatus = NULL );
	virtual	GLXContext      context( MStatus * ReturnStatus = NULL );
	virtual	Display *       display( MStatus * ReturnStatus = NULL );
	virtual XVisualInfo *   visual( MStatus * ReturnStatus = NULL );
	virtual int *   		attributeList( MStatus * ReturnStatus = NULL );

	virtual MStatus         setUseExternalDrawable( bool state );
	virtual MStatus         setDoubleBuffer( bool state );
	virtual MStatus         setDisplay( Display * disp );
	virtual MStatus         setDrawable( GLXDrawable drawable );
	virtual MStatus         setVisual( XVisualInfo * vis );

#endif // __unix

	virtual void			beginBufferNotify( );
	virtual void			endBufferNotify( );
	virtual	MStatus			close();

protected:
	bool					hasColorIndex;
	bool					hasAlphaBuffer;
	bool					hasDepthBuffer;
	bool					hasAccumulationBuffer;
	bool					hasDoubleBuffer;
	bool					hasStencilBuffer;

private:
	void   setData( void* );
	virtual const char*	className() const;
	void * 	data;

};

#endif /* __cplusplus */
#endif /* _MPxGlBuffer */
