#ifndef _MRenderLine
#define _MRenderLine
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All 
// rights reserved.
// 
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors,  which is protected by U.S. and Canadian federal copyright law 
// and by international treaties.
// 
// The Data may not be disclosed or distributed to third parties or be 
// copied or duplicated, in whole or in part, without the prior written 
// consent of Autodesk.
// 
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the following 
// disclaimer, must be included in all copies of the Software, in whole 
// or in part, and all derivative works of the Software, unless such copies 
// or derivative works are solely in the form of machine-executable object 
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, 
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO 
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST 
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR 
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS 
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES. 
// ==========================================================================
//+
//
// CLASS:    MRenderLine
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// DECLARATIONS

class MVectorArray;
class MDoubleArray;

// ****************************************************************************
// CLASS DECLARATION (MRenderLine)

//! \ingroup OpenMayaFX
//! \brief Class for accessing paint effects output curve data. 
/*!
	A MRenderLine provides access to paint effects curve rendering info.
	This class contains arrays for per vertex attributes along an individual curve:
	line: the vertices in worldspace
    twist: a twist vector at each vertice
    width: the tube widths
    flatness: the tube flatness along the twist vector direction
    parameter: the u parameterization value for each vertice
    color: color rgb value for each vertice
    incandescence: incandescence rgb value for each vertice
    transpareancy: transparency rgb value for each vertice
*/
class OPENMAYAFX_EXPORT MRenderLine
{
public:
	MRenderLine();
	~MRenderLine();

	MRenderLine&  operator = (const MRenderLine& other );

	// Access Methods
	MVectorArray getLine() const;
	MVectorArray getTwist() const;
	MDoubleArray getWidth() const;
	MDoubleArray getFlatness() const;
	MDoubleArray getParameter() const;
	MVectorArray getColor() const;
	MVectorArray getIncandescence() const;
	MVectorArray getTransparency() const;

protected:
// No protected members

private:
	static const char* className();
	MRenderLine( void* );
	void * fData;
};

#endif /* __cplusplus */
#endif /* _MRenderLine */
