#ifndef _MRenderShadowData
#define _MRenderShadowData
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MRenderShadowData
//
// ****************************************************************************

#if defined __cplusplus


#include <maya/MFloatPoint.h>
#include <maya/MFloatMatrix.h>

//! \ingroup OpenMayaRender
//! \brief Access Rendering Shadow Map Data
/*!

  The shadow map can be changed by instanciating a MRenderCallback and
  overriding shadowCastCallback(). When this is invoked, a
  MRenderShadowData is passed as an argument; the depthMaps and
  midDistMaps members can then be changed by this API. Methods and
  data are provided to assist in transforming back and forth from
  world space to z buffer space. Paint Effects and Fur are two
  examples which use this mechanism to change the shadow map.

  To prevent self shadowing, Maya uses a mid distance map to resolve
  the ambiguity. Details of this technique can be obtained from
  Graphics Gems III, "The Shadow Depth Map Revisited".
*/
class OPENMAYARENDER_EXPORT MRenderShadowData {
public:
						MRenderShadowData();

    void                worldToZbuffer(
                            const MFloatPoint&  worldPoint,
                            MFloatPoint&        screenPoint) const;

    void                zbufferToWorld(
                            const MFloatPoint& screenPoint,
                            MFloatPoint&        worldPoint) const;

    // in data
	//! set if the light has a perspective projection
    bool                perspective;
	//! set if the light generates a depth and midDist map
    bool                useMidDistMap;

    //! Light Types
    enum LightType
    {
        kInvalid,	//!< \nop
        kPoint,		//!< \nop
        kDirectional,	//!< \nop
        kSpot		//!< \nop
    };

	//! the type of light the shadow map is generated for
    LightType           lightType;

	//! the x resolution of shadow map
    unsigned short      shadowResX;
	//! the y resolution of the shadow map
    unsigned short      shadowResY;
	//! position of the light in world space
    MFloatPoint         lightPosition;
	//! projection matrix for the light
    MFloatMatrix        projectionMatrix;
	//! perspective matrix for the light
    MFloatMatrix        perspectiveMatrix;

    // out data
	//! the output depth map
    float               *depthMaps;
	//! the output mid distance map
    float               *midDistMaps;

    // private
    const void*         internalData;

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MRenderShadowData */

