#ifndef _MVaryingParameter
#define _MVaryingParameter
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MVaryingParameter
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>
#include <maya/MString.h>

class MGeometry;

// ****************************************************************************
// CLASS DECLARATION (MVaryingParameter)

//! \ingroup OpenMayaRender
//! \brief Geometric data cache.
/*!

  The MVaryingParameter class provides a high-level interface to
  hardware shader varying parameters. By defining your shader's
  varying data through this class, you allow Maya to handle the
  attributes, editing, serialisation, requirements setup, and cache
  management for you in a standard way that ensure you'll be able to
  leverage future performance and functionlity improvements.

  At setup time (either initial load or when the effect/technique is
  changed), your shader simply creates the list of parameters it
  requires, specifying the name, type, semantic of the parameters. At
  render time, you can then use the parameters to directly access the
  appropriate buffers for that surface data.

  If you include a custom Attribute Editor template for your shader
  node, you can include these surface parameters by calling the
  AEhwShaderTemplateParameters script function. The following sample
  code provides a basic template you can modify - however your AE
  template can use as much or as little of this as you like:

\code
global int $yourShaderNameTemplateInitialised = 0;

global proc AEyourShaderNameTemplate ( string $node )
{
	global int $yourShaderNameTemplateInitialised;
	if( $yourShaderNameTemplateInitialised == 0)
	{
		source "AEhwShaderTemplate.mel";
		$yourShaderNameTemplateInitialised = 1;
	}

	AEhwShaderTemplateHeader( $node);

	// Insert custom attributes between the swatch and the parameters here

	AEhwShaderTemplateParameters( $node);

	// Insert custom attributes after the parameters here

	AEhwShaderTemplateFooter( $node);
}
\endcode
*/
class OPENMAYARENDER_EXPORT MVaryingParameter
{
public:
	//! Parameter types.
	typedef enum
	{
		// Warning - make sure you modify the internal version when changing this!

		kInvalidParameter = -1,	//!< \nop
		kStructure = 0,		//!< \nop
		kFloat			//!< \nop
	} MVaryingParameterType;

	//! Parameter semantics (i.e. what the parameter represents).
	typedef enum
	{
		// Warning - make sure you modify the internal version when changing this!

		kNoSemantic = 0,	//!< \nop
		kPosition,		//!< \nop
		kNormal,		//!< \nop
		kTexCoord,		//!< \nop
		kColor,			//!< \nop
		kWeight,		//!< \nop
		kTangent = kWeight + 2,	//!< \nop
		kBinormal,		//!< \nop
	} MVaryingParameterSemantic;

	MVaryingParameter();

	MVaryingParameter( const MString& name,
						MVaryingParameterType type,
						int minElements = 1,
						int maxElements = 1,
						MVaryingParameterSemantic semantic = kNoSemantic,
						bool invertTexCoords = false);

	~MVaryingParameter();

	const MVaryingParameter& operator=( const MVaryingParameter& other);

	const MString&	name() const;

	MVaryingParameter::MVaryingParameterType type() const;

	MVaryingParameter::MVaryingParameterSemantic semantic() const;

	MStatus			getBuffer( MGeometry& geometry, const void*& data, unsigned int& elements, unsigned int& count) const;

	MVaryingParameter::MVaryingParameterSemantic getSourceType() const;

	MString			getSourceSetName() const;

	MStatus			setSource( MVaryingParameter::MVaryingParameterSemantic type, const MString& setName);

	unsigned int	getElementSize() const;

	unsigned int	getMaximumStride() const;

	MStatus			addElement( const MVaryingParameter& child);

	unsigned int	numElements() const;

	MVaryingParameter getElement( unsigned int i) const;

	MStatus			removeElements();

protected:

	MVaryingParameter( void* ptr);

	void*			_ptr;

private:
// No private members

	friend class MVaryingParameterList;
};

#endif
#endif // _MVaryingParameter
