#ifndef _MAnimControl
#define _MAnimControl
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// ****************************************************************************
//
// CLASS:    MAnimControl
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTime.h>
#include <maya/MTypes.h>
#include <maya/MFnAnimCurve.h>

// ****************************************************************************
// CLASS DECLARATION (MAnimControl)

//! \ingroup OpenMayaAnim
//! \brief Control over animation playback and values 
/*!
  This class provide access to the values that control how an
  animation is played.  This includes the minimum and maximum frames
  included in the playback, whether the playback loops, and whether
  the animation runs in all views, or only the active view, etc.

  Methods also exist that mirror the functionality of the controls
  found on the time slider in the UI to start and stop the playback.
*/
class OPENMAYAANIM_EXPORT MAnimControl
{
public:

	//! Animation playback modes.
	enum PlaybackMode {
		kPlaybackOnce,			//!< Play once then stop.
		kPlaybackLoop,			//!< Play continuously.
		kPlaybackOscillate		//!< Play forwards, then backwards continuously.
	};

	//! Animation playback viewing modes.
	enum PlaybackViewMode {
		kPlaybackViewAll,		//!< Playback in all views
		kPlaybackViewActive		//!< Playback in only the active view
	};


											MAnimControl();
	virtual									~MAnimControl();
	static MAnimControl::PlaybackMode		playbackMode();
	static MStatus							setPlaybackMode( PlaybackMode
															 newMode );
	static MAnimControl::PlaybackViewMode	viewMode();
	static MStatus							setViewMode( PlaybackViewMode
														 newMode );
	static double							playbackBy();
	static MStatus							setPlaybackBy( const double& newTime );
	static MTime							minTime();
	static MTime							maxTime();
	static MStatus							setMinTime( MTime newMinTime );
	static MStatus							setMaxTime( MTime newMaxTime );
	static MStatus							setMinMaxTime( MTime min,
														   MTime max );
	static MTime							animationStartTime();
	static MTime							animationEndTime();
	static MStatus							setAnimationStartTime( MTime newStartTime );
	static MStatus							setAnimationEndTime( MTime newEndTime );
	static MStatus							setAnimationStartEndTime( MTime newStartTime,
														   MTime newEndTime );
	static MTime							currentTime();
	static MStatus							setCurrentTime( const MTime&
															newTime );
	static double							playbackSpeed();
	static MStatus							setPlaybackSpeed( double newSpeed );
	static MStatus							playForward();
	static MStatus							playBackward();
	static bool								isPlaying();
	static MStatus							stop();
	static bool			autoKeyMode ();
	static MStatus		setAutoKeyMode ( bool mode );
	static MFnAnimCurve::TangentType globalInTangentType (
												MStatus * ReturnStatus = NULL );
	static MStatus		setGlobalInTangentType (const MFnAnimCurve::TangentType
												&tangentType );
	static MFnAnimCurve::TangentType globalOutTangentType (
												MStatus * ReturnStatus = NULL );
	static MStatus		setGlobalOutTangentType (const MFnAnimCurve::TangentType
												 &tangentType );
	static bool			weightedTangents( MStatus * ReturnStatus = NULL );
	static MStatus		setWeightedTangents( bool weightState );

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MAnimControl */
