#ifndef _MArrayDataBuilder
#define _MArrayDataBuilder
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MArrayDataBuilder
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>
#include <maya/MDataHandle.h>
#include <maya/MArrayDataHandle.h>

// ****************************************************************************
// FORWARD DECLARATIONS

class MDataBlock;
class MArrayDataHandle;

// ****************************************************************************
// CLASS DECLARATION (MArrayDataBuilder)

//! \ingroup OpenMaya
//! \brief Array builder for arrays in data blocks. 
/*!
  An MArrayDataBuilder is used to construct data for attributes/plugs that
  have an array of data.  An array builder is used with an MArrayDataHandle
  for managing data.
*/
class OPENMAYA_EXPORT MArrayDataBuilder
{

public:
    //! Obsolete ...
	MArrayDataBuilder ( const MObject & attribute, unsigned int numElements,
						MStatus * ReturnStatus = NULL );

	MArrayDataBuilder ( MDataBlock *, const MObject &attribute, unsigned int,
						MStatus * ReturnStatus = NULL );

	MDataHandle      addLast(MStatus * ReturnStatus = NULL);
	MDataHandle      addElement( unsigned int index,
								 MStatus * ReturnStatus = NULL );
	MArrayDataHandle addLastArray(MStatus * ReturnStatus = NULL );
	MArrayDataHandle addElementArray( unsigned int index,
									  MStatus * ReturnStatus = NULL  );
	MStatus          removeElement( unsigned int index );
	unsigned int         elementCount( MStatus * ReturnStatus = NULL ) const;
	MStatus          growArray( unsigned int amount );
	MStatus          setGrowSize( unsigned int size );

    MArrayDataBuilder( const MArrayDataBuilder &other );
	MArrayDataBuilder& operator=( const MArrayDataBuilder& other );
    ~MArrayDataBuilder();

protected:
// No protected members

private:
	void constructClass(MDataBlock *, const MObject &attribute, unsigned int,
						MStatus * ReturnStatus = NULL );
	const char*		className() const;
	friend class MArrayDataHandle;
	MArrayDataBuilder();
	MArrayDataBuilder( void* );
#ifdef MBits64_
	char data[48];
#else
	char data[32];
#endif
	bool fIsNull;
};

#endif /* __cplusplus */
#endif /* _MArrayDataBuilder */
