#ifndef _MAttributeIndex
#define _MAttributeIndex
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MAttributeIndex
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>
#include <maya/MStatus.h>

// ****************************************************************************
// CLASS DECLARATION (MAttributeIndex)

//! \ingroup OpenMaya
//! \brief The index information for an attribute specification. 
/*!
Class that provides access to the index part of an attribute
specification (MAttributeSpec).

See MAttributeSpec for more information.
*/
class OPENMAYA_EXPORT MAttributeIndex {
public:
	//! Data types for attribute indices.
	enum MIndexType {
		kInteger,	//!< Integer index (e.g. mesh.cp[5])
		kFloat		//!< Floating-poing index (e.g. curve.u[1.3])
	};

	MAttributeIndex();
	~MAttributeIndex();
	MAttributeIndex( const MAttributeIndex & other );
	MAttributeIndex( int value );
	MAttributeIndex( double value );

public:
	MIndexType		type() const;
	bool			hasRange() const;
	bool			hasValidRange() const;

	bool			hasLowerBound() const;
	bool			hasUpperBound() const;
	MStatus			getLower( int & value ) const;
	MStatus			getLower( double & value ) const;
	MStatus			getUpper( int & value ) const;
	MStatus			getUpper( double & value ) const;

	bool			isBounded() const;
	MStatus			getValue( int & value ) const;
	MStatus			getValue( double & value ) const;

public:
	MStatus			setType( MIndexType type);
	MStatus			setValue( int value );
	MStatus			setValue( double value );
	MStatus			setLower( int value );
	MStatus			setLower( double value );
	MStatus			setUpper( int value );
	MStatus			setUpper( double value );

public:
	MAttributeIndex & operator=( const MAttributeIndex & other );
	bool			operator==( const MAttributeIndex & other ) const;
	bool			operator!=( const MAttributeIndex & other ) const;

private:
	MAttributeIndex( void* );
	friend class MAttributeSpec;
	void*	data;
	bool	own;
	static const char* className();
};

#endif /* __cplusplus */
#endif /* _MAttributeIndex */
