#ifndef _MCursor
#define _MCursor
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MCursor
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>

// ****************************************************************************
// CLASS DECLARATION (MCursor)

//! \ingroup OpenMayaUI
//! \brief Manipulate Cursors 
/*!
  The MCursor class implements a cursor class, and is used to pass
  all cursor arguments to Maya API methods.

  The cursor image and mask are stored in xbm format to the constructor
  along with the cursor dimensions and the cursor hotspot.
*/
class OPENMAYAUI_EXPORT MCursor
{
public:
#ifdef _WIN32
	//! Windows-only.
				MCursor( LPCSTR pszResource );
#endif
				MCursor(short width,
						short height,
						short hotSpotX,
						short hotSpotY,
						unsigned char * bits,
						unsigned char * mask );
				MCursor(const MCursor& other);
	        	~MCursor();

	MCursor &	operator=(const MCursor &);
	bool		operator==(const MCursor &) const;
	bool		operator!=(const MCursor &) const;
	//! Maya default cursor, the left arrow.
	static		MCursor	defaultCursor;
	//! '+' cursor.
	static		MCursor	crossHairCursor;
	//! '+' cursor with double lines.
	static		MCursor	doubleCrossHairCursor;
	//! Wedge-shaped arrow pointing left.
	static		MCursor	editCursor;
	//! Pencil shape.
	static		MCursor	pencilCursor;
	//! Open hand shaped cursor.
	static		MCursor	handCursor;

protected:
// No protected members

private:
				MCursor();
				MCursor(const void *);
	const void*	apiData;
	const void* apiData2;
};

#endif /* __cplusplus */
#endif /* _MCursor */
