#ifndef _MDistance
#define _MDistance
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MDistance
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// CLASS DECLARATION (MDistance)

//! \ingroup OpenMaya
//! \brief Manipulate Linear Data. 
/*!
The MDistance class provides a fundamental type for the Maya API to hold
and manipulate linear data.  All API methods that require or return
distance information do so through variables of this type.
*/
class OPENMAYA_EXPORT MDistance
{
public:
	//! Available Unit Systems
	enum Unit
	{
		kInvalid,
		//! Inches
		kInches,
		//! Feet
		kFeet,
		//! Yards
		kYards,
		//! Miles
		kMiles,
		//! Millimeters
		kMillimeters,
		//! Centimeters
		kCentimeters,
		//! Kilometers
		kKilometers,
		//! Meters
		kMeters,
		kLast
	};
					MDistance();
					MDistance( double value, Unit unitSystem = kCentimeters );
					MDistance( const MDistance& src );
					~MDistance();
	MDistance&		operator=( const MDistance& src );
	Unit			unit() const;
	double			value() const;
	MStatus			setUnit( Unit newUnit );
	MStatus			setValue( double newValue );

BEGIN_NO_SCRIPT_SUPPORT:
	double			as( Unit newUnit, MStatus *ReturnStatus = NULL ) const;
END_NO_SCRIPT_SUPPORT:

	double          asUnits( Unit newUnit, MStatus *ReturnStatus = NULL ) const;
	double			asInches() const;
	double			asFeet() const;
	double			asYards() const;
	double			asMiles() const;
	double			asMillimeters() const;
	double			asCentimeters() const;
	double			asKilometers() const;
	double			asMeters()  const;
	static Unit		uiUnit();
	static MStatus	setUIUnit( Unit newUnit );
	static Unit		internalUnit();
	static double	internalToUI( double internalValue );
	static double	uiToInternal( double uiValue );

	// Obsolete
	// Changing the internal units is generally not a good idea and
	// using this method may often produce unexpected results.
	static MStatus  setInternalUnit( Unit internalUnit );

protected:
	double			val;
	Unit			valUnit;

private:

	static const char* className();

};

#endif /* __cplusplus */
#endif /* _MDistance */
