#ifndef _MDrawRequestQueue
#define _MDrawRequestQueue
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MDrawRequestQueue
//
// ****************************************************************************
//
#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>
#include <maya/MObject.h>
#include <maya/MDrawRequest.h>

// ****************************************************************************
// CLASS DECLARATION (MDrawRequestQueue)

//! \ingroup OpenMayaUI
//! \brief Drawing queue used in MPxSurfaceShapeUI::getDrawRequests
/*!
This class defines a simple interface for a collection of
MDrawRequest objects.

An MDrawRequestQueue object is passed to the getDrawRequests method
of a user defined shape's UI class (MPxSurfaceShapeUI).
This queue keeps track of all the things that need to get draw
when a refresh of the view occurs.

Maya will call the getDrawRequest methods of all the visible DAG objects
before a refresh happens. Then as the refresh happens, each draw request
will be processed and the corresponding draw method for each DAG
object will get called. For user defined shapes MPxSurfaceShapeUI::draw
will get called.
*/
class OPENMAYAUI_EXPORT MDrawRequestQueue
{
public:
	MDrawRequestQueue();
	~MDrawRequestQueue();

public:
	bool			isEmpty() const;
	void			add( MDrawRequest & );
	MDrawRequest	remove();

	MDrawRequestQueue( const MDrawRequestQueue & );
	MDrawRequestQueue & operator=( const MDrawRequestQueue & );

protected:
// No protected members

private:
	bool			isInternalQueue() const; 
	void			cleanup();
	const char*		className() const;
    MDrawRequestQueue( void* in );
	void*			fDrawRequestQueue;
};

#endif /* __cplusplus */
#endif /* _MDrawRequestQueue */
