#ifndef _MEvent
#define _MEvent
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MEvent
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>

// ****************************************************************************
// DECLARATIONS

class MDeviceState;

// ****************************************************************************
// CLASS DECLARATION (MEvent)

//! \ingroup OpenMayaUI
//! \brief System event information
/*!
The MEvent class is used for querying system events such as mouse presses.

Events are handled by an MPxContext derived class in which MEvents are passed
and can be accessed.

Since Maya has default actions for several events, only a subset are avalaible
through the API.
The events that can be accessed are:

\li <b>buttonPress</b>       - mouse button press event (left & middle only)
\li <b>buttonRelease</b>     - mouse buttons release event (left & middle only)
\li <b>mouseDrag</b>         - mouse button drag event (left & middle only)
\li <b>hold</b>              - mouse button hold event (left & middle only)
\li <b>deleteEvent</b>       - delete/backspace key event
\li <b>commandCompletion</b> - complete key event

Several modifiers for events are also accessible through the API.  Modifiers
are actions that occur during an event.  For example, holding down the shift
key while pressing a mouse button causes a button press event to occur with
a shift modifier.

A modifier can be used to determine if two mouse events occur simulaneously.
The second mouse event is registered as a modifier in the hold event of the
first mouse button.  So if you wanted to determine if both the left and middle
buttons are pressed then you would query the modifier in the hold event
of the first mouse button using the isModifierMiddleMouseButton() and
isModifierLeftMouseButton() methods.
*/
class OPENMAYAUI_EXPORT MEvent
{
public:
    //! Modifier key types.
    enum ModifierType {
        shiftKey    = 1<<0,	//!< \nop
        controlKey  = 1<<2	//!< \nop
    };

    	//! Mouse button types.
	enum MouseButtonType {
		kLeftMouse		= 1<<6,	//!< \nop
		kMiddleMouse	= kLeftMouse<<1	//!< \nop
	};

public:
    MEvent();
    virtual ~MEvent();

    MStatus         getPosition( short& x_pos, short& y_pos ) const;
    MStatus         setPosition( short x_pos, short y_pos );
    MStatus         getWindowPosition( short& x_pos, short& y_pos ) const;
    MouseButtonType mouseButton( MStatus * ReturnStatus = NULL ) const;
    bool            isModifierKeyRelease( MStatus * ReturnStatus = NULL ) const;
    ModifierType    modifiers( MStatus * ReturnStatus = NULL ) const;
    MStatus         setModifiers( const ModifierType& modType );
    bool            isModifierNone( MStatus * ReturnStatus = NULL ) const;
    bool            isModifierShift( MStatus * ReturnStatus = NULL ) const;
    bool            isModifierControl( MStatus * ReturnStatus = NULL ) const;
    bool            isModifierLeftMouseButton( MStatus * ReturnStatus = NULL )
					const;
    bool            isModifierMiddleMouseButton( MStatus * ReturnStatus = NULL )
					const;

protected:
// No protected members

private:
    static const char* className();


    MEvent( const void * );
    const void * fEventPtr;
    void * fModifier;
};

#endif /* __cplusplus */
#endif /* _MEvent */
