#ifndef _MFileIO
#define _MFileIO
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFileIO
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MObject.h>
#include <maya/MPlugArray.h>
#include <maya/MStatus.h>
#include <maya/MString.h>
#include <maya/MStringArray.h>
#include <maya/MSelectionList.h>
#include <maya/MTypes.h>

// ****************************************************************************
// DECLARATIONS

class MPxFileTranslator;

// ****************************************************************************
// CLASS DECLARATION (MFileIO)

//! \ingroup OpenMaya
//! \brief I/O operations on scene files. 
/*!
  Methods for opening, saving, importing, exporting and referencing files.

  The MFileIO class provides a set of global functions that can be used to
  load and store scene elements into maya files.  Methods are also provided
  to import elements from other files into the current scene, and export
  elements of the current scene into files.  As well, references to other
  files can be created and removed.

  This class implements only the most common operations from the full set
  possible with the MEL command "file."  See the documentation of this
  command for a complete listing of all the possiblities.  If more control
  is required than provided by this class, a MEL command can be constructed
  according to the instructions for the "file" command, and issued via the
  executeCommand method of the MGlobal class.
*/
class OPENMAYA_EXPORT MFileIO
{
public:
	//! Specifies which references to load.
	enum ReferenceMode {
		kLoadDefault,	//!< Load references that were loaded when scene was saved.
		kLoadAllReferences,	//!< Load all references in the scene.
		kLoadNoReferences	//!< Don't load any references.
	};

						MFileIO ();
						MFileIO ( const MString& fileName );
	virtual				~MFileIO ();
	static MString		currentFile ();
	static MStatus		setCurrentFile ( const MString& fileName );
	static MString		fileType();
	static MStatus		getFileTypes ( MStringArray& types );
	static MStatus		newFile ( bool force = false );
	static MStatus		open ( const MString& fileName,
							   const char* type = NULL,
							   bool force = false,
							   ReferenceMode refMode = kLoadDefault,
							   bool ignoreVersion = false );
	static MStatus		save ( bool force = false );
	static MStatus		saveAs ( const MString& fileName,
							     const char* type = NULL,
								 bool force = false );
	static MStatus		importFile ( const MString& fileName,
								 const char* type = NULL,
								 bool  preserveReferences = false,
								 const char* nameSpace = NULL);
	static MStatus		exportSelected ( const MString& fileName,
								 const char* type = NULL,
								 bool preserveReferences = false);
	static MStatus		exportAll ( const MString& fileName,
								 const char* type = NULL,
								 bool preserveReferences = false);
	static MStatus		exportAnimFromReference ( const MString& fileName, const char* type = NULL);
	static MStatus		exportAnimFromReference ( const MString& fileName, const MString& refNodeName, const char* type = NULL);
	static MStatus		exportSelectedAnimFromReference ( const MString& fileName, const char* type = NULL);
	static MStatus		exportSelectedAnimFromReference ( const MString& fileName, const MString& refNodeName, const char* type = NULL);
	static MStatus		exportAnim ( const MString& fileName, const char* type = NULL);
	static MStatus		exportSelectedAnim ( const MString& fileName, const char* type = NULL);
	static MStatus		exportAsReference ( const MString& fileName, const char* type = NULL);
	static MStatus		getReferences ( MStringArray& references, 
										bool wantUnresolvedNames = false );
	static MStatus		getFiles( MStringArray& files,
								  bool wantUnresolvedNames = false,
								  bool wantReferencesOnly = false );
	static MStatus		getReferenceNodes ( const MString &fileName,
											MStringArray& nodes );
	static MStatus		getReferenceNodes ( const MString &fileName, 
											MSelectionList& list);	
	static MStatus		getReferenceConnectionsMade ( const MString &fileName,
													  MStringArray& connections );
	static MStatus		getReferenceConnectionsBroken(
							const MString&	fileName,
							MStringArray&	connections
						);
	static MStatus		getReferenceConnectionsBroken(
							const MString&	fileName,
							MPlugArray&		srcPlugs,
							MPlugArray&		destPlugs
						);
	static MStatus		getReferenceConnectionsBroken(
							const MObject&	node,
							MStringArray&	connections,
							bool			append = false,
							bool			removeDuplicates = true
						);
	static MStatus		getReferenceConnectionsBroken(
							const MObject&	node,
							MPlugArray&		srcPlugs,
							MPlugArray&		destPlugs,
							bool			append = false,
							bool			removeDuplicates = true
						);
	static MStatus		reference ( const MString& fileName, bool deferReference = false, bool lockReference = false );
	static MStatus		removeReference ( const MString& fileName );
	static bool			isReadingFile();
	static bool			isWritingFile();
	static bool			isOpeningFile();
	static bool			isNewingFile();
	static bool			mustRenameToSave(MStatus *ReturnStatus = NULL);
	static MStatus		setMustRenameToSave(bool);
	static MString		mustRenameToSaveMsg(MStatus *ReturnStatus = NULL);
	static MStatus		setMustRenameToSaveMsg(const MString &);
	static MString		beforeOpenFilename(MStatus * ReturnStatus = NULL);
	static MString		beforeImportFilename(MStatus * ReturnStatus = NULL);
	static MString		beforeSaveFilename(MStatus * ReturnStatus = NULL);
	static MString		beforeExportFilename(MStatus * ReturnStatus = NULL);
	static MString		beforeReferenceFilename(MStatus * ReturnStatus = NULL);

	static MPxFileTranslator*	beforeOpenUserFileTranslator(MStatus* ReturnStatus = NULL);
	static MPxFileTranslator*	beforeImportUserFileTranslator(MStatus* ReturnStatus = NULL);
	static MPxFileTranslator*	beforeSaveUserFileTranslator(MStatus* ReturnStatus = NULL);
	static MPxFileTranslator*	beforeExportUserFileTranslator(MStatus* ReturnStatus = NULL);
	static MPxFileTranslator*	beforeReferenceUserFileTranslator(MStatus* ReturnStatus = NULL);

	static MString		getLastTempFile(MStatus * ReturnStatus = NULL);
	static bool			getErrorStatus(MStatus * ReturnStatus = NULL);
	static MStatus		resetError();

	static MString		loadReference(const MString& referenceFileName, MStatus *returnStatus = NULL);
	static MString		loadReferenceByNode(const MString& referenceNodeName, MStatus *returnStatus = NULL);
	static MString		loadReferenceByNode(MObject& referenceNode, MStatus *returnStatus = NULL);

	static MString		unloadReference(const MString& referenceFileName, MStatus *returnStatus = NULL);
	static MString		unloadReferenceByNode(const MString& referenceNodeName, MStatus *returnStatus = NULL);
	static MString		unloadReferenceByNode(MObject& referenceNode, MStatus *returnStatus = NULL);
	static MString		getReferenceFileByNode(MObject& referenceNode, MStatus *returnStatus = NULL);
	static MStatus		cleanReference(const MString& referenceNodeName, const char* editCommand = NULL, MStatus *returnStatus = NULL);
	static MStatus		saveReference(const MString& referenceNodeName, MStatus *returnStatus = NULL);

	static MString		fileCurrentlyLoading ();
	static bool			isImportingFile();

BEGIN_NO_SCRIPT_SUPPORT:

	// Obsolete & no script support
	static MStatus		import ( const MString& fileName,
								 const char* type = NULL,
								 bool  preserveReferences = false,
								 const char* nameSpace = NULL);

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
	static const char* 	className();

};

#endif /* __cplusplus */
#endif /* _MFileIO */
