#ifndef _MFnAttribute
#define _MFnAttribute
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnAttribute
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnBase.h>
#include <maya/MFnData.h>

// ****************************************************************************
// DECLARATIONS

class MTypeId;
class MString;

// ****************************************************************************
// CLASS DECLARATION (MFnAttribute)

//! \ingroup OpenMaya MFn
//! \brief Dependency node attribute function set. 
/*!
  MFnAttribute is the function set for dependency node attributes.

  An attribute of a dependency node describes a piece of data that belongs to
  nodes of that type.  For example, a node that makes a sphere might have a
  radius attribute.  A node's attributes describe connections sites on the node
  that can be used in the dependency graph.

  Attributes typically belong to a class of nodes, rather than to an individual
  node.  For example, all sphere nodes have a radius.  Even though a single
  attribute may be shared by all nodes of a given type, each node will have
  its own value for the attribute.

  Attributes are heirarchical.  For example, the translate scale attribute of a
  transform has x, y, and z child attributes.

  By default, attributes are:

  \li Readable.
  \li Writable.
  \li Connectable.
  \li Storable.
  \li Cached.
  \li Not arrays.
  \li Have indices that matter.
  \li Do not use an array builder.
  \li Not keyable.
  \li Not hidden.
  \li Not used as colors.
  \li Not indeterminant.
  \li Set to disconnect behavior kNothing.
*/
class OPENMAYA_EXPORT MFnAttribute : public MFnBase
{
	declareMFn(MFnAttribute, MFnBase);

public:

	//! Attribute behaviour on disconnect.
	enum DisconnectBehavior {
		kDelete,		//!< Delete array element (array attributes only).
		kReset,			//!< Reset the attribute to its default.
		kNothing		//!< Do nothing to the attribute's value.
	};

	bool		isReadable( MStatus* ReturnStatus=NULL ) const;
	bool		isWritable( MStatus* ReturnStatus=NULL ) const;
	bool		isConnectable( MStatus* ReturnStatus=NULL ) const;
	bool		isStorable( MStatus* ReturnStatus=NULL ) const;
	bool		isCached( MStatus* ReturnStatus=NULL ) const;
	bool		isArray( MStatus* ReturnStatus=NULL ) const;
	bool		indexMatters( MStatus* ReturnStatus=NULL ) const;
	bool		isKeyable( MStatus* ReturnStatus=NULL ) const;
	bool		isChannelBoxFlagSet( MStatus* ReturnStatus=NULL ) const;
	bool		isHidden( MStatus* ReturnStatus=NULL ) const;
	bool		isUsedAsColor( MStatus* ReturnStatus=NULL ) const;
	bool		isIndeterminant( MStatus* ReturnStatus=NULL ) const;
	bool		isRenderSource( MStatus* ReturnStatus=NULL ) const;
	bool		isDynamic( MStatus* ReturnStatus=NULL ) const;
	bool		isWorldSpace( MStatus* ReturnStatus=NULL ) const;
	bool		isAffectsWorldSpace( MStatus* ReturnStatus=NULL ) const;

	DisconnectBehavior disconnectBehavior( MStatus* ReturnStatus=NULL ) const;
	bool        usesArrayDataBuilder( MStatus* ReturnStatus=NULL ) const;
	bool     	internal( MStatus* ReturnStatus=NULL ) const;

	MStatus		setReadable( bool state );
	MStatus		setWritable( bool state );
	MStatus		setConnectable( bool state );
	MStatus	 	setStorable( bool state );
	MStatus		setCached( bool state );
	MStatus	 	setArray( bool state );
	MStatus	 	setIndexMatters( bool state );
	MStatus	 	setKeyable( bool state );
	MStatus	 	setChannelBox( bool state );
	MStatus	 	setHidden( bool state );
	MStatus		setUsedAsColor( bool state );
	MStatus		setIndeterminant( bool state );
	MStatus		setRenderSource( bool state );
	MStatus		setWorldSpace( bool state );
	MStatus		setAffectsWorldSpace( bool state );

	MStatus     setDisconnectBehavior( DisconnectBehavior behavior );
	MStatus     setUsesArrayDataBuilder( bool state );
	MStatus     setInternal( bool state );
	bool		accepts( MFnData::Type type, MStatus* ReturnStatus=NULL ) const;
	bool		accepts( const MTypeId& id, MStatus* ReturnStatus=NULL ) const;
	MObject		parent(MStatus* ReturnStatus=NULL) const;
	MStatus		setParent( const MObject & parent );
    MString     name( MStatus* ReturnStatus=NULL ) const;
    MString     shortName( MStatus* ReturnStatus=NULL ) const;
	MString		getAddAttrCmd(
					bool			useLongName = false,
					MStatus*		status=NULL
				) const;

BEGIN_NO_SCRIPT_SUPPORT:

	//!	NO SCRIPT SUPPORT
 	declareMFnConstConstructor( MFnAttribute, MFnBase );

END_NO_SCRIPT_SUPPORT:

	// INTERNAL USE ONLY
	bool		isUsedAsFilename( MStatus* ReturnStatus=NULL ) const;
	// INTERNAL USE ONLY
	MStatus		setUsedAsFilename( bool state );

protected:
	void * ca[4];
	void setPtr( MPtrBase* );

private:
	virtual bool objectChanged( MFn::Type, MStatus * );
};

#endif /* __cplusplus */
#endif /* _MFnAttribute */
