#ifndef _MFnField
#define _MFnField
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnField
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnDagNode.h>

// ****************************************************************************
// DECLARATIONS

class MPointArray;
class MVectorArray;
class MDoubleArray;

// ****************************************************************************
// CLASS DECLARATION (MFnField)

//! \ingroup OpenMayaFX
//! \brief Function set for Dynamic Fields
/*!
  Function set for creation, edit, and query of Dynamic Fields.

  There are several types of dynamic fields: Air, Drag, Gravity,
  Newton Radial, Turbulence, Uniform, and Vortex.
*/
class OPENMAYAFX_EXPORT MFnField : public MFnDagNode
{
    declareDagMFn(MFnField, MFnDagNode);

public:
    MStatus getForceAtPoint(const MPointArray&   point,
                            const MVectorArray&  velocity,
                            const MDoubleArray&  mass,
                            MVectorArray&        force,
							double deltaTime = 1.0 / 24.0 );
    MStatus getForceAtPoint(const MVectorArray&  point,
                            const MVectorArray&  velocity,
                            const MDoubleArray&  mass,
                            MVectorArray&        force,
							double deltaTime = 1.0 / 24.0 );
    double       magnitude          ( MStatus *ReturnStatus = NULL ) const;
    MStatus      setMagnitude       ( double mag );
    double       attenuation        ( MStatus *ReturnStatus = NULL ) const;
    MStatus      setAttenuation     ( double atten );
    double       maxDistance        ( MStatus *ReturnStatus = NULL ) const;
    MStatus      setMaxDistance     ( double maxDist );
    bool         perVertex          ( MStatus *ReturnStatus = NULL ) const;
    MStatus      setPerVertex       ( bool enable );
    bool         useMaxDistance     ( MStatus *ReturnStatus = NULL ) const;
    MStatus      setUseMaxDistance  ( bool enable );
    double       falloffCurve       ( const double param, MStatus *ReturnStatus = NULL );
    bool         isFalloffCurveConstantOne       (MStatus *ReturnStatus = NULL);

BEGIN_NO_SCRIPT_SUPPORT:

 	declareDagMFnConstConstructor( MFnField, MFnDagNode );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members
private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnField */
