#ifndef _MFnMatrixAttribute
#define _MFnMatrixAttribute
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnMatrixAttribute
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnAttribute.h>

// ****************************************************************************
// DECLARATIONS

class MString;
class MMatrix;
class MFloatMatrix;

// ****************************************************************************
// CLASS DECLARATION (MFnMatrixAttribute)

//! \ingroup OpenMaya MFn
//! \brief Matrix attribute function set.
/*!
  Function object for matrix attributes. These attributes accept
  either a matrix of float values or double values depending on the
  type specified to the create method.
*/
class OPENMAYA_EXPORT MFnMatrixAttribute : public MFnAttribute
{
	declareMFn(MFnMatrixAttribute, MFnAttribute);

public:

	//! Matrix data type.
	enum Type {
		kFloat,			//!< Matrix of float values.
		kDouble			//!< Matrix of double values.
	};

	MObject     create( const MString& fullName,
					    const MString& briefName,
						Type matrixType = kDouble,
					    MStatus* ReturnStatus = NULL );
	MStatus     getDefault( MMatrix & def );
	MStatus     getDefault( MFloatMatrix & def );
	MStatus     setDefault( const MMatrix & def );
	MStatus     setDefault( const MFloatMatrix & def );

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnMatrixAttribute, MFnAttribute );

END_NO_SCRIPT_SUPPORT:
};

#endif /* __cplusplus */
#endif /* _MFnMatrixAttribute */



