#ifndef _MFnPointOnSurfaceManip
#define _MFnPointOnSurfaceManip
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnPointOnSurfaceManip
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnBase.h>
#include <maya/MFnManip3D.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MPoint;

// ****************************************************************************
// CLASS DECLARATION (MFnPointOnSurfaceManip)

//! \ingroup OpenMayaUI MFn
//! \brief PointOnSurfaceManip function set 
/*!
The PointOnSurfaceManip allows the user to manipulate a point
constrained to move along a surface, in order to specify the (u, v)
surface parameter values. This manipulator generates two floating
point values corresponding to the surface (u, v) parameters.
*/
class OPENMAYAUI_EXPORT MFnPointOnSurfaceManip : public MFnManip3D
{
	declareDagMFn(MFnPointOnSurfaceManip, MFnManip3D);

public:
	MObject		create(MStatus *ReturnStatus = NULL);
	MObject		create(const MString &manipName,
					   const MString &paramName,
					   MStatus *ReturnStatus = NULL);
	MStatus		connectToSurfacePlug(MPlug &surfacePlug);
	MStatus		connectToParamPlug(MPlug &paramPlug);
	MStatus		setDrawSurface(bool state);
	MStatus		setDrawArrows(bool state);
	MStatus		setParameters(double u, double v);
	MStatus		getParameters(double &u, double &v);
	bool		isDrawSurfaceOn(MStatus *ReturnStatus = NULL) const;
	unsigned int	surfaceIndex(MStatus *ReturnStatus = NULL) const;
	unsigned int	paramIndex(MStatus *ReturnStatus = NULL) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareDagMFnConstConstructor( MFnPointOnSurfaceManip, MFnManip3D );

END_NO_SCRIPT_SUPPORT:

protected:

private:

};

#endif /* __cplusplus */
#endif /* _MFnPointOnSurfaceManip */
