#ifndef _MFnSkinCluster
#define _MFnSkinCluster
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnSkinCluster
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnGeometryFilter.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MObject;
class MDagPath;
class MIntArray;
class MFloatArray;
class MDoubleArray;
class MObjectArray;
class MSelectionList;
class MString;
class MDagPathArray;

// ****************************************************************************
// CLASS DECLARATION (MFnSkinCluster)

//! \ingroup OpenMayaAnim MFn
//! \brief skinCluster function set 
/*!
MFnSkinCluster is the function set for skinClusters. SkinCluster nodes
are created during a smooth bindSkin.  The purpose of the skinCluster
is to store a weight per influence object for each component of each
geometry that is deformed. Influence objects can be joints or any
transform.

Note that unlike most deformers, a skinCluster node can deform only a
single geometry. Therefore, if additional geometries are added to the
skinCluster set, they will be ignored.

This function set provides methods for getting and setting weights on
skin cluster nodes.  It parent class, MFnGeometryFilter provides
methods for accessing the skin cluster's input and output geometry.
*/
class OPENMAYAANIM_EXPORT MFnSkinCluster : public MFnGeometryFilter
{
	declareMFn(MFnSkinCluster, MFnGeometryFilter);

public:
	MStatus		getWeights(const MDagPath& path,
						   const MObject& components,
						   unsigned int influenceIndex,
						   MDoubleArray& weights) const;
	MStatus		getWeights(const MDagPath& path,
						   const MObject& components,
						   MDoubleArray& weights,
						   unsigned int& influenceCount) const;
	MStatus		getWeights(const MDagPath& path,
						   const MObject& components,
						   MIntArray& influenceIndices,
						   MDoubleArray& weights) const;
	MStatus		setWeights(const MDagPath& path,
						   const MObject& components,
						   unsigned int jointIndex,
						   double value,
						   bool normalize = true,
						   MDoubleArray *oldValues = NULL);
	MStatus		setWeights(const MDagPath& path,
						   const MObject& components,
						   MIntArray& influenceIndices,
						   MDoubleArray& values,
						   bool normalize = true,
						   MDoubleArray *oldValues = NULL);
	MStatus		getPointsAffectedByInfluence(const MDagPath& path,
											 MSelectionList& result,
											 MDoubleArray& weights);
	unsigned int 	indexForInfluenceObject(const MDagPath& path,
										MStatus *ReturnStatus = NULL) const;
	unsigned int 	influenceObjects(MDagPathArray& paths,
								 MStatus *ReturnStatus = NULL) const;
	MStatus		getWeights(const MDagPath& path,
						   const MObject& components,
						   unsigned int influenceIndex,
						   MFloatArray& weights) const;
	MStatus		getWeights(const MDagPath& path,
						   const MObject& components,
						   MFloatArray& weights,
						   unsigned int& influenceCount) const;
	MStatus		setWeights(const MDagPath& path,
						   const MObject& components,
						   unsigned int jointIndex,
						   float value,
						   bool normalize = true,
						   MFloatArray *oldValues = NULL);
	MStatus		setWeights(const MDagPath& path,
						   const MObject& components,
						   MIntArray& influenceIndices,
						   MFloatArray& values,
						   bool normalize = true,
						   MFloatArray *oldValues = NULL);
	MStatus		getPointsAffectedByInfluence(const MDagPath& path,
											 MSelectionList& result,
											 MFloatArray& weights);

	MStatus		getBlendWeights(const MDagPath& path,
						   const MObject& components,
						   MDoubleArray& weights) const;

	MStatus		setBlendWeights(const MDagPath& path,
						   const MObject& components,
						   const MDoubleArray& weights);


BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnSkinCluster, MFnGeometryFilters );

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
	bool		isValidComponentType(const MObject& comp) const;
	MStatus		getWeightsHelper(bool useInfluenceIndex,
								 unsigned int influenceIndex,
								 const MDagPath& path,
								 const MObject& components,
								 unsigned int& influenceCount,
								 MDoubleArray& weights) const;
	MStatus		getWeightsHelper(const MDagPath& path,
					 const MObject& components,
					 const MIntArray& infArray,
					 MDoubleArray& weights) const;

	MStatus		setWeightsHelper(const MDagPath& path,
								 const MObject& components,
								 bool useInfluenceIndex,
								 unsigned int influenceIndex,
								 const MIntArray& infArray,
								 const MDoubleArray& wtArray,
								 bool normalize /* = true */,
								 MDoubleArray *oldValues /* = NULL */);

};

#endif /* __cplusplus */
#endif /* _MFnSkinCluster */
