#ifndef _MFnUint64SingleIndexedComponent
#define _MFnUint64SingleIndexedComponent
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All 
// rights reserved.
// 
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors,  which is protected by U.S. and Canadian federal copyright law 
// and by international treaties.
// 
// The Data may not be disclosed or distributed to third parties or be 
// copied or duplicated, in whole or in part, without the prior written 
// consent of Autodesk.
// 
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the following 
// disclaimer, must be included in all copies of the Software, in whole 
// or in part, and all derivative works of the Software, unless such copies 
// or derivative works are solely in the form of machine-executable object 
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, 
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO 
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST 
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR 
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS 
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES. 
// ==========================================================================
//+
//
// CLASS:    MFnUint64SingleIndexedComponent
//
// *****************************************************************************

#if defined __cplusplus

// *****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnBase.h>
#include <maya/MString.h>
#include <maya/MFnComponent.h>

// *****************************************************************************
// DECLARATIONS

class MUint64Array;

// *****************************************************************************
// CLASS DECLARATION (MFnUint64SingleIndexedComponent)

//! \ingroup OpenMaya MFn
//! \brief Single MUint64 indexed component function set. 
/*!
This function set allows you to create, edit, and query single MUint64
indexed components. Single indexed components store 1 dimensional index
values, where each value is an MUint64.
*/
class OPENMAYA_EXPORT MFnUint64SingleIndexedComponent : public MFnComponent 
{
	declareMFn( MFnUint64SingleIndexedComponent, MFnComponent );

public:

	// Create a single indexed component of the given type.
	// Allowable types are
	//
	//    MFn::kSubdivCVComponent
	//    MFn::kSubdivEdgeComponent
	//    MFn::kSubdivFaceComponent
	//
	MObject		create( MFn::Type compType, MStatus * ReturnStatus = NULL );

    MStatus 	addElement( MUint64 element );
    MStatus 	addElements( const MUint64Array& elements );

    MUint64		element( int index, MStatus * ReturnStatus = NULL ) const;
    MStatus		getElements( MUint64Array& elements ) const;

	MStatus		setCompleteData( MUint64 numElements );
	MStatus		getCompleteData( MUint64 & numElements ) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnUint64SingleIndexedComponent, MFnComponent );
	
END_NO_SCRIPT_SUPPORT: 

protected:
// No protected members

private:
// No private members
 
};

// *****************************************************************************
#endif /* __cplusplus */
#endif /* _MFnUint64SingleIndexedComponent */
