#ifndef _MFnWeightGeometryFilter
#define _MFnWeightGeometryFilter
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MFnWeightGeometryFilter
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MFnGeometryFilter.h>
#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MObject;
class MDagPath;
class MIntArray;
class MFloatArray;
class MObjectArray;
class MSelectionList;
class MString;

// ****************************************************************************
// CLASS DECLARATION (MFnWeightGeometryFilter)

//! \ingroup OpenMayaAnim MFn
//! \brief Weight geometry filter function set 
/*!
MFnWeightGeometryFilter is the function set for weight geometry
filters.  Weight geometry filter nodes include clusters, cluster
flexors, and user-defined deformers derived from MPxDeformerNode.  The
purpose of the weight geometry filter is to store the weights for each
component of each geometry that is deformed.  The weight geometry
filter is independent of any algorithm that calculates a deformation
based on the component weight values.  Clusters, cluster flexors, and
user-defined deformers each have their own algorithm to determine the
deformation based on the component weights.

This function set provides methods for getting and setting weights on
weight geometry filter nodes.  In addition to getting and settings
weights on components, this class provides methods for accessing the
weight geometry filter's input and output geometry through its parent
class, MFnGeometryFilter.

When getting and setting weights on components, it is more
efficient to use the methods that take a plug index.  The plug index
is a sparse array index, and is the same index used in MEL scripts to
index into an array of plugs.
*/
class OPENMAYAANIM_EXPORT MFnWeightGeometryFilter : public MFnGeometryFilter
{
	declareMFn(MFnWeightGeometryFilter, MFnGeometryFilter);

public:
	MStatus		getWeights(unsigned int index,
						   const MObject &components,
						   MFloatArray &weights) const;
	MStatus		getWeights(const MDagPath &path,
						   const MObject &components,
						   MFloatArray &weights) const;
	MStatus		setWeight(const MDagPath &path,
						  unsigned int index,
						  const MObject &components,
						  float weight,
						  MFloatArray *oldValues = NULL);
	MStatus		setWeight(const MDagPath &path,
						  const MObject &components,
						  float weight,
						  MFloatArray *oldValues = NULL);
	MStatus		setWeight(const MDagPath &path,
						  unsigned int index,
						  const MObject &components,
						  MFloatArray &values);
	MStatus		setWeight(const MDagPath &path,
						  const MObject &components,
						  MFloatArray &values);
	MString		weightPlugStrings(const MSelectionList &list,
									 MStatus * ReturnStatus = NULL ) const;
	MStatus		getWeightPlugStrings(const MSelectionList &list,
									 MStringArray &plugStringArray) const;

BEGIN_NO_SCRIPT_SUPPORT:

 	declareMFnConstConstructor( MFnWeightGeometryFilter, MFnGeometryFilter );

	//!     NO SCRIPT SUPPORT
	MStatus		getWeightPlugStrings(const MSelectionList &list,
									 MString &plugStrings) const;

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
// No private members
};

#endif /* __cplusplus */
#endif /* _MFnWeightGeometryFilter */
