#ifndef _MGeometryList
#define _MGeometryList
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MGeometryList
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>
#include <maya/MGeometry.h>
#include <maya/MDagPath.h>
class MMatrix;
class MRenderingInfo;
class MDagPath;

// ****************************************************************************
// CLASS DECLARATION (MGeometryList)

//! \ingroup OpenMayaRender
//! \brief Geometric data cache.
/*!
  This class holds the set of data elements which represent a Maya
  surface. It provides iterated access to a list of geometry items,
  along with the rendering context require to render them
  (e.g. matrix, etc).
*/
class OPENMAYARENDER_EXPORT MGeometryList
{
public:
	MGeometryList( const MRenderingInfo& info, int initialCapacity = 1);

	~MGeometryList();

	// Iteration

	bool			isDone() const;

	void			next();

	void			reset();

	// Random access

	int				length() const;

	void			setCurrentElement( int i);

	// Query the current element

	//! Bit flags for the geometry method that govern which OpenGL state Maya sets for you
	enum
	{
        //! No renderer setup is required for this element
		kNone						= 0,
        //! Setup the model view matrix for this element
		kMatrices					= 1 << 0,
        //! Setup the fixed function lighting state for this element
		kFixedFunctionLighting		= 1 << 1,
        //! Setup the back/front face culling state for this element
		kCulling					= 1 << 2,
        //! Setup all renderer state for this element
		kAll						= -1
	} MSetupFlags;

	MGeometry&		geometry( int setupFlags = kAll);

	const MMatrix&	objectToWorldMatrix() const;

	const MMatrix&	projectionMatrix() const;

	const MMatrix&	viewMatrix() const;

	MDagPath		path() const;

	//! Defines the culling modes to use when rendering this geometry
	typedef enum
	{
		//! No culling should be performed on this geometry
		kCullNone,
		//! Cull clockwise faces when rendering this geometry
		kCullCW,
		//! Cull counter-clockwise faces when rendering this geometry
		kCullCCW
	} MCullMode;

	MGeometryList::MCullMode cullMode() const;


	// Build a list of geometry to render

	bool			addLast( const MDagPath& path, const MObject* components = NULL);

	bool			addLast( const MGeometry& geometry, const MMatrix& matrix);

protected:

	MGeometryList( void* pGeometry, int count, const void* info);

private:

	MGeometry		_geometry;
	void*			_geometryRequests;
	int				_count;
	int				_capacity;
	int				_currentElement;
	const void*		_info;
	int				_ownership;

	void			setCapacity( int capacity);

	friend class MUniformParameter;
	friend class MGeometryManager;
};

#endif
#endif // _MGeometryList
