#ifndef _MItGeometry
#define _MItGeometry
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MItGeometry
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MObject.h>

// ****************************************************************************
// DECLARATIONS

class MPoint;
class MDataHandle;
class MDagPath;
class MWeight;
class MPointArray;

// ****************************************************************************
// CLASS DECLARATION (MItGeometry)

//! \ingroup OpenMaya
//! \brief Iterator class for geometry data. 
/*!
This class is the iterator class for geometry data, and can be used to
loop over the CVs of NURBS, the points of subds & lattices, and the vertices of
polygonal meshes.

\par Examples:
Simple traversal.

\code
    MItGeometry iter( dagPath );
    for ( ; !iter.isDone(); iter.next() )
    {
        MPoint pt = iter.position();

        // do something with it
    }
\endcode

Traversal of a geometry group within a compute() method.

\code
    MStatus
    exampleIterator::compute(const MPlug& plug, MDataBlock& dataBlock)
    {
        MStatus status;

        if (plug.attribute() == oOutputGeometry) {
            // get the input geometry and input groupId
            MDataHandle hInputGeom = dataBlock.inputValue(inputGeomAttr);
            MDataHandle hGroupId = dataBlock.inputValue(inputGroupIdAttr);

            unsigned int groupId = hGroup.asLong();
            MDataHandle hOutput = dataBlock.outputValue(plug);
            hOutput.copy(hInputGeom);

            // do an iteration where we get each point and set it to a new value
            MItGeometry iter(hOutput,groupId,false);
            for ( ; !iter.isDone(); iter.next()) {
                MPoint pt = iter.position();

                // do something here to modify the point ...

                iter.setPosition(pt);
            }
        } else {
            status = MStatus::kUnknownParameter;
        }        

        return status;
    }
\endcode
*/
class OPENMAYA_EXPORT MItGeometry
{
public:
	MItGeometry( const MDagPath& dagPath,
				 MStatus * ReturnStatus = NULL);
    MItGeometry( const MDagPath& dagPath,
                 MObject & component,
                 MStatus * ReturnStatus = NULL );
    MItGeometry( MObject& dagObject,
                 MStatus * ReturnStatus = NULL );
    MItGeometry( MDataHandle& dataHandle,
                 unsigned int groupId,
                 bool readOnly = true,
                 MStatus * ReturnStatus = NULL );
    MItGeometry( MDataHandle& dataHandle,
                 bool readOnly = true,
                 MStatus * ReturnStatus = NULL );
    virtual ~MItGeometry();
    bool        isDone( MStatus * ReturnStatus = NULL ) const;
    MStatus     next();
    MPoint      position( MSpace::Space space = MSpace::kObject,
                          MStatus * ReturnStatus = NULL ) const;
    MStatus     setPosition( const MPoint& point,
                             MSpace::Space space = MSpace::kObject  );
	MWeight		weight( MStatus * ReturnStatus = NULL ) const;
    int	    index( MStatus * ReturnStatus = NULL ) const;
	// obsolete
	MObject		component( MStatus * ReturnStatus = NULL ) const;
	MObject		currentItem( MStatus * ReturnStatus = NULL ) const;
	int		count( MStatus * ReturnStatus = NULL ) const;
	int		exactCount( MStatus * ReturnStatus = NULL );
	MStatus		reset( );

	MStatus		allPositions( MPointArray& points,
							  MSpace::Space space = MSpace::kObject  ) const;
	MStatus		setAllPositions( const MPointArray& points,
								 MSpace::Space space = MSpace::kObject  );

protected:
// No protected members

private:
	// internal : called by the dataHandle constructors to set up the iterator
	//
	void 		createIterator(MDataHandle& dataHandle,
							   bool useComponents,
							   void* comps = NULL,
							   unsigned int groupId = 0,
							   bool readOnly = true,
							   MStatus* status = NULL);

private:
	void *      f_it;
    void *      f_path;
    void *      f_matrix;
    void *      f_clist;
	bool        f_readOnly;
	bool        f_own;

    static const char* className();
	MItGeometry( void * ptr );
};

#endif /* __cplusplus */
#endif /* _MItGeometry */
