#ifndef _MItSubdEdge
#define _MItSubdEdge
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MItSubdEdge
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>

// ****************************************************************************
// DECLARATIONS

class MObject;
class MStatus;

// ****************************************************************************
// CLASS DECLARATION (MItSubdEdge)

//! \ingroup OpenMaya
//! \brief Subdiv edge iterator. 
/*!
	This class is the iterator for subdiv edges.
*/
class OPENMAYA_EXPORT MItSubdEdge
{
public:
	MItSubdEdge( MObject & subdObject, MStatus * ReturnStatus = NULL );
	virtual ~MItSubdEdge();

	MStatus		reset();
	MStatus		next();
	bool		isDone( MStatus * ReturnStatus = NULL );
	bool isValid(MStatus * ReturnStatus = NULL) const;

	int level(MStatus * ReturnStatus = NULL) const;
	void setLevel( int level, MStatus * ReturnStatus = NULL );

	MUint64		index( MStatus * ReturnStatus = NULL );

	bool		isSharp( MStatus * ReturnStatus = NULL );
	void		setSharpness( bool sharp, MStatus * ReturnStatus = NULL );
	bool		isBoundary( MStatus * ReturnStatus = NULL );

protected:

private:
	static const char* 	className();
	void     *       f_it;
};

#endif /* __cplusplus */
#endif /* _MItSubdEdge */



