#ifndef _MLibrary
#define _MLibrary
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MLibrary
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// CLASS DECLARATION (MLibrary)

//! Set up Maya to run in library mode. (OpenMaya)
/*!
 Initialize and cleanup routines for Maya running in library mode.

When creating a "library mode" Maya application, this class must be
used in the program's main routine to initialize Maya, and later
to cleanUp allocated Maya state.  A typical usage would be:

\code
    main(int argc, char **argv)
    {
        MStatus status;
        status = MLibrary::initialize (argv[0], true);
        if ( !status ) {
            status.perror("MLibrary::initialize");
            return (1);
        }

        // Maya API code goes here

        MLibrary::cleanup();
        return (0);
    }
\endcode

If the call to cleanup is omitted, you will get errors when the program
exits as the static destructors in the Maya libraries are run.
*/
class OPENMAYA_EXPORT MLibrary
{
public:
						MLibrary ();
	virtual				~MLibrary ();
	static MStatus		initialize (char* applicationName,
									bool viewLicense = false);
	static MStatus		initialize (bool wantScriptOutput,
									char* applicationName,
									bool viewLicense = false);
	static void			cleanup( int exitStatus = 0 );

protected:
// No protected members

private:
// No private members

};

#ifdef _WIN32
#if _MSC_VER < 1500
	// When  external code is compiling, MLIBRARY_DONTUSE_MFC_MANIFEST
	// will not be defined.  This will force the manifest on
	// x86 and amd64 to mfc80.dll.  We do not force the manifest
	// to mfc80d.dll for a Debug build since a released version of
	//  Maya does not use Debug libraries.
	#if !defined(MLIBRARY_DONTUSE_MFC_MANIFEST)
		#include <crtassem.h>
		#pragma comment(lib, "mfc80")
		#if defined(_M_IX86)
			#pragma comment(linker,"/manifestdependency:\"type='win32' "	\
				"name='" __LIBRARIES_ASSEMBLY_NAME_PREFIX ".MFC' "			\
				"version='" _CRT_ASSEMBLY_VERSION "' "						\
				"processorArchitecture='x86' "								\
				"publicKeyToken='" _VC_ASSEMBLY_PUBLICKEYTOKEN "'\"")
		#elif defined(_M_AMD64)
			#pragma comment(linker,"/manifestdependency:\"type='win32' "	\
				"name='" __LIBRARIES_ASSEMBLY_NAME_PREFIX ".MFC' "			\
				"version='" _CRT_ASSEMBLY_VERSION "' "						\
				"processorArchitecture='amd64' "							\
				"publicKeyToken='" _VC_ASSEMBLY_PUBLICKEYTOKEN "'\"")
		#endif	// _M_AMD64
	#endif	// MLIBRARY_DONTUSE_MFC_MANIFEST
#endif
#endif // _WIN32

#endif /* __cplusplus */
#endif /* _MLibrary */
