#ifndef _MPointArray
#define _MPointArray
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPointArray
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>
#include <maya/MStatus.h>
#include <maya/MPoint.h>

// ****************************************************************************
// CLASS DECLARATION (MPointArray)

//! \ingroup OpenMaya
//! \brief Array of MPoint data type. 
/*!
This class implements an array of MPoints.  Common convenience functions
are available, and the implementation is compatible with the internal
Maya implementation so that it can be passed efficiently between plugins
and internal maya data structures.
*/
class OPENMAYA_EXPORT MPointArray
{
public:
					MPointArray();
					MPointArray( const MPointArray& other );
BEGIN_NO_SCRIPT_SUPPORT:
	//!	NO SCRIPT SUPPORT
					MPointArray( const MPoint points[], unsigned int count );
END_NO_SCRIPT_SUPPORT:
					MPointArray( const double points[][4], unsigned int count );
					MPointArray( const float points[][4], unsigned int count );
					MPointArray( unsigned int initialSize,
								 const MPoint &initialValue
								 = MPoint::origin );
					~MPointArray();
	const MPoint&	operator[]( unsigned int index ) const;
 	MPointArray &   operator=( const MPointArray & other );
	MStatus			set( const MPoint& element, unsigned int index);
	MStatus 		set( unsigned int index, double x, double y, double z=0,
						 double w=1);
	MStatus			set( double element[4], unsigned int index);
	MStatus			set( float element[4], unsigned int index);
	MStatus			setLength( unsigned int length );
	unsigned int		length() const;
	MStatus			remove( unsigned int index );
	MStatus			insert( const MPoint & element, unsigned int index );
	MStatus			append( const MPoint & element );
	MStatus 		append( double x, double y, double z=0, double w=1 );
 	MStatus         copy( const MPointArray& source );
	MStatus			clear();
	MStatus			get( double [][4] ) const;
	MStatus			get( float [][4] ) const;
	void			setSizeIncrement ( unsigned int newIncrement );
	unsigned int		sizeIncrement () const;

BEGIN_NO_SCRIPT_SUPPORT:

	//!	NO SCRIPT SUPPORT
	MPoint&	        operator[]( unsigned int index );

	//!	NO SCRIPT SUPPORT
	friend OPENMAYA_EXPORT std::ostream &operator<<(std::ostream &os,
											   const MPointArray &array);

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
	MPointArray( void* );
	void * arr;
	struct api_data
	{
		double  x;
		double  y;
		double  z;
		double  w;

	};
	const api_data* debugPeekValue ;
	bool   own;
	void syncDebugPeekValue();
	static const char* className();
};

#endif /* __cplusplus */
#endif /* _MPointArray */
