#ifndef _MPxLocatorNode
#define _MPxLocatorNode
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxLocatorNode
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES



#include <maya/MStatus.h>
#include <maya/MTypes.h>
#include <maya/MObject.h>
#include <maya/MPxNode.h>
#include <maya/M3dView.h>
#include <maya/MBoundingBox.h>
#include <maya/M3dView.h>

// ****************************************************************************
// DECLARATIONS

class MDagPath;

// ****************************************************************************
// CLASS DECLARATION (MPxNode)

//! \ingroup OpenMayaUI MPx
//! \brief Base class for user defined locators 
/*!

  MPxLocatorNode allows the creation of user-defined locators.  A
  locator is a DAG shaped that is drawn on the screen, but that has is
  not rendered.  Locators are full dependency nodes and can have
  attributes and a compute method.

  To create a locator, derive off of this class and override the draw method.
  The draw method can be overridden to draw custom geometry using standard
  OpenGL calls.  The other methods of the parent class MPxNode may also
  be overridden to perform dependency node capabilities as well.
*/
class OPENMAYAUI_EXPORT MPxLocatorNode : public MPxNode
{
public:
	MPxLocatorNode();
	virtual ~MPxLocatorNode();
	virtual MPxNode::Type type() const;

	// Methods to overload

	virtual void draw( M3dView & view, const MDagPath & path,
			    	   M3dView::DisplayStyle style, M3dView:: DisplayStatus );
	virtual bool isBounded() const;
	virtual MBoundingBox boundingBox() const;


	// Color methods

	unsigned int         color( M3dView::DisplayStatus displayStatus );

	MColor               colorRGB( M3dView::DisplayStatus displayStatus );

	virtual bool		 excludeAsLocator() const;

	virtual bool		 isTransparent() const;

	virtual bool		 drawLast() const;

	// Inherited attributes

	//! under world attribute
	static MObject underWorldObject;
	//! local position attribute
	static MObject localPosition;
		//! X component of localPosition
		static MObject localPositionX;
		//! Y component of localPosition
		static MObject localPositionY;
		//! Z component of localPosition
		static MObject localPositionZ;
	//! world position attribute
	static MObject worldPosition;
	    //! X component of worldPosition
	    static MObject worldPositionX;
	    //! Y component of worldPosition
	    static MObject worldPositionY;
	    //! Z component of worldPosition
	    static MObject worldPositionZ;
	//! local scale attribute
	static MObject localScale;
		//! X component of localScale
		static MObject localScaleX;
		//! Y component of localScale
		static MObject localScaleY;
		//! Z component of localScale
		static MObject localScaleZ;
	//! bounding box attribute
	static MObject nodeBoundingBox;
	    //! bounding box minimum point
	    static MObject nodeBoundingBoxMin;
	        //! X component of boundingBoxMin
	        static MObject nodeBoundingBoxMinX;
	        //! Y component of boundingBoxMin
	        static MObject nodeBoundingBoxMinY;
	        //! Z component of boundingBoxMin
	        static MObject nodeBoundingBoxMinZ;
	    //!  bounding box maximum point
	    static MObject nodeBoundingBoxMax;
	        //! X component of boundingBoxMax
	        static MObject nodeBoundingBoxMaxX;
	        //! Y component of boundingBoxMax
	        static MObject nodeBoundingBoxMaxY;
	        //! Z component of boundingBoxMax
	        static MObject nodeBoundingBoxMaxZ;
	    //!  bounding box size vector
	    static MObject nodeBoundingBoxSize;
	        //! X component of boundingBoxSize
	        static MObject nodeBoundingBoxSizeX;
	        //! Y component of boundingBoxSize
	        static MObject nodeBoundingBoxSizeY;
	        //! Z component of boundingBoxSize
	        static MObject nodeBoundingBoxSizeZ;
	//! object center attribute
	static MObject center;
	    //! X component of boundingBoxCenter
	    static MObject boundingBoxCenterX;
	    //! Y component of boundingBoxCenter
	    static MObject boundingBoxCenterY;
	    //! Z component of boundingBoxCenter
	    static MObject boundingBoxCenterZ;
	//! matrix attribute
	static MObject matrix;
	//! inverse matrix attribute
	static MObject inverseMatrix;
	//! world matrix attribute
	static MObject worldMatrix;
	//! inverse world matrix attribute
	static MObject worldInverseMatrix;
	//! parent matrix attribute
	static MObject parentMatrix;
	//! inverse parent matrix attribute
	static MObject parentInverseMatrix;
	//! visibility attribute
	static MObject visibility;
	//! intermediate object attribute
	static MObject intermediateObject;
	//! template attribute
	static MObject isTemplated;
	//! instances object group info attribute
	static MObject instObjGroups;
	    //! object groups attributes
	    static MObject objectGroups;
	        //! component in object groups attribute
	        static MObject objectGrpCompList;
	        //! group id attribute
	        static MObject objectGroupId;
	        //! group id attribute
	        static MObject objectGroupColor;
	//! controls choice of wireframe dormant object color
	static MObject useObjectColor;
	//! the per object dormant wireframe color
	static MObject objectColor;

protected:
	// No protected members

private:
	static void				initialSetup();
	static const char*	    className();

};

#endif /* __cplusplus */
#endif /* _MPxLocatorNode */
