#ifndef _MPxMidiInputDevice
#define _MPxMidiInputDevice
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxMidiInputDevice
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES

#ifdef SGI

#include <dmedia/midi.h>
#endif // SGI
#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// DECLARATIONS

class MDeviceState;
class MDeviceChannel;
class MString;

// ****************************************************************************
// CLASS DECLARATION (MPxMidiInputDevice)

//! \ingroup OpenMayaUI MPx
//! \brief Midi input device 
/*!
This is the base class for user defined MIDI input devices.

Child classes of MPxMidiInputDevice should define:

\li <b>a constructor</b>		which defines number of buttons and axes
\li <b>nameAttributes()</b>	which names the buttons and axes (optional)
\li <b>deviceState()</b>		which turns a midi event into an MDeviceState
								or returns NULL if it is not a midi event
								from this device
*/
class OPENMAYAUI_EXPORT MPxMidiInputDevice
{
public:
	MPxMidiInputDevice();
	virtual ~MPxMidiInputDevice();

	virtual	MStatus			openDevice();
	virtual	void			closeDevice();

	virtual	void			nameAxes();
	virtual void			nameButtons();
	virtual	MDeviceState* 	deviceState();
#ifdef SGI
	virtual	MDeviceState* 	deviceState( MDevent& );
#endif // SGI

	virtual MStatus 		sendMessage(	const char* const messageType,
											const char* const messageParams );
	virtual char* 			getMessage(	const char* const messageType,
										char* messageResponse );

	virtual void 			doButtonEvents( bool = true );
	virtual void 			doMovementEvents( bool = true );

	MPxMidiInputDevice( void * init );

protected:
	MStatus		setNamedButton( const MString &, unsigned short );
	MStatus		addChannel( MDeviceChannel & );
	MStatus 	setDegreesOfFreedom( int freedom );
	MStatus 	setNumberOfButtons( int buttons );

private:
	void   setData( void* );
	virtual const char*	className() const;
	void * 	data;
	int 	degreesOfFreedom;
	int 	numberOfButtons;
};

#endif /* __cplusplus */
#endif /* _MPxMidiInputDevice */
