#ifndef _MPxRenderPassImpl
#define _MPxRenderPassImpl

//-
// ==========================================================================
// Copyright (C) 1995 - 2008 Autodesk, Inc., and/or its licensors.  All 
// rights reserved.
// 
// The coded instructions, statements, computer programs, and/or related 
// material (collectively the "Data") in these files contain unpublished 
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its 
// licensors,  which is protected by U.S. and Canadian federal copyright law 
// and by international treaties.
// 
// The Data may not be disclosed or distributed to third parties or be 
// copied or duplicated, in whole or in part, without the prior written 
// consent of Autodesk.
// 
// The copyright notices in the Software and this entire statement, 
// including the above license grant, this restriction and the following 
// disclaimer, must be included in all copies of the Software, in whole 
// or in part, and all derivative works of the Software, unless such copies 
// or derivative works are solely in the form of machine-executable object 
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND. 
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED 
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF 
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, 
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO 
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST 
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR 
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS 
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES. 
// ==========================================================================
//+
//
// CLASS:    MPxRenderPassImpl
//
// ****************************************************************************

#if defined __cplusplus


#include <maya/MString.h>

// ****************************************************************************
// CLASS DECLARATION (MRenderPassRegistry)

//! \ingroup OpenMayaRender
//! \brief Render pass implementation
/*!
	The MPxRenderPassImpl class is an abstract base class which provides a
	common interface for pass implementations. Extend this class to create
	custom pass implementations.
*/

class OPENMAYA_EXPORT MPxRenderPassImpl
{
public:

	//! Data types that implementation may support
	enum PassTypeBit
	{
		//! Unsigned 8-bit integer
		kUInt8 = 0x1,
		//! Unsigned 16-bit integer
		kUInt16 = 0x2,
		//! Unsigned 32-bit integer
		kUInt32 = 0x4,
		//! Unsigned 64-bit integer
		kUInt64 = 0x8,
		//! Signed 8-bit integer
		kInt8 = 0x10,
		//! Signed 16-bit integer
		kInt16 = 0x20,
		//! Signed 32-bit integer
		kInt32 = 0x40,
		//! Signed 64-bit integer
		kInt64 = 0x80,
		//! half precision floating point
		kFloat16 = 0x100,
		//! single precision floating point
		kFloat32 = 0x200,
		//! double precision floating point
		kFloat64 = 0x400,
		//! single bit
		kBit = 0x800,
		//! undefined type
		kOther = 0x1000
	};

    //! Description of the nature of the data stored in the frame buffer
	enum PassSemantic {
		//! Invalid
		kInvalidSemantic = 0,
		//! RGB, RGBA, alpha, luminance, etc.
		kColorSemantic,
		//! General vector data (e.g. motion vectors, surface displacements)
		kVectorSemantic,
		//! Vectors that represent a direction (e.g. surface normals, light directions)
		kDirectionVectorSemantic,
		//! Depth or range data
		kDepthSemantic,
		//! Labels, such as material tags or object tags.
		kLabelSemantic,
		//! Pixel mask (e.g. a stencil buffer)
		kMaskSemantic,
		//! Undefined, unknown or custom semantic
		kOtherSemantic
	};

	//! Use to create a mask of PassTypeBit types
	typedef unsigned int PassTypeMask;

	MPxRenderPassImpl();
	virtual ~MPxRenderPassImpl();

	// Virtual overrides
	virtual bool isCompatible(const MString &renderer) const = 0;
	virtual PassTypeMask typesSupported() const = 0;
	virtual PassTypeBit getDefaultType() const = 0;
	virtual unsigned int getNumChannels() const = 0;
	virtual PassSemantic frameBufferSemantic() const = 0;
	virtual bool perLightPassContributionSupported() const = 0;

protected:
// No protected members

private:
	friend class MRenderPassDef;

	void* fInstance;
};

// ****************************************************************************

#endif/* __cplusplus */
#endif/* _MPxRenderPassImpl */
