#ifndef _MPxSpringNode
#define _MPxSpringNode
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MPxSpringNode
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MObject.h>
#include <maya/MPxNode.h>
#include <maya/MPointArray.h>
#include <maya/MVectorArray.h>
#include <maya/MDoubleArray.h>

// ****************************************************************************
// CLASS DECLARATION (MPxSpringNode)

//! \ingroup OpenMayaFX MPx
//! \brief Base class for user defined spring law 
/*!
	MPxSpringNode allows the creation and manipulation of dependency
	graph nodes representing a spring law.  The class is a DAG node
	and Maya manages the drawing, creation, and selection of springs.

    A user defined spring node is a DAG node that can have attributes
    and a applySpringLaw() method. To derive the full benefit
    of the MPxSpringNode class, it is suggested that you do not write
    your own compute() method. Instead, write the applySpringLaw() method.
    All of the parameters passed into this method will be supplied by Maya.

    To create a user defined spring node, derive from this class
    and override the applySpringLaw() method. The other methods of
    the parent class MPxNode may also be overridden to perform
    dependency node capabilities.
*/
class OPENMAYAFX_EXPORT MPxSpringNode : public MPxNode
{
public:
	MPxSpringNode();
	virtual ~MPxSpringNode();

	virtual MPxNode::Type	type() const;

	virtual MStatus	applySpringLaw( double stiffness,
						double damping, double restLength,
						double endMass1, double endMass2,
						const MVector &endP1, const MVector &endP2,
						const MVector &endV1, const MVector &endV2,
						MVector &forceV1, MVector &forceV2 );


	// ************************************************************
	// Inherited attributes
	// ************************************************************

	// General attributes for spring.
	//
	//! from end weight attribute
	static MObject	mEnd1Weight;
	//! to end weight attribute
	static MObject	mEnd2Weight;

	//! delta time attribute
	static MObject	mDeltaTime;

protected:
// No protected members

private:
// No private members

	static void			initialSetup();
	static const char*	className();

};

#endif /* __cplusplus */
#endif /* _MPxSpringNode */

