#ifndef _MRenderLineArray
#define _MRenderLineArray
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MRenderLineArray
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// DECLARATIONS

class MRenderLine;

// ****************************************************************************
// CLASS DECLARATION (MRenderLineArray)

//! \ingroup OpenMayaFX
//! \brief Class for accessing paint effects output curve data.
/*!
	A MRenderLineArray provides access to paint effects curve rendering info.
	This class contains arrays for per vertex attributes along an individual curve:
	line: the vertices in worldspace
    twist: a twist vector at each vertex
    width: the tube widths
    flatness: the tube flatness along the twist vector direction
    parameter: the u parameterization value for each vertex
    color: color rgb value for each vertex
    incandescence: incandescence rgb value for each vertex
    transpareancy: transparency rgb value for each vertex
*/
class OPENMAYAFX_EXPORT MRenderLineArray
{
public:
	MRenderLineArray();
	~MRenderLineArray();

	MRenderLineArray&  operator = (const MRenderLineArray& other );
	void deleteArray();

	// Access Methods
	int	  length() const;
	MRenderLine renderLine( unsigned int index, MStatus *status ) const;

protected:
// No protected members

private:
	static const char* className();
	MRenderLineArray( void* );
	void * fData;
};

#endif /* __cplusplus */
#endif /* _MRenderLineArray */
