#ifndef _MRenderUtil
#define _MRenderUtil
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MRenderUtil
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MStatus.h>
#include <maya/MTypes.h>

// ****************************************************************************
// DECLARATIONS

class MFloat;
class MFloatPoint;
class MFloatVector;
class MFloatVectorArray;
class MIntArray;
class MFloatPoint;
class MFloatArray;
class MFloatPointArray;
class MFloatMatrix;
class MObject;
class MString;
class MDagPath;
class MCommonRenderSettingsData;
class MSelectionList;

// ****************************************************************************
// CLASS DECLARATION (MRenderUtil)

//! \ingroup OpenMayaRender
//! \brief Common API rendering functions.
/*!
	MRenderUtil is a class which provides static API methods to access
	Maya's rendering functionalities.
*/
class OPENMAYARENDER_EXPORT MRenderUtil
{
public:

	//! Defines the current rendering state of Maya
	enum MRenderState {
		kNotRendering,		//!< Not rendering.
		kBatchRender,		//!< Performing a batch render.
		kInteractiveRender,	//!< Performing an interactive render.
		kIprRender,			//!< Performing an IPR render.
		kHardwareRender		//!< Performing a hardware render.
	};

	//! Defines the current pass of Maya
	enum MRenderPass {
		kAll,			//!< Default case, compute everything.
		kColorOnly,		//!< Compute only color information, no shadows.
		kShadowOnly,	//!< Compute only shadow information, no color.
		kAmbientOnly,	//!< Compute only ambient information.
		kDiffuseOnly,	//!< Compute only diffuse information.
		kSpecularOnly	//!< Compute only specular information.
	};

	static MRenderState	mayaRenderState();

	static MStatus	raytrace(
						const MFloatVector& rayOrigin,  // in camera space
						const MFloatVector& rayDirection,
						const void* objectId,
						const void* raySampler,
						const short rayDepth,

						// storage for return value

						MFloatVector& resultColor,
						MFloatVector& resultTransparency,

						// true for reflected rays, false for refracted rays
						const bool isReflectedRays = true
					);

	// vectorized version

	static MStatus	raytrace(
						const MFloatVectorArray& rayOrigins,  // in camera space
						const MFloatVectorArray& rayDirections,
						const void* objectId,
						const void* raySampler,
						const short rayDepth,

						// storage for return value

						MFloatVectorArray& resultColors,
						MFloatVectorArray& resultTransparencies,

						// true for reflected rays, false for refracted rays
						const bool isReflectedRays = true
					);

	static MStatus	raytraceFirstGeometryIntersections(
						const MFloatVectorArray& rayOrigins,  // in camera space
						const MFloatVectorArray& rayDirections,
						const void* objectId,
						const void* raySampler,

						// storage for return value

						MFloatVectorArray& 	resultIntersections,
						MIntArray& 			resultIntersected
					);


	static MStatus sampleShadingNetwork(

		MString             shadingNodeName,
		int                numSamples,
		bool				useShadowMaps,
		bool				reuseMaps,

		MFloatMatrix		&cameraMatrix,	// eye to world

		MFloatPointArray    *points,	// in world space
		MFloatArray         *uCoords,
		MFloatArray         *vCoords,
		MFloatVectorArray   *normals,	// in world space
		MFloatPointArray    *refPoints,	// in world space
		MFloatVectorArray   *tangentUs,	// in world space
		MFloatVectorArray   *tangentVs,	// in world space
		MFloatArray         *filterSizes,

		MFloatVectorArray   &resultColors,
		MFloatVectorArray   &resultTransparencies
	);

	static bool 	   generatingIprFile();

	static MString relativeFileName(
						const MString& absFileName,
						MStatus *ReturnStatus = NULL
						);

BEGIN_NO_SCRIPT_SUPPORT:

	static bool exactFileTextureName(
						const MObject& fileNode,
						MString& texturePath,
						MStatus *ReturnStatus = NULL
					);
	static bool exactFileTextureName(
						const MString& baseName,
						bool           useFrameExt,
						const MString& currentFrameExt,
						MString&       exactName,
						MStatus *ReturnStatus = NULL
						);

	//! Internal use only
	static bool convertPsdFile(
						const MObject& fileNode,
						MString& texturePath,
						const bool		&state = false,
						MStatus *ReturnStatus = NULL
					);

	static bool exactImagePlaneFileName(
						const MObject& imagePlaneNode,
						MString& texturePath,
						MStatus *ReturnStatus = NULL
					);

END_NO_SCRIPT_SUPPORT:

	static MString exactFileTextureName(
						const MObject& fileNode,
						MStatus *ReturnStatus = NULL
					);
	static MString exactFileTextureName(
						const MString& baseName,
						bool           useFrameExt,
						const MString& currentFrameExt,
						MStatus *ReturnStatus = NULL
						);

	//! Internal use only
	static MString convertPsdFile(
						const MObject& fileNode,
						const bool		&state = false,
						MStatus *ReturnStatus = NULL
					);

	static MString exactImagePlaneFileName(
						const MObject& imagePlaneNode,
						MStatus *ReturnStatus = NULL
					);

    static bool inCurrentRenderLayer(
                        const MDagPath& objectPath,
		                MStatus *ReturnStatus = NULL
                    );

	static MRenderPass renderPass( void );

	static MString mainBeautyPassCustomTokenString();
	static MString mainBeautyPassName();

	static float	diffuseReflectance(
						const void* lightBlindData,
						const MFloatVector& lightDirection,
						const MFloatVector& pointCamera,
						const MFloatVector& normal,
						bool lightBackFace,
						MStatus *ReturnStatus = NULL );

	static MFloatVector		maximumSpecularReflection(
								const void* lightBlindData,
								const MFloatVector& lightDirection,
								const MFloatVector&  pointCamera,
								const MFloatVector& normal,
								const MFloatVector& rayDirection,
								MStatus *ReturnStatus = NULL );

	static float	lightAttenuation(
							const void* lightBlindData,
							const MFloatVector& pointCamera,
							const MFloatVector& normal,
							bool lightBackFace,
							MStatus *ReturnStatus = NULL );

	static float	hemisphereCoverage(
							const void* lightBlindData,
							const MFloatVector& lightDirection,
							const MFloatVector& pointCamera,
							const MFloatVector& rayDirection,
							bool lightBackFace,
							MStatus *ReturnStatus = NULL );

	static void		sendRenderProgressInfo (const MString &pixFile, int percentageDone);

	// Fill the set of common render settings, based on current renderer
	static void		getCommonRenderSettings(MCommonRenderSettingsData &rgData);

    static MStatus  renderObjectItem(
                            const void* objectId,
                            MSelectionList& item);

protected:
	static const char* className();
private:
    ~MRenderUtil();
#ifdef __GNUC__
	friend class shutUpAboutPrivateDestructors;
#endif
};

// ****************************************************************************
#endif /* __cplusplus */
#endif /* _MRenderUtil */
