#ifndef _MStringArray
#define _MStringArray
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MStringArray
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>
#include <maya/MStatus.h>

// ****************************************************************************
// DECLARATIONS

class MString;

// ****************************************************************************
// CLASS DECLARATION (MStringArray)

//! \ingroup OpenMaya
//! \brief Array of MStrings data type.
/*!
This class implements an array of MStrings.  Common convenience functions
are available, and the implementation is compatible with the internal
Maya implementation so that it can be passed efficiently between plugins
and internal maya data structures.
*/
class OPENMAYA_EXPORT MStringArray
{

public:
				MStringArray();
				MStringArray( const MStringArray& other );
				MStringArray( const MString strings[], unsigned int count );
				MStringArray( const char* strings[], unsigned int count );
				MStringArray( unsigned int initialSize,
							  const MString &initialValue );
				~MStringArray();
	MString		operator[]( unsigned int index ) const;
 	MStringArray & operator=( const MStringArray & other );
	MStatus		set( const MString& element, unsigned int index );
	MStatus		set( char* element, unsigned int index );
	MStatus		setLength( unsigned int length );
	unsigned int	length() const;
	MStatus		remove( unsigned int index );
	MStatus		insert( const MString & element, unsigned int index );
	MStatus		append( const MString & element );
	MStatus		clear();
	MStatus		get( MString array[] ) const;
	MStatus		get( char* array[] ) const;
	void		setSizeIncrement ( unsigned int newIncrement );
	unsigned int	sizeIncrement () const;

BEGIN_NO_SCRIPT_SUPPORT:

	//!	NO SCRIPT SUPPORT
	MString&	operator[]( unsigned int index );

	//!	NO SCRIPT SUPPORT
	friend OPENMAYA_EXPORT std::ostream &operator<<(std::ostream &os,
											   const MStringArray &array);

END_NO_SCRIPT_SUPPORT:

protected:
// No protected members

private:
	MStringArray( void* );
	void * arr;
	struct arrItem{
		const char *debugPeekValue;
		void* item;
	};
	const arrItem* debugPeekValue;
	bool   own;
	static const char* className();
	void syncDebugPeekValue();
};

#endif /* __cplusplus */
#endif /* _MStringArray */
