#ifndef _MSwatchRenderBase
#define _MSwatchRenderBase
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MSwatchRenderBase
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MImage.h>

// ****************************************************************************
// DECLARATIONS

class MObject ;

//! \ingroup OpenMayaRender
//! \brief Swatch Render Base class
/*!
A class providing an interface through which a plugin can implement a
class to provide custom rendered images for swatches which are
displayed in hypershade and the Attribute Editor.

By deriving from this class and implementing the doIteration function,
swatches for nodes (having the required classification) can be custom
rendered by the plugin.

The derived class needs to be registered with Maya using the interface
provided by MSwatchRenderRegister.  Please refer to documentation of
MSwatchRenderRegister for more details.

To indicate that swatch for a certain node type will be generated by
the plugin the classfication string of the node needs to contain the
following string : "swatch/<swatch generator name>" The swatch
generator name string should match the name used to register the
swatch generator class.
*/
class OPENMAYARENDER_EXPORT MSwatchRenderBase {
public:
	//! constructor
	MSwatchRenderBase(MObject obj, MObject renderObj, int res);

	//! destructor
	virtual	~MSwatchRenderBase();

	//! Method called to do swatch image generation, derived classes
	//! needs to implement this.
	virtual bool doIteration()  ;

	//! returns the node for which the swatch is required to be generated
	MObject swatchNode() const ;
	//! returns the node used to compute the swatch
	MObject node() const ;

	//! returns the expected resolution of the swatch image
	int		resolution() const ;

	//! returns the swatch image
	MImage&  image() ;
	// this has to be a reference otherwise the internal image gets deleted !

protected :
	// node for which the swatch is required
	MObject fObjToSwatch ;
	MObject fObjToRender ;

	// object in which the swatch image should be stored
	MImage fImage ;

	// resolution at which the swatch image is to be generated
	int fRes ;

private:
	// No private members
};

inline
MObject MSwatchRenderBase::swatchNode() const
{
	return fObjToSwatch ;
}

inline
MObject MSwatchRenderBase::node() const
{
	return fObjToRender ;
}

inline int
MSwatchRenderBase::resolution() const
{
	return fRes ;
}

inline MImage&
MSwatchRenderBase::image()
{
	return fImage ;
}

#endif /* __cplusplus */
#endif /* _MSwatchRenderBase */
