#ifndef _MUint64Array
#define _MUint64Array
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MUint64Array
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES


#include <maya/MTypes.h>
#include <maya/MStatus.h>

// ****************************************************************************
// CLASS DECLARATION (MUint64Array)

//! \ingroup OpenMaya
//! \brief Array of MUint64 data type. 
/*!
This class implements an array of MUint64s.  Common convenience functions
are available, and the implementation is compatible with the internal
Maya implementation so that it can be passed efficiently between plugins
and internal maya data structures.
*/
class OPENMAYA_EXPORT MUint64Array
{
public:
					MUint64Array();
					MUint64Array( const MUint64Array& other );
					MUint64Array( const MUint64 src[], unsigned int count );
					MUint64Array( unsigned int initialSize,
								  MUint64 initialValue = 0 );
					~MUint64Array();
 	MUint64Array &  operator=( const MUint64Array & other );
	MStatus			set( MUint64 element, unsigned int index );
	MStatus			setLength( unsigned int length );
 	unsigned int        length() const;
 	MStatus         remove( unsigned int index );
 	MStatus         insert( MUint64 element, unsigned int index );
 	MStatus         append( MUint64 element );
 	MStatus         copy( const MUint64Array& source );
 	MStatus		 	clear();
	MStatus			get( MUint64[] ) const;
	void			setSizeIncrement ( unsigned int newIncrement );
	unsigned int		sizeIncrement () const;

BEGIN_NO_SCRIPT_SUPPORT:

	//! NO SCRIPT SUPPORT
	MUint64			operator[]( unsigned int index ) const;

	//!	NO SCRIPT SUPPORT
 	MUint64 &	 	operator[]( unsigned int index );

	//!	NO SCRIPT SUPPORT
	friend OPENMAYA_EXPORT std::ostream &operator<<(std::ostream &os,
											   const MUint64Array &array);

END_NO_SCRIPT_SUPPORT:

#if defined(SWIG)
	swigTPythonObjectConverter(MUint64);
	swigExtendAPIArray(MUint64Array,MUint64);
#endif

protected:
// No protected members

private:
	MUint64Array( void* );
 	void * arr;
	const MUint64*  debugPeekValue;
	bool   fOwn;
	static const char* className();
	void			syncDebugPeekValue();
};

#endif /* __cplusplus */
#endif /* _MUint64Array */
