#ifndef _MnSolver
#define _MnSolver
//-
// ==========================================================================
// Copyright (C) 1995 - 2006 Autodesk, Inc., and/or its licensors.  All
// rights reserved.
//
// The coded instructions, statements, computer programs, and/or related
// material (collectively the "Data") in these files contain unpublished
// information proprietary to Autodesk, Inc. ("Autodesk") and/or its
// licensors,  which is protected by U.S. and Canadian federal copyright law
// and by international treaties.
//
// The Data may not be disclosed or distributed to third parties or be
// copied or duplicated, in whole or in part, without the prior written
// consent of Autodesk.
//
// The copyright notices in the Software and this entire statement,
// including the above license grant, this restriction and the following
// disclaimer, must be included in all copies of the Software, in whole
// or in part, and all derivative works of the Software, unless such copies
// or derivative works are solely in the form of machine-executable object
// code generated by a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND.
// AUTODESK DOES NOT MAKE AND HEREBY DISCLAIMS ANY EXPRESS OR IMPLIED
// WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE WARRANTIES OF
// NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
// OR ARISING FROM A COURSE OF DEALING, USAGE, OR TRADE PRACTICE. IN NO
// EVENT WILL AUTODESK AND/OR ITS LICENSORS BE LIABLE FOR ANY LOST
// REVENUES, DATA, OR PROFITS, OR SPECIAL, DIRECT, INDIRECT, OR
// CONSEQUENTIAL DAMAGES, EVEN IF AUTODESK AND/OR ITS LICENSORS HAS
// BEEN ADVISED OF THE POSSIBILITY OR PROBABILITY OF SUCH DAMAGES.
// ==========================================================================
//+
//
// CLASS:    MnSolver
//
// ****************************************************************************

#if defined __cplusplus

// ****************************************************************************
// INCLUDED HEADER FILES



#include <maya/MTypes.h>
#include <maya/MStatus.h>
#include <maya/MnObject.h>

class TnSolver;
class MFloatPointArray;

// ****************************************************************************
// CLASS DECLARATION (MnSolver)

//! \ingroup OpenMayaFX
//! \brief Class for wrapping N solver objects
/*!
  This class wraps the internal Maya representation of a Nucleus solver
  suitable for use with the Nucleus objects such as nCloth or nParticles
*/
class OPENMAYAFX_EXPORT MnSolver
{

public:
	MnSolver();
	virtual			~MnSolver();

	MStatus createNSolver();
	MStatus addNObject(MnObject *obj);
	MStatus removeNObject(MnObject *obj);
	MStatus setGravity(float grav);
	MStatus setGravityDir(float gravX, float gravY, float gravZ);
	MStatus setAirDensity (float dens);
	MStatus setWindSpeed (float speed);
	MStatus setWindDir(float windX, float windY, float windZ);
	MStatus setWindNoiseIntensity (float noise);
	MStatus setDisabled(bool disabled);
	MStatus setSubsteps(int substeps);
	MStatus setMaxIterations(int maxIter);
	MStatus setStartTime(float startTime);
	MStatus makeAllCollide();
	MStatus removeAllCollisions();
	MStatus solve(float solveTime);
	

protected:
	TnSolver * fNSolver;
	bool   fOwn;

private:
	MnSolver( TnSolver * );
	void  setNSolver(TnSolver * nSolv,bool own);
	TnSolver * getNSolver() { return fNSolver; };
	friend class MFnNObjectData;
};

#endif /* __cplusplus */
#endif /* _MnCloth */
