#ifndef __FBGROUP_H__
#define __FBGROUP_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file fbgroup.h
*	Groups interface for FBSDK
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif

__FB_FORWARD( FBGroup );
__FB_FORWARD( FBSet );
FB_DEFINE_COMPONENT( FBSDK_DLL, Group );
FB_DEFINE_COMPONENT( FBSDK_DLL, Set );

typedef class FBSDK_DLL FBPropertyBaseList< HFBGroup > FBPropertyBaseListGroup;
typedef class FBSDK_DLL FBPropertyBaseList< HFBSet > FBPropertyBaseListSet;
typedef class FBSDK_DLL FBPropertyBaseList< HFBComponent > FBPropertyBaseListGroupItems;
typedef class FBSDK_DLL FBPropertyBaseList< HFBComponent > FBPropertyBaseListSetItems;

FB_FORWARD( FBPropertyListGroup );
FB_FORWARD( FBPropertyListSet );
FB_FORWARD( FBPropertyListGroupItems );
FB_FORWARD( FBPropertyListSetItems );

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//! <b>List:</b> Group
class FBSDK_DLL FBPropertyListGroup : public FBPropertyBaseList< HFBGroup >
{
public:
	/**	Internal operation only. You cannot add to this list. */
	virtual int Add(HFBGroup pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual int Remove(HFBGroup pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual void RemoveAt(int pIndex);

	/**	Get the group at \e pIndex.
	*	\param	pIndex	Index of group to get.
	*	\return Group at \e pIndex.
	*/
	virtual HFBGroup operator[](int pIndex);

	/** Get the number of group.
	*	\return Number of group.
	*/
	virtual int GetCount();
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//! <b>List:</b> Set
class FBSDK_DLL FBPropertyListSet : public FBPropertyBaseList< HFBSet >
{
public:
	/**	Internal operation only. You cannot add to this list. */
	virtual int Add(HFBSet pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual int Remove(HFBSet pItem);

	/**	Internal operation only. You cannot remove from this list. */
    virtual void RemoveAt(int pIndex);

	/**	Get the set at \e pIndex.
	*	\param	pIndex	Index of set to get.
	*	\return Set at \e pIndex.
	*/
	virtual HFBSet operator[](int pIndex);

	/** Get the number of set.
	*	\return Number of set.
	*/
	virtual int GetCount();
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//! <b>List:</b> Group Items
class FBSDK_DLL FBPropertyListGroupItems : public FBPropertyBaseList< HFBComponent >
{
public:
	/**	Add an item to the property list.
	*	\param	pItem	Item to add to list.
	*	\return	Number of items in list after operation.
	*	\remark	If -1 is returned, the item could not be added.
	*/
	virtual int Add(HFBComponent pItem);

	/**	Remove item \e pItem from property list.
	*	\param	pItem	Item to remove from list.
	*	\return Number of items in list after operation.
	*/
    virtual int Remove(HFBComponent pItem);

	/** Remove the item at \e pIndex.
	*	\param pIndex	Index of track to remove.
	*/
    virtual void RemoveAt(int pIndex);

	/**	Get the item at \e pIndex.
	*	\param	pIndex	Index of item to get.
	*	\return Item at \e pIndex.
	*/
	virtual HFBComponent operator[](int pIndex);

	/** Get the number of item.
	*	\return Number of items.
	*/
	virtual int GetCount();
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//! <b>List:</b> Set Items
class FBSDK_DLL FBPropertyListSetItems : public FBPropertyBaseList< HFBComponent >
{
public:
	/**	Add an item to the property list.
	*	\param	pItem	Item to add to list.
	*	\return	Number of items in list after operation.
	*	\remark	If -1 is returned, the item could not be added.
	*/
	virtual int Add(HFBComponent pItem);

	/**	Remove item \e pItem from property list.
	*	\param	pItem	Item to remove from list.
	*	\return Number of items in list after operation.
	*/
    virtual int Remove(HFBComponent pItem);

	/** Remove the item at \e pIndex.
	*	\param pIndex	Index of track to remove.
	*/
    virtual void RemoveAt(int pIndex);

	/**	Get the item at \e pIndex.
	*	\param	pIndex	Index of item to get.
	*	\return Item at \e pIndex.
	*/
	virtual HFBComponent operator[](int pIndex);

	/** Get the number of item.
	*	\return Number of items.
	*/
	virtual int GetCount();
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// FBGroup
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** Objects Grouping class.
*	This class is an interface to manipulate object's grouping in the scene.
*/
class FBSDK_DLL FBGroup : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare(FBGroup, FBComponent);
public:

	/**	Constructor.
	*	\param	pName	Group name.
	*	\param	pObject	For internal use only.
	*/
	FBGroup(char* pName, HIObject pObject=NULL);

	/** Virtual FBDelete function.
	*/
	virtual void FBDelete();

	/** Select
	*	\param	pSelect	If <b>true</b>, group contents will be selected.
	*/
	void Select(bool pSelect);

	FBPropertyBool				Show;			//!< <b>Read Write Property:</b> Controls if objects in the group are displayed.
	FBPropertyBool				Pickable;		//!< <b>Read Write Property:</b> Controls if objects in the group are pickable.
	FBPropertyBool				Transformable;	//!< <b>Read Write Property:</b> Controls if objects in the group are transformable.
	FBPropertyListGroupItems	Items;			//!< <b>List:</b> Items in the group.
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// FBSet
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/** Objects Set class.
*	This class is an interface to manipulate object sets in the scene.
*	Note that an item cannot be in two FBSet at a time. Also, an FBSet cannot
*	contain FBGroup objects, but the contrary is possible though.
*/
class FBSDK_DLL FBSet : public FBComponent
{
	//--- Open Reality declaration.
	__FBClassDeclare(FBSet, FBComponent);
public:

	/**	Constructor.
	*	\param	pName	Set name.
	*	\param	pObject	For internal use only.
	*/
	FBSet(char* pName, HIObject pObject=NULL);

	/** Virtual FBDelete function.
	*/
	virtual void FBDelete();

	/** Select
	*	\param	pSelect	If <b>true</b>, set contents will be selected.
	*/
	void Select(bool pSelect);

	FBPropertyAnimatableBool	Visibility;		//!< <b>Read Write Property:</b> Visibility of set (animatable).
	FBPropertyBool				Pickable;		//!< <b>Read Write Property:</b> Controls if objects in the set are pickable.
	FBPropertyBool				Transformable;	//!< <b>Read Write Property:</b> Controls if objects in the set are transformable.
	FBPropertyListSetItems		Items;			//!< <b>List:</b> Items in the set.
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef FBSDKUseNamespace
	}
#endif
#endif /* this must be the last line of this file */
