#ifndef __FBUNDOMANAGER_H__
#define __FBUNDOMANAGER_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/** \file fbundomanager.h
*   Undo manager.
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
    #define FBSDK_DLL K_DLLIMPORT
#endif

#ifdef FBSDKUseNamespace
    namespace FBSDKNamespace {
#endif

////////////////////////////////////////////////////////////////////////////////////
// FBUndoManager
////////////////////////////////////////////////////////////////////////////////////
FB_FORWARD( FBUndoManager );

/** Access to global undo and redo functionality.
*   Users have the possibility of undoing and redoing actions performed using
*   the GUI.
*   At the present time it is impossible to interact with the undo and redo stacks
*   to provide support for custom actions.
*   
*   This class cannot be used as a base class.
*/
class FBSDK_DLL FBUndoManager {

    /** Disabled copy constructor.
    *   Voluntarily making the copy constructor unavailable.
    */
    FBUndoManager( const FBUndoManager& );

    /** Disabled assignment operator.
    *   Voluntarily making the assignment operator unavailable.
    */
    FBUndoManager& operator=( const FBUndoManager& );

public:

    /** Constructor.
    */
    FBUndoManager();

    /** Clear the undo and redo stacks.
    *   @return A boolean value indicating success (true) or failure (false).
    */
    bool Clear();

    /** Redo last undone action.
    */
    void Redo();

    /** Undo last action.
    *   @param pNoRedo  If true, once the action is undone, it cannot be redone.
    */
    void Undo( bool pNoRedo = false );

};

#ifdef FBSDKUseNamespace
    }
#endif
#endif

