#ifndef __FBVIDEOGRABBER_H__
#define __FBVIDEOGRABBER_H__
/**************************************************************************
 Copyright (c) 1994 - 2006 Autodesk, Inc. and/or its licensors.
 All Rights Reserved.
 
 The coded instructions, statements, computer programs, and/or related 
 material (collectively the "Data") in these files contain unpublished 
 information proprietary to Autodesk, Inc. and/or its licensors, which is 
 protected by Canada and United States of America federal copyright law 
 and by international treaties.
 
 The Data may not be disclosed or distributed to third parties, in whole 
 or in part, without the prior written consent of Autodesk, Inc. 
 ("Autodesk").
 
 THE DATA IS PROVIDED "AS IS" AND WITHOUT WARRANTY.
 ALL WARRANTIES ARE EXPRESSLY EXCLUDED AND DISCLAIMED. AUTODESK MAKES NO 
 WARRANTY OF ANY KIND WITH RESPECT TO THE DATA, EXPRESS, IMPLIED OR 
 ARISING BY CUSTOM OR TRADE USAGE, AND DISCLAIMS ANY IMPLIED WARRANTIES 
 OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR 
 PURPOSE OR USE. WITHOUT LIMITING THE FOREGOING, AUTODESK DOES NOT 
 WARRANT THAT THE OPERATION OF THE DATA WILL BE UNINTERRUPTED OR ERROR 
 FREE.
 
 IN NO EVENT SHALL AUTODESK, ITS AFFILIATES, PARENT COMPANIES, LICENSORS 
 OR SUPPLIERS ("AUTODESK GROUP") BE LIABLE FOR ANY LOSSES, DAMAGES OR 
 EXPENSES OF ANY KIND (INCLUDING WITHOUT LIMITATION PUNITIVE OR MULTIPLE 
 DAMAGES OR OTHER SPECIAL, DIRECT, INDIRECT, EXEMPLARY, INCIDENTAL, LOSS 
 OF PROFITS, REVENUE OR DATA, COST OF COVER OR CONSEQUENTIAL LOSSES OR 
 DAMAGES OF ANY KIND), HOWEVER CAUSED, AND REGARDLESS OF THE THEORY OF 
 LIABILITY, WHETHER DERIVED FROM CONTRACT, TORT (INCLUDING, BUT NOT 
 LIMITED TO, NEGLIGENCE), OR OTHERWISE, ARISING OUT OF OR RELATING TO THE 
 DATA OR ITS USE OR ANY OTHER PERFORMANCE, WHETHER OR NOT AUTODESK HAS 
 BEEN ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 
**************************************************************************/

/**	\file fbvideograbber.h
*	Video grabbing.
*/

#include <kaydaradef.h>
#ifndef FBSDK_DLL 
	#define FBSDK_DLL K_DLLIMPORT
#endif

#include <fbsdk/fbcomponent.h>
#include <fbsdk/fbaudiofmt.h>

#ifdef FBSDKUseNamespace
	namespace FBSDKNamespace {
#endif

__FB_FORWARD( FBVideoGrabber );
FB_DEFINE_COMPONENT( FBSDK_DLL, VideoGrabber );

enum FBVideoRenderViewingMode	{FBViewingModeStandard, FBViewingModeModelsOnly, FBViewingModeXRay, FBViewingModeCurrent, FBViewingModeCount};
enum FBVideoRenderFieldMode		{FBFieldModeNoField, FBFieldModeField0, FBFieldModeField1, FBFieldModeHalfField0, FBFieldModeHalfField1, FBFieldModeCount};
enum FBVideoRenderDepth			{FBVideoRender24Bits, FBVideoRender32Bits, FBVideoRenderDepthCount};

/** Video Grabbing Options structure.
*	Contain options to control how the grabbing process will occur.
*/
struct FBVideoGrabOptions
{
	FBTimeSpan					mTimeSpan;			//!< <b>Property:</b> Start and stop selection time to grab.
	FBTime						mTimeSteps;			//!< <b>Property:</b> Time step length between each grab.
	FBCameraResolutionMode	mCameraResolution;	//!< <b>Property:</b> Camera Resolution.
	FBVideoRenderDepth			mBitsPerPixel;		//!< <b>Property:</b> Video grab color depth.
	FBVideoRenderFieldMode		mFieldMode;			//!< <b>Property:</b> Video grab field mode.
	FBVideoRenderViewingMode	mViewingMode;		//!< <b>Property:</b> Video grab viewing mode.
	FBString					mOutputFileName;	//!< <b>Property:</b> Grabbing destination file.
	bool						mShowSafeArea;		//!< <b>Property:</b> If true, display safe area. NOTE: If you use your own FBView, set also this option in FBViewingOptions.
	bool						mShowTimeCode;		//!< <b>Property:</b> If true, display time code information. NOTE: If you use your own FBView, set also this option in FBViewingOptions.
	bool						mShowCameraLabel;	//!< <b>Property:</b> If true, display camera label information. NOTE: If you use your own FBView, set also this option in FBViewingOptions.
	bool						mAntiAliasing;		//!< <b>Property:</b> If true, video frames will be anti-aliased.
	bool						mRenderAudio;		//!< <b>Property:</b> If true and there's audio in the scene, add audio to the output file.
	FBAudioFmt					mAudioRenderFormat;	//!< <b>Property:</b> Audio render format.
    int                         mStillImageCompression;   //!< <b>Property:</b> Compression ratio for image(jpg) 0-100 where 0=Greatest compression, 100=Least Compression.
};

typedef FBVideoGrabOptions* HFBVideoGrabOptions;

/** Video Grabbing Statistics structure.
*	Contain statistics about the current video grabbing process.
*/
struct FBVideoGrabStats
{
	int		mTotalFrameCount;			//!< <b>Property:</b> Total frame count to grab.
	int		mRemainingFrameCount;		//!< <b>Property:</b> Remaining frame count to grab.
	FBTime	mTotalTimeElapsed;			//!< <b>Property:</b> Current total time elapsed since grab's started.
	FBTime	mEstimatedTime;				//!< <b>Property:</b> Estimated time to complete grab.
	FBTime	mEstimatedTimeRemaining;	//!< <b>Property:</b> Remaining estimated time to complete grab.
	FBTime	mTimePerFrame;				//!< <b>Property:</b> Time it tooks to render and grab previous frame.
};

/** Video Grabber class.
*	Used to grab video frames generated with the FBRenderer.
*/
class FBSDK_DLL FBVideoGrabber : public FBComponent 
{
	//--- Open Reality declaration.
	__FBClassDeclare(FBVideoGrabber, FBComponent);
  public:

	/**	Constructor.
	*	\param	pObject	For internal use only.
	*/
	FBVideoGrabber(HIObject pObject=NULL);

	//--- Grabbing options management
	/** SetOptions.
	*	\param pOptions Struct that contain all grabbing options.
	*/
	void SetOptions(HFBVideoGrabOptions pOptions);

	/** GetOptions give you a copy of current grabbing options.
	*	\return Struct that contain all grabbing options.
	*/
	FBVideoGrabOptions GetOptions();

	/** SetDefaultOptions.
	*	This function reset all grabbing options to the default value.
	*/
	void ResetOptions();

	//--- Rendering functions setup
	/** SetRefreshViewFunc.
	*	Set the callback function to be called for each frame render.
	*
	*	\param pThis Pointer to the callback receiver.
	*	\param pCallbackFuncPtr Pointer to the callback function.
	*/
	void SetRefreshViewFunc(void* pThis, void(*pCallbackFuncPtr)(void*));

	/** SetPostRenderFrameCallback.
	*	Set the callback function to be called after each frame is rendered.
	*
	*	\param pThis Pointer to the callback receiver.
	*	\param pCallbackFuncPtr Pointer to the callback function.
	*/
	void SetPostRenderFrameCallback(void* pThis, void(*pCallbackFuncPtr)(void*));

	//--- Grabbing control
	/** BeginGrab.
	*	Begin video grabbing session.
	*
	*	\return \b True if we can begin the grab session.
	*/
	bool BeginGrab();

	/** Grab.
	*	Grab all specified video frames.
	*/
	void Grab();

	/** EndGrab.
	*	Close video grabbing session.
	*/
	void EndGrab();
	
	//--- Grabbing statistics query
	/** GetStatistics.
	*	\return Struct that contain all grabbing statistics.
	*/
	FBVideoGrabStats GetStatistics();
	
	//--- Errors management
	/** GetLastErrorMsg.
	*	\return If an error occured, this function returns the last error message, otherwise an empty string.
	*/
	FBString GetLastErrorMsg();
};


#ifdef FBSDKUseNamespace
	}
#endif
#endif /* this must be the last line of this file */
