#ifndef KARCH_TYPES_EE_H
#define KARCH_TYPES_EE_H
/**************************************************************************
 Copyright (C) 1994 - 2004 Systemes Alias Quebec Inc. and/or its licensors.
 All rights reserved.

 The  coded  instructions,  statements, computer programs, and/or related
 material  (collectively  the  "Data") in these files contain unpublished
 information  proprietary  to  Systemes  Alias  Quebec  Inc.  and/or  its
 licensors,  which  is protected by Canadian and US federal copyright law
 and by international treaties.

 The  Data  may  not  be  disclosed or distributed to third parties or be
 copied  or  duplicated,  in  whole or in part, without the prior written
 consent of Alias Systems Corp ("Alias").

 THE  DATA  IS  PROVIDED  "AS IS".  ALIAS HEREBY DISCLAIMS ALL WARRANTIES
 RELATING TO THE DATA, INCLUDING, WITHOUT LIMITATION, ANY AND ALL EXPRESS
 OR   IMPLIED  WARRANTIES  OF  NON-INFRINGEMENT,  MERCHANTABILITY  AND/OR
 FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL ALIAS BE LIABLE FOR
 ANY  DAMAGES WHATSOEVER, WHETHER DIRECT, INDIRECT, SPECIAL, OR PUNITIVE,
 WHETHER  IN  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 OR  IN  EQUITY,  ARISING  OUT OF ACCESS TO, USE OF, OR RELIANCE UPON THE
 DATA.
**************************************************************************/

#include <float.h>

#define KARCH_LITTLE_ENDIAN

typedef unsigned short		kWChar;			/* international character */
#define K_WCHAR_MIN			(0)
#define K_WCHAR_MAX			(65535)
typedef kWChar *			kWCharPtr;		/* international string */

#ifdef K_UNICODE
    typedef kWChar char;
    typedef kWCharPtr kTCharPtr;
    #ifndef _T
        #define _T(a) L ## a
    #endif
#else
    typedef char char;
    typedef char* kTCharPtr;
    #ifndef _T
        #define _T(a) a
    #endif
#endif

#define K_SHORT_MIN			(-32768)
#define K_SHORT_MAX			(32767)
#define K_USHORT_MIN		(0)
#define K_USHORT_MAX		(65535)

#define K_INT_MIN			(0x80000000)
#define K_INT_MAX			(0x7fffffff)
#define K_UINT_MIN			(0)
#define K_UINT_MAX			(0xffffffff)

// in ee-gcc longs are 64 bits, so we use int for 32bits type
typedef signed int			kLong;
typedef unsigned int		kULong;
#define K_LONG_MIN			(0x80000000)
#define K_LONG_MAX			(0x7fffffff)
#define K_ULONG_MIN			(0)
#define K_ULONG_MAX			(0xffffffff)

typedef long				kLongLong;
typedef unsigned long		kULongLong;
#define K_LONGLONG_MIN		(0x8000000000000000)
#define K_LONGLONG_MAX		(0x7fffffffffffffff)
#define K_ULONGLONG_MIN		(0)
#define K_ULONGLONG_MAX		(0xffffffffffffffff)
#define K_LONGLONG(a)       a
#define K_ULONGLONG(a)      a

#define K_FLOAT_MIN			FLT_MIN					// minimum positive value
#define K_FLOAT_MAX			FLT_MAX					// maximum positive value

#define K_DOUBLE_MIN		DBL_MIN					// minimum positive value
#define K_DOUBLE_MAX		DBL_MAX					// maximum positive value

typedef signed char			kInt8;
typedef unsigned char		kUInt8;

typedef signed short		kInt16;
typedef unsigned short		kUInt16;

typedef signed int			kInt32;
typedef unsigned int		kUInt32;

typedef signed long			kInt64;
typedef unsigned long		kUInt64;
#define K_INT64_MIN			(0x8000000000000000)
#define K_INT64_MAX			(0x7fffffffffffffff)
#define K_UINT64_MIN		(0)
#define K_UINT64_MAX		(0xffffffffffffffff)

// used a lot for pointers in DMA packets and other
// low level PSX2 stuff, no math operations possible on that
// type, only used for moving data around	
typedef int					kInt128 __attribute__ ((mode(TI)));
typedef unsigned int		kUInt128 __attribute__ ((mode(TI)));

typedef int				kEnum;

#define kOffset				kULong

typedef kOffset				kSizeT;

#define K_REFERENCE_MIN		K_ULONG_MIN
#define K_REFERENCE_MAX		K_ULONG_MAX

#define K_TEMPLATE_SPEC(t)

#define K_INLINE			inline
#define K_FORCEINLINE		K_INLINE

// Atomic definitions

typedef kUInt32			    kAtomic;
#define K_ATOMIC_MIN		K_INT32_MIN
#define K_ATOMIC_MAX		K_INT32_MAX
#define K_SIZEOF_ATOMIC		4
#define K_ATOMIC_BITS		32

typedef kUInt64					kLongAtomic;
#define K_LONGATOMIC_MIN		K_UINT64_MIN
#define K_LONGATOMIC_MAX		K_UINT64_MAX
#define K_SIZEOF_LONGATOMIC		8
#define K_LONGATOMIC_BITS		64


#endif /* KARCH_TYPES_WIN32_H */
