// ADOBE SYSTEMS INCORPORATED
// (c) Copyright  1993 - 2005-2007 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this 
// file in accordance with the terms of the Adobe license agreement
// accompanying it.  If you have received this file from a source
// other than Adobe, then your use, modification, or distribution
// of it requires the prior written permission of Adobe.
//-------------------------------------------------------------------
/**
* \file PIStringTerminology.h
*
* \brief  This file defines constants for the strings used to access descriptor
* events, keys, classes, enum types, and enum values. 
* 
* \details
*  Copyright 2000 Adobe Systems Incorporated.
*  All Rights Reserved.
* 
* Distribution:
* 	PUBLIC
*/

#ifndef __PIStringTerminology_h__
#define __PIStringTerminology_h__

#if PRAGMA_ONCE
#pragma once
#endif

//*****************************************************************************

// This file defines constants for the strings used to access descriptor
// events, keys, classes, enum types, and enum values. The name of each symbol is
// the same as the string it represents with "k" prepended and "Str" appended.
// The purpose of using these symbols instead of literal strings is to detect
// misspellings at call sites. 
//
// Check that your new names are unique by searching within UActionsTerminology.r
//
// * All event names must be different from all other event names.
// * All class names must be different from all other class names
// * All enumeration type names must be different from all other enumeration type names
// * All keys must be different from all other keys used in the same class or event.
// * All enumeration values must be different from all other enumeration values
//   in the same enumeration type.
// * A class, event, enumeration type, enumeration value, and a key can all have
//   the same name.
//
// Put generally, the names for things must only be unique within a particular
// category and scope, and in fact you shouldn't make things unique unnecessarily --
// generic terms are preferable, and if there's an existing word for something, use it.
//
// If you need to get the DescType value corresponding to any string, use
// GetStringID (stringValue). This is useful when you need to pass an event
// or other ID to a routine that has only a DescType parameter interface or
// when you have been passed a DescType event, class, etc. value and need
// to compare it against one of these string values.


/******************************************************************************/

#define k128BitFloatingPointStr "128BitFloatingPoint"
#define k16BitsPerPixelStr "16BitsPerPixel"
#define k1BitPerPixelStr "1BitPerPixel"
#define k2BitsPerPixelStr "2BitsPerPixel"
#define k32BitsPerPixelStr "32BitsPerPixel"
#define k32BitPreviewOptionsStr	"32BitPreviewOptions"
#define k3DSetGlobalAmbientStr	"set3DGlobalAmbient"
#define k3DAddLayerFromFileStr	"add3DLayerFromFile"
#define k3DUpdateSceneObjectsStr	"updateSceneObjects"
#define k3DLayerOpenTextureStr	"open3DLayerTexture"
#define k3DSaveTexturesStr	"save3DTextures"
#define k3DExportLayerStr	"export3DModel"
#define k3DLightsNewLightStr	"3DLightsNewLight"
#define k3DReloadLayerStr	"reload3DModel"
#define k3DToggleTextureStr	"toggle3DTexture"
#define k3DDoFinalRenderStr	"doFinal3DRender"
#define k3DToggleTexturesStr	"toggle3DTextures"
#define k3DSetStateStr	"set3DState"
#define k3DCreatePostcardStr	"create3DPostcard"
#define k3DCreateTiledPaintingStr	"create3DTiledPainting"
#define k3DCreateVolumeStr	"createVolume"
#define k3DAntiAliasStr "3DAntiAlias"
#define k3DRenderUVWireframeStr	"renderUVWireframe"
#define k3DRenderUVShadedStr	"renderUVShaded"
#define k3DRenderUVNormalMapStr	"renderUVNormalMap"
#define k3DRibbonEffectStr "3DRibbonEffect"
#define k3DTransformStr "3DTransform"
#define k3DTransformObjectStr "transform3DObject"
#define k3DSetCameraStr "set3DCamera"
#define k3DSetObjectPositionStr "set3DObjectPosition"
#define k3DSetCrossSectionStr "set3DCrossSection"
#define k3DSetLightModeStr "set3DLightMode"
#define k3DSetRenderModeStr "set3DRenderMode"
#define k3DSetEngineStr "set3DEngine"
#define k3DSetPaintTypeStr "set3DPaintType"
#define k3DSetTransferFunctionStr "set3DTransferFunction"
#define k3DAdd3DViewStr "add3DView"
#define k3DDelete3DViewStr "delete3DView"
#define k3DAdd3DObjectPositionStr "add3DObjectPosition"
#define k3DDelete3DObjectPositionStr "delete3DObjectPosition"
#define k3DSetLightSwitchStr "set3DLightSwitch"
#define k3DSetLightPositionStr "set3DLightPosition"
#define k3DSetLightDirectionStr "set3DLightDirection"
#define k3DSetLightTypeStr "set3DLightType"
#define k3DSetLightColorStr "set3DLightColor"
#define k3DSetLightHotspotAngleStr "set3DLightHotspotAngle"
#define k3DSetLightFalloffAngleStr "set3DLightFalloffAngle"
#define k3DSetLightInnerRadiusStr "set3DLightInnerRadius"
#define k3DSetLightOuterRadiusStr "set3DLightOuterRadius"
#define k3DSetLightIntensityStr "set3DLightIntensity"
#define k3DSetLightCastsShadowsSwitchStr "set3DLightCastsShadowsSwitch"
#define k3DSetLightAttenuationSwitchStr "set3DLightAttenuationSwitch"
#define k3DSetLightAttenuationTypeStr "set3DLightAttenuationType"
#define k3DSetLightAttenuationCoeffStr "set3DLightAttenuationCoeff"
#define k3DSetLightPointAtOriginStr "set3DLightPointAtOrigin"
#define k3DSetLightMoveToCurrViewStr "set3DLightMoveToCurrView"
#define k3DSetLightSoftShadowsStr	"set3DLightSoftShadows"
#define k3DSetMeshPositionStr "set3DMeshPosition"
#define k3DSetMeshDirectionStr "set3DMeshDirection"
#define k3DSetMeshSwitchStr "set3DMeshSwitch"
#define k3DSetMeshShadowCatcherStr "set3DMeshShadowCatcher"
#define k3DSetMeshShadowCastingStr "set3DMeshShadowCasting"
#define k3DSetMeshShadowInvisibleStr "set3DMeshShadowInvisible"
#define k3DSetMaterialSwitchStr "set3DMaterialSwitch"
#define k3DSetMaterialScalarStr "set3DMaterialScalar"
#define k3DSetMaterialColorStr "set3DMaterialColor"
#define k3DSetMaterialTexturePathStr "set3DMaterialTexturePath"
#define k3DSetMaterialTextureInfoStr "set3DMaterialTextureInfo"
#define k3DSetPaintFalloffStr "set3DPaintFalloff"
#define k3DHideAllSurfacesStr "hideAll3DSelected"
#define k3DHideTopSurfaceStr "hideTop3DSelected"
#define k3DHideEnclosedOnlyStr "hide3DEnclosedOnly"
#define k3DRevealAllStr "revealAll3D"
#define k3DInvertVisibleStr "invert3DSelected"
#define k3DPaintTypeDiffuse					"paint3DDiffuse"
#define k3DPaintTypeEnvironment				"paint3DEnvironment"
#define k3DPaintTypeBump					"paint3DBump"
#define k3DPaintTypeSpecular				"paint3DSpecular"
#define k3DPaintTypeOpacity					"paint3DOpacity"
#define k3DPaintTypeShininess				"paint3DShininess"
#define k3DPaintTypeSelfIllumination		"paint3DSelfIllumination"
#define k3DPaintTypeReflection				"paint3DReflection"
#define k3DPaintTypeNormal					"paint3DNormal"
#define k3DPaintTypeCustom					"paint3DCustom"
#define k3DRenderSettings					"renderSettings3D"
#define k3DReparameterizeModelStr			"reparameterize3DModel"
#define k3DRotateObjectToolStr			"3DObjectRotateTool"
#define k3DRollObjectToolStr			"3DObjectRollTool"
#define k3DPanObjectToolStr				"3DObjectPanTool"
#define k3DSlideObjectToolStr			"3DObjectSlideTool"
#define k3DScaleObjectToolStr			"3DObjectScaleTool"
#define k3DRotateMeshToolStr			"3DMeshRotateTool"
#define k3DRollMeshToolStr				"3DMeshRollTool"
#define k3DPanMeshToolStr				"3DMeshPanTool"
#define k3DSlideMeshToolStr				"3DMeshSlideTool"
#define k3DScaleMeshToolStr				"3DMeshScaleTool"
#define k3DRotateLightToolStr			"3DLightRotateTool"
#define k3DRollLightToolStr				"3DLightRollTool"
#define k3DPanLightToolStr				"3DLightPanTool"
#define k3DSlideLightToolStr			"3DLightSlideTool"
#define k3DOrbitCameraToolStr			"3DOrbitCameraTool"
#define k3DRollCameraToolStr			"3DRollCameraTool"
#define k3DPanCameraToolStr				"3DPanCameraTool"
#define k3DWalkCameraToolStr			"3DWalkCameraTool"
#define k3DFOVToolStr					"3DFOVTool"
#define k3DPanelKeyStr					"3DPanelKey"
#define k3DFromDepthPlaneStr			"create3DFromDepthPlane"
#define k3DFromDepthTwoSidedPlaneStr	"create3DFromDepthTwoSidedPlane"
#define k3DFromDepthCylinderStr			"create3DFromDepthCylinder"
#define k3DFromDepthSphereStr			"create3DFromDepthSphere"
#define k3DSet3DVisibilityStr			"objectVisibilitySwitch"
#define k3DDeleteObjStr					"objectDelete"
#define k3DNewObjStr					"objectNew"
#define k3DRenameObjStr					"objectRename"
#define k3DAddLightsFromPresetStr		"add3DLightsFromPreset"
#define k3DReplaceLightsFromPresetStr	"replace3DLightsFromPreset"
#define k3DReplaceMaterialFromPresetStr	"replace3DMaterialFromPreset"
#define k3DSaveLightsToPresetStr		"save3DLightsToPreset"
#define k3DSaveMaterialToPresetStr		"save3DMaterialToPreset"
#define k3DSelectPaintableStr			"select3DPaintable"
#define k3DBrowseOnlineStr				"browse3DOnline"
#define k3DAutoHideLayersStr			"autoHide3D"
#define k3DToggleGroundPlaneStr		"3DToggleGroundPlane"
#define k3DToggleLightGuidesStr		"3DToggleLightGuides"
#define k3DNewPointLightStr			"3DNewPointLight"
#define k3DNewSpotLightStr			"3DNewSpotLight"
#define k3DNewInfiniteLightStr		"3DNewInfiniteLight"
#define k3DAddLightsStr				"3DAddLights"
#define k3DReplaceLightsStr			"3DReplaceLights"
#define k3DSaveLightPresetStr		"3DSaveLightPreset"
#define k3DDeleteLightStr			"3DDeleteLight"
#define k3DReplaceMaterialStr		"3DReplaceMaterial"
#define k3DSaveMaterialPresetStr	"3DSaveMaterialPreset"
#define k4BitsPerPixelStr "4BitsPerPixel"
#define k5000Str "5000"
#define k5500Str "5500"
#define k6500Str "6500"
#define k72ColorStr "72Color"
#define k72GrayStr "72Gray"
#define k7500Str "7500"
#define k8BitsPerPixelStr "8BitsPerPixel"
#define k9300Str "9300"
#define kAddLayerFromFileStr "addLayerFromFile"
#define kAddLayerFromViewlessDocStr "addLayerFromViewlessDoc"
#define kADSBottomsStr "ADSBottoms"
#define kADSCentersHStr "ADSCentersH"
#define kADSCentersVStr "ADSCentersV"
#define kADSContentStr "ADSContent"
#define kADSHorizontalStr "ADSHorizontal"
#define kADSLeftsStr "ADSLefts"
#define kADSRightsStr "ADSRights"
#define kADSTopsStr "ADSTops"
#define kADSVerticalStr "ADSVertical"
#define kAEListStr "AEList"
#define kAERecordStr "AERecord"
#define kAOLPreferencesStr "AOLPreferences"
#define kAppBarStr "appBar"
#define kAppContainerStr "appContainer"
#define kASCII85Str "ASCII85"
#define kASCIIStr "ASCII"
#define kAntialiasGlossStr "antialiasGloss"
#define kartSprayerToolStr "artSprayerTool"
#define kaverageStr "average"
#define kcameraRawStr "cameraRaw"
#define kcameraRawJPEGStr "cameraRawJPEG"
#define kcameraRawPrefsStr "cameraRawPrefs"
#define kCIERGBStr "CIERGB"
#define kCineonHalfStr "CineonHalf"
#define kCineonFullStr "CineonFull"
#define kClassCustomHSFPairStr "classCustomHSFPair"
#define kCloseActionsPanelStr "closeActionsPanel"
#define kCloseAdjustmentsPanelStr "closeAdjustmentsPanel"
#define kCloseAnimationPanelStr "closeAnimationPanel"
#define kCloseBrushesPanelStr "closeBrushesPanel"
#define kCloseChannelsPanelStr "closeChannelsPanel"
#define kCloseCharacterPanelStr "closeCharacterPanel"
#define kCloseCloneSourcePanelStr "closeCloneSourcePanel"
#define kCloseColorPanelStr "closeColorPanel"
#define kCloseHistogramPanelStr "closeHistogramPanel"
#define kCloseHistoryPanelStr "closeHistoryPanel"
#define kCloseInfoPanelStr "closeInfoPanel"
#define kCloseLayerCompsPanelStr "closeLayerCompsPanel"
#define kCloseLayersPanelStr "closeLayersPanel"
#define kCloseMaskPanelStr "closeMaskPanel"
#define kCloseMeasurementPanelStr "closeMeasurementPanel"
#define kCloseNavigatorPanelStr "closeNavigatorPanel"
#define kCloseParagraphPanelStr "closeParagraphPanel"
#define kClosePathsPanelStr "closePathsPanel"
#define kCloseStylesPanelStr "closeStylesPanel"
#define kCloseSwatchesPanelStr "closeSwatchesPanel"
#define kCloseTimelinePanelStr "closeTimelinePanel"
#define kCloseToolPresetsPanelStr "closeToolPresetsPanel"
#define kClose3DPanelStr "close3DPanel"
#define kCloseActionsPanelGroupStr "closeActionsPanelGroup"
#define kCloseAdjustmentsPanelGroupStr "closeAdjustmentsPanelGroup"
#define kCloseAnimationPanelGroupStr "closeAnimationPanelGroup"
#define kCloseBrushesPanelGroupStr "closeBrushesPanelGroup"
#define kCloseChannelsPanelGroupStr "closeChannelsPanelGroup"
#define kCloseCharacterPanelGroupStr "closeCharacterPanelGroup"
#define kCloseCloneSourcePanelGroupStr "closeCloneSourcePanelGroup"
#define kCloseColorPanelGroupStr "closeColorPanelGroup"
#define kCloseHistogramPanelGroupStr "closeHistogramPanelGroup"
#define kCloseHistoryPanelGroupStr "closeHistoryPanelGroup"
#define kCloseInfoPanelGroupStr "closeInfoPanelGroup"
#define kCloseLayerCompsPanelGroupStr "closeLayerCompsPanelGroup"
#define kCloseLayersPanelGroupStr "closeLayersPanelGroup"
#define kCloseMaskPanelGroupStr "closeMaskPanelGroup"
#define kCloseMeasurementPanelGroupStr "closeMeasurementPanelGroup"
#define kCloseNavigatorPanelGroupStr "closeNavigatorPanelGroup"
#define kCloseParagraphPanelGroupStr "closeParagraphPanelGroup"
#define kClosePathsPanelGroupStr "closePathsPanelGroup"
#define kCloseStylesPanelGroupStr "closeStylesPanelGroup"
#define kCloseSwatchesPanelGroupStr "closeSwatchesPanelGroup"
#define kCloseTimelinePanelGroupStr "closeTimelinePanelGroup"
#define kCloseToolPresetsPanelGroupStr "closeToolPresetsPanelGroup"
#define kCloseViewlessDocumentStr "closeViewlessDocument"
#define kClose3DPanelGroupStr "close3DPanelGroup"
#define kCMYK64Str "CMYK64"
#define kCMYKColorClassStr "CMYKColorClass"
#define kCMYKColorEnumStr "CMYKColorEnum"
#define kCMYKColorModeStr "CMYKColorMode"
#define kCMYKSetupEngineStr "CMYKSetupEngine"
#define kCMYKSetupStr "CMYKSetup"
#define kCMYKSpectrumStr "CMYKSpectrum"
#define kCMYKStr "CMYK"
#define kcolorModelStr "colorModel"
#define kcolor2GrayStr "color2Gray"
#define kContourCustomStr "shapeCurveCustom"
#define kContourDoubleStr "shapeCurveDouble"
#define kContourGaussianStr "shapeCurveGaussian"
#define kContourLinearStr "shapeCurveLinear"
#define kContourSingleStr "shapeCurveSingle"
#define kContourStr "shapingCurve"
#define kContourTripleStr "shapeCurveTriple"
#define kContourTypeStr "shapeCurveType"
#define kCustomHSFIsStdStr "customHSFIsStd"
#define kCustomHSFListStr "customHSFList"
#define kCustomHSFNameStr "customHSFName"
#define kCustomHSFValueStr "customHSFValue"
#define kDCSStr "DCS"
#define kDICOMFormatStr	"Dicom"
#define kDSEncodingAuto "dataSetEncodingAuto"
#define kDSEncodingISOLatin1 "dataSetEncodingISOLatin1"
#define kDSEncodingMacRoman "dataSetEncodingMacRoman"
#define kDSEncodingUTF8 "dataSetEncodingUTF8"
#define kDSEncodingUTF16 "dataSetEncodingUTF16"
#define kDSEncodingNative "dataSetEncodingNative"
#define kEPSGenericFormatStr "EPSGenericFormat"
#define kEPSPICTPreviewStr "EPSPICTPreview"
#define kEPSPreviewStr "EPSPreview"
#define kEPSTIFFPreviewStr "EPSTIFFPreview"
#define keraseAllStr "eraseAll"
#define kEXIFStr "EXIF"
#define kFileBrowserBackgroundProcessingStr "FileBrowserBackgroundProcessing"
#define kFileBrowserCacheSizeLimitStr "FileBrowserCacheSizeLimit"
#define kFileBrowserCustomThumbSizeStr "FileBrowserCustomThumbSize"
#define kFileBrowserFileSizeLimitStr "FileBrowserFileSizeLimit"
#define kFileBrowserHighQualityPreviewStr "FileBrowserHighQualityPreview"
#define kFileBrowserMaintainSidecarFilesStr "FileBrowserMaintainSidecarFiles"
#define kFileBrowserParseNonImageXMPMetadataStr "FileBrowserParseNonImageXMPMetadata"
#define kFileBrowserParseVectorFilesStr "FileBrowserParseVectorFiles"
#define kFileBrowserPrefsClassStr "FileBrowserPrefsClass"
#define kFileBrowserPrefsEnumStr "FileBrowserPrefsEnum"
#define kFileBrowserPrefsKeyStr "FileBrowserPrefsKey"
#define kFilm2kStr "Film2k"
#define kFilm4kStr "Film4k"
#define kFPXCompressLossyJPEGStr "FPXCompressLossyJPEG"
#define kFPXCompressNoneStr "FPXCompressNone"
#define kFPXCompressStr "FPXCompress"
#define kFPXQualityStr "FPXQuality"
#define kFPXSizeStr "FPXSize"
#define kFPXViewStr "FPXView"
#define kFSSStr "FSS"
#define kFourDigitStr "fourDigit"
#define kGCRStr "GCR"
#define kGIF89aExportStr "GIF89aExport"
#define kGIFColorFileColorTableStr "GIFColorFileColorTable"
#define kGIFColorFileColorsStr "GIFColorFileColors"
#define kGIFColorFileMicrosoftPaletteStr "GIFColorFileMicrosoftPalette"
#define kGIFColorFileTypeStr "GIFColorFileType"
#define kGIFColorLimitStr "GIFColorLimit"
#define kGIFExportCaptionStr "GIFExportCaption"
#define kGIFFormatStr "GIFFormat"
#define kGIFMaskChannelIndexStr "GIFMaskChannelIndex"
#define kGIFMaskChannelInvertedStr "GIFMaskChannelInverted"
#define kGIFPaletteAdaptiveStr "GIFPaletteAdaptive"
#define kGIFPaletteExactStr "GIFPaletteExact"
#define kGIFPaletteFileStr "GIFPaletteFile"
#define kGIFPaletteOtherStr "GIFPaletteOther"
#define kGIFPaletteSystemStr "GIFPaletteSystem"
#define kGIFPaletteTypeStr "GIFPaletteType"
#define kGIFRequiredColorSpaceIndexedStr "GIFRequiredColorSpaceIndexed"
#define kGIFRequiredColorSpaceRGBStr "GIFRequiredColorSpaceRGB"
#define kGIFRequiredColorSpaceTypeStr "GIFRequiredColorSpaceType"
#define kGIFRowOrderInterlacedStr "GIFRowOrderInterlaced"
#define kGIFRowOrderNormalStr "GIFRowOrderNormal"
#define kGIFRowOrderTypeStr "GIFRowOrderType"
#define kGIFTransparentColorStr "GIFTransparentColor"
#define kGIFTransparentIndexBlueStr "GIFTransparentIndexBlue"
#define kGIFTransparentIndexGreenStr "GIFTransparentIndexGreen"
#define kGIFTransparentIndexRedStr "GIFTransparentIndexRed"
#define kGIFUseBestMatchStr "GIFUseBestMatch"
#define kGPUEnabledStr	"gpuEnabled"
#define kAcrobat3dEngineEnabledStr	"acrobat3dEnabled"
#define kOpenGLEnabledStr	"openglEnabled"
#define kOpenGLAutoTuneStr	"autoTune"
#define kOpenGLAdvancedStr	"openglAdvanced"
#define kOpenGLAdvancedEnabledStr	"glAdvancedEnabled"
#define kOpenGLD2SEnabledStr	"openglD2SEnabled"
#define kOpenGLCheckCompEnumStr	"gpuCheckerComposite"
#define kOpenGLVBLSyncEnabledStr	"openglVBLSyncEnabled"
#define kOpenGLAdvDTSEnabledStr	"openglAdvDTSEnabled"
#define kOpenGLAdvImageEnabledStr	"openglAdvImageEnabled"
#define kOpenGLBilerpEnabledStr	"openglBilerpEnabled"
#define kOpenGLACEEnabledStr	"openglACEEnabled"
#define kOpenGLPOTEnabledStr	"openglPOTEnabled"
#define kOpenGLSimpleTextUploadsEnabledStr "openglSimpleTextUploadsEnabled"
#define kOpenGLDeepColorEnabledStr	"openglDeepColorEnabled"
#define kOpenGLTuneSizeStr	"openglTunedSize"
#define kOpenGLCheckCompStr	"openglCheckerComposite"
#define kOpenViewlessDocumentStr "openViewlessDocument"
#define kHDTVStr "HDTV"
#define kHDTV1080pStr "HDTV1080p"
#define kHDVHDTV720pStr "HDVHDTV720p"
#define kHDV1080pStr "HDV1080p"
#define kHSBColorClassStr "HSBColorClass"
#define kHSBColorEnumStr "HSBColorEnum"
#define kHSBColorModeStr "HSBColorMode"
#define kHSLColorStr "HSLColor"
#define kIBMPCStr "IBMPC"
#define kICCEngineStr "ICCEngine"
#define kICCSetupNameStr "ICCSetupName"
#define kICCStr "ICC"
#define kIDStr "ID"
#define kIEEE32BitFloatingPointStr "IEEE32BitFloatingPoint"
#define kIEEE64BitFloatingPointStr "IEEE64BitFloatingPoint"
#define kJIS78FormStr "JIS78Form"
#define kJIS83FormStr "JIS83Form"
#define kJPEGFormatStr "JPEGFormat"
#define kJPEGQualityStr "JPEGQuality"
#define kJPEGStr "JPEG"
#define klensCorrectionStr "lensCorrection"
#define kLUTAnimationStr "LUTAnimation"
#define kLZWCompressionStr "LZWCompression"
#define kNTSCColorsStr "NTSCColors"
#define kNTSCStr "NTSC"
#define kNTSCWidescreenStr "NTSCWidescreen"
#define kOS2Str "OS2"
#define kP22EBUStr "P22EBU"
#define kPALStr		"PAL"
#define kPDFExportStr "PDFExport"
#define kPDFGenericFormatStr "PDFGenericFormat"
#define kPICTFileFormatStr "PICTFileFormat"
#define kPICTResourceFormatStr "PICTResourceFormat"
#define kPNGFilterAdaptiveStr "PNGFilterAdaptive"
#define kPNGFilterAverageStr "PNGFilterAverage"
#define kPNGFilterNoneStr "PNGFilterNone"
#define kPNGFilterPaethStr "PNGFilterPaeth"
#define kPNGFilterStr "PNGFilter"
#define kPNGFilterSubStr "PNGFilterSub"
#define kPNGFilterUpStr "PNGFilterUp"
#define kPNGFormatStr "PNGFormat"
#define kPNGInterlaceAdam7Str "PNGInterlaceAdam7"
#define kPNGInterlaceNoneStr "PNGInterlaceNone"
#define kPNGInterlaceTypeStr "PNGInterlaceType"
#define kPixelScaleFactorStr "pixelScaleFactor"
#define kPromptedForColorSetup "promptedForColorSetup"
#define kProtectAllStr "protectAll"
#define kProtectCompositeStr "protectComposite"
#define kProtectNoneStr	"protectNone"
#define kProtectPositionStr "protectPosition"
#define kProtectTransparencyStr "protectTransparency"
#define kPSOpenFileDialogStr "PSOpenFileDialog"
#define kQCSAverageStr "QCSAverage"
#define kQCSCorner0Str "QCSCorner0"
#define kQCSCorner1Str "QCSCorner1"
#define kQCSCorner2Str "QCSCorner2"
#define kQCSCorner3Str "QCSCorner3"
#define kQCSIndependentStr "QCSIndependent"
#define kQCSSide0Str "QCSSide0"
#define kQCSSide1Str "QCSSide1"
#define kQCSSide2Str "QCSSide2"
#define kQCSSide3Str "QCSSide3"
#define kQDRectangleStr "QDRectangle"
#define kRGB48Str "RGB48"
#define kRGBBlendGammaStr "RGBBlendGamma"
#define kRGBColorModeStr "RGBColorMode"
#define kRGBColorStr "RGBColor"
#define kRGBFloatColorStr "RGBFloatColor"
#define kRGBSetupClassStr "RGBSetupClass"
#define kRGBSetupSourceStr "RGBSetupSource"
#define kRGBSetupStr "RGBSetup"
#define kRGBSpectrumStr "RGBSpectrum"
#define kRGBStr "RGB"
#define kRLEStr "RLE"
#define kSMPTECStr "SMPTEC"
#define kTIFFFormatStr "TIFFFormat"
#define kTIFFStr "TIFF"
#define ktimeStr "time"
#define kUCAStr "UCA"
#define kURLStr "URL"
#define kXMPMetadataAsUTF8Str "XMPMetadataAsUTF8"
#define kZoomViewStr "Zoomify"
#define kaStr "a"
#define kabbreviatedNameStr "abbreviatedName"
#define kaboutAppStr "aboutApp"
#define kabsColorimetricStr "absColorimetric"
#define kabsoluteStr "absolute"
#define kacceleratedStr "accelerated"
#define kaccentedEdgesStr "accentedEdges"
#define kactionDataStr "actionData"
#define kactionReferenceStr "actionReference"
#define kactionSetStr "actionSet"
#define kactionStr "action"
#define kactiveFrameIndexStr "activeFrameIndex"
#define kactiveFrameSetIDStr "activeFrameSetID"
#define kactualPixelsStr "actualPixels"
#define kactualSizeStr "actualSize"
#define kadaptCorrectStr "adaptCorrect"
#define kadaptiveStr "adaptive"
#define kaddFilterMaskToSelectionStr "addFilterMaskToSelection"
#define kaddKeyframeStr "addKeyframe"
#define kaddKnotToolStr "addKnotTool"
#define kaddLayerTogroupByDragStr "addLayerTogroupByDrag"
#define kaddNoiseStr "addNoise"
#define kaddStr "add"
#define kaddBlankVideoLayerStr "addBlankVideoLayer"
#define kaddToStr "addTo"
#define kaddToSelectionStr "addToSelection"
#define kaddToSelectionContinuousStr "addToSelectionContinuous"
#define kaddVideoLayerStr "addVideoLayer"
#define kaddressAttrStr "addressAttr"
#define kaddUserMaskToSelectionStr "addUserMaskToSelection"
#define kaddVectorMaskToSelectionStr "addVectorMaskToSelection"
#define kadjustImageStr "adjustImage"
#define kadjustmentAddMaskStr "adjustmentAddMask"
#define kadjustmentAutoOptionsStr "adjustmentAutoOptions"
#define kadjustmentClipStr "adjustmentClip"
#define kadjustmentCloseStr "adjustmentClose"
#define kadjustmentCloseGroupStr "adjustmentCloseGroup"
#define kadjustmentCompositeStr "adjustmentComposite"
#define kadjustmentDeletePresetStr "adjustmentDeletePreset"
#define kadjustmentExpandedViewStr "adjustmentExpandedView"
#define kadjustmentLayerStr "adjustmentLayer"
#define kadjustmentLoadStr "adjustmentLoad"
#define kadjustmentLoadPresetStr "adjustmentLoadPreset"
#define kadjustmentOptionsStr "adjustmentOptions"
#define kadjustmentResetStr "adjustmentReset"
#define kadjustmentSaveStr "adjustmentSave"
#define kadjustmentSavePresetStr "adjustmentSavePreset"
#define kadjustmentShowClippingStr "adjustmentShowClipping"
#define kadjustmentStr "adjustment"
#define kadobeOnlineHomeStr "adobeOnlineHome"
#define kadobeOnlineRegistrationStr "adobeOnlineRegistration"
#define kadobeOnlineUpdatesStr "adobeOnlineUpdates"
#define kadobeRGB1998Str "adobeRGB1998"
#define kairbrushEraserStr "airbrushEraser"
#define kairbrushToolStr "airbrushTool"
#define kaliasStr "alias"
#define kalignByAscentStr "alignByAscent"
#define kalignByCapHeightStr "alignByCapHeight"
#define kalignByLeadingStr "alignByLeading"
#define kalignByMinimumValueRomanStr "alignByMinimumValueRoman"
#define kalignByMinimumValueAsianStr "alignByMinimumValueAsian"
#define kalignByXHeightStr "alignByXHeight"
#define kalignDistributeSelectorStr "alignDistributeSelector"
#define kalignStr "align"
#define kalignGroupStr "alignGroup"
#define kalignedStr "aligned"
#define kalignmentStr "alignment"
#define kalignmentTypeStr "alignmentType"
#define kallCapsStr "allCaps"
#define kallEnumStr "allEnum"
#define kallExceptStr "allExcept"
#define kallMeasurementsStr "allMeasurements"
#define kallSmallCapsStr "allSmallCaps"
#define kallStr "all"
#define kallToolOptionsStr "allToolOptions"
#define kallowSystemShortcuts "allowSystemShortcuts"
#define kallowUserModifyStr "allowUserModify"
#define kalphaChannelOptionsClassStr "alphaChannelOptionsClass"
#define kalphaChannelOptionsStr "alphaChannelOptions"
#define kalphaChannelsStr "alphaChannels"
#define kalphaInterpretationStr "alphaInterpretation"
#define kaltTagStr "altTag"
#define kalternateStr "alternate"
#define kalternateLigaturesStr "alternateLigatures"
#define kaltligatureStr "altligature"
#define kambientBrightnessStr "ambientBrightness"
#define kambientColorStr "ambientColor"
#define kamountHighStr "amountHigh"
#define kamountLowStr "amountLow"
#define kamountMediumStr "amountMedium"
#define kamountStr "amount"
#define kamplitudeMaxStr "amplitudeMax"
#define kamplitudeMinStr "amplitudeMin"
#define kanchorStr "anchor"
#define kanchorTimeStr "anchorTime"
#define kancientStr "ancient"
#define kangle1Str "angle1"
#define kangle2Str "angle2"
#define kangle3Str "angle3"
#define kangle4Str "angle4"
#define kangleDynamicsStr "angleDynamics"
#define kangleStr "angle"
#define kangleUnitStr "angleUnit"
#define kangledStrokesStr "angledStrokes"
#define kanimationFrameActivateStr "animationFrameActivate"
#define kanimationFrameClassStr "animationFrameClass"
#define kanimationFrameExtendSelectionStr "animationFrameExtendSelection"
#define kanimationClassStr "animationClass"
#define kanimationFrameListStr "animationFrameList"
#define kanimationFrameDelayStr "animationFrameDelay"
#define kanimationFrameReplaceStr "animationFrameReplace"
#define kanimationFrameReplaceTypeStr "animationFrameReplaceType"
#define kanimationFrameReplaceDontDisposeStr "animationFrameReplaceDontDispose"
#define kanimationFrameReplaceDisposeStr "animationFrameReplaceDispose"
#define kanimationFrameReplaceAutoDisposeStr "animationFrameReplaceAutoDispose"
#define kanimationFramesByDefaultStr "animationFramesByDefault"
#define kanimationFramesContiguousStr "animationFramesContiguous"
#define kanimationFramesFromLayersStr "animationFramesFromLayers"
#define kanimationFramesToLayersStr "animationFramesToLayers"
#define kanimationGoToNextFrameStr "animationGoToNextFrame"
#define kanimationGoToPreviousFrameStr "animationGoToPreviousFrame"
#define kanimationGoToFirstFrameStr "animationGoToFirstFrame"
#define kanimationGoToLastFrameStr "animationGoToLastFrame"
#define kanimationPanelKeyStr "animationPanelKey"
#define kanimationFXRefPointStr "animationFXRefPoint"
#define kanimationImageMaskStr "animationImageMask"
#define kanimationKeyStr "animationKey"
#define kanimationLayerIDStr "animationLayerID"
#define kanimationLayerSettingsStr "animationLayerSettings"
#define kanimationLayerSpecificStr "animationLayerSpecific"
#define kanimationMatchLayerStr "animationMatchLayer"
#define kanimationMatchLayerPositionStr "animationMatchLayerPosition"
#define kanimationMatchLayerVisibilityStr "animationMatchLayerVisibility"
#define kanimationMatchLayerStyleStr "animationMatchLayerStyle"
#define kanimationNewLayerPerFrameStr "animationNewLayerPerFrame"
#define kanimationOldLayerSpecificStr "_LSpec"
#define kanimationOptionsAutoStr "animationOptionsAuto"
#define kanimationOptionsHideStr "animationOptionsHide"
#define kanimationOptionsShowStr "animationOptionsShow"
#define kanimationFrameIDListStr "animationFrameIDList"
#define kanimationLoopCountStr "animationLoopCount"
#define kanimationLoopEnumStr "animationLoopEnum"
#define kanimationLoopForeverStr "animationLoopForever"
#define kanimationLoopOnceStr "animationLoopOnce"
#define kanimationLoopTypeStr "animationLoopType"
#define kanimationOptimizeStr "animationOptimize"
#define kanimationOptByBoundsStr "animationOptByBounds"
#define kanimationOptByPixelRemovalStr "animationOptByPixelRemoval"
#define kanimationPaletteOptionsStr "animationPaletteOptions"
#define kanimationPasteFramesStr "animationPasteFrames"
#define kanimationPasteFramesMethodStr "animationPasteFramesMethod"
#define kanimationPasteFramesOverStr "animationPasteFramesOver"
#define kanimationPasteFramesBeforeStr "animationPasteFramesBefore"
#define kanimationPasteFramesAfterStr "animationPasteFramesAfter"
#define kanimationPasteFramesReplaceStr "animationPasteFramesReplace"
#define kanimationPasteFramesLinkStr "animationPasteFramesLink"
#define kanimationPictSizeStr "animationPictSize"
#define kanimationPropagateStr "animationPropagate"
#define kanimationSelectAllStr "animationSelectAll"
#define kanimationShowNewLayersInFramesStr "animationShowNewLayersInFrames"
#define kanimationToFrameStr "animationToFrame"
#define kanimationTweenStr "animationTween"
#define kanimationTweenWithNextStr "animationTweenWithNext"
#define kanimationTweenWithPrevStr "animationTweenWithPrev"
#define kanimationTweenSelStr "animationTweenSel"
#define kanimationTweenAllLayersStr "animationTweenAllLayers"
#define kanimationTweenSelLayersStr "animationTweenSelLayers"
#define kanimationTweenNumFramesStr "animationTweenNumFrames"
#define kanimationTweenPositionStr "animationTweenPosition"
#define kanimationTweenOpacityStr "animationTweenOpacity"
#define kanimationTweenEffectsStr "animationTweenEffects"
#define kanimationUnifyPositionStr "animationUnifyPosition"
#define kanimationUnifyEffectsStr "animationUnifyEffects"
#define kanimationUnifyVisibilityStr "animationUnifyVisibility"
#define kanimationVectorMaskStr "animationVectorMask"
#define kanimationTrackStr "animationTrack"
#define kanimInterpStyleStr "animInterpStyle"
#define kanimKeyStr "animKey"
#define kanisotropicStr "anisotropic"
#define kannotSoundStr "annotSound"
#define kannotTextStr "annotText"
#define kannotTypeStr "annotType"
#define kannotUnknownStr "annotUnknown"
#define kannotationStr "annotation"
#define kantiAliasCrispStr "antiAliasCrisp"
#define kantiAliasHighStr "antiAliasHigh"
#define kantiAliasLowStr "antiAliasLow"
#define kantiAliasMediumStr "antiAliasMedium"
#define kantiAliasNoneStr "antiAliasNone"
#define kantiAliasSharpStr "antiAliasSharp"
#define kantiAliasSmoothStr "antiAliasSmooth"
#define kantiAliasStr "antiAlias"
#define kantiAliasStrongStr "antiAliasStrong"
#define kantiAliasTypeStr "antiAliasType"
#define kantiAliasedPICTAcquireStr "antiAliasedPICTAcquire"
#define kanyStr "any"
#define kappParametersStr "appParameters"
#define kappendCopyStr "appendCopy"
#define kappendStr "append"
#define kapplSignatureStr "applSignature"
#define kappleEventStr "appleEvent"
#define kappleRGBStr "appleRGB"
#define kapplicationStr "application"
#define kapplyCompStr "applyComp"
#define kapplyImageEnumStr "applyImageEnum"
#define kapplyImageEventStr "applyImageEvent"
#define kapplyimageStackPluginRendererStr	"applyImageStackPluginRenderer"
#define kapplyLockingStr "applyLocking"
#define kapplyStr "apply"
#define kapplyStyleStr "applyStyle"
#define kareaSelectorStr "areaSelector"
#define kareaStr "area"
#define karoundCenterStr "aroundCenter"
#define karrangeStr "arrange"
#define karrowheadStr "arrowhead"
#define kartBoxStr "artBox"
#define kartBrushToolStr "artBrushTool"
#define kasStr "as"
#define kascenderAlignmentStr "ascenderAlignment"
#define kaskLayeredTIFFStr "askLayeredTIFF"
#define kaskMismatchOpeningStr "askMismatchOpening"
#define kaskMismatchPastingStr "askMismatchPasting"
#define kaskMissingStr "askMissing"
#define kaskStr "ask"
#define kaskWhenOpeningStr "askWhenOpening"
#define kaspectRatioStr "aspectRatio"
#define kassertStr "assert"
#define kassignProfileStr "assignProfile"
#define kassumeOptionsStr "assumeOptions"
#define kassumedCMYKStr "assumedCMYK"
#define kassumedGrayStr "assumedGray"
#define kassumedProfileStr "assumedProfile"
#define kassumedRGBStr "assumedRGB"
#define katStr "at"
#define kate1Str "ate1"
#define kattachEMailStr "attachEMail"
#define kauthorNameStr "authorName"
#define kautoAdvanceSecondsStr "autoAdvanceSeconds"
#define kautoAdvanceStr "autoAdvance"
#define kautoBlackWhiteStr "autoBlackWhite"
#define kautoBlendTypeStr  "autoBlendType"
#define kautoCollapseDrawersStr "autoCollapseDrawers"
#define kautoContrastStr "autoContrast"
#define kautoEraseStr "autoErase"
#define kautoFixCorrectStr "autoFixCorrect"
#define kautoKernStr "autoKern"
#define kautoLeadingPercentageStr "autoLeadingPercentage"
#define kautoLeadingStr "autoLeading"
#define kautoNeutralsStr "autoNeutrals"
#define kautoShowRevealStripsStr "autoShowRevealStrips"
#define kautoStr "auto"
#define kautoTCYStr "autoTCY"
#define kautoUpdateFileStr	"autoUpdateFiles"
#define kaxisStr "axis"
#define kbMPFormatStr "bMPFormat"
#define kbStr "b"
#define kbackLightStr "backLight"
#define kbackStr "back"
#define kbackgroundColorStr "backgroundColor"
#define kbackgroundEraserToolStr "backgroundEraserTool"
#define kbackgroundLayerStr "backgroundLayer"
#define kbackgroundLevelStr "backgroundLevel"
#define kbackgroundStr "background"
#define kbackwardEnumStr "backwardEnum"
#define kbackwardStr "backward"
#define kbalanceStr "balance"
#define kbasReliefStr "basRelief"
#define kbaseNameStr "baseName"
#define kbaseStr "base"
#define kbaselineAlignmentStr "baselineAlignment"
#define kbaselineDirectionStr "baselineDirection"
#define kbaselineShiftStr "baselineShift"
#define kbaselineStr "baseline"
#define kbatchFromDropletStr "batchFromDroplet"
#define kbatchSourceTypeStr "batchSourceType"
#define kbatchStr "batch"
#define kbeepWhenDoneStr "beepWhenDone"
#define kbeforeRunningStr "beforeRunning"
#define kbeginRampStr "beginRamp"
#define kbeginSustainStr "beginSustain"
#define kbehindStr "behind"
#define kbelowStr "below"
#define kbestStr "best"
#define kbetterStr "better"
#define kbevelDirectionStr "bevelDirection"
#define kbevelEmbossStampStyleStr "bevelEmbossStampStyle"
#define kbevelEmbossStr "bevelEmboss"
#define kbevelEmbossStyleStr "bevelEmbossStyle"
#define kbevelJoinStr "bevelJoin"
#define kbevelStyleStr "bevelStyle"
#define kbevelTechniqueStr "bevelTechnique"
#define kbicubicStr "bicubic"
#define kbicubicSmootherStr "bicubicSmoother"
#define kbicubicSharperStr "bicubicSharper"
#define kbigNudgeHStr "bigNudgeH"
#define kbigNudgeVStr "bigNudgeV"
#define kbilateralStr "surfaceBlur"
#define kbilinearStr "bilinear"
#define kbinaryStr "binary"
#define kbitDepth1Str "bitDepth1"
#define kbitDepth24Str "bitDepth24"
#define kbitDepth4Str "bitDepth4"
#define kbitDepth8Str "bitDepth8"
#define kbitDepthStr "bitDepth"
#define kbitmapModeStr "bitmapMode"
#define kbitmapStr "bitmap"
#define kblackAndWhiteStr "blackAndWhite"
#define kblackAndWhitePresetModeStr "blackAndWhitePresetMode"
#define kblackAndWhitePresetFileNameStr "blackAndWhitePresetFileName"
#define kblackBodyStr "blackBody"
#define kblackClipStr "blackClip"
#define kblackGenerationCurveStr "blackGenerationCurve"
#define kblackGenerationStr "blackGeneration"
#define kblackGenerationTypeStr "blackGenerationType"
#define kblackIntensityStr "blackIntensity"
#define kblackLevelStr "blackLevel"
#define kblackLimitStr "blackLimit"
#define kblackStr "black"
#define kblacksStr "blacks"
#define kblankFrameReaderStr "blankFrameReader"
#define kblastStr "blast"
#define kbleedStr "bleed"
#define kbleedBoxStr "bleedBox"
#define kblendClippedStr "blendClipped"
#define kblendInteriorStr "blendInterior"
#define kblendModeStr "blendMode"
#define kblendOptionsStr "blendOptions"
#define kblendRangeStr "blendRange"
#define kblindsHorzStr "blindsHorz"
#define kblindsVertStr "blindsVert"
#define kblockEraserStr "blockEraser"
#define kblocksStr "blocks"
#define kblueBlackPointStr "blueBlackPoint"
#define kblueChannelCleanupStr "blueChannelCleanup"
#define kblueFloatStr	"blueFloat"
#define kblueGammaStr "blueGamma"
#define kblueStr "blue"
#define kblueWhitePointStr "blueWhitePoint"
#define kblueXStr "blueX"
#define kblueYStr "blueY"
#define kbluesStr "blues"
#define kblurEventStr "blurEvent"
#define kblurMethodStr "blurMethod"
#define kblurMoreStr "blurMore"
#define kblurQualityStr "blurQuality"
#define kblurStr "blur"
#define kblurToolStr "blurTool"
#define kblurTypeStr "blurType"
#define kbokmalNorwegianLanguageStr "bokmalNorwegianLanguage"
#define kboldStr "bold"
#define kbolditalicStr "bolditalic"
#define kbookColorKeyStr	"bookKey"
#define kbookColorStr "bookColor"
#define kbookIDStr	"bookID"
#define kbookStr "book"
#define kbooleanStr "boolean"
#define kborderStr "border"
#define kborderThicknessStr "borderThickness"
#define kbothAxesStr	"bothAxes"
#define kbothStr "both"
#define kbottomEnumStr "bottomEnum"
#define kbottomRightPixelColorStr "bottomRightPixelColor"
#define kbottomStr "bottom"
#define kboundsStr "bounds"
#define kboundingBoxStr "boundingBox"
#define kboxStr "box"
#define kboxBlurStr	"boxblur"
#define kboxInStr "boxIn"
#define kboxOutStr "boxOut"
#define kbrazilianPortugueseLanguageStr "brazilianPortugueseLanguage"
#define kbrightnessContrastStr "brightnessContrast"
#define kbrightnessEventStr "brightnessEvent"
#define kbrightnessStr "brightness"
#define kbringToFrontStr "bringToFront"
#define kbroadcastKeyStr "broadcastKey"
#define kbrowserHeightStr "browserHeight"
#define kbrowserWidthStr "browserWidth"
#define kbrushColorRedStr "brushColorRed"
#define kbrushColorGreenStr "brushColorGreen"
#define kbrushColorBlueStr "brushColorBlue"
#define kbrushDarkRoughStr "brushDarkRough"
#define kbrushDetailStr "brushDetail"
#define kbrushGroupStr "brushGroup"
#define kbrushLightRoughStr "brushLightRough"
#define kbrushPresetStr "brushPreset"
#define kbrushSimpleStr "brushSimple"
#define kbrushSizeStr "brushSize"
#define kbrushSparkleStr "brushSparkle"
#define kbrushStr "brush"
#define kbrushTypeStr "brushType"
#define kBrushTipDynamicsLockStr "brushTipDynamicsLock"
#define kbrushWideBlurryStr "brushWideBlurry"
#define kbrushWideSharpStr "brushWideSharp"
#define kbrushesAppendStr "brushesAppend"
#define kbrushesDefineStr "brushesDefine"
#define kbrushesDeleteStr "brushesDelete"
#define kbrushesLoadStr "brushesLoad"
#define kbrushesNewStr "brushesNew"
#define kbrushesOptionsStr "brushesOptions"
#define kbrushesResetStr "brushesReset"
#define kbrushesSaveStr "brushesSave"
#define kbrushesStr "brushes"
#define kbucketToolStr "bucketTool"
#define kbuildNumberStr "buildNumber"
#define kbuiltInContourStr "builtInShapeCurve"
#define kbuiltinProfileStr "builtinProfile"
#define kbuiltinProofStr "builtinProof"
#define kbuiltinStr "builtin"
#define kbulgarianLanguageStr "bulgarianLanguage"
#define kbumpAmplitudeStr "bumpAmplitude"
#define kbumpChannelStr "bumpChannel"
#define kburasagariNoneStr "burasagariNone"
#define kburasagariStandardStr "burasagariStandard"
#define kburasagariStr "burasagari"
#define kburasagariStrongStr "burasagariStrong"
#define kburasagariTypeStr "burasagariType"
#define kburnInHStr "burnInH"
#define kburnInMStr "burnInM"
#define kburnInSStr "burnInS"
#define kburnInToolStr "burnInTool"
#define kbuttCapStr "buttCap"
#define kbuttonModeStr "buttonMode"
#define kbyStr "by"
#define kbylineStr "byline"
#define kbylineTitleStr "bylineTitle"
#define kbyteOrderStr "byteOrder"
#define kbwPresetKindStr "bwPresetKind"
#define kbwPresetFileNameStr "bwPresetFileName"
#define kcachePrefsStr "cachePrefs"
#define kcalculationStr "calculation"
#define kcalculationTypeStr "calculationType"
#define kcalculationsStr "calculations"
#define kcalibrationBarsStr "calibrationBars"
#define kcameraRotationStr "cameraRotation"
#define kcanOpenByPhotoshopStr "canOpenByPhotoshop"
#define kcanadianFrenchLanguageStr "canadianFrenchLanguage"
#define kcanadianEnglishLanguageStr "canadianEnglishLanguage"
#define kcanvasBackgroundColorsStr "canvasBackgroundColors"
#define kcancelStr "cancel"
#define kcanvasAttributesStr "canvasAttributes"
#define kcanvasColorModeStr "canvasColorMode"
#define kcanvasExtensionColorStr "canvasExtensionColor"
#define kcanvasExtensionColorTypeStr "canvasExtensionColorType"
#define kCanvasFrameStr "canvasFrame"
#define kcanvasSizeStr "canvasSize"
#define kcaptionStr "caption"
#define kcaptionWriterStr "captionWriter"
#define kcascadeStr "cascade"
#define kcaseSensitiveStr "caseSensitive"
#define kcatalanLanguageStr "catalanLanguage"
#define kcategoryStr "category"
#define kccittFaxStr "ccittFax"
#define kcellSizeStr "cellSize"
#define kcenterAlignmentStr "centerAlignment"
#define kcenterCropMarksStr "centerCropMarks"
#define kcenterDocumentWindows "centerDocumentWindows"
#define kcenterGlowStr "centerGlow"
#define kcenterStr "center"
#define kcenteredFrameStr "centeredFrame"
#define kchalkAreaStr "chalkArea"
#define kchalkCharcoalStr "chalkCharcoal"
#define kchannelDenoiseStr "channelDenoise"
#define kchannelDenoiseParamsStr "channelDenoiseParams"
#define kchannelMatrixStr "channelMatrix"
#define kchannelMixerStr "channelMixer"
#define kchannelNameStr "channelName"
#define kchannelOptionsStr "channelOptions"
#define kchannelReferenceStr "channelReference"
#define kchannelRestrictionsStr "channelRestrictions"
#define kchannelStr "channel"
#define kchannelsInterleavedStr "channelsInterleaved"
#define kchannelsPaletteOptionsStr "channelsPaletteOptions"
#define kchannelsStr "channels"
#define kcharStr "char"
#define kcharacterRotationStr "characterRotation"
#define kcharcoalAmountStr "charcoalAmount"
#define kcharcoalAreaStr "charcoalArea"
#define kcharcoalStr "charcoal"
#define kcheckAllStr "checkAll"
#define kcheckForBackgroundLayerStr "checkForBackgroundLayer"
#define kcheckForOpenDocStr "checkForOpenDoc"
#define kcheckForRasterLayerStr "checkForRasterLayer"
#define kcheckForSelectionStr "checkForSelection"
#define kcheckForTextLayerStr "checkForTextLayer"
#define kcheckForVectorLayerStr "checkForVectorLayer"
#define kcheckerboardLargeStr "checkerboardLarge"
#define kcheckerboardMediumStr "checkerboardMedium"
#define kcheckerboardNoneStr "checkerboardNone"
#define kcheckerboardSizeStr "checkerboardSize"
#define kcheckerboardSmallStr "checkerboardSmall"
#define kchineseLanguageStr "chineseLanguage"
#define kchokeMatteStr "chokeMatte"
#define kchromaStr "chroma"
#define kchromeFXClassStr "chromeFXClass"
#define kchromeFXStr "chromeFX"
#define kchromeStr "chrome"
#define kcityStr "city"
#define kclassBrowserFileStr "classBrowserFile"
#define kclassBrowserStr "classBrowser"
#define kclassColorStr "classColor"
#define kclassContour	"classFXShapeCurve"
#define kclassElementStr "classElement"
#define kclassExportStr "classExport"
#define kclassFormatStr "classFormat"
#define kclassHueSatHueSatV2Str "classHueSatHueSatV2"
#define kclassImportStr "classImport"
#define kclassModeStr "classMode"
#define kclassStr "class"
#define kclassStringFormatStr "classStringFormat"
#define kclassTextExportStr "classTextExport"
#define kclassTextImportStr "classTextImport"
#define kclearAmountStr "clearAmount"
#define kclearBrushControlsStr "clearBrushControls"
#define kclearEnumStr "clearEnum"
#define kclearEventStr "clearEvent"
#define kclearGuidesStr "clearGuides"
#define kclearRecentFilesStr "clearRecentFiles"
#define kclearSlicesStr "clearSlices"
#define kclearStyleStr "clearStyle"
#define	kclearWarningStr "clearWarning"
#define kclipStr "clip"
#define kclipboardStr "clipboard"
#define kclippingInfoStr "clippingInfo"
#define kclippingPathEPSStr "clippingPathEPS"
#define kclippingPathFlatnessStr "clippingPathFlatness"
#define kclippingPathIndexStr "clippingPathIndex"
#define kclippingPathInfoStr "clippingPathInfo"
#define kclippingPathStr "clippingPath"
#define kcloneSourceStr "cloneSource"
#define kcloneSourceAutoHideOverlayStr "cloneSourceAutoHideOverlay"
#define kcloneSourceInvertOverlayStr "cloneSourceInvertOverlay"
#define kcloneSourceLockFrameStr "cloneSourceLockFrame"
#define kcloneSourceResetTransformStr "cloneSourceResetTransform"
#define kcloneSourceShowOverlayStr "cloneSourceShowOverlay"
#define kcloneSourceClipOverlayStr "cloneSourceClipOverlay"
#define kcloneSourceSource1Str "cloneSourceSource1"
#define kcloneSourceSource2Str "cloneSourceSource2"
#define kcloneSourceSource3Str "cloneSourceSource3"
#define kcloneSourceSource4Str "cloneSourceSource4"
#define kcloneSourceSource5Str "cloneSourceSource5"
#define kcloneSourceToolOptionsStr "cloneSourceToolOptions"
#define kcloneStampToolStr "cloneStampTool"
#define kcloseAllStr "closeAll"
#define kcloseQuickStartStr "closeQuickStart"
#define kcloseStr "close"
#define kclosedSubpathStr "closedSubpath"
#define kcloudsStr "clouds"
#define kcoarseDotsStr "coarseDots"
#define kcolorBalanceStr "colorBalance"
#define kcolorBurnStr "colorBurn"
#define kcolorCastStr "colorCast"
#define kcolorChannelStr "colorChannel"
#define kcolorChannelsStr "colorChannels"
#define kcolorCorrectionStr "colorCorrection"
#define kcolorDodgeStr "colorDodge"
#define kcolorDynamicsLockStr "colorDynamicsLock"
#define kcolorHalftoneStr "colorHalftone"
#define kcolorIndicatesStr "colorIndicates"
#define kcolorManagementStr "colorManagement"
#define kcolorMatchStr "colorMatch"
#define kcolorModeStr "colorMode"
#define kcolorNoiseStr "colorNoise"
#define kcolorOverlayStr "colorOverlay"
#define kcolorPaletteStr "colorPalette"
#define kcolorPickerPrefsClassStr "colorPickerPrefsClass"
#define kcolorPickerPrefsStr "colorPickerPrefs"
#define kcolorRangeStr "colorRange"
#define kcolorReplacementBrushTool "colorReplacementBrushTool"
#define kcolorSamplerListStr "colorSamplerList"
#define kcolorSamplerStr "colorSampler"
#define kcolorSamplerToolStr "colorSamplerTool"
#define kcolorSettingsStr "colorSettings"
#define kcolorSpaceStr "colorSpace"
#define kcolorStopStr "colorStop"
#define kcolorStopTypeStr "colorStopType"
#define kcolorStr "color"
#define kcolorTableStr "colorTable"
#define kcoloredPencilStr "coloredPencil"
#define kcolorimetricStr "colorimetric"
#define kcolorizeStr "colorize"
#define kcolorsListStr "colorsList"
#define kcolorsStr "colors"
#define kcolumnCountStr "columnCount"
#define kcolumnGutterStr "columnGutter"
#define kcolumnWidthStr "columnWidth"
#define kcombineStr "combine"
#define kcommandKeyStr "commandKey"
#define kcommandStr "command"
#define kcommentStr "comment"
#define kcommitStr "commit"
#define kcommonIssuesStr "common"
#define kcompStr "comp"
#define kcompatibleStr "compatible"
#define kcompensationStr "compensation"
#define kcomponentStr "component"
#define kcompositeStr "composite"
#define kcompressionStr "compression"
#define kcompsClassStr "compsClass"
#define kcompsListStr "compsList"
#define kcompsPanelKeyStr "compsPanelKey"
#define kcomputedBrushStr "computedBrush"
#define kconcavityStr "concavity"
#define kconciseStr "concise"
#define kconditionStr "condition"
#define kconnectionFormsStr "connectionForms"
#define kconsolidateAllTabsStr "consolidateAllTabs"
#define kconstantStr "constant"
#define kconstrainProportionsStr "constrainProportions"
#define kconstrainStr "constrain"
#define kconstructionFOVStr "constructionFOV"
#define kcontactSheetStr "contactSheet"
#define kconteCrayonStr "conteCrayon"
#define kcontentAwareStr "contentAware"
#define kcontentLayerStr "contentLayer"
#define kcontentStr "content"
#define kcontextualLigaturesStr "contextualLigatures"
#define kcontiguousStr "contiguous"
#define kcontinueStr "continue"
#define kcontinuityStr "continuity"
#define kcontourBrushStr "contourBrush"
#define kcontourEdgeStr "contourEdge"
#define kcontractStr "contract"
#define kcontrastStr "contrast"
#define kconvertKnotToolStr "convertKnotTool"
#define kconvertModeStr "convertMode"
#define kconvertStr "convert"
#define kconvertAnimationStr "convertAnimation"
#define kconvertTimelineStr "convertTimeline"
#define kconvertToCMYKStr "convertToCMYK"
#define kconvertToGrayStr "convertToGray"
#define kconvertToLabStr "convertToLab"
#define kconvertToProfileStr "convertToProfile"
#define kconvertToRGBStr "convertToRGB"
#define kconvertToShapeStr "convertToShape"
#define kcopyAsHTMLStr "copyAsHTML"
#define kcopyBrushTextureStr "copyBrushTexture"
#define kcopyEffectsStr "copyEffects"
#define kcopyEventStr "copyEvent"
#define kcopyKeyframesStr "copyKeyframes"
#define kcopyMergedStr "copyMerged"
#define kcopyStr "copy"
#define kcopyToLayerStr "copyToLayer"
#define kcopyrightNoticeStr "copyrightNotice"
#define kcopyrightStatusStr "copyrightStatus"
#define kcopyrightStr "copyright"
#define kcopyrightedWorkStr "copyrightedWork"
#define kcornerCropMarksStr "cornerCropMarks"
#define kcornerStr "corner"
#define kcorrectionMethodStr "correctionMethod"
#define kcountDynamicsStr "countDynamics"
#define kcountStr "count"
#define kcountAutoStr "countAuto"
#define kcountClearStr "countClear"
#define kcountAddStr "countAdd"
#define kcountDeleteStr "countDelete"
#define kcountMoveStr "countMove"
#define kcountClassStr "countClass"
#define kcountColorStr "countColor"
#define kcountGroupVisibleStr "countGroupVisible"
#define kcountGroupMarkerSizeStr "countGroupMarkerSize"
#define kcountGroupFontSizeStr "countGroupFontSize"
#define kcountRenameGroupStr "countRenameGroup"
#define kcountAddGroupStr "countAddGroup"
#define kcountDeleteGroupStr "countDeleteGroup"
#define kcountSetCurrentGroupStr "countSetCurrentGroup"
#define kcountCustomColorStr "countCustomColor"
#define kcountToolStr "countTool"
#define kcountryNameStr "countryName"
#define kcoverDownStr "coverDown"
#define kcoverRightStr "coverRight"
#define kcrackBrightnessStr "crackBrightness"
#define kcrackDepthStr "crackDepth"
#define kcrackSpacingStr "crackSpacing"
#define kcraquelureStr "craquelure"
#define kcreateDropletStr "createDroplet"
#define kcreateDuplicateStr "createDuplicate"
#define kcreateInterpolationStr "createInterpolation"
#define kcreateLayersFromLayerFXStr "createLayersFromLayerFX"
#define kcreateWorkPathStr "createWorkPath"
#define kcreatorAddrStr "creatorAddr"
#define kcreatorAddrCityStr "creatorAddrCity"
#define kcreatorAddrRegionStr "creatorAddrRegion"
#define kcreatorAddrPostStr "creatorAddrPostCode"
#define kcreatorAddrCountryStr "creatorAddrCountry"
#define kcreatorPhoneStr "creatorPhone"
#define kcreatorEmailStr "creatorEmail"
#define kcreatorURLStr "creatorURL"
#define kcreditStr "credit"
#define kcroatianLanguageStr "croatianLanguage"
#define kcropStr "crop"
#define kcropBoxStr "cropBox"
#define kcropToStr "cropTo"
#define kcropToolStr "cropTool"
#define kcrossStr "cross"
#define kcrosshatchStr "crosshatch"
#define kcrossoverStr "crossover"
#define kcrystallizeStr "crystallize"
#define kctrlPPrint "ctrlPPrint"
#define kctrlPSystemPrint "ctrlPSystemPrint"
#define kctrlShiftZEnumStr "ctrlShiftZEnum"
#define kctrlYEnumStr "ctrlYEnum"
#define kctrlZEnumStr "ctrlZEnum"
#define kcurrentColorsStr "currentColors"
#define kcurrentFrameStr "currentFrame"
#define kcurrentHistoryStateStr "currentHistoryState"
#define kcurrentLayerStr "currentLayer"
#define kcurrentLightStr "currentLight"
#define kcurrentStr "current"
#define kcurrentToolOptionsStr "currentToolOptions"
#define kcursorCrosshairStr "cursorCrosshair"
#define kcursorKindStr "cursorKind"
#define kcursorShapeStr "cursorShape"
#define kcurveFileStr "curveFile"
#define kcurvePointStr "curvePoint"
#define kcurveStr "curve"
#define kcurvesAdjustmentStr "curvesAdjustment"
#define kcurvesDisplayOptionsStr "curvesDisplayOptions"
#define kcurvesPresetKindStr "curvesPresetKind"
#define kcurvesPresetFileNameStr "curvesPresetFileName"
#define kcurvesStr "curves"
#define kcustomEnumStr "customEnum"
#define kcustomEnvelopeWarpStr "customEnvelopeWarp"
#define kcustomForcedStr "customForced"
#define kcustomMatteStr "customMatte"
#define kcustomPaletteClassStr "customPaletteClass"
#define kcustomPaletteStr "customPalette"
#define kcustomPatternStr "customPattern"
#define kcustomPhosphorsStr "customPhosphors"
#define kcustomScaleFactorStr "customScaleFactor"
#define kcustomShapeStr	"customShape"
#define kcustomShapeToolStr "customShapeTool"
#define kcookieCutterToolStr "cookieCutterTool"
#define kcustomStopsStr "customStops"
#define kcustomStr "custom"
#define kcustomWhitePointStr "customWhitePoint"
#define kcutStr "cut"
#define kcutToLayerStr "cutToLayer"
#define kcutoutStr "cutout"
#define kcylindricalStr "cylindrical"
#define kcyanStr "cyan"
#define kcyansStr "cyans"
#define kcycleCompStr "cycleComp"
#define kczechLanguageStr "czechLanguage"
#define kdanishLanguageStr "danishLanguage"
#define kdarkIntensityStr "darkIntensity"
#define kdarkStr "dark"
#define kdarkStrokesStr "darkStrokes"
#define kdarkenOnlyStr "darkenOnly"
#define kdarkenStr "darken"
#define kdarkerColorStr	"darkerColor"
#define kdarknessStr "darkness"
#define kdashedLinesStr "dashedLines"
#define kdataPointsStr "dataPoints"
#define kdataSetClassStr "dataSetClass"
#define kdataSetEncodingStr "dataSetEncoding"
#define kdataSetNameStr "dataSetName"
#define kdataSetNumberLeadingZerosStr "dataSetNumberLeadingZeros"
#define kdataSetNumberStr "dataSetNumber"
#define kdateCreatedStr "dateCreated"
#define kdatumStr "datum"
#define kddmmStr "ddmm"
#define kddmmyyStr "ddmmyy"
#define kdeInterlaceStr "deInterlace"
#define kdeinterlaceMethodStr "deinterlaceMethod"
#define kdePosterizeStr "dePosterize"
#define kdebugExecutionModeClassStr "debugExecutionModeClass"
#define kdebugExecutionModeStr "debugExecutionMode"
#define kdecimalStructStr "decimalStruct"
#define kdeepDepthStr "deepDepth"
#define kdeepStr "deep"
#define kdefaultAppScriptStr "defaultAppScript"
#define kdefaultFillStr "defaultFill"
#define kdefaultFormStr "defaultForm"
#define kdefaultStyleStr "defaultStyle"
#define kdefaultTabWidthStr "defaultTabWidth"
#define kdefaultWorkspaceStr "defaultWorkspace"
#define kdefineBrushStr "defineBrush"
#define kdefineCustomShapeStr "defineCustomShape"
#define kdefineVariablesStr "defineVariables"
#define kdefinePatternStr "definePattern"
#define kdefineSprayerStr "defineSprayer"
#define kdefinitionStr "definition"
#define kdefringeStr "defringe"
#define kdeleteAllAnnotStr "deleteAllAnnot"
#define kdeleteContainedStr "deleteContained"
#define kdeleteFrameStr "deleteFrame"
#define kdeleteKeyframeStr "deleteKeyframe"
#define kdeleteKnotToolStr "deleteKnotTool"
#define kdeleteMeasurementsStr "deleteMeasurements"
#define kdeleteScaleFactorStr "deleteScaleFactor"
#define kdeleteSelectedKeyframesStr "deleteSelectedKeyframes"
#define kdeleteSelectionStr "deleteSelection"
#define kdeleteStr "delete"
#define kdeleteWorkspaceStr "deleteWorkspace"
#define kdenoiseStr "denoise"
#define kdenoisePresetsStr "denoisePresets"
#define kdenominatorStr "denominator"
#define kdensityStr "density"
#define kdensityUnitStr "densityUnit"
#define kdeposterizeStr "deposterize"
#define kdepthStr "depth"
#define kdesaturateStr "desaturate"
#define kdescenderAlignmentStr "descenderAlignment"
#define kdescriptionStr "description"
#define kdeselectStr "deselect"
#define kdespeckleStr "despeckle"
#define kdestBlackMaxStr "destBlackMax"
#define kdestBlackMinStr "destBlackMin"
#define kdestWhiteMaxStr "destWhiteMax"
#define kdestWhiteMinStr "destWhiteMin"
#define kdestinationModeStr "destinationMode"
#define kdetailStr "detail"
#define kdetailedStr "detailed"
#define kdeviceCentralStr "deviceCentral"
#define kdiameterStr "diameter"
#define kdiamondStr "diamond"
#define kdifferenceCloudsStr "differenceClouds"
#define kdifferenceStr "difference"
#define kdiffuseGlowStr "diffuseGlow"
#define kdiffuseModeStr "diffuseMode"
#define kdiffuseStr "diffuse"
#define kdiffusionDitherEnumStr "diffusionDitherEnum"
#define kdiffusionDitherStr "diffusionDither"
#define kdiffusionStr "diffusion"
#define kdimensionStr "dimension"
#define kdirectSelectToolStr "directSelectTool"
#define kdirectionBalanceStr "directionBalance"
#define kdirectionStr "direction"
#define kdisableStr "disable"
#define kdisableLayerFXStr "disableLayerFX"
#define kdisableLayerStyleStr "disableLayerStyle"
#define kdisableSingleFXEventStr "disableSingleFX"
#define kdiscardVectorMaskStr "discardVectorMask"
#define kdispatcherIDStr "dispatcherID"
#define kdisplaceFileStr "displaceFile"
#define kdisplaceStr "displace"
#define kdisplacementMapStr "displacementMap"
#define kdisplayCursorsPreferencesStr "displayCursorsPreferences"
#define kdisplayNameStr "displayName"
#define kdisplayPrefsStr "displayPrefs"
#define kdisposeFrameStr "disposeFrame"
#define kdissolveStr "dissolve"
#define kdistanceStr "distance"
#define kdistanceUnitStr "distanceUnit"
#define kdistortStr "distort"
#define kdistortionStr "distortion"
#define kdistributeStr "distribute"
#define kdistributionStr "distribution"
#define kditherAmountStr "ditherAmount"
#define kditherPreserveStr "ditherPreserve"
#define kditherQualityStr "ditherQuality"
#define kditherStr "dither"
#define kdivideStr "divide"
#define kdocumentIDStr "documentID"
#define kdocumentModeStr "documentMode"
#define kdocumentReferenceStr "documentReference"
#define kdocumentStr "document"
#define kdocumentTimelineSettingsStr "documentTimelineSettings"
#define kdodgeHStr "dodgeH"
#define kdodgeMStr "dodgeM"
#define kdodgeSStr "dodgeS"
#define kdodgeToolStr "dodgeTool"
#define kdontRecordStr "dontRecord"
#define kdotGainCurvesStr "dotGainCurves"
#define kdotGainStr "dotGain"
#define kdotsStr "dots"
#define kdowngradeProfileStr "downgradeProfile"
#define kdraftStr "draft"
#define kdrawStr "draw"
#define kdropCapMultiplierStr "dropCapMultiplier"
#define kdropShadowStr "dropShadow"
#define kdryBrushStr "dryBrush"
#define kdualBrushStr "dualBrush"
#define kdualBrushLockStr "dualBrushLock"
#define kduotoneInkStr "duotoneInk"
#define kduotoneModeStr "duotoneMode"
#define kduotoneStr "duotone"
#define kduplicateFrameStr "duplicateFrame"
#define kduplicateStr "duplicate"
#define kduplicationStr "duplication"
#define kdurationStr "duration"
#define kdustAndScratchesStr "dustAndScratches"
#define kdutchLanguageStr "dutchLanguage"
#define kdutchLanguageOldRulesStr "kdutchLanguageOldRules"
#define kDVCPRO720pStr "DVCPRO720p"
#define kDVCPRO1080pStr "DVCPRO1080p"
#define kdynamicColorSlidersStr "dynamicColorSliders"
#define keBUITUStr "eBUITU"
#define keMBoxStrikethroughOnStr "eMBoxStrikethroughOn"
#define keasyTextSelection "easyTextSelection"
#define kedgeBrightnessStr "edgeBrightness"
#define kedgeFidelityStr "edgeFidelity"
#define kedgeGlowStr "edgeGlow"
#define kedgeIntensityStr "edgeIntensity"
#define kedgeSimplicityStr "edgeSimplicity"
#define kedgeStr "edge"
#define kedgeThicknessStr "edgeThickness"
#define kedgeWidthStr "edgeWidth"
#define keditCommentStr "editComment"
#define keditDataSetsStr "editDataSets"
#define keditInImageReadyStr "editInImageReady"
#define keditLogItemsStr "editLogItems"
#define keditLogItemsTypeStr "editLogItemsType"
#define keditVariablesStr "editVariables"
#define keffectBevelStr "effectBevel"
#define keffectColorOverlayStr "effectColorOverlay"
#define keffectDropShadowStr "effectDropShadow"
#define keffectGradientOverlayStr "effectGradientOverlay"
#define keffectInnerGlowStr "effectInnerGlow"
#define keffectInnerShadowStr "effectInnerShadow"
#define keffectNoneStr "effectNone"
#define keffectOuterGlowStr "effectOuterGlow"
#define keffectOverlayStr "effectOverlay"
#define keffectPatternOverlayStr "effectPatternOverlay"
#define keffectSatinStr "effectSatin"
#define keffectStr "effect"
#define keffectStrokeStr "effectStroke"
#define kelementReferenceStr "elementReference"
#define kelementStr "element"
#define keliminateEvenFieldsStr "eliminateEvenFields"
#define keliminateOddFieldsStr "eliminateOddFields"
#define kellipseStr "ellipse"
#define kellipseToolStr "ellipseTool"
#define kembedCMYKStr "embedCMYK"
#define kembedFontsStr "embedFonts"
#define kembedGrayStr "embedGray"
#define kembedLabStr "embedLab"
#define kembedLayerStr	"embedLayer"
#define kembedProfilesStr "embedProfiles"
#define kembedRGBStr "embedRGB"
#define kembossStr "emboss"
#define kemulsionDownStr "emulsionDown"
#define kenableStr "enable"
#define kenabledStr "enabled"
#define kenableFloatingDocDockingStr "enableFloatingDocDocking"
#define kenableFontFallbackStr "enableFontFallback"
#define kenableWariChuStr "enableWariChu"
#define kencodingStr "encoding"
#define kendArrowheadStr "endArrowhead"
#define kendFrameNumberStr "endFrameNumber"
#define kendIndentStr "endIndent"
#define kendRampStr "endRamp"
#define kendStr "end"
#define kendSustainStr "endSustain"
#define kendTimeStr "endTime"
#define kengineStr "engine"
#define kenglishLanguageStr "englishLanguage"
#define kentireImageStr "entireImage"
#define kentryStatusInvalidStr "invalid"
#define kentryStatusIsDirectoryStr "isDirectory"
#define kentryStatusIsFileStr "isFile"
#define kentryStatusIsVolumeStr "isVolume"
#define kentryStatusNotProcessedStr "notprocessed"
#define kentryStatusStr "entryStatus"
#define kentryStatusTypeStr "entryStatusType"
#define kenumeratedStr "enumerated" // DON'T NAME THINGS "enumSomething"; just name them "something"
#define kenvelopeWarpStyleStr "envelopewarpStyle"
#define kequalizeStr "equalize"
#define keraseToHistoryStr "eraseToHistory"
#define keraserKindStr "eraserKind"
#define keraserToolStr "eraserTool"
#define kestonianLanguageStr "estonianLanguage"
#define kevenStr "even"
#define keventClassAttrStr "eventClassAttr"
#define keventIDAttrStr "eventIDAttr"
#define keventRecordStr "eventRecord"
#define keventSourceAttrStr "eventSourceAttr"
#define kexactPointsStr "exactPoints"
#define kexactStr "exact"
#define kexchangeStr "exchange"
#define kexcludeIntersectionStr "excludeIntersection"
#define kexclusionStr "exclusion"
#define kexpandStr "expand"
#define kexpertFormStr "expertForm"
#define kexportClipboardStr "exportClipboard"
#define kexportDataSetStr "exportDataSet"
#define kexportMeasurementsStr "exportMeasurements"
#define kexportStr "export"
#define kexportTimelineCommentsStr "exportTimelineComments"
#define kexposureStr "exposure"
#define kextendStr "extend"
#define kextendedQualityStr "extendedQuality"
#define kextendedStr "extended"
#define kextendKeyframeSelectionStr "extendKeyframeSelection"
#define kextensionStr "extension"
#define kextensionsQueryStr "extensionsQuery"
#define kextractWorkAreaStr "extractWorkArea"
#define kextraLargeStr "extraLarge"
#define kextrudeDepthStr "extrudeDepth"
#define kextrudeMaskIncompleteStr "extrudeMaskIncomplete"
#define kextrudeRandomStr "extrudeRandom"
#define kextrudeSizeStr "extrudeSize"
#define kextrudeSolidFaceStr "extrudeSolidFace"
#define kextrudeStr "extrude"
#define kextrudeTypeStr "extrudeType"
#define keyeDropperSampleStr "eyeDropperSample"
#define keyeDropperSampleSheetStr "eyeDropperSampleSheet"
#define keyeDropperSampleTypeStr "eyeDropperSampleType"
#define keyedropperToolStr "eyedropperTool"
#define kfacetStr "facet"
#define kfadeStr "fade"
#define kfadeToStr "fadeTo"
#define kfadeoutStepsStr "fadeoutSteps"
#define kfalloffStr "falloff"
#define kfalseStr "false"
#define kfasterStr "faster"
#define kfeatherStr "feather"
#define kfiberLengthStr "fiberLength"
#define kfigureStyleStr "figureStyle"
#define kfileBrowserStr "fileBrowser"
#define kfileCreatorStr "fileCreator"
#define kfileEnumStr "fileEnum"
#define kfileInfoStr "fileInfo"
#define kfileNamingComponentStr "fileNamingComponent"
#define kfileNamingComponentsStr "fileNamingComponents"
#define kfileNamingRulesStr "fileNamingRules"
#define kfileReferenceStr "fileReference"
#define kfileSavePrefsClassStr "fileSavePrefsClass"
#define kfileSavePrefsStr "fileSavePrefs"
#define kfileStr "file"
#define kfilesListStr "filesList"
#define kfileTypeStr "fileType"
#define kfillBackStr "fillBack"
#define kfillColorStr "fillColor"
#define kfillContentsStr "fillContents"
#define kfillFirstStr "fillFirst"
#define kfillForeStr "fillFore"
#define kfillInverseStr "fillInverse"
#define kfillModeStr "fillMode"
#define kfillNeutralStr "fillNeutral"
#define kfillOpacityStr "fillOpacity"
#define kfillOverPrintStr "fillOverPrint"
#define kfillSameStr "fillSame"
#define kfillStr "fill"
#define kfillflashStr "fillflash" //rkulkarn 11/15/2000
#define kfilmGrainStr "filmGrain"
#define kfilterFXStr "filterFX"
#define kfilterFXListStr "filterFXList"
#define kfilterFXStyleStr	"filterFXStyle"
#define kfilterFXTrackIDStr "filterFXTrackID"
#define kfilterMaskDensityStr "filterMaskDensity"
#define kFilterMaskEnabledStr "filterMaskEnable"
#define kFilterMaskExtendWithWhiteStr "filterMaskExtendWithWhite"
#define kfilterMaskFeatherStr "filterMaskFeather"
#define kFilterMaskLinkedStr "filterMaskLinked"
#define kfilterMaskOptionsStr "filterMaskOptions"
#define kfilterMaskStr "filterMask"
#define kfilterStr "filter"
#define kfilterIDStr "filterID"
#define kfindEdgesStr "findEdges"
#define kfindReplaceStr "findReplace"
#define kfindStr "find"
#define kfineDotsStr "fineDots"
#define kfingerpaintingStr "fingerpainting"
#define kfinnishLanguageStr "finnishLanguage"
#define kfirstBaselineMinimumStr "firstBaselineMinimum"
#define kfirstIdleStr "firstIdle"
#define kfirstLineIndentStr "firstLineIndent"
#define kfirstStr "first"
#define kfitOnScreenStr "fitOnScreen"
#define kfitPageStr "fitPage"
#define kfixedStr "fixed"
#define kflaggedStr "flagged"
#define kflareCenterStr "flareCenter"
#define kflashPixFormatStr "flashPixFormat"
#define kflatnessStr "flatness"
#define kflattenImageStr "flattenImage"
#define kflattenStr "flatten"
#define kflickStr "flick"
#define kflipStr "flip"
#define kflipXStr "flipX"
#define kflipYStr "flipY"
#define kfloatingPointPredictorStr	"floatPredictor"
#define kfloatAllWindowsStr "floatAllWindows"
#define kfloatTypeStr "floatType"
#define kfloatUnitStr "floatUnit"
#define kfloatWindowStr "floatWindow"
#define kflowStr "flow"
#define kfocalLengthStr "focalLength"
#define kfocusStr "focus"
#define kfoldersStr "folders"
#define kfontCapsStr "fontCaps"
#define kfontDesignAxesStr "fontDesignAxes"
#define kfontDesignAxesVectorsStr "fontDesignAxesVectors"
#define kfontFamilyNameStr "fontFamilyName"
#define kfontLargeNameStr "fontLargeName"
#define kfontLargeSizeStr "fontLargeSize"
#define kfontListStr "fontList"
#define kfontNameStr "fontName"
#define kfontPostScriptNameStr "fontPostScriptName"
#define kfontScriptStr "fontScript"
#define kfontSizeStr "fontSize"
#define kfontSmallNameStr "fontSmallName"
#define kfontSmallSizeStr "fontSmallSize"
#define kfontStyleNameStr "fontStyleName"
#define kfontTechnologyStr "fontTechnology"
#define kfootageInfoStr "footageInfo"
#define kfootageInterpretationStr "footageInterpretation"
#define kfootageSizeStr "footageSize"
#define kforcedColorsStr "forcedColors"
#define kforcedNoDebuggerStr "forcedNoDebugger"
#define kforceFormatOptionsStr "forceFormatOptions"
#define kforceNotifyStr "forceNotify"
#define kforegroundColorStr "foregroundColor"
#define kforegroundLevelStr "foregroundLevel"
#define kforceRecordingStr "forceRecording"
#define kformatStr "format"
#define kforwardEnumStr "forwardEnum"
#define kforwardStr "forward"
#define kfractionsStr "fractions"
#define kfragmentStr "fragment"
#define kframeCountStr	"frameCount"
#define kframeDelayStr "frameDelay"
#define kframeDisposeStr "frameDispose"
#define kframeBaselineAlignmentStr "frameBaselineAlignment"
#define kframeNumberStr "frameNumber"
#define kframeFXClassStr "frameFXClass"
#define kframeFXStr "frameFX"
#define kframeFillStr "frameFill"
#define kframeFromVideoStr "frameFromVideo"
#define kframeGlobalAngleStr "frameGlobalAngle"
#define kframeGlobalAltitudeStr "frameGlobalAltitude"
#define kframeStr "frame"
#define kframeIDStr "frameID"
#define kframeInfoStr "frameInfo"
#define kframeRateStr "frameRate"
#define kframeSetIDStr "frameSetID"
#define kframeSkipStr "frameSkip"
#define kframesStr "frames"
#define kframeStepStr "frameStep"
#define kframeStyleStr "frameStyle"
#define kframeSetsStr "frameSets"
#define kframeWidthStr "frameWidth"
#define kfreeTransformCenterStateStr "freeTransformCenterState"
#define kfreeTransformStr "freeTransform"
#define kfreeformPenToolStr "freeformPenTool"
#define kfrequencyStr "frequency"
#define kfrescoStr "fresco"
#define kfromBuiltinStr "fromBuiltin"
#define kfromModeStr "fromMode"
#define kfromStr "from"
#define kfrontStr "front"
#define kfullDocumentStr "fullDocument"
#define kfullNameStr "fullName"
#define kfullSizeStr "fullSize"
#define kfullWidthFormStr "fullWidthForm"
#define kfunctionKeyStr "functionKey"
#define kfuzzinessStr "fuzziness"
#define kgainStr	"gain"
#define kgammaStr "gamma"
#define kgammaCorrectionStr "gammaCorrection"
#define kgamutWarningStr "gamutWarning"
#define kgaussianBlurStr "gaussianBlur"
#define kgaussianDistributionStr "gaussianDistribution"
#define kgeneralPreferencesStr "generalPreferences"
#define kgeneralPrefsStr "generalPrefs"
#define kgenieBrushToolStr "genieBrushTool"
#define kgeometryOnlyStr "geometryOnly"
#define kgeometryRecordStr "geometryRecord"
#define kgeometryToolModeStr "geometryToolMode"
#define kgetStr "get"
#define kglassStr "glass"
#define kglitterRightStr "glitterRight"
#define kglitterDownStr "glitterDown"
#define kglitterRDownStr "glitterRDown"
#define kglobalAltitudeStr "globalAltitude"
#define kglobalAngleStr "globalAngle"
#define kglobalClassStr "globalClass"
#define kglobalLightingAltitudeStr "globalAltitude"
#define kglobalLightingAngleStr "globalLightingAngle"
#define kglobalLightingStr "globalLighting"
#define kglobalObjectStr "globalObject"
#define kglossStr "gloss"
#define kglowAmountStr "glowAmount"
#define kglowTechniqueStr "glowTechnique"
#define kglowingEdgesStr "glowingEdges"
#define kgoodStr "good"
#define kgradientClassEventStr "gradientClassEvent"
#define kgradientFillStr "gradientFill"
#define kgradientFormStr "gradientForm"
#define kgradientLayerStr "gradientLayer"
#define kgradientMapClassStr "gradientMapClass"
#define kgradientMapEventStr "gradientMapEvent"
#define kgradientOverlayStr "gradientOverlay"
#define kgradientStr "gradient"
#define kgradientToolStr "gradientTool"
#define kgradientTypeStr "gradientType"
#define kgrainClumpedStr "grainClumped"
#define kgrainContrastyStr "grainContrasty"
#define kgrainEnlargedStr "grainEnlarged"
#define kgrainHorizontalStr "grainHorizontal"
#define kgrainRegularStr "grainRegular"
#define kgrainSoftStr "grainSoft"
#define kgrainSpeckleStr "grainSpeckle"
#define kgrainSprinklesStr "grainSprinkles"
#define kgrainStippledStr "grainStippled"
#define kgrainStr "grain"
#define kgrainTypeStr "grainType"
#define kgrainVerticalStr "grainVertical"
#define kgraininessStr "graininess"
#define kgrainyDotsStr "grainyDots"
#define kgraphicPenStr "graphicPen"
#define kgraphicsStr "graphics"
#define kgravityEffectStr "gravityEffect"
#define kgray16Str "gray16"
#define kgray18Str "gray18"
#define kgray22Str "gray22"
#define kgray50Str "gray50"
#define kgrayBehaviorStr "grayBehavior"
#define kgrayFloatStr	"grayFloat"
#define kgrayScaleRampStr "grayScaleRamp"
#define kgrayScaleStr "grayScale"
#define kgraySetupStr "graySetup"
#define kgrayStr "gray"
#define kgrayscaleModeStr "grayscaleMode"
#define kgrayscaleStr "grayscale"
#define kgrayscaleFloatStr "grayscaleFloat"
#define kgreekLanguageStr "greekLanguage"
#define kgreenBlackPointStr "greenBlackPoint"
#define kgreenFloatStr	"greenFloat"
#define kgreenGammaStr "greenGamma"
#define kgreenStr "green"
#define kgreenWhitePointStr "greenWhitePoint"
#define kgreenXStr "greenX"
#define kgreenYStr "greenY"
#define kgreensStr "greens"
#define kgridAlignmentStr "gridAlignment"
#define kgridColorStr "gridColor"
#define kgridCustomColorStr "gridCustomColor"
#define kgridMajorStr "gridMajor"
#define kgridMinorStr "gridMinor"
#define kgridStyleStr "gridStyle"
#define kgridUnitsStr "gridUnits"
#define kgroupEventStr "groupEvent"
#define kgroupStr "group"
#define kgroutWidthStr "groutWidth"
#define kgrowStr "grow"
#define kguideGridColorStr "guideGridColor"
#define kguideGridStyleStr "guideGridStyle"
#define kguideStr "guide"
#define kguidesColorStr "guidesColor"
#define kguidesCustomColorStr "guidesCustomColor"
#define kguidesGridPreferencesStr "guidesGridPreferences"
#define kguidesPrefsStr "guidesPrefs"
#define kguidesStr "guides"
#define kguidesStyleStr "guidesStyle"
#define kgutterWidthStr "gutterWidth"
#define khalfWidthFormStr "halfWidthForm"
#define khalftoneFileStr "halftoneFile"
#define khalftoneScreenStr "halftoneScreen"
#define khalftoneSizeStr "halftoneSize"
#define khalftoneSpecStr "halftoneSpec"
#define khandToolStr "handTool"
#define khangingRomanStr "hangingRoman"
#define khardLightStr "hardLight"
#define khardMixStr "hardMix"
#define khardProofStr "hardProof"
#define khardnessStr "hardness"
#define khasAlphaStr "hasAlpha"
#define khasMotionStr "hasMotion"
#define khasOptionsStr "hasoptions"
#define khasFilterMaskStr "hasFilterMask"
#define khasUserMaskStr "hasUserMask"
#define khasVectorMaskStr "hasVectorMask"
#define kvectorMaskParamsStr "vectorMaskParams"
#define khdrOptionsStr	"hdrOptions"
#define khdrToningMethodTypeStr	"hdrToningMethodType"
#define kheaderStr "header"
#define kheadlineStr "headline"
#define khealFromDest2SrcStr "healFromDest2Src"
#define khealFromSrc2DestStr "healFromSrc2Dest"
#define khealJPEGStr "healJPEG"
#define khealSelectionStr "healSelection"
#define khealingBrushToolStr "healingBrushTool"
#define khealingDirectionStr "healingDirection"
#define kheavyStr "heavy"
#define kheightStr "height"
#define khelpStr "help"
#define khiddenStr "hidden"
#define khideAllStr "hideAll"
#define khideCurrentPathStr "hideCurrentPath"
#define khideSelectionStr "hideSelection"
#define khideStr "hide"
#define khideDocumentTabsStr "hideDocumentTabs"
#define khighPassStr "highPass"
#define khighQualityStr "highQuality"
#define khighQualityWarpStr "highQualityWarp"
#define khighStr "high"
#define khighlightAreaStr "highlightArea"
#define khighlightColorStr "highlightColor"
#define khighlightLevelsStr "highlightLevels"
#define khighlightModeStr "highlightMode"
#define khighlightOpacityStr "highlightOpacity"
#define khighlightStrengthStr "highlightStrength"
#define khighlightsStr "highlights"
#define khistogramPaletteAllChannelsViewStr "histogramPaletteAllChannelsView"
#define khistogramPaletteCompactViewStr "histogramPaletteCompactView"
#define khistogramPaletteExpandedViewStr "histogramPaletteExpandedView"
#define khistogramPaletteShowChannelsInColorStr "histogramPaletteShowChannelsInColor"
#define khistogramPaletteShowStatisticsStr "histogramPaletteShowStatistics"
#define khistogramPaletteUncachedRefreshStr "histogramPaletteUncachedRefresh"
#define khistogramStr "histogram"
#define khistoryBrushSourceStr "historyBrushSource"
#define khistoryBrushToolStr "historyBrushTool"
#define khistoryLogStr "historyLog"
#define khistoryPaletteOptionsStr "historyPaletteOptions"
#define khistoryPreferencesStr "historyPreferences"
#define khistoryPrefsClassStr "historyPrefsClass"
#define khistoryPrefsStr "historyPrefs"
#define khistoryStateSourceStr "historyStateSource"
#define khistoryStateSourceTypeStr "historyStateSourceType"
#define khistoryStateStr "historyState"
#define khistoryStatesStr "historyStates"
#define khistoryStr "history"
#define kholdStr "hold"
#define khorizontalLocationStr "horizontalLocation"
#define khorizontalOnlyStr "horizontalOnly"
#define khorizontalScaleStr "horizontalScale"
#define khorizontalStr "horizontal"
#define khostNameStr "hostName"
#define khostVersionStr "hostVersion"
#define khoursStr "hours"
#define khtmlTextStr "htmlText"
#define khueSatAdjustmentStr "hueSatAdjustment"
#define khueSatAdjustmentV2Str "hueSatAdjustmentV2"
#define khueSaturationStr "hueSaturation"
#define khueStr "hue"
#define khugeStr "huge"
#define khungarianLanguageStr "hungarianLanguage"
#define khyphenateCapitalizedStr "hyphenateCapitalized"
#define khyphenateLimitStr "hyphenateLimit"
#define khyphenatePostLengthStr "hyphenatePostLength"
#define khyphenatePreLengthStr "hyphenatePreLength"
#define khyphenateStr "hyphenate"
#define khyphenateWordSizeStr "hyphenateWordSize"
#define khyphenationPreferenceStr "hyphenationPreference"
#define khyphenationZoneStr "hyphenationZone"
#define khyphenStr "hyphen"
#define kicelandicLanguageStr "icelandicLanguage"
#define kicfbottomStr "icfbottom"
#define kicftopStr "icftop"
#define kiconStr "icon"
#define kidleStr "idle"
#define kidleVMStr "idleVM"
#define kignoreStr "ignore"
#define killustratorPathsExportStr "illustratorPathsExport"
#define kimageBalanceStr "imageBalance"
#define kimageCachePreferencesStr "imageCachePreferences"
#define kimageCenterStr "imageCenter"
#define kimageInterpolationStr "imageInterpolation"
#define kimageLocationStr "imageLocation"
#define kimagePointStr "imagePoint"
#define kimageReferenceStr "imageReference"
#define kimageSizeStr "imageSize"
#define kimageStatisticsStr "imageStatistics"
#define kimageStr "image"
#define kimageStackStr	"imageStack"
#define kimageStackConvertSmartObjectStr	"imageStackConvertSmartObject"
#define kimageStackEditContentsStr	"imageStackEditContents"
#define kimageStackPluginStr	"imageStackPlugin"
#define kimageTypeStr "imageType"
#define kimportAnnotsStr "importAnnots"
#define kimportDataSetStr "importDataSets"
#define kimportStr "import"
#define kimportVideoToLayersStr "importVideoToLayers"
#define kimpressionistStr "impressionist"
#define kinAPathStr "inAPath"
#define kinStr "in"
#define kincludeAnnotationsStr "includeAnnotations"
#define kincludeAuthorStr "includeAuthor"
#define kincludeCopyrightStr "includeCopyright"
#define kincludeDescriptionStr "includeDescription"
#define kincludeEXIFDataStr "includeEXIFData"
#define kincludeExtensionStr "includeExtension"
#define kincludeFilenameStr "includeFilename"
#define kincludeTitleStr "includeTitle"
#define kincludeVectorDataStr "includeVectorData"
#define kindentStr "indent"
#define kindexedColorModeStr "indexedColorMode"
#define kindexedColorStr "indexedColor"
#define kinfoPaletteOptionsStr "infoPaletteOptions"
#define kinfoPaletteToggleSamplersStr "infoPaletteToggleSamplers"
#define kinheritsStr "inherits"
#define kinkBlackStr "inkBlack"
#define kinkColorsStr "inkColors"
#define kinkOutlinesStr "inkOutlines"
#define kinkTransferStr "inkTransfer"
#define kinksStr "inks"
#define kinnerBevelStr "innerBevel"
#define kinnerGlowSourceStr "innerGlowSource"
#define kinnerGlowSourceTypeStr "innerGlowSourceType"
#define kinnerGlowStr "innerGlow"
#define kinnerShadowStr "innerShadow"
#define kinputMapRangeStr "inputMapRange"
#define kinputRangeStr "inputRange"
#define kinputStr "input"
#define kinsertBlankFrameStr "insertBlankFrame"
#define kinsetFrameStr "insetFrame"
#define kinsideStr "inside"
#define kintegerChannelStr "integerChannel"
#define kintegerStr "integer"
#define kintellectualGenreStr "intellectualGenre"
#define kintensityStr "intensity"
#define kintentStr "intent"
#define kinteractiveStr "interactive"
#define kinteractLevelAttrStr "interactLevelAttr"
#define kinterfaceBevelHighlightStr "interfaceBevelHighlight"
#define kinterfaceBevelShadowStr "interfaceBevelShadow"
#define kinterfaceBlackStr "interfaceBlack"
#define kinterfaceBorderStr "interfaceBorder"
#define kinterfaceButtonDarkShadowStr "interfaceButtonDarkShadow"
#define kinterfaceButtonDownFillStr "interfaceButtonDownFill"
#define kinterfaceButtonUpFillStr "interfaceButtonUpFill"
#define kinterfaceColorBlue2Str "interfaceColorBlue2"
#define kinterfaceColorBlue32Str "interfaceColorBlue32"
#define kinterfaceColorGreen2Str "interfaceColorGreen2"
#define kinterfaceColorGreen32Str "interfaceColorGreen32"
#define kinterfaceColorRed2Str "interfaceColorRed2"
#define kinterfaceColorRed32Str "interfaceColorRed32"
#define kinterfaceColorStr "interfaceColor"
#define kinterfaceIconFillActiveStr "interfaceIconFillActive"
#define kinterfaceIconFillDimmedStr "interfaceIconFillDimmed"
#define kinterfaceIconFillSelectedStr "interfaceIconFillSelected"
#define kinterfaceIconFrameActiveStr "interfaceIconFrameActive"
#define kinterfaceIconFrameDimmedStr "interfaceIconFrameDimmed"
#define kinterfaceIconFrameSelectedStr "interfaceIconFrameSelected"
#define kinterfaceOWLPaletteFillStr "interfaceOWLPaletteFill"
#define kinterfacePaletteFillStr "interfacePaletteFill"
#define	kinterfacePrefsStr	"interfacePrefs"
#define kinterfaceRedStr "interfaceRed"
#define kinterfaceToolTipBackgroundStr "interfaceToolTipBackground"
#define kinterfaceToolTipTextStr "interfaceToolTipText"
#define kinterfaceTransparencyBackgroundStr "interfaceTransparencyBackground"
#define kinterfaceTransparencyForegroundStr "interfaceTransparencyForeground"
#define kinterfaceWhiteStr "interfaceWhite"
#define kinterlaceCreateTypeStr "interlaceCreateType"
#define kinterlaceEliminateTypeStr "interlaceEliminateType"
#define kinterlaceStr "interlace"
#define kinterpolationHoldStr "interpolationHold"
#define kinterpolationLinearStr "interpolationLinear"
#define kinterpolationMethodStr "interpolationMethod"
#define kinterpolationStr "interpolation"
#define kinterpolationTypeStr "interpolationType"
#define kinterpretAlphaStr "interpretAlpha"
#define kinterpretationStr "interpretation"
#define kinterpretFootageStr "interpretFootage"
#define kinTimeStr "inTime"
#define KPaletteFontTypePrefKeyStr "paletteFontTypeKey"
#define KPaletteFontTypePrefClassStr "paletteFontType"
#define KOldPaletteFontTypePrefKeyStr "oldPaletteFontTypeKey"
#define KOldPaletteFontTypePrefClassStr "oldPaletteFontType"
#define KuiLanguagePrefKeyStr "uiLanguageKey"
#define KUILanguagePrefKeyStr "uiLanguageKey"

#define kintersectFilterMaskWithSelectionStr "intersectFilterMaskWithSelection"
#define kintersectStr "intersect"
#define kintersectUserMaskWithSelectionStr "intersectUserMaskWithSelection"
#define kintersectVectorMaskWithSelectionStr "intersectVectorMaskWithSelection"
#define kintersectWithStr "intersectWith"
#define kinverseStr "inverse"
#define kinvertAlphaStr "invertAlpha"
#define kinvertMaskStr "invertMask"
#define kinvertSource2Str "invertSource2"
#define kinvertStr "invert"
#define kinvertTextureStr "invertTexture"
#define kiptcSceneStr "iptcScene"
#define kiptcSubjectCodeStr "iptcSubjectCode"
#define kisDirtyStr "isDirty"
#define kisoCountryCodeStr "isoCountryCode"
#define kitalianLanguageStr "italianLanguage"
#define kitalicStr "italic"
#define kitalicsStr "italics"
#define kitemIndexStr "itemIndex"
#define kjapaneseAlternateStr "japaneseAlternate"
#define kjapaneseLanguageStr "japaneseLanguage"
#define kjapaneseStr "japanese"
#define kjavaScriptMessageStr "javaScriptMessage"
#define kjavaScriptOptionsStr "javaScriptOptions"
#define kjavaScriptOptionsClassStr "javaScriptOptionsClass"
#define kjavaScriptNameStr "javaScriptName"
#define kjavaScriptStr "javaScript"
#define kjavaScriptTextStr "javaScriptText"
#define kjiDoriStr "jiDori"
#define kjitterStr "jitter"
#define kjobNameStr "jobName"
#define kjustificationGlyphDesiredStr "justificationGlyphDesired"
#define kjustificationGlyphMaximumStr "justificationGlyphMaximum"
#define kjustificationGlyphMinimumStr "justificationGlyphMinimum"
#define kjustificationLetterDesiredStr "justificationLetterDesired"
#define kjustificationLetterMaximumStr "justificationLetterMaximum"
#define kjustificationLetterMinimumStr "justificationLetterMinimum"
#define kjustificationWordDesiredStr "justificationWordDesired"
#define kjustificationWordMaximumStr "justificationWordMaximum"
#define kjustificationWordMinimumStr "justificationWordMinimum"
#define kjustifyAllStr "justifyAll"
#define kjustifyCenterStr "justifyCenter"
#define kjustifyFullStr "justifyFull"
#define kjustifyLeftStr "justifyLeft"
#define kjustifyRightStr "justifyRight"
#define kkanaStr "kana"
#define kkeepProfileStr "keepProfile"
#define kkeepTogetherStr "keepTogether"
#define kkelvinCustomWhitePointStr "kelvinCustomWhitePoint"
#define kkelvinStr "kelvin"
#define kkernelProcessIDStr "kernelProcessID"
#define kkernelTypeStr	"kernelType"
#define kkerningRangeStr "kerningRange"
#define kkerningStr "kerning"
#define kkeyboardCustomizationStr	"keyboardCustomization"
#define kcustomizationStr "customization"
#define kbrowseAndCloseStr "browseAndClose"
#define kbrowseFiltersStr "browseFilters"
#define kbrowseScriptsStr	"browseScripts"
#define kkeyboardPreferencesStr "keyboardPreferences"
#define kkeywordStr "keyword"
#define kkeywordsStr "keywords"
#define kkindStr "kind"
#define kkinsokuSetNameStr "kinsokuSetName"
#define kknockoutBlockingStr "knockoutBlocking"
#define kknockoutStr "knockout"
#define kcroatianLanguageStr "croatianLanguage"
#define kkurikaeshiMojiShoriStr "kurikaeshiMojiShori"
#define klab48Str "lab48"
#define klabColorModeStr "labColorMode"
#define klabColorStr "labColor"
#define klabStr "lab"
#define klabelsStr "labels"
#define klandscapeStr "landscape"
#define klargeDocumentFormatStr	"largeDocumentFormat"
#define klargeStr "large"
#define klassoToolStr "lassoTool"
#define klastFilterStr "lastFilter"
#define klastStr "last"
#define klastTransformStr "lastTransform"
#define klayer3DStr	"layer3D"
#define klayerCompressionStr "layerCompression"
#define klayerConcealsStr "layerConceals"
#define klayerEffectsStr "layerEffects"
#define klayerFXVisibleStr "layerFXVisible"
#define klayerIDStr "layerID"
#define klayerLockingStr "layerLocking"
#define klayerMaskAsGlobalMaskStr "layerMaskAsGlobalMask"
#define klayerNameStr "layerName"
#define klayerOptionsStr "layerOptions"
#define klayerGroupContentStr "layerSectionContent"
#define klayerGroupEndStr "layerSectionEnd"
#define klayerGroupStartStr "layerSectionStart"
#define klayerGroupStr "layerSection"
#define klayerGroupTypeStr "layerSectionType"
#define klayerGroupFromLinkedEventStr "layerSetFromLinkedEvent"
#define klayerGroupFromSelectedEventStr "layerSetFromSelectedEvent"

// jdc - 9/13/2004 - the following 6 symbols are deprecated, do not use them
		
#define klayerSectionContentStr klayerGroupContentStr
#define klayerSectionEndStr klayerGroupEndStr
#define klayerSectionStartStr klayerGroupStartStr
#define klayerSectionStr klayerGroupStr
#define klayerSectionTypeStr klayerGroupTypeStr
#define klayerSetFromLinkedEventStr klayerGroupFromLinkedEventStr
#define klayerTransformationStr "layerTransformation"

#define kgroupLayersEventStr "groupLayersEvent"
#define kungroupLayersEventStr "ungroupLayersEvent"
#define klatvianLanguageStr "latvianLanguage"
#define klayerStr "layer"
#define klayersPaletteOptionsStr "layersPaletteOptions"
#define klayersStr "layers"
#define klayerTime "layerTime"
#define klayerXMP "layerXMP"
#define kleAdobeOnlineWebStr "leAdobeOnlineWeb"
#define kleHealingBrushStr "leHealingBrush"
#define kleHelpContentStr "leHelpContent"
#define kleHelpSupportStr "leHelpSupport"
#define kleSystemInfoStr "leSystemInfo"
#define kleTutorialsStr "leTutorials"
#define kleUserForumsStr "leUserForums"
#define kleadingAboveStr "leadingAbove"
#define kleadingBelowStr "leadingBelow"
#define kleadingStr "leading"
#define kleadingTypeStr "leadingType"
#define kleftAkiStr "leftAki"
#define kleftPluginStr "leftPlugin"
#define kleftStr "left"
#define klengthStr "length"
#define klensBlurStr "lensBlur"
#define klensFlareStr "lensFlare"
#define klensStr "lens"
#define klevelBasedStr "levelBased"
#define klevelStr "level"
#define klevelsAdjustmentStr "levelsAdjustment"
#define klevelsStr "levels"
#define kliftWorkAreaStr "liftWorkArea"
#define kligatureStr "ligature"
#define klightBlueStr "lightBlue"
#define klightDarkStr "lightDark"
#define klightDirBottomLeftStr "lightDirBottomLeft"
#define klightDirBottomRightStr "lightDirBottomRight"
#define klightDirBottomStr "lightDirBottom"
#define klightDirLeftStr "lightDirLeft"
#define klightDirRightStr "lightDirRight"
#define klightDirTopLeftStr "lightDirTopLeft"
#define klightDirTopRightStr "lightDirTopRight"
#define klightDirTopStr "lightDirTop"
#define klightDirectionStr "lightDirection"
#define klightDirectionalStr "lightDirectional"
#define klightGrayStr "lightGray"
#define klightIntensityStr "lightIntensity"
#define klightOmniStr "lightOmni"
#define klightroomBridgetalkIDStr "lightroomBridgetalkID"
#define klightroomDocIDStr "lightroomDocID"
#define klightroomSaveParamsStr "lightroomSaveParams"
#define klightPosBottomLeftStr "lightPosBottomLeft"
#define klightPosBottomRightStr "lightPosBottomRight"
#define klightPosBottomStr "lightPosBottom"
#define klightPosLeftStr "lightPosLeft"
#define klightPosRightStr "lightPosRight"
#define klightPosTopLeftStr "lightPosTopLeft"
#define klightPosTopRightStr "lightPosTopRight"
#define klightPosTopStr "lightPosTop"
#define klightPositionStr "lightPosition"
#define klightRedStr "lightRed"
#define klightSourceStr "lightSource"
#define klightSpotStr "lightSpot"
#define klightStr "light"
#define klightTypeStr "lightType"
#define klightenGroutStr "lightenGrout"
#define klightenOnlyStr "lightenOnly"
#define klightenStr "lighten"
#define klighterColorStr	"lighterColor"
#define klightingEffectsStr "lightingEffects"
#define klightnessStr "lightness"
#define klimitedStr "limited"
#define klineCapStr "lineCap"
#define klineClassStr "lineClass"
#define klineDashOffsetStr "lineDashoffset"
#define klineDashStr "lineDash"
#define klineJoinStr "lineJoin"
#define klineStr "line"
#define klineToolStr "lineTool"
#define klineWidthStr "lineWidth"
#define klinearBurnStr "linearBurn"
#define klinearDodgeStr "linearDodge"
#define klinearHeightStr "linearHeight"
#define klinearLightStr "linearLight"
#define klinearStr "linear"
#define klinesStr "lines"
#define klinkStr "link"
#define klinkSelectedLayersStr "linkSelectedLayers"
#define klinkEnableStr "enableLayerLink"
#define klinkDisableStr "disableLayerLink"
#define klinkToOtherEffectsStr "linkToOtherEffects"
#define klithuanianLanguageStr "lithuanianLanguage"
#define kselectAllLayersStr "selectAllLayers"
#define kselectNoLayersStr "selectNoLayers"
#define kselectSimilarLayersStr "selectSimilarLayers"
#define klinkedLayerIDsStr "linkedLayerIDs"
#define klinkedStr "linked"
#define khideLayersStr "hideLayers"
#define kshowAlteredVideoStr "showAlteredVideo"
#define khideAlteredVideoStr "hideAlteredVideo"
#define kshowLayersStr "showLayers"
#define klocalLightingAltitudeStr "localLightingAltitude"
#define klocalLightingAngleStr "localLightingAngle"
#define klocalRangeStr "localRange"
#define klocationReferenceStr "locationReference"
#define klocationStr "location"
#define klockedStr "locked"
#define klogicalLengthStr "logicalLength"
#define klogicalUnitsStr "logicalUnits"
#define klogStr "log"
#define klongFloatStr "longFloat"
#define klongIntegerStr "longInteger"
#define klongLinesStr "longLines"
#define klongStrokesStr "longStrokes"
#define kloopStr "loop"
#define kloopCountStr "loopCount"
#define klowQualityStr "lowQuality"
#define klowStr "low"
#define klowerCaseExtensionStr "lowerCaseExtension"
#define klowerCaseSerialStr "lowerCaseSerial"
#define klowerCaseStr "lowerCase"
#define klowerStr "lower"
#define kluminanceStr "luminance"
#define kluminosityStr "luminosity"
#define kmacPaintFormatStr "macPaintFormat"
#define kmacThumbnailStr "macThumbnail"
#define kmacintoshStr "macintosh"
#define kmacintoshSystemStr "macintoshSystem"
#define kmagentaStr "magenta"
#define kmagentasStr "magentas"
#define kmagicEraserToolStr "magicEraserTool"
#define kmagicPointStr "magicPoint"
#define kmagicStampToolStr "magicStampTool"
#define kmagicWandToolStr "magicWandTool"
#define kmagneticLassoToolStr "magneticLassoTool"
#define kmagnificationStr "magnification"
#define kmagnitudeStr "magnitude"
#define kmakeAnimationStr "makeAnimation"
#define kmakeFramesFromLayersStr "makeFramesFromLayers"
#define kmakeLayersFromFramesStr "makeLayersFromFrames"
#define kmakeShapeLayersStr "makeShapeLayers"
#define kmakeStr "make"
#define kmakeVisibleStr "makeVisible"
#define kmanageStr "manage"
#define kmanipulationFOVStr "manipulationFOV"
#define kmanualStr "manual"
#define kmapBlackStr "mapBlack"
#define kmappingShapeStr "mappingShape"
#define kmappingStr "mapping"
#define kmarqueeEllipToolStr "marqueeEllipTool"
#define kmarqueeRectToolStr "marqueeRectTool"
#define kmarqueeSingleColumnToolStr "marqueeSingleColumnTool"
#define kmarqueeSingleRowToolStr "marqueeSingleRowTool"
#define kmaskIndicatorStr "maskIndicator"
#define kmaskParametersStr "maskParameters"
#define kmaskStr "mask"
#define kmaskedAreasStr "maskedAreas"
#define kmasterAdaptiveStr "masterAdaptive"
#define kmasterDiameterStr "masterDiameter"
#define kmasterFXSwitchStr "masterFXSwitch"
#define kmasterPerceptualStr "masterPerceptual"
#define kmasterSelectiveStr "masterSelective"
#define kmatchColorStr "matchColor"
#define kmatchLocationStr	"matchLocation"
#define kmatchRotationStr "matchRotation"
#define kmatchZoomAndLocationStr	"matchZoomAndLocation"
#define kmatchZoomStr	"matchZoom"
#define kmaterialStr "material"
#define kmatrixStr "matrix"
#define kmatteColorStr "matteColor"
#define kmatteStr "matte"
#define kmatteTechniqueStr "matteTechnique"
#define kmaxDOFStr "maxDOF"
#define kmaximizeCompatibilityStr "maximizeCompatibility"
#define kmaximumEnumStr "maximumEnum"
#define kmaximumQualityStr "maximumQuality"
#define kmaximumStatesStr "maximumStates"
#define kmaximumStr "maximum"
#define kmeansStr "means"
#define kmeasurementDataPointStr "measurementDataPoint"
#define kmeasurementDataPointsCustomStr "measurementDataPointsCustom"
#define kmeasurementLogAutoDisplayPaletteStr "measurementLogAutoDisplayPalette"
#define kmeasurementLogDataClassStr "measurementLogDataClass"
#define kmeasurementLogDataPointClassStr "measurementLogDataPointClass"
#define kmeasurementLogDataPointDataClassStr "measurementLogDataPointDataClass"
#define kmeasurementLogDataPointDataTypeClassStr "measurementLogDataPointDataTypeClass"
#define kmeasurementLogDeleteSelectedStr "measurementLogDeleteSelected"
#define kmeasurementLogDeselectAllStr "measurementLogDeselectAll"
#define kmeasurementLogErrorClassStr "measurementLogErrorClass"
#define kmeasurementLogExportSelectedStr "measurementLogExportSelected"
#define kmeasurementLogExtentClassStr "measurementLogExtentClass"
#define kmeasurementLogOptionsStr "measurementLogOptions"
#define kmeasurementLogPanelKeyStr "measurementLogPanelKey"
#define kmeasurementLogSelectAllStr "measurementLogSelectAll"
#define kmeasurementRangeStr "measurementRange"
#define kmeasurementRecordMeasurementsStr "measurementRecordMeasurements"
#define kmeasurementScaleStr "measurementScale"
#define kmeasurementScaleCustomStr "measurementScaleCustom"
#define kmeasurementScaleDefaultStr "measurementScaleDefault"
#define kmeasurementScaleMarkerStr "measurementScaleMarker"
#define kmeasurementScaleMarkerColorStr "measurementScaleMarkerColor"
#define kmeasurementScaleMarkerLengthStr "measurementScaleMarkerLength"
#define kmeasurementScaleMarkerDisplayTicksStr "measurementScaleMarkerDisplayTicks"
#define kmeasurementScaleMarkerDisplayTextStr "measurementScaleMarkerDisplayText"
#define kmeasurementScaleMarkerTextPositionBottomStr "measurementScaleMarkerTextPositionBottom"
#define kmeasurementScaleMarkerLocationBottomStr "measurementScaleMarkerLocationBottom"
#define kmeasurementScaleMarkerLocationLeftStr "measurementScaleMarkerLocationLeft"
#define kmeasurementSourceStr "measurementSource"
#define kmedianStr "median"
#define kmediaBoxStr "mediaBox"
#define kmediumBlueStr "mediumBlue"
#define kmediumDotsStr "mediumDots"
#define kmediumLinesStr "mediumLines"
#define kmediumQualityStr "mediumQuality"
#define kmediumStr "medium"
#define kmediumStrokesStr "mediumStrokes"
#define kmemoryPreferencesStr "memoryPreferences"
#define kmemoryUsagePercentStr "memoryUsagePercent"
#define kmenuCustomizationStr "menuCustomization"
#define kmenuItemClassStr "menuItemClass"
#define kmenuItemTypeStr "menuItemType"
#define kmergeAlignedLayersStr "mergeAlignedLayers"
#define kmergeChannelsStr "mergeChannels"
#define kmergeLayersStr "mergeLayersNew"			// new for PSCS2
#define koldMergeLayersStr "mergeLayers"			// used prior to PSCS2
#define kmergeSpotChannelStr "mergeSpotChannel"
#define kmergeStr "merge"
#define kmergeVisibleStr "mergeVisible"
#define kmergedLayersStr "mergedLayers"
#define kmergedStr "merged"
#define kmeshPointsStr "meshPoints"
#define kmessageStr "message"
#define kmethodStr "method"
#define kmetadataStr "metadata"
#define kmetricsKernStr "metricsKern"
#define kmezzotintStr "mezzotint"
#define kmezzotintTypeStr "mezzotintType"
#define kmiddleStr "middle"
#define kmidpointStr "midpoint"
#define kmidtoneLevelsStr "midtoneLevels"
#define kmidtonesStr "midtones"
#define kmixerPresetKindStr "mixerPresetKind"
#define kmixerPresetFileNameStr "mixerPresetFileName"


// DO NOT USE except in text code -- see comments under "Units"
// in PITerminology.h

#define kmillimetersUnitStr "millimetersUnit"
#define kminDepthStr "minimumDepth"
#define kminDiameterStr "minimumDiameter"
#define kminDigitsStr "minDigits"
#define kminRoundnessStr "minimumRoundness"
#define kminScaleStr "minimumScale"
#define kminutesStr "minutes"
#define kminimumStr "minimum"
#define kmismatchCMYKStr "mismatchCMYK"
#define kmismatchGrayStr "mismatchGray"
#define kmismatchRGBStr "mismatchRGB"
#define kmissedKeywordAttrStr "missedKeywordAttr"
#define kmiterJoinStr "miterJoin"
#define kmiterLimitStr "miterLimit"
#define kmmddStr "mmdd"
#define kmmddyyStr "mmddyy"
#define kmodeGrayStr "modeGray"
#define kmodeRGBStr "modeRGB"
#define kmodeStr "mode"
#define kmojiKumiNameStr "mojiKumiName"
#define kMojiKumiNone		"Photoshop6MojiKumiNone"
#define kMojikumiTable1		"Photoshop6MojiKumiSet1"
#define kMojikumiTable2		"Photoshop6MojiKumiSet2"
#define kMojikumiTable3		"Photoshop6MojiKumiSet3"
#define kMojikumiTable4		"Photoshop6MojiKumiSet4"

#define kmojiZumeStr "mojiZume"
#define kmonitorCompressionStr "monitorCompression"
#define kmonitorRGBStr "monitorRGB"
#define kmonitorSetupStr "monitorSetup"
#define kmonitorStr "monitor"
#define kmonochromaticStr "monochromatic"
#define kmonotoneStr "monotone"
#define kmosaicPluginStr "mosaicPlugin"
#define kmosaicStr "mosaic"
#define kmotionBlurStr "motionBlur"
#define kmoreAccurateStr "moreAccurate"
#define kmoveStr "move"
#define kmoveAllTimeStr "moveAllTime"
#define kmoveInTimeStr "moveInTime"
#define kmoveKeyframesStr "moveKeyframes"
#define kmoveOutTimeStr "moveOutTime"
#define kmoveStartTimeStr "moveStartTime"
#define kmoveToStr "moveTo"
#define kmoveToolOnCommit "moveToolOnCommit"
#define kmoveToolStr "moveTool"
#define kmoveWorkAreaStr "moveWorkArea"
#define kmovieFrameReaderStr "movieFrameReader"
#define kMRUFolderSizeStr "MRUFolderSize"
#define kmulti72ColorStr "multi72Color"
#define kmulti72GrayStr "multi72Gray"
#define kmultiAdjustorStr "multiAdjustor"
#define kmultiNoCompositePSStr "multiNoCompositePS"
#define kmultichannelModeStr "multichannelMode"
#define kmultichannelStr "multichannel"
#define kmultiplyStr "multiply"
#define kmuteVideoStr "muteVideo"
#define knameStr "name"
#define knavigatorPaletteOptionsStr "navigatorPaletteOptions"
#define knearestNeighborStr "nearestNeighbor"
#define knegativeStr "negative"
#define kneonGlowStr "neonGlow"
#define knegGaussClustersStr "negGaussClusters"
#define knegGaussParamsStr "negGaussParams"
#define knegGaussToleranceStr "negGaussTolerance"
#define knegSpaGaussToleranceStr "negSpaGaussTolerance"
#define knetscapeGrayStr "netscapeGray"
#define kneutralizeColorStr "neutralizeColor"
#define kneutralsStr "neutrals"
#define kneverShowDebuggerStr "neverShowDebugger"
#define knewDocPresetPrintResolutionStr "newDocPresetPrintResolution"
#define knewDocPresetPrintScaleStr "newDocPresetPrintScale"
#define knewDocPresetScreenResolutionStr "newDocPresetScreenResolution"
#define knewDocPresetScreenScaleStr "newDocPresetScreenScale"
#define knewFromClipboardStr "newFromClipboard"
#define knewGuideStr "newGuide"
#define knewPlacedLayerStr	"newPlacedLayer"
#define knewStr "new"
#define knewViewStr "newView"
#define knextStr "next"
#define knextFrameStr "nextFrame"
#define knextKeyframeStr "nextKeyframe"
#define knikon105Str "nikon105"
#define knikonStr "nikon"
#define knoBreakStr "noBreak"
#define knoCompositePSStr "noCompositePS"
#define knoImageStr "noImage"
#define knoReferenceStr "noReference"
#define knoStr "no"
#define knoiseStr "noise"
#define knoiseLockStr "noiseLock"
#define knonAffineTransformStr "nonAffineTransform"
#define knonImageDataStr "nonImageData"
#define knonLinearStr "nonLinear"
#define knoneStr "none"
#define knoneUnitStr "noneUnit"
#define knormalPathStr "normalPath"
#define knormalStr "normal"
#define knoteLocationStr "noteLocation"
#define knotePaperStr "notePaper"
#define knotifyStr "notify"
#define kNTSCDVStr "NTSCDV"
#define kNTSCDVWideStr "NTSCDVWide"
#define kNTSCD1Str "NTSCD1"
#define kNTSCD1WideStr "NTSCD1Wide"
#define kNTSCD1SquareStr "NTSCD1Square"
#define kNTSCD1WideSquareStr "NTSCD1WideSquare"
#define knullStr "null"
#define knullFrameReaderStr "nullFrameReader"
#define knumLightsStr "numLights"
#define knumberOfCacheLevelsStr "numberOfCacheLevels"
#define knumberOfChannelsStr "numberOfChannels"
#define knumberOfChildrenStr "numberOfChildren"
#define knumberOfDocumentsStr "numberOfDocuments"
#define knumberOfGeneratorsStr "numberOfGenerators"
#define knumberOfLayersStr "numberOfLayers"
#define knumberOfLevelsStr "numberOfLevels"
#define knumberOfPathsStr "numberOfPaths"
#define knumberOfRipplesStr "numberOfRipples"
#define knumberOfSiblingsStr "numberOfSiblings"
#define knumberStr "number"
#define knumeratorStr "numerator"
#define knumericSequenceFrameReaderStr "numericSequenceFrameReader"
#define knumericSequenceSpecStr "numericSequenceSpec"
#define knynorskNorwegianLanguageStr "nynorskNorwegianLanguage"
#define kobjectNameStr "objectName"
#define kobjectReferenceStr "objectReference"
#define kobjectStr "object"
#define kobsoleteTextLayerStr "obsoleteTextLayer"
#define koceanRippleStr "oceanRipple"
#define koddStr "odd"
#define koffStr "off"
#define koffsetStr "offset"
#define kokStr "ok"
#define koldStyleStr "oldStyle"
#define koldTextStr "oldText"
#define koldTextAgeStr "oldTextAge"
#define konACurveStr "onACurve"
#define konErrorStr "onError"
#define konOffStr "onOff"
#define konStr "on"
#define koneDigitStr "oneDigit"
#define kopacityClassStr "opacityClass"
#define kopacityStr "opacity"
#define kopacityFloatStr	"opacityFloat"
#define kopenAsStr "openAs"
#define kopenAsSmartObjectStr "openAsSmartObject"
#define kopenStr "open"
#define kopenNewDocsAsTabsStr "openNewDocsAsTabs"
#define kopticalKernStr "opticalKern"
#define koptimizedStr "optimized"
#define koptionalKeywordAttrStr "optionalKeywordAttr"
#define korangeStr "orange"
#define kordinalStr "ordinal"
#define kordinalsStr "ordinals"
#define korientationStr "orientation"
#define koriginalAddressAttrStr "originalAddressAttr"
#define koriginalHeaderStr "originalHeader"
#define koriginalTransmissionReferenceStr "originalTransmissionReference"
#define kornamentsStr "ornaments"
#define kotbaselineStr "otbaseline"
#define kotherCursorsStr "otherCursors"
#define koutFromCenterStr "outFromCenter"
#define koutOfGamutStr "outOfGamut"
#define kouterBevelStr "outerBevel"
#define kouterGlowStr "outerGlow"
#define koutputStr "output"
#define koutsetFrameStr "outsetFrame"
#define koutsideStr "outside"
#define koutTimeStr "outTime"
#define koverlapStr "overlap"
#define koverlayStr "overlay"
#define koverprintColorsStr "overprintColors"
#define koverrideNodeStr "overrideNode"
#define koverrideOpenStr "overrideOpen"
#define koverridePrinterStr "overridePrinter"
#define koverrideSaveStr "overrideSave"
#define kpInheritsStr "pInherits"
#define kpageStr "page"
#define kpageFormatStr "pageFormat"
#define kpageNumberStr "pageNumber"
#define kpagePosCenteredStr "pagePosCentered"
#define kpagePosTopLeftStr "pagePosTopLeft"
#define kpagePositionStr "pagePosition"
#define kpageSetupStr "pageSetup"
#define kpaintDaubsStr "paintDaubs"
#define kpaintStr "paint"
#define kpaintDynamicsLock "paintDynamicsLock"
#define kpaintStrokeStr "paintStroke"
#define kpaintTypeStr "paintType"
#define kpaintbrushEraserStr "paintbrushEraser"
#define kpaintbrushToolStr "paintbrushTool"
#define kpaintingCursorsStr "paintingCursors"
#define kPALD1DVStr "PALD1DV"
#define kPALD1DVWideStr "PALD1DVWide"
#define kPALD1DVSquareStr "PALD1DVSquare"
#define kPALD1DVWideSquareStr "PALD1DVWideSquare"
#define kpalSecamStr "palSecam"
#define kpaletteFileStr "paletteFile"
#define kpaletteKnifeStr "paletteKnife"
#define kpaletteStr "palette"
#define kpaletteBrightnessStr "paletteBrightness"
#define kpanaVisionStr "panaVision"
#define kpanoramaStr "panorama"
#define kpaperBrightnessStr "paperBrightness"
#define kpaperWhiteStr "paperWhite"
#define kparagraphStyleRangeStr "paragraphStyleRange"
#define kparagraphStyleStr "paragraphStyle"
#define kparentIDStr "parentID"
#define kparentIndexStr "parentIndex"
#define kparentNameStr "parentName"
#define kpassThroughStr	"passThrough"
#define kpasswordsStr "passwords"
#define kpasteEffectsStr "pasteEffects"
#define kpasteIntoStr "pasteInto"
#define kpasteKeyframesStr "pasteKeyframes"
#define kpasteNewDocStr "pasteNewDocument"
#define kpasteOutsideStr "pasteOutside"
#define kpasteStr "paste"
#define kpatchSelectionStr "patchSelection"
#define kpatchworkStr "patchwork"
#define kpathClassStr "pathClass"
#define kpathComponentSelectToolStr "pathComponentSelectTool"
#define kpathComponentStr "pathComponent"
#define kpathComponentsStr "pathComponents"
#define kpathContentsStr "pathContents"
#define kpathKindStr "pathKind"
#define kpathNameStr "pathName"
#define kpathOperationStr "pathOperation"
#define kpathPointStr "pathPoint"
#define kpathReferenceStr "pathReference"
#define kpathStr "path"
#define kpathTypeAlignToStr "pathTypeAlignTo"
#define kpathTypeAlignmentStr "pathTypeAlignment"
#define kpathTypeEffectStr "pathTypeEffect"
#define kpathTypeSpacingStr "pathTypeSpacing"
#define kpathsPaletteOptionsStr "pathsPaletteOptions"
#define kpatternDitherStr "patternDither"
#define kpatternFillClassStr "patternFillClass"
#define kpatternFillStr	"patternFill"
#define kpatternKeyStr "patternKey"
#define kpatternLayerStr "patternLayer"
#define kpatternOverlayStr "patternOverlay"
#define kpatternStampToolStr "patternStampTool"
#define kpatternStr "pattern"
#define kpauseForAudioStr "pauseForAudio"
#define kpauseStr "pause"
#define kpdfxStandardStr "pdfxStandard"
#define kpdfx1a2001Str "pdfx1a2001"
#define kpdfx1a2003Str "pdfx1a2003"
#define kpdfx32001Str "pdfx32001"
#define kpdfx32003Str "pdfx32003"
#define kpdfx42008Str "pdfx42008"
#define kpdfCompatibilityLevelStr "pdfCompatibilityLevel"
#define kpdf13Str "pdf13"
#define kpdf14Str "pdf14"
#define kpdf15Str "pdf15"
#define kpdf16Str "pdf16"
#define kpdf17Str "pdf17"
#define kpdfPreserveEditingStr "pdfPreserveEditing"
#define kpdfEmbedThumbnailsStr "pdfEmbedThumbnails"
#define kpdfOptimizeForWebStr "pdfOptimizeForWeb"
#define kpdfViewAfterSaveStr "pdfViewAfterSave"
#define kpdfSubsetFontThresholdStr "pdfSubsetFontThreshold"
#define kpdfDownSampleStr "pdfDownSample"
#define kpdfDownsampleResolutionStr "pdfDownsampleResolution"
#define kpdfThresholdResolutionStr "pdfThresholdResolution"
#define kpdfTileSizeStr "pdfTileSize"
#define kpdfCompressionTypeStr "pdfCompressionType"
#define kpdfConvert16To8Str "pdfConvert16To8"
#define kpdfPrinterTrimMarksStr "pdfPrinterTrimMarks"
#define kpdfPrinterRegistrationMarksStr "pdfPrinterRegistrationMarks"
#define kpdfPrinterColorBarsStr "pdfPrinterColorBars"
#define kpdfPrinterPageInfoStr "pdfPrinterPageInfo"
#define kpdfPrinterMarkTypeStr "pdfPrinterMarkType"
#define kpdfMarkWeightStr "pdfMarkWeight"
#define kpdfMarkOffsetStr "pdfMarkOffset"
#define kpdfTopBleedStr "pdfTopBleed"
#define kpdfBottomBleedStr "pdfBottomBleed"
#define kpdfLeftBleedStr "pdfLeftBleed"
#define kpdfRightBleedStr "pdfRightBleed"
#define kpdfColorConversionStr "pdfColorConversion"
#define kpdfDestinationProfileDescriptionStr "pdfDestinationProfileDescription"
#define kpdfIncludeProfileStr "pdfIncludeProfile"
#define kpdfOutputConditionStr "pdfOutputCondition"
#define kpdfOutputConditionIdentifierStr "pdfOutputConditionIdentifier"
#define kpdfRegistryNameStr "pdfRegistryName"
#define kpdfRequireOpenPasswordStr "pdfRequireOpenPassword"
#define kpdfOpenPasswordStr "pdfOpenPassword"
#define kpdfRequirePermissionPasswordStr "pdfRequirePermissionPassword"
#define kpdfPermissionPasswordStr "pdfPermissionPassword"
#define kpdfPrintingAllowedStr "pdfPrintingAllowed"
#define kpdfChangesAllowedStr "pdfChangesAllowed"
#define kpdfEnableCopyingStr "pdfEnableCopying"
#define kpdfEnableReadersStr "pdfEnableReaders"
#define kpdfEnablePlaintextMetadataStr "pdfEnablePlaintextMetadata"
#define kpdfPresetFilenameStr "pdfPresetFilename"
#define kpdfSelectionStr "pdfSelection"
#define kpenToolStr "penTool"
#define kpencilEraserStr "pencilEraser"
#define kpencilToolStr "pencilTool"
#define kpencilWidthStr "pencilWidth"
#define kpercentUnitStr "percentUnit"
#define kperceptualStr "perceptual"
#define kperformanceStr "performance"
#define kpersistentScreenModeStr "persistentScreenMode"
#define kperspectiveIndexStr "perspectiveIndex"
#define kperspectiveStr "perspective"
#define kphaseStr "phase"
#define kphotoBinAutoHide "photoBinAutoHide"
#define kphosphorsCustomPhosphorsStr "phosphorsCustomPhosphors"
#define kphosphorsStr "phosphors"
#define kphotoFilterStr	"photoFilter"
#define kphotocopyStr "photocopy"
#define kphotomergeStr "photomerge"
#define kphotoshop20FormatStr "photoshop20Format"
#define kphotoshop35FormatStr "photoshop35Format"
#define kphotoshopDCS2FormatStr "photoshopDCS2Format"
#define kphotoshopDCSFormatStr "photoshopDCSFormat"
#define kphotoshopEPSFormatStr "photoshopEPSFormat"
#define kphotoshopPDFFormatStr "photoshopPDFFormat"
#define kphotoshopPickerStr "photoshopPicker"
#define kpickCMYKStr "pickCMYK"
#define kpickGrayStr "pickGray"
#define kpickHSBStr "pickHSB"
#define kpickLabStr "pickLab"
#define kpickOptionsStr "pickOptions"
#define kpickRGBStr "pickRGB"
#define kpickWebStr "pickWeb"
#define kpickerIDStr "pickerID"
#define kpickerKindStr "pickerKind"
#define kpickerKindTypeStr "pickerKindType"
#define kpickingForegroundStr	"pickingForeground"
#define kpicturePackageStr "picturePackage"
#define kpillowEmbossStr "pillowEmboss"
#define kpinLightStr "pinLight"
#define kpinchStr "pinch"
#define kpixelDoublingStr "pixelDoubling"
#define kpixelLengthStr "pixelLength"
#define kpixelHeightStr "pixelHeight"
#define kpixelPaintFormatStr "pixelPaintFormat"
#define kpixelPaintSize1Str "pixelPaintSize1"
#define kpixelPaintSize2Str "pixelPaintSize2"
#define kpixelPaintSize3Str "pixelPaintSize3"
#define kpixelPaintSize4Str "pixelPaintSize4"
#define kpixelPaintSizeStr "pixelPaintSize"
#define kpixelStr "pixel"
#define kpixelWidthStr "pixelWidth"
#define kpixelsAcrossStr "pixelsAcross"
#define kpixelsDownStr "pixelsDown"
#define kpixelsUnitStr "pixelsUnit"
#define kplaceEnumStr "placeEnum"
#define kplaceEventStr "placeEvent"
#define kplaceMeasurementScaleMarkerStr	"placeMeasurementScaleMarker"
#define kplacedStr	"placed"
#define kplacedLayerMakeCopyStr	"placedLayerMakeCopy"
#define kplacedLayerEditContentsStr	"placedLayerEditContents"
#define kplacedLayerExportContentsStr	"placedLayerExportContents"
#define kplacedLayerReplaceContentsStr	"placedLayerReplaceContents"
#define kplanarStr	"planar"
#define kplasterStr "plaster"
#define kplasticWrapStr "plasticWrap"
#define kplatformStr "platform"
#define kplayStr "play"
#define kplaybackOptionsStr "playbackOptions"
#define kpluginFolderStr "pluginFolder"
#define kpluginPickerStr "pluginPicker"
#define kpluginPrefsStr "pluginPrefs"
#define kpluginsScratchDiskPreferencesStr "pluginsScratchDiskPreferences"
#define kpoint16Str "point16"
#define kpointStr "point"
#define kpointillizeStr "pointillize"
#define kpointsStr "points"

// DO NOT USE except in text code -- see comments under "Units"
// in PITerminology.h

#define kpointsUnitStr "pointsUnit"
#define kpolarStr "polar"
#define kpolarToRectStr "polarToRect"
#define kpolicyCMYKStr "policyCMYK"
#define kpolicyGrayStr "policyGray"
#define kpolicyRGBStr "policyRGB"
#define kpolicyStr "policy"
#define kpolishLanguageStr "polishLanguage"
#define kpolySelToolStr "polySelTool"
#define kpolygonStr "polygon"
#define kpolygonToolStr "polygonTool"
#define kpondRipplesStr "pondRipples"
#define kposGaussClustersStr "posGaussClusters"
#define kposGaussParamsStr "posGaussParams"
#define kposGaussToleranceStr "posGaussTolerance"
#define kposSpaGaussToleranceStr "posSpaGaussTolerance"
#define kpositionStr "position"
#define kpostScriptColorStr "postScriptColor"
#define kposterEdgesStr "posterEdges"
#define kposterizationStr "posterization"
#define kposterizeStr "posterize"
#define kpowerStr "power"
#define kpreciseMatteStr "preciseMatte"
#define kpreciseStr "precise"
#define kpredefinedColorsStr "predefinedColors"
#define kpreferBuiltinStr "preferBuiltin"
#define kpreferEnhancedTIFFStr "preferEnhancedTIFF"
#define kpreferXMPFromACRStr "preferXMPFromACR"
#define kpreferencesClassStr "preferencesClass"
#define kpreferencesFolderStr "preferencesFolder"
#define kpreferencesStr "preferences"
#define kpreferredKinsokuOrderStr "preferredKinsokuOrder"
#define KinsokuPredefinedTagStr "KinsokuPredefinedTag"
#define kprefixStr "prefix"
#define kpremultipliedBlackStr "premultipliedBlack"
#define kpremultipliedColorStr "premultipliedColor"
#define kpremultipliedWhiteStr "premultipliedWhite"
#define kpresentationStr "presentation"
#define kfullpathStr "fullPath"
#define kpreserveAdditionalStr "preserveAdditional"
#define kpreserveLuminosityStr "preserveLuminosity"
#define kpreserveStr "preserve"
#define kpreserveTransparencyStr "preserveTransparency"
#define kpresetManagerCommandStr "presetManager"
#define kpresetStr "preset"
#define kpresetFileModeStr "presetFileMode"
#define kpresetFileNameStr "presetFileName"
#define kpresetFileSpecStr "presetFileSpec"
#define kpresetKindStr "presetKind"
#define kpresetKindEnumStr "presetKindEnum"
#define kpresetKindTypeStr "presetKindType"
#define kpresetKindCustomStr "presetKindCustom"
#define kpresetKindDefaultStr "presetKindDefault"
#define kpresetKindFactoryStr "presetKindFactory"
#define kpresetKindUserDefinedStr "presetKindUserDefined"
#define kpressureStr "pressure"
#define kpreviewBlackStr "previewBlack"
#define kpreviewCMYKEnumStr "previewCMYKEnum"
#define kpreviewCMYKStr "previewCMYK"
#define kpreviewCMYKTypeStr "previewCMYKType"
#define kpreviewCMYStr "previewCMY"
#define kpreviewCyanStr "previewCyan"
#define kpreviewFullSizeStr "previewFullSize"
#define kpreviewIconStr "previewIcon"
#define kpreviewMacThumbnailStr "previewMacThumbnail"
#define kpreviewMagentaStr "previewMagenta"
#define kpreviewOffStr "previewOff"
#define kpreviewStr "preview"
#define kpreviewWinThumbnailStr "previewWinThumbnail"
#define kpreviewYellowStr "previewYellow"
#define kpreviewsQueryStr "previewsQuery"
#define kpreviousStr "previous"
#define kpreviousFrameStr "previousFrame"
#define kpreviousKeyframeStr "previousKeyframe"
#define kprimariesStr "primaries"
#define kprintColorHandling "printColorHandling"
#define kprintCopies "printCopies"
#define kprintCurrentPrinter "printCurrentPrinter"
#define kprintKeysStr "printKeys"
#define kprintKeysTypeStr "printKeysType"
#define kprintNotManaged "printNotManaged"
#define kprintOptionsStr "printOptions"
#define kprintPhotoshopManaged "photoshopManaged"
#define kprintPrintersList "printerList"
#define kprintPrinterManaged "printerManaged"
#define kprintResolutionStr "printerResolution"  // mscarafone 4/13/00
#define kprintSeparations "printSeparations"
#define kprintSettingsStr "printSettings"
#define kprintSizeStr "printSize"
#define kprintSizeUnitsStr "printSizeUnits"
#define kprintStr "print"
#define kprintToFitStr "printToFit" // mscarafone 4/19/00
#define kprintingInksSetupStr "printingInksSetup"
#define kprocessSerialNumberStr "processSerialNumber"
#define kprofileMismatchStr "profileMismatch"
#define kprofileSetupStr "profileSetup"
#define kprofileStr "profile"
#define kprofileToProfileStr "profileToProfile"
#define kprojectionStr "projection"
#define kproofBlackStr "proofBlack"
#define kproofCMYKStr "proofCMYK"
#define kproofCMYStr "proofCMY"
#define kproofCustomStr "proofCustom"
#define kproofCyanStr "proofCyan"
#define kproofDeuteranopiaStr	"proofDeuteranopia"
#define kproofInkBlackStr "proofInkBlack"
#define kproofMacintoshStr "proofMacintosh"
#define kproofMagentaStr "proofMagenta"
#define kproofMonitorStr "proofMonitor"
#define kproofPaperWhiteStr "proofPaperWhite"
#define kproofProtanopiaStr	"proofProtanopia"
#define kproofSetupStr "proofSetup"
#define kproofWindowsStr "proofWindows"
#define kproofYellowStr "proofYellow"
#define kpropertyStr "property"
#define kproportionalLiningStr "proportionalLining"
#define kproportionalMetricsStr "proportionalMetrics"
#define kproportionalNumbersStr "proportionalNumbers"
#define kproportionalOldStyleStr "proportionalOldStyle"
#define kproportionalWidthFormStr "proportionalWidthForm"
#define kprotectTextureStr "protectTexture"
#define kprotectTextureLockStr "protectTextureLock"
#define kprovinceStateStr "provinceState"
#define kpublicDomainStr "publicDomain"
#define kpurgeItemStr "purgeItem"
#define kpurgeStr "purge"
#define kpurityStr "purity"
#define kpurpleStr "purple"
#define kpushInStr "pushIn"
#define kpushOutFirstStr "pushOutFirst"
#define kpushOutStr "pushOut"
#define kpushDownStr "pushDown"
#define kpushRightStr "pushRight"
#define kKinsokuNone "None"
#define kKinsokuHard "Hard"
#define kKinsokuSoft "Soft"
#define kpyramidsStr "pyramids"
#define kquadCenterStateStr "quadCenterState"
#define kquadCorner0Str "quadCorner0"
#define kquadCorner1Str "quadCorner1"
#define kquadCorner2Str "quadCorner2"
#define kquadCorner3Str "quadCorner3"
#define kquadrilateralStr "quadrilateral"
#define kquadtoneStr "quadtone"
#define kqualityStr "quality"
#define kquarterWidthFormStr "quarterWidthForm"
#define kqueryAlwaysStr "queryAlways"
#define kqueryAskStr "queryAsk"
#define kqueryNeverStr "queryNever"
#define kqueryStateStr "queryState"
#define kquickFixStr "quickFix"
#define kquickMaskStr "quickMask"
#if qQuickSelection
#define kquickSelectAutoEnhanceStr "autoEnhance"
#define kquickSelectBrushSizeStr "quickSelectBrushSize"
#define kquickSelectSampleAllLayersStr "quickSelectSampleAllLayers"
#define kquickSelectModeStr "quickSelectMode"
#define kquickSelectSpreadStr "quickSelectSpread"
#define kquickSelectStickinessStr "quickSelectStickiness"
#define kquickSelectToolStr "quickSelectTool"
#endif
#define kquitStr "quit"
#define kradialBlurStr "radialBlur"
#define kradialStr "radial"
#define kradialDistortStr "radialDistort"
#define kradiusStr "radius"
#define krainbowEffectStr "rainbowEffect"
#define krandomSeedStr "randomSeed"
#define krandomStr "random"
#define krangeStr "range"
#define krasterizeAllStr "rasterizeAll"
#define krasterizeContentStr "rasterizeContent"
#define krasterizeImageStackStr	"rasterizeImageStack"
#define krasterizeItemStr "rasterizeItem"
#define krasterizeLayerStr "rasterizeLayer"
#define krasterizeLinkedStr "rasterizeLinked"
#define krasterizePlacedStr "rasterizePlaced"
#define krasterizeShapeStr "rasterizeShape"
#define krasterizeStr "rasterize"
#define krasterizeTypeLayerStr "rasterizeTypeLayer"
#define krasterizeVectorMaskStr "rasterizeVectorMask"
#define krasterizeVideoStr "rasterizeVideo"
#define kratioStr "ratio"
#define krationalStr "rational"
#define krationalPointStr "rationalPoint"
#define krawDataStr "rawData"
#define krawFormatStr "rawFormat"
#define krecaptureStr "recapture"
#define krecentFilesStr "recentFiles"
#define krecordStr	"record"
#define krecordMeasurementsStr "recordMeasurements"
#define krect16Str "rect16"
#define krectStr "rect"
#define krectToPolarStr "rectToPolar"
#define krectangleStr "rectangle"
#define krectangleToolStr "rectangleTool"
#define kredBlackPointStr "redBlackPoint"
#define kredEyeToolStr "redEyeTool"
#define kredFloatStr	"redFloat"
#define kredGammaStr "redGamma"
#define kredEyeToolStr "redEyeTool"
#define kredStr "red"
#define kredWhitePointStr "redWhitePoint"
#define kredXStr "redX"
#define kredYStr "redY"
#define kredoStr "redo"
#define kredoTypeStr "redoType"
#define kredrawCompleteStr "redrawComplete"
#define kredsStr "reds"
#define krefineEdgeChokeStr "refineEdgeChoke"
#define krefineEdgeContrastStr "refineEdgeBorderContrast"
#define krefineEdgeFeatherRadiusStr "refineEdgeFeatherRadius"
#define krefineEdgeSmoothStr "refineEdgeSmooth"
#define krefineEdgeRadiusStr "refineEdgeBorderRadius"
#define krefineSelectionEdgeStr "refineSelectionEdge"
#define kreflectedStr "reflected"
#define kregionCodeStr "regionCode"
#define kregistrationMarksStr "registrationMarks"
#define krelativeStr "relative"
#define kreliefStr "relief"
#define kreloadFrameStr "reloadFrame"
#define kremoveBlackMatteStr "removeBlackMatte"
#define kremoveFromSelectionStr "removeFromSelection"
#define kremoveJPEGArtifactStr "removeJPEGArtifact"
#define kremoveLayerMaskStr "removeLayerMask"
#define kremoveWhiteMatteStr "removeWhiteMatte"
#define krenameStr "rename"
#define krenderFidelityStr "renderFidelity"
#define krenderSceneReferredStr	"renderSceneReferred"
#define krepeatEdgePixelsStr "repeatEdgePixels"
#define krepeatStr "repeat"
#define krepeatLockStr "repeatLock"
#define kreplaceColorStr "replaceColor"
#define kreplaceExistingStr "replaceExisting"
#define kreplaceFootageStr "replaceFootage"
#define kreplaceStr "replace"
#define kreplaceSubstitutesStr "replaceSubstitutes"
#define kresampleStr "resample"
#define kresetFromCompStr "resetFromComp"
#define kresetPalettesStr "resetPalettes"
#define kresetMenusStr "resetMenus"
#define kresetShortcutsStr "resetShortcuts"
#define kresetScaleFactorStr "resetScaleFactor"
#define kresetStr "reset"
#define kresetDocumentFormatStr "resetDocumentFormatStr"
#define kresizeStr "resize"
#define kresizePastePlace	"resizePastePlace"
#define kresizeWindowsOnZoomStr "resizeWindowsOnZoom"
#define kresolutionStr "resolution"
#define kresourceIDStr "resourceID"
#define kresponseStr "response"
#define krestoreAllFramesStr "restoreAllFrames"
#define krestoreFrameStr "restoreFrame"
#define kretainHeaderStr "retainHeader"
#define kreticulationStr "reticulation"
#define kreturnIDAttrStr "returnIDAttr"
#define krevealAllStr "revealAll"
#define krevealCurrentPathStr "revealCurrentPath"
#define krevealSelectionStr "revealSelection"
#define kreverseStr "reverse"
#define krevertStr "revert"
#define krightAkiStr "rightAki"
#define krightStr "right"
#define krightsUsageStr "rightsUsage"
#define krippleMagnitudeStr "rippleMagnitude"
#define krippleSizeStr "rippleSize"
#define krippleStr "ripple"
#define krolloverStr "rollover"
#define kromanRotationInVerticalStr "romanRotationInVertical"
#define kromanStr "roman"
#define kromanianLanguageStr "romanianLanguage"
#define krotateAllStr "rotateAll"
#define krotateEventEnumStr "rotateEventEnum"
#define krotateStr "rotate"
#define krotatedStr "rotated"
#define krotateToolStr "rotateTool"
#define krotoscopingPreferencesStr "rotoscopingPreferences"
#define kroughPastelsStr "roughPastels"
#define kroundCapStr "roundCap"
#define kroundJoinStr "roundJoin"
#define kroundStr "round"
#define kroundedRectangleToolStr "roundedRectangleTool"
#define kroundnessDynamicsStr "roundnessDynamics"
#define kroundnessStr "roundness"
#define krowCountStr "rowCount"
#define krowGutterStr "rowGutter"
#define krowMajorOrderStr "rowMajorOrder"
#define krubyStr "ruby"
#define krulerCmStr "rulerCm"
#define krulerInchesStr "rulerInches"
#define krulerMmStr "rulerMm"
#define krulerOriginHStr "rulerOriginH"
#define krulerOriginVStr "rulerOriginV"
#define krulerPercentStr "rulerPercent"
#define krulerPicasStr "rulerPicas"
#define krulerPixelsStr "rulerPixels"
#define krulerPointsStr "rulerPoints"
#define krulerToolStr "rulerTool"
#define krulerUnitsStr "rulerUnits"
#define krumanianLanguageStr "rumanianLanguage"
#define krussianLanguageStr "russianLanguage"
#define ksInt16Str "sInt16"
#define ksInt32Str "sInt32"
#define ksInt64Str "sInt64"
#define ksMFloatStr "sMFloat"
#define ksMIntStr "sMInt"
#define ksRGBStr "sRGB"
#define ksample3x3Str "sample3x3"
#define ksample5x5Str "sample5x5"
#define ksamplePointStr "samplePoint"
#define ksampledBlurStr	"shapeBlur"
#define ksampledBrushStr "sampledBrush"
#define ksampledDataStr "sampledData"
#define ksaturateStr "saturate"
#define ksaturationStr "saturation"
#define ksaturationToolStr "saturationTool"
#define ksaveAndCloseStr "saveAndClose"
#define ksaveCompositeStr "saveComposite"
#define ksaveForWebStr "saveForWeb"
#define ksaveHistoryToStr "saveHistoryTo"
#define ksaveHistoryToTypeStr "saveHistoryToType"
#define ksavePaletteLocationsStr "savePaletteLocations"
#define ksavePathsStr "savePaths"
#define ksavePyramidsStr "savePyramids"
#define ksaveStr "save"
#define ksaveTransparencyStr "saveTransparency"
#define ksaveWorkspaceStr "saveWorkspace"
#define ksavedStr "saved"
#define ksavingFilesPreferencesStr "savingFilesPreferences"
#define ksavingStr "saving"
#define kscaleEffectsEventStr "scaleEffectsEvent"
#define kscaleEffectsStr "scaleEffects"
#define kscaleHorizontalStr "scaleHorizontal"
#define kscaleKeyframesStr "scaleKeyframes"
#define kscaleStr "scale"
#define kscaleStylesStr "scaleStyles"
#define kscaleVerticalStr "scaleVertical"
#define kscalingStr "scaling"
#define kscansStr "scans"
#define kscatterDynamicsStr "scatterDynamics"
#define kscatterDynamicsLockStr "scatterDynamicsLock"
#define kscatterStr "scatter"
#define ksceneCollageStr "sceneCollage"
#define kscitexCTFormatStr "scitexCTFormat"
#define kscratchDisksStr "scratchDisks"
#define kscreenCircleStr "screenCircle"
#define kscreenDotStr "screenDot"
#define kscreenFileStr "screenFile"
#define kscreenLineStr "screenLine"
#define kscreenModeStr "screenMode"
#define kscreenModeFullScreen "screenModeFullScreen"
#define kscreenModeFullScreenWithMenubar "screenModeFullScreenWithMenubar"
#define kscreenModeStandard "screenModeStandard"
#define kscreenStr "screen"
#define kscreenTypeStr "screenType"
#define ksecondsStr "seconds"
#define ksectionHStr "sectionH"
#define kselectStr "select"
#define kselectedAreasStr "selectedAreas"
#define kselectedItemsStr	"selectedItems"
#define kselectedLayerStr "selectedLayer"
#define kselectedMeasurementsStr "selectedMeasurements"
#define kselectedSourceAreasStr "selectedSourceAreas"
#define kselectionBrushToolStr "selectionBrushTool"
#define kselectionClassStr "selectionClass"
#define kselectionEnumStr "selectionEnum"
#define kselectionModeStr "selectionMode"
#define kselectionModifierStr "selectionModifier"
#define kselectionModifierTypeStr "selectionModifierType"
#define kselectionOrderStr "selectionOrder"
#define kselectionStr "selection"
#define kselectiveColorStr "selectiveColor"
#define kselectiveStr "selective"
#define kselectKeyframeStr "selectKeyframe"
#define kselectLinkedLayersStr "selectLinkedLayers"
#define kseparationSetupStr "separationSetup"
#define kseparationTablesStr "separationTables"
#define kseparationsStr "separations"
#define ksequenceStr "sequence"
#define kserbianLanguageStr "serbianLanguage"
#define kserialStringStr "serialString"
#define ksessionIDStr "sessionID"
#define ksessionStr "session"
#define ksetStr "set"
#define ksetCurrentTimeStr "setCurrentTime"
#define kshadeStr "shade"
#define kshadingIntensityStr "shadingIntensity"
#define kshadingNoiseStr "shadingNoise"
#define kshadingShapeStr "shadingShape"
#define kshadowColorStr "shadowColor"
#define kshadowIntensityStr "shadowIntensity"
#define kshadowLevelsStr "shadowLevels"
#define kshadowModeStr "shadowMode"
#define kshadowOpacityStr "shadowOpacity"
#define kshadowsStr "shadows"
#define kshallowStr "shallow"
#define kshapeClassStr "shapeClass"
#define kshapeOperationStr "shapeOperation"
#define kshapeStr "shape"
#define kshapeburstStr "shapeburst"
#define kshareMyScreenStr "shareMyScreen"
#define ksharpenEdgesStr "sharpenEdges"
#define ksharpenMoreStr "sharpenMore"
#define ksharpenStr "sharpen"
#define ksharpenToolStr "sharpenTool"
#define ksharpnessStr "sharpness"
#define kshearEdStr "shearEd"
#define kshearPointsStr "shearPoints"
#define kshearStStr "shearSt"
#define kshearStr "shear"
#define ksheetStyleStr "sheetStyle"
#define kshiftKeyStr "shiftKey"
#define kshiftKeyToolSwitchStr "shiftKeyToolSwitch"
#define kshortFloatStr "shortFloat"
#define kshortIntegerStr "shortInteger"
#define kshortLinesStr "shortLines"
#define kshortNamesStr "shortNames"
#define kshortStrokesStr "shortStrokes"
#define kshowAllStr "showAll"
#define kshowBBoxStr "showBBox" // mscarafone 4/19/00
#define kshowCJKFeaturesStr "showCJKFeatures"
#define kshowComboFXPaletteStr "showComboFXPalette"
#define kshowDirectoriesStr "showDirectories"
#define kshowEffectsPaletteStr "showEffectsPalette"
#define kshowEnglishFontNamesStr "showEnglishFontNames"
#define kshowFileBrowserPaletteStr "showFileBrowserPalette"
#define kshowFiltersPaletteStr "showFiltersPalette"
#define kshowHelpPaletteStr "showHelpPalette"
#define kshowHideOptionsStr "showHideOptions"
#define kshowHistogramPaletteStr "showHistogramPalette"
#define kshowHistoryPaletteStr "showHistoryPalette"
#define kshowInfoPaletteStr "showInfoPalette"
#define kshowLayersPaletteStr "showLayersPalette"
#define kshowMenuColorsStr "showMenuColors"
#define kshowMoreOptionsStr "showMoreOptions" //mscarafone 4/19/00
#define kshowNavigatorPaletteStr "showNavigatorPalette"
#define kshowNoneStr "showNone"
#define kshowPaletteBinStr "showPaletteBin"
#define kshowQuickStartPaletteStr "showQuickStartPalette"
#define kshowRecipesPaletteStr "showRecipesPalette"
#define kshowSearchPaletteStr "showSearchPalette"
#define kshowSliceNumbersStr "showSliceNumbers"
#define kshowStr "show"
#define kshowStylesPaletteStr "showStylesPalette"
#define kshowSwatchesPaletteStr "showSwatchesPalette"
#define kshowToolTipsStr "showToolTips"
#define kshowTransparencyStr "showTransparency"
#define ksidesStr "sides"
#define ksimilarStr "similar"
#define ksimplifyLayerStr "simplifyLayer"
#define ksingle72ColorStr "single72Color"
#define ksingle72GrayStr "single72Gray"
#define ksingleColumnStr "singleColumn"
#define ksingleNoCompositePSStr "singleNoCompositePS"
#define ksingleRowStr "singleRow"
#define ksingleWordJustificationStr "singleWordJustification"
#define ksizeStr "size"
#define ksizeSelectorStr "sizeSelector"
#define kskewEffectStr "skewEffect"
#define kskewStr "skew"
#define kskinToneStr "skinTone"
#define ksliceBGColor "sliceBackgroundColor"
#define ksliceBGTypeStr "sliceBackgroundType"
#define ksliceColorStr "sliceColor"
#define ksliceFromLayerStr "sliceFromLayer"
#define ksliceImageTypeStr "sliceImageType"
#define ksliceSelectToolStr "sliceSelectTool"
#define ksliceStr "slice"
#define ksliceToolStr "sliceTool"
#define ksliceTypeStr "sliceType"
#define kslicesAcrossStr "slicesAcross"
#define kslicesDownStr "slicesDown"
#define kslopeLimitMatteStr "slopeLimitMatte"
#define kslotStr "slot"
#define kslovakLanguageStr "slovakLanguage"
#define kslovenianLanguageStr "slovenianLanguage"
#define ksmallCapsStr "smallCaps"
#define ksmallStr "small"
#define ksmartBlurModeEdgeOnlyStr "smartBlurModeEdgeOnly"
#define ksmartBlurModeNormalStr "smartBlurModeNormal"
#define ksmartBlurModeOverlayEdgeStr "smartBlurModeOverlayEdge"
#define ksmartBlurModeStr "smartBlurMode"
#define ksmartBlurQualityHighStr "smartBlurQualityHigh"
#define ksmartBlurQualityLowStr "smartBlurQualityLow"
#define ksmartBlurQualityMediumStr "smartBlurQualityMedium"
#define ksmartBlurQualityStr "smartBlurQuality"
#define ksmartBlurStr "smartBlur"
#define ksmartFilterEnableAllStr "smartFilterEnableAll"
#define ksmartGuidesColorStr "smartGuidesColor"
#define ksmartGuidesCustomColorStr "smartGuidesCustomColor"
#define ksmartObjectStr "smartObject"
#define ksmartQuotesStr "smartQuotes"
#define ksmartSharpenPresetsStr "smartSharpenPresets"
#define ksmartSharpenStr "smartSharpen"
#define ksmoothCornersStr "smoothCorners"
#define ksmoothIndentsStr "smoothIndents"
#define ksmoothStr "smooth"
#define ksmoothingStr "smoothing"
#define ksmoothingLockStr "smoothingLock"
#define ksmoothnessStr "smoothness"
#define ksmudgeStickStr "smudgeStick"
#define ksmudgeToolStr "smudgeTool"
#define ksnapAllStr "snapAll"
#define ksnapNoneStr "snapNone"
#define ksnapStr "snap"
#define ksnapToDocBoundsStr "snapToDocBounds"
#define ksnapToGridStr "snapToGrid"
#define ksnapToGuidesStr "snapToGuides"
#define ksnapToLayerBoundsStr "snapToLayerBounds"
#define ksnapToSlicesStr "snapToSlices"
#define ksnapshotClassStr "snapshotClass"
#define ksnapshotEnumStr "snapshotEnum"
#define ksnapshotInitialStr "snapshotInitial"
#define ksoftLightStr "softLight"
#define ksoftMatteStr "softMatte"
#define ksoftnessStr "softness"
#define ksolarizeStr "solarize"
#define ksolidStr "solid"
#define ksolidColorLayerStr "solidColorLayer"
#define ksolidColorStr "solidColor"
#define ksolidFillStr "solidFill"
#define ksoundAnnotToolStr "soundAnnotTool"
#define ksource2Str "source2"
#define ksourceFolderStr "sourceFolder"
#define ksourceImportStr "sourceImport"
#define ksourceModeStr "sourceMode"
#define ksourceModeTypeStr "sourceModeType"
#define ksourceOpenFilesStr "sourceOpenFiles"
#define ksourceStr "source"
#define kspaceAfterStr "spaceAfter"
#define kspaceBeforeStr "spaceBefore"
#define kspaceStr "space"
#define kspacingStr "spacing"
#define kspanishLanguageStr "spanishLanguage"
#define kspatterStr "spatter"
#define kspecialInstructionsStr "specialInstructions"
#define kspectrumStr "spectrum"
#define kspellCheckStr "spellCheck"
#define ksphericalStr "spherical"
#define kspherizeModeStr "spherizeMode"
#define kspherizeStr "spherize"
#define kspinStr "spin"
#define ksplitChannelsStr "splitChannels"
#define ksplitHorizontalInStr "splitHorizontalIn"
#define ksplitHorizontalOutStr "splitHorizontalOut"
#define ksplitVerticalInStr "splitVerticalIn"
#define ksplitVerticalOutStr "splitVerticalOut"
#define ksplitVideoLayerStr "splitVideoLayer"
#define kspongeStr "sponge"
#define kspotColorChannelStr "spotColorChannel"
#define kspotColorStr "spotColor"
#define kspotHealingBrushToolStr "spotHealingBrushTool"
#define kspotStr "spot"
#define ksprayRadiusStr "sprayRadius"
#define ksprayedStrokesStr "sprayedStrokes"
#define ksquareCapStr "squareCap"
#define ksquareSizeStr "squareSize"
#define ksquareScaleFactorStr "squareScaleFactor"
#define ksquareStr "square"
#define ksrcBlackMaxStr "srcBlackMax"
#define ksrcBlackMinStr "srcBlackMin"
#define ksrcWhiteMaxStr "srcWhiteMax"
#define ksrcWhiteMinStr "srcWhiteMin"
#define kstackWithOriginal "stackWithOriginal"
#define kstaggerStr "stagger"
#define kstainedGlassStr "stainedGlass"
#define kstairStepEffectStr "stairStepEffect"
#define kstampInStr "stampIn"
#define kstampOutStr "stampOut"
#define kstampStr "stamp"
#define kstandardDeviationsStr "standardDeviations"
#define kstandardFrenchLanguageStr "standardFrenchLanguage"
#define kstandardGermanLanguageStr "standardGermanLanguage"
#define kgermanLanguageReformed1996Str "germanLanguageReformed1996"
#define koldGermanLanguageStr "oldGermanLanguage"

#define kstandardPortugueseLanguageStr "standardPortugueseLanguage"
#define kstandardStr "standard"
#define kstarStr "star"
#define kstartArrowheadStr "startArrowhead"
#define kstartFrameNumberStr "startFrameNumber"
#define kstartIndentStr "startIndent"
#define kstartStr "start"
#define kstartTimeStr "startTime"
#define kstateStr "state"
#define kstdAStr "stdA"
#define kstdBStr "stdB"
#define kstdCStr "stdC"
#define kstdEStr "stdE"
#define kstdTrackIDStr "stdTrackID"
#define kstepByStepStr "stepByStep"
#define kstopStr "stop"
#define kstraightStr "straight"
#define kstrengthPluginStr "strengthPlugin"
#define kstrengthRatioStr "strengthRatio"
#define kstrengthStr "strength"
#define kstretchToFitStr "stretchToFit"
#define kstrikethroughOffStr "strikethroughOff"
#define kstrikethroughStr "strikethrough"
#define kstringChannelStr "stringChannel"
#define kstringClassFormatStr "stringClassFormat"
#define kstringCompensationStr "stringCompensation"
#define kstringFSSStr "stringFSS"
#define kstringIntegerStr "stringInteger"
#define kstrokeColorStr "strokeColor"
#define kstrokeDetailStr "strokeDetail"
#define kstrokeDirHorizontalStr "strokeDirHorizontal"
#define kstrokeDirLeftDiagStr "strokeDirLeftDiag"
#define kstrokeDirRightDiagStr "strokeDirRightDiag"
#define kstrokeDirVerticalStr "strokeDirVertical"
#define kstrokeDirectionStr "strokeDirection"
#define kstrokeDirectionTypeStr "strokeDirectionType"
#define kstrokeEmbossStr "strokeEmboss"
#define kstrokeLengthStr "strokeLength"
#define kstrokeLocationStr "strokeLocation"
#define kstrokeOverPrintStr "strokeOverPrint"
#define kstrokePressureStr "strokePressure"
#define kstrokeSizeStr "strokeSize"
#define kstrokeStr "stroke"
#define kstrokeWidthStr "strokeWidth"
#define kstrokebehaviorStr "strokebehavior"
#define kstyleBrushStr "styleBrush"
#define kstyleClassStr "styleClass"
#define kstylePresetStr "stylePreset"
#define kstyleStr "style"
#define kstylesAppendStr "stylesAppend"
#define kstylesDeleteStr "stylesDelete"
#define kstylesDetailViewStr	"stylesDetailView"
#define kstylesLoadStr "stylesLoad"
#define kstylesNewStr "stylesNew"
#define kstylesResetStr "stylesReset"
#define kstylesSaveStr "stylesSave"
#define kstylesSmallTextViewStr	"stylesSmallTextView"
#define kstylesSmallThumbnailViewStr	"stylesSmallThumbnailView"
#define kstylesStr "styles"
#define kstylesTextThumbnailViewStr	"stylesTextThumbnailView"
#define kstylesTextViewStr	"stylesTextView"
#define kstylesThumbnailViewStr	"stylesThumbnailView"
#define kstylisticAlternatesStr "stylisticAlternates"
#define kstylusIsColorStr "stylusIsColor"
#define kstylusIsOpacityStr "stylusIsOpacity"
#define kstylusIsPressureStr "stylusIsPressure"
#define kstylusIsSizeStr "stylusIsSize"
#define ksubScriptStr "subScript"
#define ksubpathListKeyStr "subpathListKey"
#define ksubpathStr "subpath"
#define ksubpathsListStr "subpathsList"
#define ksubsampleStr "subsample"
#define ksubstitutesUsedStr "substitutesUsed"
#define ksubtractFilterMaskFromSelectionStr "subtractFilterMaskFromSelection"
#define ksubtractFromStr "subtractFrom"
#define ksubtractStr "subtract"
#define ksubtractUserMaskFromSelectionStr "subtractUserMaskFromSelection"
#define ksubtractVectorMaskFromSelectionStr "subtractVectorMaskFromSelection"
#define ksuffixStr "suffix"
#define ksumieStr "sumie"
#define ksuperScriptStr "superScript"
#define ksupplementalCategoriesStr "supplementalCategories"
#define ksuppressOpenOptionsStr "suppressOpenOptions"
#define ksuppressWarningsStr "suppressWarnings"
#define kswashStr "swash"
#define kswatchExchangeFile "swatchExchangeFile"
#define kswatchesAppendStr "swatchesAppend"
#define kswatchesNewStr "swatchesNew"
#define kswatchesReplaceStr "swatchesReplace"
#define kswatchesResetStr "swatchesReset"
#define kswatchesSaveStr "swatchesSave"
#define kswatchesTextThumbnailViewStr "swatchesTextThumbnailView"
#define kswatchesThumbnailViewStr "swatchesThumbnailView"
#define kswatchesLargeThumbnailViewStr "swatchesLargeThumbnailView"
#define kswatchesLargeListViewStr "swatchesLargeListView"
#define kswedishLanguageStr "swedishLanguage"
#define kswissGermanLanguageStr "swissGermanLanguage"
#define kswissGermanLanguageOldRulesStr "swissGermanLanguageOldRules"

#define ksyntheticBoldStr "syntheticBold"
#define ksyntheticItalicStr "syntheticItalic"
#define ksyntheticStyleStr "syntheticStyle"
#define ksystemCallStr "systemCall"
#define ksystemCMYKStr "systemCMYK"
#define ksystemGrayStr "systemGray"
#define ksystemInfoStr "systemInfo"
#define ksystemMetricsStr "systemMetrics"
#define ksystemPaletteStr "systemPalette"
#define ksystemPickerStr "systemPicker"
#define ksystemRGBStr "systemRGB"
#define ktRangeStr "tRange"
#define ktabStopsStr "tabStops"
#define ktablesStr "tables"
#define ktabularLiningStr "tabularLining"
#define ktabularOldStyleStr "tabularOldStyle"
#define ktakeMergedSnapshotStr "takeMergedSnapshot"
#define ktakeSnapshotStr "takeSnapshot"
#define ktargaFormatStr "targaFormat"
#define ktargetChannels "targetChannels"
#define ktargetEnumStr "targetEnum"
#define ktargetIDStr "targetID"
#define ktargetLayers "targetLayers"
#define ktargetPathIndexStr "targetPathIndex"
#define ktargetPathStr "targetPath"
#define ktargetStr "target"
#define ktcyLeftRightStr "tcyLeftRight"
#define ktcyUpDownStr "tcyUpDown"
#define ktemplateStr "template"
#define ktexTypeBlocksStr "texTypeBlocks"
#define ktexTypeBrickStr "texTypeBrick"
#define ktexTypeBurlapStr "texTypeBurlap"
#define ktexTypeCanvasStr "texTypeCanvas"
#define ktexTypeFrostedStr "texTypeFrosted"
#define ktexTypeSandstoneStr "texTypeSandstone"
#define ktexTypeTinyLensStr "texTypeTinyLens"
#define ktextAllCapsStr "textAllCaps"
#define ktextAnnotToolStr "textAnnotTool"
#define ktextBurasagariStr "textBurasagari"
#define ktextClickPointStr "textClickPoint"
#define ktextDataStr "textData"
#define ktextEveryLineComposerStr "textEveryLineComposer"
#define ktextFauxBoldStr "textFauxBold"
#define ktextFauxItalicStr "textFauxItalic"
#define ktextFileStr "textFile"
#define ktextFractionalWidthsStr "textFractionalWidths"
#define ktextGriddingStr "textGridding"
#define ktextHyphenationStr "textHyphenation"
#define ktextJustificationStr "textJustification"
#define ktextKeyStr "textKey"
#define ktextLanguageStr "textLanguage"
#define ktextLayerStr "textLayer"
#define ktextLigaturesStr "textLigatures"
#define ktextNewTextMode "textNewTextMode"
#define ktextNewTextOrientation "textNewTextOrientation"
#define ktextNoBreakStr "textNoBreak"
#define ktextOidashiStr "textOidashi"
#define ktextOikomiStr "textOikomi"
#define ktextOldStyleStr "textOldStyle"
#define ktextOrientationStr "textOrientation"
#define ktextParagraphStr "textParagraph"
#define ktextRotateHankakuStr "textRotateHankaku"
#define ktextShapeStr "textShape"
#define ktextSingleLineComposerStr "textSingleLineComposer"
#define ktextSmallCapsStr "textSmallCaps"
#define ktextStr "text"
#define ktextStrikethroughStr "textStrikethrough"
#define ktextStyleRangeStr "textStyleRange"
#define ktextStyleStr "textStyle"
#define ktextSubscriptStr "textSubscript"
#define ktextSuperscriptStr "textSuperscript"
#define ktextTValueStr "textTValue"
#define ktextTateChuuYokoStr "textTateChuuYoko"
#define ktextToolCharacterOptions "textToolCharacterOptions"
#define ktextToolOptions "textToolOptions"
#define ktextToolParagraphOptions "textToolParagraphOptions"
#define ktextTypeStr "textType"
#define ktextUnderlineStr "textUnderline"
#define ktextureBlendModeStr "textureBlendMode"
#define ktextureCoverageStr "textureCoverage"
#define ktextureDepthDynamicsStr "textureDepthDynamics"
#define ktextureDepthStr "textureDepth"
#define ktextureFileStr "textureFile"
#define ktextureFillStr "textureFill"
#define ktextureScaleStr "textureScale"
#define ktextureStr "texture"
#define ktextureTypeStr "textureType"
#define ktextureInteractionLockStr "textureInteractionLock"
#define ktexturizerStr "texturizer"
#define ktextWarpStr "textWarp"
#define kthirdWidthFormStr "thirdWidthForm"
#define kthreeDigitStr "threeDigit"
#define kthresholdClassEventStr "thresholdClassEvent"
#define kthresholdEnumStr "thresholdEnum"
#define kthresholdStr "threshold"
#define kthumbnailStr "thumbnail"
#define ktileNumberStr "tileNumber"
#define ktileOffsetStr "tileOffset"
#define ktilePluginStr "tilePlugin"
#define ktileSizeStr "tileSize"
#define ktileStr "tile"
#define ktilesStr "tiles"
#define ktileVerticallyStr	"tileVertically"
#define ktiltScaleStr "tiltScale"
#define ktimecodeStr "timecode"
#define ktimeDenominatorStr "timeDenominator"
#define ktimelinePanelKeyStr "timelinePanelKey"
#define ktimelineStr "timeline"
#define ktimelineDeleteKeyframesStr "timelineDeleteKeyframes"
#define ktimelineEnableShortcutKeysStr "timelineEnableShortcutKeys"
#define ktimelineKeyframeInterpolationLinearStr "timelineKeyframeInterpolationLinear"
#define ktimelineKeyframeInterpolationHoldStr "timelineKeyframeInterpolationHold"
#define ktimelineSelectAllKeyframesStr "timelineSelectAllKeyframes"
#define ktimelineSelectNoKeyframesStr "timelineSelectNoKeyframes"
#define ktimelineCopyKeyframesStr "timelineCopyKeyframes"
#define ktimelinePasteKeyframesStr "timelinePasteKeyframes"
#define ktimelineSetStartOfWorkAreaStr "timelineSetStartOfWorkArea"
#define ktimelineSetEndOfWorkAreaStr "timelineSetEndOfWorkArea"
#define ktimelineGoToTimeStr "timelineGoToTime"
#define ktimelineGoToNextFrameStr "timelineGoToNextFrame"
#define ktimelineGoToPreviousFrameStr "timelineGoToPreviousFrame"
#define ktimelineGoToFirstFrameStr "timelineGoToFirstFrame"
#define ktimelineGoToLastFrameStr "timelineGoToLastFrame"
#define ktimelineGoToWorkAreaStartStr "timelineGoToWorkAreaStart"
#define ktimelineGoToWorkAreaEndStr "timelineGoToWorkAreaEnd"
#define ktimelineAllowFrameSkippingStr "timelineAllowFrameSkipping"
#define ktimelineMoveLayerInPointStr "timelineMoveLayerInPoint"
#define ktimelineMoveLayerEndPointStr "timelineMoveLayerEndPoint"
#define ktimelineTrimLayerStartStr "timelineTrimLayerStart"
#define ktimelineTrimLayerEndStr "timelineTrimLayerEnd"
#define ktimelineTrimDocumentDurationStr "timelineTrimDocumentDuration"
#define ktimelineSplitLayerStr "timelineSplitLayer"
#define ktimelineLiftWorkAreaStr "timelineLiftWorkArea"
#define ktimelineExtractWorkAreaStr "timelineExtractWorkArea"
#define ktimelineMakeFramesFromLayersStr "timelineMakeFramesFromLayers"
#define ktimelineFlattenFramesIntoLayersStr "timelineFlattenFramesIntoLayers"
#define ktimelineEditTimelineCommentStr "timelineEditTimelineComment"
#define ktimelineDocumentSettingsStr "timelineDocumentSettings"
#define ktimelineConvertToFramesStr "timelineConvertToFrames"
#define ktimelineOnionSkinSettingsStr "timelineOnionSkinSettings"
#define ktimelineEnableOnionSkinsStr "timelineEnableOnionSkins"
#define ktimelineShowAllLayersStr "timelineShowAllLayers"
#define ktimelineShowFavoriteLayersStr "timelineShowFavoriteLayers"
#define ktimelineShowSetFavoriteLayersStr "timelineShowSetFavoriteLayers"
#define ktimelinePaletteOptionsStr "timelinePaletteOptions"
#define ktimeNumeratorStr "timeNumerator"
#define ktimeOffsetStr "timeOffset"
#define ktimeStringStr "timeString"
#define ktimeoutAttrStr "timeoutAttr"
#define ktintColorStr	"tintColor"
#define ktintFilterStr	"tintFilter"
#define ktitleStr "title"
#define ktitlingStr "titling"
#define ktoBuiltinStr "toBuiltin"
#define ktoLinkedStr "toLinked"
#define ktoModeStr "toMode"
#define ktoNextWholeSecond "toNextWholeSecond"
#define ktoPathBottomStr "toPathBottom"
#define ktoPathCenterStr "toPathCenter"
#define ktoPathTopStr "toPathTop"
#define ktoStr "to"
#define ktoggle3DPanelStr "toggle3DPanel"
#define ktoggle3DAxisStr "toggle3DAxis"
#define ktoggleActionsPaletteStr "toggleActionsPalette"
#define ktoggleAdjustmentPaletteStr "toggleAdjustmentPalette"
#define ktoggleAnimationPaletteStr "toggleAnimationPalette"
#define ktoggleAnnotationPaletteStr "toggleAnnotationPalette"
#define ktoggleAnnotsStr "toggleAnnots"
#define ktoggleAutoSlicesStr "toggleAutoSlices"
#define ktoggleBlackPreviewStr "toggleBlackPreview"
#define ktoggleBrushStylerPaletteStr "toggleBrushStylerPalette"
#define ktoggleBrushesExpandedViewStr "toggleBrushesExpandedView"
#define ktoggleBrushesPaletteStr "toggleBrushesPalette"
#define ktoggleCloneSourcePaletteStr "toggleCloneSourcePalette"
#define ktoggleCMYKPreviewStr "toggleCMYKPreview"
#define ktoggleCMYPreviewStr "toggleCMYPreview"
#define ktoggleChannelsPaletteStr "toggleChannelsPalette"
#define ktoggleCharacterPaletteStr "toggleCharacterPalette"
#define ktoggleColorPaletteStr "toggleColorPalette"
#define ktoggleComboFXPaletteStr "toggleComboFXPalette"
#define ktoggleCompsPaletteStr "toggleCompsPalette"
#define ktoggleControlCenterStr "toggleControlCenter"
#define ktoggleCountStr "toggleCount"
#define ktoggleCyanPreviewStr "toggleCyanPreview"
#define ktoggleEdgesStr "toggleEdges"
#define ktoggleEffectsPaletteStr "toggleEffectsPalette"
#define ktoggleFileBrowserPaletteStr "toggleFileBrowserPalette"
#define ktoggleFiltersPaletteStr "toggleFiltersPalette"
#define ktoggleGamutWarningStr "toggleGamutWarning"
#define ktoggleGridStr "toggleGrid"
#define ktoggleGuidesStr "toggleGuides"
#define ktoggleHintsPaletteStr "toggleHintsPalette"
#define ktoggleHistogramPaletteStr "toggleHistogramPalette"
#define ktoggleHistoryPaletteStr "toggleHistoryPalette"
#define ktoggleInfoPaletteStr "toggleInfoPalette"
#define ktoggleKeyframeSelectionStr "toggleKeyframeSelection"
#define ktoggleLayerMaskStr "toggleLayerMask"
#define ktoggleLayersPaletteStr "toggleLayersPalette"
#define ktoggleLockGuidesStr "toggleLockGuides"
#define ktoggleLockSlicesStr "toggleLockSlices"
#define ktoggleMagentaPreviewStr "toggleMagentaPreview"
#define ktoggleMaskPaletteStr "toggleMaskPalette"
#define ktoggleMeasurementLogPaletteStr "toggleMeasurementLogPalette"
#define ktoggleNavigatorPaletteStr "toggleNavigatorPalette"
#define ktoggleOptionsPaletteStr "toggleOptionsPalette"
#define ktoggleOthersStr "toggleOthers"
#define ktogglePalettesStr "togglePalettes"
#define ktoggleParagraphPaletteStr "toggleParagraphPalette"
#define ktogglePathsPaletteStr "togglePathsPalette"
#define ktogglePathsStr "togglePaths"
#define ktogglePixelGridStr "togglePixelGrid"
#define ktoggleProofColorsStr "toggleProofColors"
#define ktoggleProofVideoStr "toggleProofVideo"
#define ktoggleQuickMaskModeStr "toggleQuickMaskMode"
#define ktoggleQuickStartPaletteStr "toggleQuickStartPalette"
#define ktoggleRGBMacPreviewStr "toggleRGBMacPreview"
#define ktoggleRGBUncompensatedPreviewStr "toggleRGBUncompensatedPreview"
#define ktoggleRGBWindowsPreviewStr "toggleRGBWindowsPreview"
#define ktoggleRecipesPaletteStr "toggleRecipesPalette"
#define ktoggleRulersStr "toggleRulers"
#define ktoggleSearchPaletteStr "toggleSearchPalette"
#define ktoggleShortcutsPaletteStr "toggleShortcutsPalette"
#define ktoggleShowExtrasStr "toggleShowExtras"
#define ktoggleLayerEdgesStr "toggleLayerEdges"
#define ktoggleSlicesStr "toggleSlices"
#define ktoggleSmartGuidesStr "toggleSmartGuides"
#define ktoggleSnapToGridStr "toggleSnapToGrid"
#define ktoggleSnapToGuidesStr "toggleSnapToGuides"
#define ktoggleStatusBarStr "toggleStatusBar"
#define ktoggleStylesPaletteStr "toggleStylesPalette"
#define ktoggleSwatchesPaletteStr "toggleSwatchesPalette"
#define ktoggleTextLayerTypeStr "toggleTextLayerType"
#define ktoggleToolPresetsPaletteStr "toggleToolPresetsPalette"
#define ktoggleToolsPaletteStr "toggleToolsPalette"
#define ktoggleVectorMaskStr "toggleVectorMask"
#define ktoggleYellowPreviewStr "toggleYellowPreview"
#define ktoleranceStr "tolerance"
#define ktoolPresetStr "toolPreset"
#define ktoolRefineEdgeBorderContrastStr "toolRefineEdgeBorderContrast"
#define ktoolRefineEdgeBorderRadiusStr "toolRefineEdgeBorderRadius"
#define ktoolRefineEdgeChokeStr "toolRefineEdgeChoke"
#define ktoolRefineEdgeFeatherRadiusStr "toolRefineEdgeFeatherRadius"
#define ktoolRefineEdgePreviewModeStr "toolRefineEdgePreviewMode"
#define ktoolRefineEdgePreviewStateStr "toolRefineEdgePreviewState"
#define ktoolRefineEdgeSmoothStr "toolRefineEdgeSmooth"
#define ktoolStr "tool"
#define ktopLeftPixelColorStr "topLeftPixelColor"
#define ktopStr "top"
#define ktornEdgesStr "tornEdges"
#define ktotalLimitStr "totalLimit"
#define ktotalPagesStr	"totalPages"
#define ktraceContourStr "traceContour"
#define ktrackIDStr "trackID"
#define ktrackingStr "tracking"
#define ktraditionalFormStr "traditionalForm"
#define ktransactionIDAttrStr "transactionIDAttr"
#define ktransferFunctionStr "transferFunction"
#define ktransferPointStr "transferPoint"
#define ktransferSpecClassStr "transferSpecClass"
#define ktransferSpecStr "transferSpec"
#define ktransformStr "transform"
#define ktransitionStr "transition"
#define ktranslationStr "translation"
#define ktransparencyEnumStr "transparencyEnum"
#define ktransparencyGamutPreferencesStr "transparencyGamutPreferences"
#define ktransparencyGridColorsStr "transparencyGridColors"
#define ktransparencyGridColorsTypeStr "transparencyGridColorsType"
#define ktransparencyGridSizeStr "transparencyGridSize"
#define ktransparencyGridStr "transparencyGrid"
#define ktransparencyPrefsStr "transparencyPrefs"
#define ktransparencyShapeStr "transparencyShape"
#define ktransparencyShapesLayerStr "transparencyShapesLayer"
#define ktransparencyStopStr "transparencyStop"
#define ktransparencyStr "transparency"
#define ktransparentIndexStr "transparentIndex"
#define ktransparentStr "transparent"
#define ktransparentWhitesStr "transparentWhites"
#define ktrapStr "trap"
#define ktrimBasedOnStr "trimBasedOn"
#define ktrimStr "trim"
#define ktrimBoxStr "trimBox"
#define ktrimDocumentToWorkAreaStr "trimDocumentToWorkArea"
#define ktrinitronStr "trinitron"
#define ktritoneStr "tritone"
#define ktrueStr "true"
#define ktsumeStr "tsume"
#define kturkishLanguageStr "turkishLanguage"
#define ktutorialsStr "tutorials"
#define ktwirlStr "twirl"
#define ktwistStr "twist"
#define ktwoDigitStr "twoDigit"
#define ktxStr "tx"
#define ktyStr "ty"
#define ktypeClassModeOrClassModeStr "typeClassModeOrClassMode"
#define ktypeCreateMaskToolStr "typeCreateMaskTool"
#define ktypeCreateOrEditToolStr "typeCreateOrEditTool"
#define ktypeIDStr "typeID"
#define ktypeStr "type"
#define kTypeCanvasColorTypeStr "canvasColorType"
#define kTypeCanvasFrameStyleStr "canvasFrameStyle"
#define kTypeCanvasScreenModeStr	"canvasScreenMode"
#define ktypeUnitsStr "typeUnits"
#define ktypeVerticalCreateMaskToolStr "typeVerticalCreateMaskTool"
#define ktypeVerticalCreateOrEditToolStr "typeVerticalCreateOrEditTool"
#define ktypeFrameDisposeStr "typeFrameDispose"
#define kuIBitmapStr "uIBitmap"
#define kuICMYKStr "uICMYK"
#define kuIDuotoneStr "uIDuotone"
#define kuIGrayscaleStr "uIGrayscale"
#define kuIIndexedStr "uIIndexed"
#define kuILabStr "uILab"
#define kuIMultichannelStr "uIMultichannel"
#define kuIRGBStr "uIRGB"
#define kuInt32Str "uInt32"
#define kukenglishLanguageStr "ukenglishLanguage"
#define kukrainianLanguageStr "ukranianLanguage"
#define kuncoverDownStr "uncoverDown"
#define kuncoverRightStr "uncoverRight"
#define kundefinedAreaStr "undefinedArea"
#define kunderlineOffStr "underlineOff"
#define kunderlineOffsetStr "underlineOffset"
#define kunderlineOnLeftInVerticalStr "underlineOnLeftInVertical"
#define kunderlineOnRightInVerticalStr "underlineOnRightInVertical"
#define kunderlineStr "underline"
#define kunderpaintingStr "underpainting"
#define kunderscoreStr "underscore"
#define kundoEnumStr "undoEnum"
#define kundoEventStr "undoEvent"
#define kungroupStr "ungroup"
#define kuniformDistributionStr "uniformDistribution"
#define kuniformStr "uniform"
#define kunitsPrefsStr "unitsPrefs"
#define kunitsRulersPreferencesStr "unitsRulersPreferences"
#define kunitTestStr "unitTest"
#define kunixStr "unix"
#define kunlinkStr "unlink"
#define kunlinkSelectedLayersStr "unlinkSelectedLayers"
#define kunmarkedStr "unmarked"
#define kunsharpMaskStr "unsharpMask"
#define kunspecifiedColorStr "unspecifiedColor"
#define kuntitledStr "untitled"
#define kuOrderStr "uOrder"
#define kupdateStr "update"
#define kupdateLayoutsStr "updateLayouts"
#define kupdatePlacedLayerStr	"updatePlacedLayer"
#define kupperCaseExtensionStr "upperCaseExtension"
#define kupperCaseSerialStr "upperCaseSerial"
#define kupperCaseStr "upperCase"
#define kupperStr "upper"
#define kupperYStr "upperY"
#define kurgencyStr "urgency"
#define kuseAccurateScreensStr "useAccurateScreens"
#define kuseAdditionalPluginsStr "useAdditionalPlugins"
#define kuseAppearanceStr "useAppearance"
#define kuseBrushGroupStr "useBrushGroup"
#define kuseCacheForHistogramsStr "useCacheForHistograms"
#define kuseColorDynamicsStr "useColorDynamics"
#define kuseCurvesStr "useCurves"
#define kuseDefaultStr "useDefault"
#define kuseDualBrushStr "useDualBrush"
#define kuseFieldStr "useField"
#define kuseFirstColumnStr "useFirstColumn"
#define kuseGlobalAngleStr "useGlobalAngle"
#define	kuseGrayscaleToolbarIconStr "useGrayscaleToolbarIcon"
#define kuseICCProfileStr "useICCProfile"
#define kuseLegacyStr "useLegacy"
#define kuseMaskStr "useMask"
#define kusePaintDynamicsStr "usePaintDynamics"
#define kusePositionStr	"usePosition"
#define kuseScatterStr "useScatter"
#define kuseShapeStr "useShape"
#define kuseTabletTabGroupAppearanceStr "useTabletTabGroupAppearance"
#define kuseTextOutlinesStr "useTextOutlines"
#define kuseTextureStr "useTexture"
#define kuseTipDynamicsStr "useTipDynamics"
#define kuseTintStr "useTint"
#define kuseVisibilityStr "useVisibility"
#define kuserDefinedStr	"userDefined"
#define kuserMaskDensityStr "userMaskDensity"
#define kuserMaskFeatherStr "userMaskFeather"
#define kvectorMaskClassStr "vectorMaskClass"
#define kvectorMaskDensityStr "vectorMaskDensity"
#define kvectorMaskFeatherStr "vectorMaskFeather"
#define kvibranceStr "vibrance"
#define kuserMaskEnabledStr "userMaskEnabled"
#define kuserMaskLinkedStr "userMaskLinked"
#define kuserMaskOptionsStr "userMaskOptions"
#define kuserStopStr "userStop"
#define kuserStr "user"
#define kusingStr "using"
#define kvMPreferencesStr "vMPreferences"
#define kvalidAtPositionStr "validAtPosition"
#define kvalueListStr "valueList"
#define kvalueStr "value"
#define kvariableClassStr "variableClass"
#define kvariationsStr "variations"
#define kvector0Str "vector0"
#define kvector1Str "vector1"
#define kvectorColorStr "vectorColor"
#define kvectorDataStr "vectorData"
#define kvectorMaskAsGlobalMaskStr "vectorMaskAsGlobalMask"
#define kvectorMaskCurrentPathStr "vectorMaskCurrentPath"
#define kvectorMaskEnabledStr "vectorMaskEnabled"
#define kvectorMaskHideAllStr "vectorMaskHideAll"
#define kvectorMaskLinkedStr "vectorMaskLinked"
#define kvectorMaskRevealAllStr "vectorMaskRevealAll"
#define kvectorMaskStr "vectorMask"
#define kverboseStr "verbose"
#define kversionFixStr "versionFix"
#define kversionMajorStr "versionMajor"
#define kversionMinorStr "versionMinor"
#define kversionStr "version"
#define kverticalLeftToRightStr "verticalLeftToRight"
#define kverticalLocationStr "verticalLocation"
#define kverticalOnlyStr "verticalOnly"
#define kverticalScaleStr "verticalScale"
#define kverticalStr "vertical"
#define kverticalUnderlineLeftStr "verticalUnderlineLeft"
#define kverticalUnderlinePositionStr "verticalUnderlinePosition"
#define kverticalUnderlineRightStr "verticalUnderlineRight"
#define kvideoStr "video"
#define kvideoAlphaStr "videoAlpha"
#define kvideoExportStr "videoExport"
#define kvideoFieldStr "videoField"
#define kvideoLayerStr "videoLayer"
#define kvideoNextFrameStr "videoNextFrame"
#define kvideoPreviousFrameStr "videoPreviousFrame"
#define kvignetteStr "vignette"
#define kvioletStr "violet"
#define kvisibleChannels "visibleChannels"
#define kvisibleStr "visible"
#define kvividLightStr "vividLight"
#define kvOrderStr "vOrder"
#define kwaitStr "wait"
#define kwariChuAutoJustifyStr "wariChuAutoJustify"
#define kwariChuCenterJustifyStr "wariChuCenterJustify"
#define kwariChuCountStr "wariChuCount"
#define kwariChuFullJustifyLastLineCenterStr "wariChuFullJustifyLastLineCenter"
#define kwariChuFullJustifyLastLineFullStr "wariChuFullJustifyLastLineFull"
#define kwariChuFullJustifyLastLineLeftStr "wariChuFullJustifyLastLineLeft"
#define kwariChuFullJustifyLastLineRightStr "wariChuFullJustifyLastLineRight"
#define kwariChuJustificationStr "wariChuJustification"
#define kwariChuLeftJustifyStr "wariChuLeftJustify"
#define kwariChuLineGapStr "wariChuLineGap"
#define kwariChuOrphanStr "wariChuOrphan"
#define kwariChuRightJustifyStr "wariChuRightJustify"
#define kwariChuScaleStr "wariChuScale"
#define kwariChuSizeStr "wariChuSize"
#define kwariChuWidowStr "wariChuWidow"
#define kwarpArcLowerStr "warpArcLower"
#define kwarpArcStr "warpArc"
#define kwarpArcUpperStr "warpArcUpper"
#define kwarpArchStr "warpArch"
#define kwarpBulgeStr "warpBulge"
#define kwarpCustomStr "warpCustom"
#define kwarpFishStr "warpFish"
#define kwarpFisheyeStr "warpFisheye"
#define kwarpFlagStr "warpFlag"
#define kwarpInflateStr "warpInflate"
#define kwarpNoneStr "warpNone"
#define kwarpPerspectiveOtherStr "warpPerspectiveOther"
#define kwarpPerspectiveStr "warpPerspective"
#define kwarpRiseStr "warpRise"
#define kwarpRotateStr "warpRotate"
#define kwarpShellLowerStr "warpShellLower"
#define kwarpShellUpperStr "warpShellUpper"
#define kwarpSqueezeStr "warpSqueeze"
#define kwarpStr "warp"
#define kwarpStyleStr "warpStyle"
#define kwarpTwistStr "warpTwist"
#define kwarpValueStr "warpValue"
#define kwarpWaveStr "warpWave"
#define kwatchSuspensionStr "watchSuspension"
#define kwaterPaperStr "waterPaper"
#define kwatercolorStr "watercolor"
#define kwatermarkStr "watermark"
#define kwaveSineStr "waveSine"
#define kwaveSquareStr "waveSquare"
#define kwaveStr "wave"
#define kwaveTriangleStr "waveTriangle"
#define kwaveTypeStr "waveType"
#define kwavelengthMaxStr "wavelengthMax"
#define kwavelengthMinStr "wavelengthMin"
#define kwebPhotoGalleryStr "webPhotoGallery"
#define kwebPhotoGalleryStr "webPhotoGallery"
#define kwebSafeRampStr "webSafeRamp"
#define kwebStr "web"
#define kwelcomeScreenStr "welcomeScreen"
#define kwetEdgesStr "wetEdges"
#define kwetEdgesLockStr "wetEdgesLock"
#define kwhatStr "what"
#define kwhichEffectStr "whichEffect"
#define kwhichEffectTypeStr "whichEffectType"
#define kwhiteClipStr "whiteClip"
#define kwhiteIntensityStr "whiteIntensity"
#define kwhiteIsHighStr "whiteIsHigh"
#define kwhiteLevelStr "whiteLevel"
#define kwhitePointStr "whitePoint"
#define kwhiteStr "white"
#define kwhitesStr "whites"
#define kwholePathStr "wholePath"
#define kwholeWordStr "wholeWord"
#define kwideGamutRGBStr "wideGamutRGB"
#define kwidePhosphorsStr "widePhosphors"
#define kwidthStr "width"
#define kwildCardStr "wildCard"
#define kwinThumbnailStr "winThumbnail"
#define kwindMethodStr "windMethod"
#define kwindStr "wind"
#define kwindingFillStr "windingFill"
#define kwindowsStr "windows"
#define kwindowsSystemStr "windowsSystem"
#define kwipeDownStr "wipeDown"
#define kwipeLeftStr "wipeLeft"
#define kwipeRightStr "wipeRight"
#define kwipeUpStr "wipeUp"
#define kwithStr "with"
#define kwithStreamStr "withStream"
#define kworkInTimeStr "workInTime"
#define kworkOutTimeStr "workOutTime"
#define kworkPathIndexStr "workPathIndex"
#define kworkPathStr "workPath"
#define kworkingCMYKStr "workingCMYK"
#define kworkingGrayStr "workingGray"
#define kworkingRGBStr "workingRGB"
#define kworkingSpaceCodeStr "workingSpaceCode"
#define kworkingSpotStr "workingSpot"
#define kworkspaceDefaultFolderStr "workspaceDefaultFolder"
#define kworkspaceMenuStr	"workspaceMenu"
#define kworkspaceStr "workspace"
#define kwrapAroundStr "wrapAround"
#define kwrapPathStr "wrapPath"
#define kwrapStr "wrap"
#define kxHeightStrikethroughOnStr "xHeightStrikethroughOn"
#define kxStr "x"
#define kxYYColorStr "xYYColor"
#define kxorStr "xor"
#define kxxStr "xx"
#define kxyStr "xy"
#define kyStr "y"
#define kyellowColorStr "yellowColor"
#define kyellowStr "yellow"
#define kyellowsStr "yellows"
#define kyesNoStr "yesNo"
#define kyesStr "yes"
#define kyxStr "yx"
#define kyyStr "yy"
#define kyyddmmStr "yyddmm"
#define kyymmddStr "yymmdd"
#define kyyyymmddStr "yyyymmdd"
#define kzigZagStr "zigZag"
#define kzigZagTypeStr "zigZagType"
#define kzipStr "zip"
#define kzoomInStr "zoomIn"
#define kzoomOutStr "zoomOut"
#define kzoomStr "zoom"
#define kzoomToolStr "zoomTool"
#define kzoomWithScrollWheelStr "zoomWithScrollWheel"
#define kPreferSmallFontTypeStr "preferSmallPaletteFontType"
#define kPreferMediumFontTypeStr "preferMediumPaletteFontType"
#define kPreferLargeFontTypeStr "preferLargePaletteFontType"

#define kshowFontPreviewsStr "showFontPreviews"
#define kfontPreviewsSizeStr "fontPreviewsSize"
#define ktypePreferencesStr "typePreferences"
#define knewDocumentStr "newDocument"

//#define kmasksOnlyStr "masksOnly"

#if qWebdav || qAssetManagement
#define kworkflowStr "workflow"
#define kworkflowIsManagedStr "workflowIsManaged"
#define kworkflowURLStr "workflowURL"
#endif

#if qWebdav
#define kcheckInStr "checkIn"
#define kcheckOutStr "checkOut"
#define kundoCheckOutStr "undoCheckOut"
#define kuploadToServerStr "uploadToServer"
#define kdownloadFromServerStr "downloadFromServer"
#define kaddToWorkflowStr "addToWorkflow"
#define kworkflowOptionsStr "workflowOptions"
#define kopenFromWorkflowStr "openFromWorkflow"
#define kverifyStateStr "verifyState"
#define klogoffAllServersStr "logoffAllServers"
#define kworkOfflineStr "workOffline"
#define kworkgroupServersStr "workgroupServers"
#define kworkgroupOptionsKeyStr "workgroupOptionsKey"
#define kworkflowIsOwnedStr "workflowIsOwned"
#define kworkflowLockedLocallyStr "workflowLockedLocally"
#define kworkflowEditOfflineStr "workflowEditOffline"
#define kworkflowIsCurrentStr "workflowIsCurrent"
#define kworkflowIsModifiedStr "workflowIsModified"
#define kWorkflowEnabledPref "workflowEnabled"
#define kWorkflowUpdatePref "workflowUpdatePref"
#define kWorkflowCheckoutPref "workflowCheckoutPref"
#endif

#if qAssetManagement
#define kassetManagementEnabledStr "assetManagementEnabled"
#endif

#if qPointAndFixDemo
#define kautoFixCorrectStr "autoFixCorrect"
#endif //qPointAndFixDemo

// - ccox - these are placeholder until we define the final UI
#define khdrToningType1Str	"hdrtype1"
#define khdrToningType2Str	"hdrtype2"
#define khdrToningType3Str	"hdrtype3"
#define khdrToningType4Str	"hdrtype4"
#define khdrToningType5Str	"hdrtype5"
#define khdrToningType6Str	"hdrtype6"

//*****************************************************************************

#endif
