/***********************************************************************/
/*                                                                     */
/* SPPiPL.h                                                            */
/*                                                                     */
/* Copyright 1995-2006 Adobe Systems Incorporated.                     */
/* All Rights Reserved.                                                */
/*                                                                     */
/* Patents Pending                                                     */
/*                                                                     */
/* NOTICE: All information contained herein is the property of Adobe   */
/* Systems Incorporated. Many of the intellectual and technical        */
/* concepts contained herein are proprietary to Adobe, are protected   */
/* as trade secrets, and are made available only to Adobe licensees    */
/* for their internal use. Any reproduction or dissemination of this   */
/* software is strictly forbidden unless prior written permission is   */
/* obtained from Adobe.                                                */
/*                                                                     */
/***********************************************************************/

#ifndef __SPPiPL__
#define __SPPiPL__


/*******************************************************************************
 **
 **	Imports and alignment
 **
 **/

#include "SPTypes.h"


#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#endif


/*******************************************************************************
 **
 **	Constants
 **
 ** Note: 4-character long IDs must be defined in hexidecimal, not long
 ** literal ('long'), due to Windows RC compilers not understanding what
 ** to do with them.
 **
 **/

/** Vendor identifier for a plug-in resource, \c #PIProperty::vendorID value.
	<br> 'ADBE' Vendor identifier for PICA-generic applications. */
#define PIAdobeVendorID				0x41444245L

/** Property mechanism version property, \c #PIProperty::propertyKey value
	<br> 'ivrs' PICA plug-in version.   */
#define PISPVersionProperty			0x69767273L

/** Plug-in resource type, \c #PIProperty::propertyKey value.
	<br> 'impt' Suite import information.  */
#define PIImportsProperty			0x696D7074L

/** Plug-in resource type, \c #PIProperty::propertyKey value.
	<br> 'expt' Suite export information.  */
#define PIExportsProperty			0x65787074L

/**  Plug-in resource type, \c #PIProperty::propertyKey value.
	<br> 'ppcR' Power PC resource information.   */
#define PIPowerPCCodeResProperty	0x70706352L

/** Plug-in resource type, \c #PIProperty::propertyKey value.
	<br> 'heap' Mac OS PPC-only.
	<br>If not defined, loads application default heap.
 	<br>If 0, loads system heap */
#define PIDestinationHeapProperty 	0x68656170L
/** Value of \c #PIDestinationHeapProperty, loads system heap */
#define PILoadInAppHeap				(1L<<0)

/** Plug-in resource type, \c #PIProperty::propertyKey value.
	<br> 'adpt' Adapter version property (a long value) */
#define PIAdapterProperty			0x61647074L

/** Plug-in resource type, \c #PIProperty::propertyKey value.
	<br> 'pinm' Internal plug-in name */
#define PIPluginNameProperty		0x70696E6DL

/**  Plug-in resource type, \c #PIProperty::propertyKey value.
	<br> 'AcpM' Message flags */
#define PIConditionalMessages		0x4163704DL
/** Flag bit for \c #PIConditionalMessages: plug-in accepts property changes. <<??>> */
#define	PIAcceptsPropertyMessage	(1L<<0)
/** Flag bit for \c #PIConditionalMessages: skip shutdown. <<when? why?>> */
#define	PISkipShutDownMessage		(1L<<1)
/** Flag bit for \c #PIConditionalMessages: plug-in accepts purge-cache messages. */
#define PIAcceptsPurgeCachesMessage	(1L<<2)
/** Flag bit for \c #PIConditionalMessages: skip startup message. <<when? why?>> */
#define PISkipStartupMessage		(1L<<3)

/** Internal. Plug-in resource type, \c #PIProperty::propertyKey value.
	<br> 'RelP' generated by Illustrator to optimize program launch */
#define PIReleasePluginEarly		0x52656c50

/*******************************************************************************
 **
 **	General PiPL properties and structures
 **
 ** Many hosts multiply define these properties, so we bracket them
 ** so they are only defined once.
 **
 **/

#ifndef kGeneralPiPLPropertiesDefined // Already defined?
/** Internal: Defines the general properties only if the application has
	not already done so. */
#define kGeneralPiPLPropertiesDefined // Only define once.

/** Data type for plug-in property key and vendor ID. See \c #PIProperty. */
typedef unsigned long PIType;

/** Plug-in properties version number. */
#define kCurrentPiPLVersion 0

// 'kind' <PIType> giving the plug-in's kind:
#define PIKindProperty			0x6b696e64L

// 'm68k' <PI68KCodeDesc> 68k code descriptor. See struct below.
#define PI68KCodeProperty		0x6d36386bL

// 'pwpc' <PICFMCodeDesc> PowerPC code descriptor. See struct below.
#define PIPowerPCCodeProperty	0x70777063L

// 'ppcb' <PICFMCodeDesc> PowerPC CARBON code descriptor. See struct below.
#define PIPowerPCCarbonCodeProperty	'ppcb'

// 'mach' <PIMachOCodeDesc> PowerPC Mach-O code descriptor. See struct below.
#define PIPowerPCMachOCodeProperty	'mach'

// 'mi32' <PIMacIntelMachCodeDesc> Intel 32 Mach-O code descriptor. See struct below.
#define PIMacIntel32Property	'mi32'

// 'mi64' <PIMacIntelMachCodeDesc> Intel 64 Mach-O code descriptor. See struct below.
#define PIMacIntel64Property	'mi64'

// 'frag' <PIFragmentCodeDesc> PowerPC fragment descriptor. See struct below.
#define PICodeFragmentProperty		'frag'

// 'frgc' <PIFragmentCodeDesc> PowerPC CARBON fragment descriptor. See struct below.
#define PICarbonCodeFragmentProperty	'frgc'

// '8664' <PIWin64X86CodeDesc> Win32 Intel code descriptor. See struct below.
#define PIWin64X86CodeProperty  0x38363634L

// 'wx86' <PIWin32X86CodeDesc> Win32 Intel code descriptor. See struct below.
#define PIWin32X86CodeProperty  0x77783836L

// DEPRECATED 'fx86' <PIWin16X86CodeDesc> Win16 Intel code descriptor. See struct below.
#define PIWin16X86CodeProperty  0x66783836L

/** Plug-in property. Properties contain information about
	plug-in resource files, such as their type and location. */
typedef struct PIProperty {
	/** Vendor-specific identifier. */
	PIType vendorID;
	/** Identification key for this resource type. */
	PIType propertyKey;
	/** 0-based index of this resource within its type.
		 Must be unique for properties of a given type within
		 a property list. */
	long propertyID;
	/** Number of characters in the data array. Rounded to a multiple of 4. */
	long propertyLength;
	/** The property data array that contains the property value, a string of 4 characters. */
	char propertyData[1];
} PIProperty;

/** Plug-in property list. Provides the version number of the plug-in
	property mechanism itself, and properties for the associated plug-in.
	 */
typedef struct PIPropertyList {
	/** Version number for the \c #PIProperty structure. */
	long version;
	/** Number of properties in the list. */
	long count;
	/** The properties array. */
	PIProperty properties[1];
} PIPropertyList;

/* Following structures describe resource file types used in plug-in property lists.
 * These structures obey Macintosh 68k alignment and padding rules though
 * generally they are laid out so fields have natural alignment and any
 * needed padding is explicit in the structure.
 */
 //<<are these internal?>>

/** 68k code descriptor. */
typedef struct PI68KCodeDesc {
	/** Property type key code. */
	PIType fType;
	/** Property type unique identifier. */
	short fID;
} PI68KCodeDesc;

/** PowerPC code descriptor. */
typedef struct PICFMCodeDesc {
	/** The offset within the data fork for the start of this plugins
		code fragment. This allows more than one code-fragment-based
		plug-in per file. */
	long fContainerOffset;
	/** The length of this plug-in's code fragment. If this
		is the only fragment in the file, the length is 0. */
	long fContainerLength;
	/** The entry-point name, used to look up the address of
		the function to call within the fragment; allows a single code
		fragment to export more than one plug-in.

		If the name is an empty string, the default entry point
		for the code fragment is used. The entry-point name
		must be an exported symbol of the code fragment. */
	unsigned char fEntryName[1];
} PICFMCodeDesc;

/** PowerPC Mach-O code descriptor. */
typedef struct PIMachCodeDesc
{
	/** Property type key code <<??>> */
	unsigned char fEntryName[1];
} PIMachCodeDesc;

// For 'mi32' PICodeMacIntel32Property:
// For 'mi64' PICodeMacIntel64Property:
typedef struct PIMacIntelMachCodeDesc 
{
	unsigned char fEntryName[1];
} PIMacIntelMachCodeDesc;

typedef struct PIFragmentCodeDesc
{
	long fFragmentResource;
	long fFramentNumber;
	unsigned char fEntryName[1];
} PIFragmentCodeDesc;

/** The entry point name for 64 bit windows, used to lookup the function 
which is called to invoke the plug-in. A \c NULL terminated string, padded 
with additional \ NULL charcters if needed to satisfy the 4-byte alignment
requirement. See @ref PIWin64X86CodeProperty above. */
typedef struct PIWin64X86CodeDesc
{
	char fEntryName[1];
} PIWin64X86CodeDesc;

/** The entry point name for 32 bit windows, used to lookup the function 
which is called to invoke the plug-in. A \c NULL terminated string, padded 
with additional \ NULL charcters if needed to satisfy the 4-byte alignment
requirement. See @ref PIWin32X86CodeProperty above. */
typedef struct PIWin32X86CodeDesc {
	char fEntryName[1];
} PIWin32X86CodeDesc;

/** DEPRECATED Win16 Intel code descriptor. 
See @ref PIWin16X86CodeProperty above. */
typedef struct PIWin16X86CodeDesc {
	char fEntryName[1];
} PIWin16X86CodeDesc;

#endif // kGeneralPiPLPropertiesDefined


/*******************************************************************************
 **
 **	Additional Types
 **
 **/

/** CFM code descriptor */
typedef struct PICFMCodeResourceDesc {
	/** Not used.  */
	long fContainerOffset;			/* Currently unused, reserved. */
	/** The length of this plug-in's code fragment. If this
		is the only fragment in the file, the length is 0. */
	long fContainerLength;
	/** Resource type key code. <<??>> */
	PIType fType;
	/** Unique identifier for the resource within the type. <<??>> */
	short fID;
	/** The entry-point name, used to look up the address of
		the function to call within the fragment; allows a single code
		fragment to export more than one plug-in.

		If the name is an empty string, the default entry point
		for the code fragment is used. The entry-point name
		must be an exported symbol of the code fragment. */
	unsigned char fEntryName[1];
} PICFMCodeResourceDesc;

/*******************************************************************************/

#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#endif

#endif // SPPiPL
