//***************************************************************************************
//
// File supervisor: Softimage 3D Games & 3D Bridge team
//
// (c) Copyright 1999-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  2006-2006 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

#ifndef DIRECTX10_VIEW_H
#define DIRECTX10_VIEW_H


#include <d3d10.h>
#include <d3dx10.h>
#include <d3dx10tex.h>
#include <SIBCArray.h>
#include <iostream>
#include <fstream>

struct SimpleVertex
{
    D3DXVECTOR3 Pos;  
};

// this is the currently used structure, we could probably
// update it one day to be more flexible
typedef struct tagDX10View_PhatVertex
{
	XSI_RTS_Vector3			m_Pos;
	XSI_RTS_Vector3			m_Normal;
	XSI_RTS_ColorRGBAf		m_Col[2];
	XSI_RTS_Vector4			m_TC[8];
} DX10View_PhatVertex;

#define PhatVertexLayoutNumElems 12
static D3D10_INPUT_ELEMENT_DESC PhatVertexLayout[PhatVertexLayoutNumElems] =
{
    { "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0,	(12*0) + (16*0), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "NORMAL", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0,		(12*1) + (16*0), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "COLOR", 0, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,		(12*2) + (16*0), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "COLOR", 1, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,		(12*2) + (16*1), D3D10_INPUT_PER_VERTEX_DATA, 0 },
    { "TEXCOORD", 0, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,	(12*2) + (16*2), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "TEXCOORD", 1, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,	(12*2) + (16*3), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "TEXCOORD", 2, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,	(12*2) + (16*4), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "TEXCOORD", 3, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,	(12*2) + (16*5), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "TEXCOORD", 4, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,	(12*2) + (16*6), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "TEXCOORD", 5, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,	(12*2) + (16*7), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "TEXCOORD", 6, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,	(12*2) + (16*8), D3D10_INPUT_PER_VERTEX_DATA, 0 },  
    { "TEXCOORD", 7, DXGI_FORMAT_R32G32B32A32_FLOAT, 0,	(12*2) + (16*9), D3D10_INPUT_PER_VERTEX_DATA, 0 }
};												

typedef struct tagDX10View_TexCoordMap
{
	int		nbActiveUVs;
	int		target[256];
	int		UVSet[256];
} DX10View_TexCoordMap;


#define NB_VTX_BUFFERS	8
#define VTX_BUFFER_SIZE	49152

typedef struct tagDX10ViewGlobals
{
	//****************************************************************************************
	// Windows
	//****************************************************************************************
	HWND							m_hwnd;							// The window handle
	HWND							m_ParentHwnd;					// The parent window handle
	RECT							m_ParentRect;					// The parent window rect
	WNDCLASSEX						m_wc;							// The window class
	HINSTANCE						m_hInst;						// HINSTANCE handle
					
	//****************************************************************************************
	// Core and display buffers
	//****************************************************************************************
	ID3D10Device*           		m_pd3dDevice;					// d3d device
	IDXGISwapChain*         		m_pSwapChain;					// swap chain
	ID3D10RenderTargetView* 		m_pRenderTargetView;			// primary render target
	ID3D10DepthStencilView*			m_pDSView;						// primary depth/stencil buffer
	IDXGIFactory*					m_pFactory;						// DXGI factory

	//****************************************************************************************
	// Grid
	//****************************************************************************************
	ID3D10Effect*           		m_pEffect;						// default effect (Grid)
	ID3D10EffectTechnique*  		m_pTechnique;					// default technique (Grid)
	ID3D10InputLayout*      		m_pGridVertexLayout;			// default vertex layout (Grid)
	ID3D10Buffer*           		m_pGridVertexBuffer;			// default verter buffer (Grid)

	//****************************************************************************************
	// Font
	//****************************************************************************************
	ID3DX10Font*					m_pFont;						// display font
	ID3DX10Sprite*					m_pSprite;						// display sprite
	ID3D10BlendState*				m_pFontBlendState;				// Font blend state

	//****************************************************************************************
	// States and buffers
	//****************************************************************************************
	ID3D10BlendState*				m_pDefaultBlendState;			// default blend state
	ID3D10RasterizerState*			m_pDefaultRasterizerState;		// default rasterizer state
	ID3D10EffectMatrixVariable*		m_pProjectionMatrix;			// current projection matrix
    ID3D10EffectMatrixVariable*		m_pModelMatrix;					// current model matrix
    ID3D10EffectMatrixVariable*		m_pViewMatrix;					// current view matrix

	//****************************************************************************************
	// Current states
	//****************************************************************************************
	BYTE*							m_pIACurrentInputSignature;				// the current GS or VS input signature
	SIZE_T							m_nIACurrentInputSignatureSize;			// the current GS or VS input signature size
	ID3D10Buffer*					m_pCurrentVertexBuffer[NB_VTX_BUFFERS];	// the current vertex buffers 
	int								m_nCurrentVertexBufferSize;				// the current vertex buffers size
	int								m_nCurrentVertexBufferId;				// the current vertex buffer id
	ID3D10ShaderReflection*			m_pCurrentGS;							// the current GS reflection
	ID3D10ShaderReflection*			m_pCurrentVS;							// the current VS reflection
	ID3D10ShaderReflection*			m_pCurrentPS;							// the current PS reflection

	//****************************************************************************************
	// XSI RTS stuff
	//****************************************************************************************
	DX10View_TexCoordMap			m_TexCoordMap;					// Texture coordinate maps
	XSI_RTS_FXSemantics				m_Semantics;					// Semantics data
	
} DX10ViewGlobals;

//****************************************************************************************
// DX10View CustomView API
//****************************************************************************************

//****************************************************************************************
// Helpers
//****************************************************************************************
#define RELEASE( ptr ) \
	{ if( ptr ) { if(ptr->Release() > 0) assert(0); ptr = NULL; } }

#define SAFE_RELEASE( ptr ) \
	{ if( ptr ) ptr->Release(); }

#define NULLPTR( ptr ) \
	{ ptr = NULL; } 

RTSHADER_API void							DX10View_Printf(XSI::siSeverityType in_lErrCode, wchar_t *in_pFormat, ...);

//****************************************************************************************
// Context management
//****************************************************************************************
RTSHADER_API DX10ViewGlobals*				DX10View_GetContext();

//****************************************************************************************
// Context initialization and cleanup
//****************************************************************************************
RTSHADER_API HRESULT						DX10View_Initialize();
RTSHADER_API HRESULT						DX10View_InitializeWindow(HWND hWnd);
RTSHADER_API HRESULT						DX10View_InitViewport(int x, int y, int width, int height);
RTSHADER_API void							DX10View_Cleanup();

//****************************************************************************************
// Rendering 
//****************************************************************************************
RTSHADER_API void							DX10View_BeginRender(float red, float green, float blue);
RTSHADER_API void							DX10View_SetInitialState();
RTSHADER_API void							DX10View_EndRender();
RTSHADER_API void							DX10View_Display(wchar_t *in_pString);
RTSHADER_API void							DX10View_DrawGrid();
RTSHADER_API bool							DX10View_DrawGeometry
(
	XSI_RTS_TriangulatedGeometry*	in_pGeom, 
	bool							in_bNormals,
	bool							in_bColors,
	bool							in_bUVs,
	DX10View_TexCoordMap*			in_pTexCoordMap
);

//****************************************************************************************
// Texture upload
//****************************************************************************************
RTSHADER_API HRESULT	DX10View_UploadTexture1D(XSI_RTS_Texture* in_pImage, ID3D10Texture1D** out_pT1d, ID3D10ShaderResourceView** out_pTView);
RTSHADER_API HRESULT	DX10View_UploadTexture2D(XSI_RTS_Texture* in_pImage, ID3D10Texture2D** out_pT2d, ID3D10ShaderResourceView** out_pTView);
RTSHADER_API HRESULT	DX10View_UploadTexture3D(XSI_RTS_Texture* in_pImage, ID3D10Texture3D** out_pT3d, ID3D10ShaderResourceView** out_pTView);
RTSHADER_API HRESULT	DX10View_UploadTextureCube(XSI_RTS_Texture* in_pImage, ID3D10Texture2D** out_pTCube, ID3D10ShaderResourceView** out_pTView);



#endif // DIRECTX10_VIEW_H