//***************************************************************************************
//
// File supervisor: Softimage 3D Games & 3D Bridge team
//
// (c) Copyright 1999-2003 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2003 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

#ifndef XSI_OGLHELPER_H
#define XSI_OGLHELPER_H

#ifdef _WIN32
#include <windows.h>
#else
#include <memory.h>
#endif

#include <stdio.h>
#include <GL/gl.h>
#include <gl/glext.h>
#include <XSI_rtshaders.h>

#ifdef UNIX
#ifndef LONG
#define LONG LONG
#endif
#ifndef TRUE
#define TRUE true
#endif
#ifndef FALSE
#define FALSE false
#endif
#ifndef ULONG
#define ULONG ULONG
#endif
#endif

//****************************************************************************************
// Structures
//****************************************************************************************
#define MAX_NB_UVS 256

struct XSI_OGLHelper_TexCoordMap
{
        XSI_OGLHelper_TexCoordMap() : nbActiveUVs( 0 ) {}
        int             nbActiveUVs;
        int             target[MAX_NB_UVS];
        int             UVSet[MAX_NB_UVS];
};

struct XSI_OGLHelper_CavColorMap
{
        XSI_OGLHelper_CavColorMap() : nbActiveCAVs( 0 ) {}
        int             nbActiveCAVs;
        int             CAVSet[MAX_NB_UVS];
};
//****************************************************************************************
// Macros
//****************************************************************************************

#define XSI_CHECKGLERROR	{int a = glGetError(); \
							assert(a == GL_NO_ERROR); \
							while(a != GL_NO_ERROR) {\
								printf("GL Error : %d in %s at line %d\n", a, __FILE__, __LINE__);	\
							a = glGetError();}}
					

//****************************************************************************************
// Function prototypes
//****************************************************************************************

//****************************************************************************************
// Context functions
//****************************************************************************************

RTSHADER_API XSI_OGLHelper_TexCoordMap		*XSI_OGLHelper_GetTextureCoordMap();
RTSHADER_API void							XSI_OGLHelper_ResetTextureCoordMap();

RTSHADER_API XSI_OGLHelper_CavColorMap		*XSI_OGLHelper_GetVertexColorMap();
RTSHADER_API void							XSI_OGLHelper_ResetVertexColorMap();


//****************************************************************************************
// Drawing functions
//****************************************************************************************

RTSHADER_API bool XSI_OGLHelper_DrawGeometry
(
	XGSExtensionsGL					*pGLExt,
	XGSGLExtensionsFuncs			*pGLExtFuncs,
	XSI_RTS_Primitive				*in_pGeometry, 
	bool							in_bNormals,
	bool							in_bColors,
	bool							in_bUV,
	XSI_OGLHelper_TexCoordMap		*in_pTexCoordMap,
	XSI_OGLHelper_CavColorMap		*in_pCavCoordMap
);

//****************************************************************************************
// Utility functions
//****************************************************************************************

RTSHADER_API ULONG XSI_OGLHelper_NearestPowerOf2(ULONG number);
RTSHADER_API void XSI_OGLHelper_ComputeTransforms
(
	float		*mat, 
	float		scx,
	float		scy,
	float		scz,
	float		rx,
	float		ry,
	float		rz,
	float		tx,
	float		ty,
	float		tz
);

RTSHADER_API void	XSI_OGLHelper_MatrixTrackWorld(float in_pDstM4x4[4][4]);
RTSHADER_API void	XSI_OGLHelper_MatrixTrackWorldAndView(float in_pWorld[4][4], float in_pView[4][4]);
RTSHADER_API void	XSI_OGLHelper_MatrixTrackView(float in_pDstM4x4[4][4]);

#endif // XSI_OGLHELPER_H
