#ifndef _XGS_INTERFACE_H_
#define _XGS_INTERFACE_H_

#include <GL/gl.h>

#ifdef _WIN32
#include <gl/wglext.h>
#endif

#include <XGS_consts.h>
#include <xsi_decl.h>
#include <XSI_rtshaders.h>	// Used for enums

//******************************************************************************
//
// Forward references
//
//******************************************************************************
namespace XSI
{
	class CGraphicSequencer;
}

class		GPUResource;

interface	I3DList;
interface	I3DObject;
interface	ISIPluginHost;

typedef struct tagDSTIME DSTIME;

template< class CElemType > class TChunkArray;

typedef void* (*GETINTERFACE)();

//******************************************************************************
//
// Typedefs
//
//******************************************************************************
//! XGS WGL extensions structure
/*! The is the structure for keeping WGL extension support status
*/

typedef struct tagXGSExtensionsWGL
{
	int	 version;
	int  size;

	bool _WGL_ARB_buffer_region ;
	bool _WGL_ARB_extensions_string ;
	bool _WGL_ARB_pixel_format ;
	bool _WGL_ARB_make_current_read ;
	bool _WGL_ARB_pbuffer ;
	bool _WGL_ARB_render_texture ;
	bool _WGL_EXT_display_color_table ;
	bool _WGL_EXT_extensions_string ;
	bool _WGL_EXT_make_current_read ;
	bool _WGL_EXT_pixel_format ;
	bool _WGL_EXT_pbuffer ;
	bool _WGL_EXT_swap_control ;
	bool _WGL_EXT_depth_float ;
	bool _WGL_EXT_multisample ;
	bool _WGL_OML_sync_control ;
	bool _WGL_I3D_digital_video_control ;
	bool _WGL_I3D_gamma ;
	bool _WGL_I3D_genlock ;
	bool _WGL_I3D_image_buffer ;
	bool _WGL_I3D_swap_frame_lock ;
	bool _WGL_I3D_swap_frame_usage ;
	bool _WGL_NV_render_depth_texture ;
	bool _WGL_NV_render_texture_rectangle ;
	bool _WGL_ATI_pixel_format_float ;

} XGSExtensionsWGL;

//! XGS WGL extensions functions
/*! The is the structure for keeping WGL extension functions
*/

typedef struct tagXGSWGLExtensionsFuncs
{																				
	int	 version;
	int  size;	

	PFNWGLCREATEBUFFERREGIONARBPROC							wglCreateBufferRegionARB;							
	PFNWGLDELETEBUFFERREGIONARBPROC							wglDeleteBufferRegionARB;							
	PFNWGLSAVEBUFFERREGIONARBPROC							wglSaveBufferRegionARB;							
	PFNWGLRESTOREBUFFERREGIONARBPROC						wglRestoreBufferRegionARB;								

	PFNWGLGETEXTENSIONSSTRINGARBPROC						wglGetExtensionsStringARB;

	PFNWGLGETPIXELFORMATATTRIBIVARBPROC						wglGetPixelFormatAttribivARB;								
	PFNWGLGETPIXELFORMATATTRIBFVARBPROC						wglGetPixelFormatAttribfvARB;								
	PFNWGLCHOOSEPIXELFORMATARBPROC							wglChoosePixelFormatARB;							

	PFNWGLMAKECONTEXTCURRENTARBPROC							wglMakeContextCurrentARB;
	PFNWGLGETCURRENTREADDCARBPROC							wglGetCurrentReadDCARB;

	PFNWGLCREATEPBUFFERARBPROC								wglCreatePbufferARB;						
	PFNWGLGETPBUFFERDCARBPROC								wglGetPbufferDCARB;						
	PFNWGLRELEASEPBUFFERDCARBPROC							wglReleasePbufferDCARB;							
	PFNWGLDESTROYPBUFFERARBPROC								wglDestroyPbufferARB;						
	PFNWGLQUERYPBUFFERARBPROC								wglQueryPbufferARB;						

	PFNWGLBINDTEXIMAGEARBPROC								wglBindTexImageARB;						
	PFNWGLRELEASETEXIMAGEARBPROC							wglReleaseTexImageARB;							
	PFNWGLSETPBUFFERATTRIBARBPROC							wglSetPbufferAttribARB;							

	PFNWGLCREATEDISPLAYCOLORTABLEEXTPROC					wglCreateDisplayColorTableEXT;									
	PFNWGLLOADDISPLAYCOLORTABLEEXTPROC						wglLoadDisplayColorTableEXT;								
	PFNWGLBINDDISPLAYCOLORTABLEEXTPROC						wglBindDisplayColorTableEXT;								
	PFNWGLDESTROYDISPLAYCOLORTABLEEXTPROC					wglDestroyDisplayColorTableEXT;									

	PFNWGLGETEXTENSIONSSTRINGEXTPROC						wglGetExtensionsStringEXT;

	PFNWGLMAKECONTEXTCURRENTEXTPROC							wglMakeContextCurrentEXT;
	PFNWGLGETCURRENTREADDCEXTPROC							wglGetCurrentReadDCEXT;

	PFNWGLCREATEPBUFFEREXTPROC								wglCreatePbufferEXT;						
	PFNWGLGETPBUFFERDCEXTPROC								wglGetPbufferDCEXT;						
	PFNWGLRELEASEPBUFFERDCEXTPROC							wglReleasePbufferDCEXT;							
	PFNWGLDESTROYPBUFFEREXTPROC								wglDestroyPbufferEXT;						
	PFNWGLQUERYPBUFFEREXTPROC								wglQueryPbufferEXT;						

	PFNWGLGETPIXELFORMATATTRIBIVEXTPROC						wglGetPixelFormatAttribivEXT;								
	PFNWGLGETPIXELFORMATATTRIBFVEXTPROC						wglGetPixelFormatAttribfvEXT;								
	PFNWGLCHOOSEPIXELFORMATEXTPROC							wglChoosePixelFormatEXT;							

	PFNWGLSWAPINTERVALEXTPROC								wglSwapIntervalEXT;						
	PFNWGLGETSWAPINTERVALEXTPROC							wglGetSwapIntervalEXT;							

	PFNWGLALLOCATEMEMORYNVPROC								wglAllocateMemoryNV;
	PFNWGLFREEMEMORYNVPROC									wglFreeMemoryNV;

	PFNWGLGETSYNCVALUESOMLPROC								wglGetSyncValuesOML;						
	PFNWGLGETMSCRATEOMLPROC									wglGetMscRateOML;					
	PFNWGLSWAPBUFFERSMSCOMLPROC								wglSwapBuffersMscOML;						
	PFNWGLSWAPLAYERBUFFERSMSCOMLPROC						wglSwapLayerBuffersMscOML;								
	PFNWGLWAITFORMSCOMLPROC									wglWaitForMscOML;					
	PFNWGLWAITFORSBCOMLPROC									wglWaitForSbcOML;					

	PFNWGLGETDIGITALVIDEOPARAMETERSI3DPROC					wglGetDigitalVideoParametersI3D;									
	PFNWGLSETDIGITALVIDEOPARAMETERSI3DPROC					wglSetDigitalVideoParametersI3D;									

	PFNWGLGETGAMMATABLEPARAMETERSI3DPROC					wglGetGammaTableParametersI3D;									
	PFNWGLSETGAMMATABLEPARAMETERSI3DPROC					wglSetGammaTableParametersI3D;									
	PFNWGLGETGAMMATABLEI3DPROC								wglGetGammaTableI3D;						
	PFNWGLSETGAMMATABLEI3DPROC								wglSetGammaTableI3D;						

	PFNWGLENABLEGENLOCKI3DPROC								wglEnableGenlockI3D;						
	PFNWGLDISABLEGENLOCKI3DPROC								wglDisableGenlockI3D;						
	PFNWGLISENABLEDGENLOCKI3DPROC							wglIsEnabledGenlockI3D;							
	PFNWGLGENLOCKSOURCEI3DPROC								wglGenlockSourceI3D;						
	PFNWGLGETGENLOCKSOURCEI3DPROC							wglGetGenlockSourceI3D;							
	PFNWGLGENLOCKSOURCEEDGEI3DPROC							wglGenlockSourceEdgeI3D;							
	PFNWGLGETGENLOCKSOURCEEDGEI3DPROC						wglGetGenlockSourceEdgeI3D;								
	PFNWGLGENLOCKSAMPLERATEI3DPROC							wglGenlockSampleRateI3D;							
	PFNWGLGETGENLOCKSAMPLERATEI3DPROC						wglGetGenlockSampleRateI3D;								
	PFNWGLGENLOCKSOURCEDELAYI3DPROC							wglGenlockSourceDelayI3D;							
	PFNWGLGETGENLOCKSOURCEDELAYI3DPROC						wglGetGenlockSourceDelayI3D;								
	PFNWGLQUERYGENLOCKMAXSOURCEDELAYI3DPROC					wglQueryGenlockMaxSourceDelayI3D;									

	PFNWGLCREATEIMAGEBUFFERI3DPROC							wglCreateImageBufferI3D;							
	PFNWGLDESTROYIMAGEBUFFERI3DPROC							wglDestroyImageBufferI3D;							
	PFNWGLASSOCIATEIMAGEBUFFEREVENTSI3DPROC					wglAssociateImageBufferEventsI3D;									
	PFNWGLRELEASEIMAGEBUFFEREVENTSI3DPROC					wglReleaseImageBufferEventsI3D;									

	PFNWGLENABLEFRAMELOCKI3DPROC							wglEnableFrameLockI3D;							
	PFNWGLDISABLEFRAMELOCKI3DPROC							wglDisableFrameLockI3D;							
	PFNWGLISENABLEDFRAMELOCKI3DPROC							wglIsEnabledFrameLockI3D;							
	PFNWGLQUERYFRAMELOCKMASTERI3DPROC						wglQueryFrameLockMasterI3D;								

	PFNWGLGETFRAMEUSAGEI3DPROC								wglGetFrameUsageI3D;						
	PFNWGLBEGINFRAMETRACKINGI3DPROC							wglBeginFrameTrackingI3D;							
	PFNWGLENDFRAMETRACKINGI3DPROC							wglEndFrameTrackingI3D;							
	PFNWGLQUERYFRAMETRACKINGI3DPROC							wglQueryFrameTrackingI3D;			
	
} XGSWGLExtensionsFuncs;

//! XGS OGL Managed Resource
/*! A class that defines an OGL resource that is managed by the XGS
*/

/////////////////////////////////////////////////////////////////////////////
//
// @interface IXGSOGLRenderTarget | Graphic Sequencer OpenGL render target.
//
// @base public | IUnknown
//
/////////////////////////////////////////////////////////////////////////////

#undef  INTERFACE
#define INTERFACE IXGSOGLRenderTarget

DECLARE_INTERFACE_( IXGSOGLRenderTarget, IUnknown )
{
	/////////////////////////////////////////////////////////////////////////////
	// IUnknown methods
	/////////////////////////////////////////////////////////////////////////////
	
	STDMETHOD( QueryInterface )(  REFIID, LPVOID FAR * ) PURE;
	STDMETHOD_( ULONG, AddRef )(  ) PURE;
	STDMETHOD_( ULONG, Release )(  ) PURE;

	/////////////////////////////////////////////////////////////////////////////
	// Interface Specific Methods
	/////////////////////////////////////////////////////////////////////////////
	STDMETHOD( GetDC) ( HDC *out_hdc) PURE;
	STDMETHOD( GetOpenGLContext) ( HGLRC *out_hglrc) PURE;
	STDMETHOD( GetName ) ( TCHAR **out_pName) PURE;
} ;

interface IXGSGraphicsDriver
{
	STDMETHOD ( DrawMappedGeometry ) ( 	XSI_RTS_Primitive	*in_pGeometry, 
												void	*in_pMap,
												XSI_RTS_Attribute_Size	*in_pAttributesSize) PURE;

	STDMETHOD_ (void*, GetInterface ) () PURE;

} ;


/*! An XGS managed resource. Things can be copied to here from COGLManagedResource as 
	needed.
*/
interface IXGSManagedResource
{
	enum eResourceType
	{
		Texture=0,
		FBO,
		VBO,
		PBO,
		DisplayList,
		RenderBuffer,
		Shader,
		RAMArray
	};

	enum eSharing
	{
		Shared,
		SharedOwner,
		Exclusive
	};

	virtual UINT			AddRef		(VOID* in_Owner) = 0;
	virtual UINT			Release		(VOID* in_Owner) = 0;

	virtual GLuint			GetResource( ) = 0;
	virtual TChunkArray<unsigned char>	*	GetArrayResource( ) = 0;
	virtual const char*		GetCode		( ) const = 0;

	virtual void			SetGPUObject( GPUResource*	in_pGPUObject ) = 0;
	virtual GPUResource*	GetGPUObject( ) = 0;
};


/////////////////////////////////////////////////////////////////////////////
//
// @interface IXGSDisplayContextManager | Graphic Sequencer Context Manager.
//
// @base public | IUnknown
//
/////////////////////////////////////////////////////////////////////////////

interface IXGSDisplayContextManager :
	public IUnknown
{
	/////////////////////////////////////////////////////////////////////////////
	// IUnknown methods
	/////////////////////////////////////////////////////////////////////////////
	
	STDMETHOD( QueryInterface )(  REFIID, LPVOID FAR * ) PURE;
	STDMETHOD_( ULONG, AddRef )(  ) PURE;
	STDMETHOD_( ULONG, Release )(  ) PURE;

	/////////////////////////////////////////////////////////////////////////////
	// Interface Specific Methods
	/////////////////////////////////////////////////////////////////////////////

	// context management
	STDMETHOD( CreateContext )(  ULONG in_pID, TCHAR *in_pRenderTargetID ) PURE ;
	STDMETHOD( SetCurrentContext )(  ULONG in_pID ) PURE ;
	STDMETHOD( FreeContext )(  ULONG in_pID ) PURE ;
	STDMETHOD( UpdateContextList )(  ) PURE ;
	STDMETHOD( RefreshContextList )(  ) PURE ;
	STDMETHOD( SetContextViewMode )(  ULONG in_pID, unsigned int in_uiViewMode, TCHAR *in_szViewModeName ) PURE;
	STDMETHOD( SetContextRenderTarget ) (  ULONG in_contextID, TCHAR *in_rtID ) PURE;
	STDMETHOD( SetViewportMapping ) (  ULONG, ULONG ) PURE;
	STDMETHOD( GetContextIDFromViewport ) ( ULONG in_uiViewportID, ULONG *out_puiContextID ) PURE;
	STDMETHOD( IsValidDisplayMode ) (  TCHAR* ) PURE;

	// Display locking (for non-ui thread access)
	STDMETHOD( AcquireExclusiveDisplay )( ) PURE;
	STDMETHOD( ReleaseExclusiveDisplay )( ) PURE;
		
	// callback management
	STDMETHOD( ExecuteCallbacks )(  ULONG in_pID, XSI::siDisplayCallback in_eFrom, XSI::siDisplayCallback in_eTo ) PURE ;
	STDMETHOD( ExecutePasses	)(  ULONG in_pID ) PURE ;

	// render target management
	STDMETHOD( CreateRenderTarget )(  unsigned int in_lType, TCHAR *in_pID, void *in_pFormat, HWND in_hWnd) PURE ;
	STDMETHOD( GetRenderTargetFromContext )(  ULONG in_pID, IXGSOGLRenderTarget **out_pRenderTarget) PURE;
	STDMETHOD( GetRenderTargetByName )(  TCHAR *in_pID, IXGSOGLRenderTarget **out_pRenderTarget) PURE;

	// states management (Generic)
	STDMETHOD( GetNbStates )(  int in_lType, int *out_pNbStates) PURE;
	STDMETHOD( DeleteState )(  int in_lType, TCHAR *in_pID ) PURE;
	STDMETHOD( CreateState )(  int in_lType, TCHAR *in_pID, LPVOID in_pValuePtr, LPVOID *out_pStateHandle) PURE;
	STDMETHOD( GetStateHandle )(  int in_lType, TCHAR *in_pID, LPVOID *out_pStateHandle) PURE;
	STDMETHOD( GetStateValue )(  int in_lType, LPVOID in_lStateHandle, LPVOID out_pStateValue) PURE;
	STDMETHOD( SetStateValue )(  int in_lType, LPVOID in_lStateHandle, LPVOID in_pStateValue) PURE;

	// notifications
	STDMETHOD( NotifyHostUnloading )(  ISIPluginHost* ) PURE ;
	
	// data extraction for realtime shaders
	STDMETHOD( ExtractLightInfo )(  ) PURE ;
	STDMETHOD( ExtractCameraInfo )(  I3DObject* ) PURE ;

	// rendering
	STDMETHOD( RenderSceneUsingMode )(  int in_eMode, int in_lRenderFlags ) PURE ;
	STDMETHOD( RenderSceneUsingMaterial) (  TCHAR* in_szMaterialName, int in_lRenderFlags ) PURE ;

	STDMETHOD( RenderListUsingMode )(  I3DList* in_pI3DList, int in_eMode, int in_lRenderFlags = XSI::siRenderDefault ) PURE ;
	STDMETHOD( RenderListUsingMaterial )(  I3DList* in_pI3DList, TCHAR *in_szMaterialName, int in_lRenderFlags = XSI::siRenderDefault ) PURE ;

	// capabilities and extensions
	STDMETHOD( GetOpenGLExtensions )		(  XGSExtensionsGL* ) PURE ;
	STDMETHOD( GetOpenGLExtensionsFuncs )	(  XGSGLExtensionsFuncs* ) PURE ;
	STDMETHOD( GetWGLExtensions )			(  XGSExtensionsWGL* ) PURE ;
	STDMETHOD( GetWGLExtensionsFuncs )		(  XGSWGLExtensionsFuncs* ) PURE ;

	// scene data access
	STDMETHOD( GetSceneData )				(  XSI_RTS_SceneData** ) PURE;

	// plugin host
	STDMETHOD( GetGraphicSequencer )		(  XSI::CGraphicSequencer** ) PURE;

	STDMETHOD( GetSceneDirtyFlag )			(  bool* ) PURE;
	
	STDMETHOD( RenderNotification )			(  ULONG in_pID, XSI::siDisplayCallback notif ) PURE;
	STDMETHOD( SetPixelFormatAttributes )	(  int* ) PURE;
	STDMETHOD( GetPixelFormatAttributes )	(  int** ) PURE;

	STDMETHOD( NotifyHostLoading )(  ISIPluginHost* ) PURE ;

	STDMETHOD( SetSceneDirty )				(  ) PURE;
	
	STDMETHOD( GetContextFlags )			(  LONG* ) PURE;
	STDMETHOD( SetContextFlags )			(  LONG ) PURE;
	
	STDMETHOD( PopulateLightIDs )			(  ) PURE;
	STDMETHOD( ReleaseLightIDs )			(  ) PURE;

	// InitializeGhostContext must be called at least once before RenderListUsingModeEx, from a convenient place that works... currently, refreshview of view A!
	STDMETHOD ( RenderListUsingModeEx )	  ( I3DList* in_pGeomList, 
											int in_eMode,
											int in_lRenderFlags,
											LPTSTR in_tcsRenderer,
											DSTIME	*in_pTime,			// NULL == current system time
											I3DList* in_pLightList,
											I3DObject	*in_pCameraObj,	// NULL == View A camera
											LPVOID in_pViewData ,
											UINT in_uiOffX,
											UINT in_uiOffY,
											UINT in_uiWidth,
											UINT in_uiHeight,
											UINT in_uiFrameWidth,
											UINT in_uiFrameHeight,
											LPVOID out_pBuffer = NULL,
											GLenum in_eComponents = GL_RGBA,
											GLenum in_eComponentSize = GL_UNSIGNED_BYTE
										  ) PURE;
	// Above these sizes, and RenderListUsingModeEx will perform multiple renders to achieve the result.
	STDMETHOD ( GetRenderToTextureSingleRenderLimit ) ( UINT *out_pMaxX, UINT *out_pMaxY ) PURE;
	// InitializeGhostContext must be called at least once before RenderListUsingModeEx, from a convenient place that works... currently, refreshview of view A!
	STDMETHOD( InitializeGhostContext ) () PURE;
	STDMETHOD_(eChannel, GetChannel ) (int in_iBuffer) PURE;

	// Returns the XGS Master Context. This is the context that contains the OpenGL sharing list.
	STDMETHOD( GetMasterRenderTarget )( IXGSOGLRenderTarget **out_pRenderTarget) PURE;

	STDMETHOD( SetCurrentOGLResourceClient )		(  LONG in_lID ) PURE;
	STDMETHOD_( BOOL, GetManagedResource )			(  LONG in_lSize, 
												UINT in_uiNbElements,
												GLenum in_eDimension,
												GLuint in_uiType, 
												IXGSManagedResource::eResourceType in_eResType, 
												IXGSManagedResource::eSharing in_eShareType, 
												VOID*	in_pOwner,
												IXGSManagedResource** ) PURE;

	STDMETHOD_( BOOL, GetManagedResource )			(  GUID in_gID,
														IXGSManagedResource::eResourceType in_eResType, 
														IXGSManagedResource::eSharing in_eShareType, 
														VOID*	in_pOwner,
														IXGSManagedResource** ) PURE;

	STDMETHOD( ReleaseManagedResource )			(  IXGSManagedResource* in_pResource, VOID*  in_lOwnwer) PURE;

	STDMETHOD_ (bool, GPUEnabled)	(  ) PURE;
	STDMETHOD_ (bool, VBOsPermitted )	(  ) PURE;

	STDMETHOD_( LONG, GetNbExperiments )		(  ) PURE;
	STDMETHOD_( ULONG, BeginTimingExperiment )	(  ) PURE;
	STDMETHOD( EndTimingExperiment )			(  ULONG ) PURE;
	STDMETHOD( AddGPUTimeToExperiments )		(  double ) PURE;
	STDMETHOD_( ULONG, BeginSubExperiment)		(  TCHAR* in_szName )PURE;
	STDMETHOD( EndSubExperiment)				(  ULONG in_ulID ) PURE;

	STDMETHOD( BeginSubGPUExperiment)			(  )PURE;
	STDMETHOD( EndSubGPUExperiment)				(  )PURE;
	
	STDMETHOD_( eGraphicsCard, GetGraphicsCardVendor )		(  ) PURE;
	STDMETHOD ( GetGraphicsCardFeature )					(  eGraphicsCardFeature in_feature, VOID* out_feature) PURE;
	STDMETHOD_ (bool, IsFeatureSupported)					(  eGraphicsCardFeature in_feature ) PURE;

	STDMETHOD ( DumpCurrentOGLContext )					(  ) PURE;
	
	//	RTS 3.0
	
	STDMETHOD_ (IXGSGraphicsDriver*, GetGraphicsDriver) (  eGraphicsAPI in_eAPI) PURE;

	STDMETHOD ( DrawGeometry ) (  eGraphicsAPI in_eAPI,
									XSI_RTS_Primitive	*in_pGeometry, 
									XSI_RTS_Attribute *in_pAttributes,
									void*	in_pAttribData,
									XSI_RTS_Attribute_Size			*in_pAttributesSize) PURE;

	STDMETHOD ( DrawGeometry ) (  eGraphicsAPI in_eAPI,
									XSI_RTS_Primitive	*in_pGeometry, 
									const char* in_szMapping, 
									void*	in_pAttribData,
									XSI_RTS_Attribute_Size			*in_pAttributesSize) PURE;

	STDMETHOD_ (XSI_RTS_Attribute*,	GetAttributeDescriptorFromMapping)(  const char* in_szMapping ) PURE;

	STDMETHOD ( GetCurrentCamera )  ( I3DObject** out_Camera ) PURE;

	//todo move just after VBOsPermitted... was at the end because of linkage.
	STDMETHOD( SetVBOsPermitted )( THIS_ bool ) PURE;

	STDMETHOD( SetActiveChannels ) ( THIS_ int* in_pChannels, int in_iNbChannels) PURE;
	STDMETHOD( PushExecutionState ) ( THIS ) PURE;
	STDMETHOD( PopExecutionState ) ( THIS ) PURE;
	STDMETHOD( EnsureValidOpenGLContext ) ( THIS ) PURE;
	STDMETHOD( SetPickMode )	(REFCATID in_PickMode ) PURE;	// see drawdata
	STDMETHOD( GetPickMode)		(CATID * out_pPickMode) PURE;	// see drawdata

} ;

#endif //_XGS_INTERFACE_H_
