//*****************************************************************************
/*!
   \file xsi_iceattributedataarray2D.h
   \brief CICEAttributeDataArray2D classes declaration.

    Copyright 1998-2007 Avid Technology, Inc. and its licensors. All rights
   reserved. This file contains confidential and proprietary information of
   Avid Technology, Inc., and is subject to the terms of the SOFTIMAGE|XSI
   end user license agreement (or EULA).
*/
//*****************************************************************************

#if (_MSC_VER > 1000) || defined(SGI_COMPILER)
#pragma once
#endif

#ifndef __XSIICEATTRIBUTEDATAARRAY2D_H__
#define __XSIICEATTRIBUTEDATAARRAY2D_H__

#include <sicppsdk.h>
#include <xsi_iceattributedataarray.h>
#include <xsi_vector2f.h>
#include <xsi_vector3f.h>
#include <xsi_vector4f.h>
#include <xsi_quaternionf.h>
#include <xsi_rotationf.h>
#include <xsi_matrix3f.h>
#include <xsi_matrix4f.h>
#include <xsi_color4f.h>

namespace XSI {

class ICEAttribute;

//*****************************************************************************
/*! \class CICEAttributeDataArray2D xsi_iceattributedataarray2D.h
	\brief This template class encapsulates ICEAttribute data as a 2D array. %CICEAttributeDataArray2D
	objects are read-only and can be filled with the methods supplied with the ICEAttribute class.
	%CICEAttributeDataArray2D is zero-based and can be one of the following types:

	\li \ref CICEAttributeDataArray2DFloat "CICEAttributeDataArray2DFloat"
	\li \ref CICEAttributeDataArray2DLong "CICEAttributeDataArray2DLong"
	\li \ref CICEAttributeDataArray2DBool "CICEAttributeDataArray2DBool"
	\li \ref CICEAttributeDataArray2DVector2f "CICEAttributeDataArray2DVector2f"
	\li \ref CICEAttributeDataArray2DVector3f "CICEAttributeDataArray2DVector3f"
	\li \ref CICEAttributeDataArray2DVector4f "CICEAttributeDataArray2DVector4f"
	\li \ref CICEAttributeDataArray2DQuaternionf "CICEAttributeDataArray2DQuaternionf"
	\li \ref CICEAttributeDataArray2DRotationf "CICEAttributeDataArray2DRotationf"
	\li \ref CICEAttributeDataArray2DMatrix3f "CICEAttributeDataArray2DMatrix3f"
	\li \ref CICEAttributeDataArray2DMatrix4f "CICEAttributeDataArray2DMatrix4f"
	\li \ref CICEAttributeDataArray2DColor4f "CICEAttributeDataArray2DColor4f"
	\li \ref CICEAttributeDataArray2DShape "CICEAttributeDataArray2DShape"

	All types are associated to specific ICEAttribute 2D types. Therefore, you need to declare the right
	array object type that matches the ICEAttribute data type you want to access. Otherwise a runtime error
	will occur and the returned array will be empty.

	\sa ICEAttribute::GetDataArray2D, ICEAttribute::GetDataArray2DChunk,
		\ref CICEAttributeDataArray2DTypedefs "Type Definitions for CICEAttributeDataArray2D"
	\since 7.0

	\eg This example demonstrates how to iterate over the EnvelopeWeightsPerDeformer ClusterProperty
		attribute data on en envelope.
	\code
		using namespace XSI;

		X3DObject cone = CreatePrim( L"Cone", L"MeshSurface", L"", L"");
		Create2DSkeleton( 2.95, 3.34, -0.33, 4.73, 0.0, 0.0, -5.71, 0, 0, 4, CValue(""), CValue(""));
		AppendBone( L"eff", 3.70, -3.02, 0.30, L"");

		XSI::siConstructionMode mode = siConstructionModeModeling;
		ApplyFlexEnv( L"cone;bone,bone1,eff", true, mode );
		SelectObj( L"cone.polymsh.cls.EnvelopWeightCls.Envelope_Weights", L"", L"" );

		// Make sure to generate the data first
		cone.GetActivePrimitive().GetGeometry(0);

		Application xsi;
		ProjectItem envProp = xsi.GetSelection()[0];

		ICEAttribute attr = envProp.GetICEAttributeFromName( L"EnvelopeWeightsPerDeformer" );

		CICEAttributeDataArray2DFloat weight2D;
		attr.GetDataArray2D( weight2D );

		for( ULONG i=0; i<weight2D.GetCount( ); i++ )
		{
			CICEAttributeDataArray< float > weights;
			weight2D.GetSubArray( i, weights );
			for( ULONG j=0; j<weights.GetCount( ); j++ )
			{
				xsi.LogMessage( CString( weights[ j ] ) );
			}
		}

		// Helpers
		CValue CreatePrim( const CString& in_presetobj, const CString& in_geometrytype, const CString& in_name, const CString& in_parent )
		{
			CValueArray args(4);
			CValue retval;
			args[0]= in_presetobj;
			args[1]= in_geometrytype;
			args[2]= in_name;
			args[3]= in_parent;

			Application app;
			app.ExecuteCommand( L"CreatePrim", args, retval );
			return retval;
		}

		CValue Create2DSkeleton( const CValue& in_rx, const CValue& in_ry, const CValue& in_rz, const CValue& in_ex, const CValue& in_ey, const CValue& in_ez, const CValue& in_nx, const CValue& in_ny, const CValue& in_nz, const CValue& in_viewtype,  CValue& out_bone,  CValue& out_effector )
		{
			CValueArray args(12);
			CValue retval;

			args[0]= in_rx;
			args[1]= in_ry;
			args[2]= in_rz;
			args[3]= in_ex;
			args[4]= in_ey;
			args[5]= in_ez;
			args[6]= in_nx;
			args[7]= in_ny;
			args[8]= in_nz;
			args[9]= in_viewtype;

			Application app;
			app.ExecuteCommand( L"Create2DSkeleton", args, retval );

			out_bone = args[10];
			out_effector = args[11];
			return retval;
		}

		CValue AppendBone( const CValue&  in_inputobjs, const CValue& in_ex, const CValue& in_ey, const CValue& in_ez, bool in_pin )
		{
			CValueArray args(5);
			CValue retval;

			args[0]= in_inputobjs;
			args[1]= in_ex;
			args[2]= in_ey;
			args[3]= in_ez;
			args[4]= in_pin;

			Application app;
			app.ExecuteCommand( L"AppendBone", args, retval );

			return retval;
		}

		CValue ApplyFlexEnv( const CValue&  in_connectionset, bool in_assignnewdeformers,  XSI::siConstructionMode & io_constructionmode )
		{
			CValueArray args(3);
			CValue retval;

			args[0]= in_connectionset;
			args[1]= in_assignnewdeformers;
			args[2]= io_constructionmode;

			Application app;
			app.ExecuteCommand( L"ApplyFlexEnv", args, retval );

			io_constructionmode = (XSI::siConstructionMode)(LONG)args[2];
			return retval;
		}

		void SelectObj( const CValue&  in_selectionlist, const CString& in_hierarchylevel, bool in_checkobjectselectability )
		{
			CValueArray args(3);
			CValue retval;
			args[0]= in_selectionlist;
			args[1]= in_hierarchylevel;
			args[2]= in_checkobjectselectability;

			Application app;

			CStatus st = app.ExecuteCommand( L"SelectObj", args, retval );
			return;
		}
	\endcode
 */
//*****************************************************************************
template<class T>
class CICEAttributeDataArray2D : public CBaseICEAttributeDataArray
{
public:
	/*! Constructor.*/
	CICEAttributeDataArray2D( ) : CBaseICEAttributeDataArray( GetDefaultType( ), XSI::siICENodeStructureArray ) {}

	/*! Destructor.	*/
	~CICEAttributeDataArray2D( ) {}

	/*! Accessor to the encapsulated array. This operator is called when reading the data so the return value is read-only.
	\param in_index Index in the array. The index must be smaller than the number of elements in the array, otherwise the
	results are unpredictable.
	\param out_dataArray A read-only reference to a \c CICEAttributeDataArray<T> object at a specific index.
	\return CStatus::OK Success
	\return CStatus::InvalidArgument If \c in_index or \c out_dataArray is invalid.
	*/
	CStatus GetSubArray( ULONG in_index, CICEAttributeDataArray<T>& out_dataArray ) const
	{
		return GetSubDataArray( in_index, (CBaseICEAttributeDataArray&)out_dataArray );
	}

	/*! Accessor to the number of elements in the array.
	\return Number of elements in the array.
	*/
	ULONG GetCount() const
	{
		return m_nCount;
	}

private:
	static SICPPSDK_INLINE XSI::siICENodeDataType GetDefaultType( );
};

/*! \page CICEAttributeDataArray2DTypedefs Type Definitions for CICEAttributeDataArray2D
	The CICEAttributeDataArray2D class is a template class that encapsulates the following 2D data arrays:

	\li \ref CICEAttributeDataArray2DFloat "CICEAttributeDataArray2DFloat"
	\li \ref CICEAttributeDataArray2DLong "CICEAttributeDataArray2DLong"
	\li \ref CICEAttributeDataArray2DBool "CICEAttributeDataArray2DBool"
	\li \ref CICEAttributeDataArray2DVector2f "CICEAttributeDataArray2DVector2f"
	\li \ref CICEAttributeDataArray2DVector3f "CICEAttributeDataArray2DVector3f"
	\li \ref CICEAttributeDataArray2DVector4f "CICEAttributeDataArray2DVector4f"
	\li \ref CICEAttributeDataArray2DQuaternionf "CICEAttributeDataArray2DQuaternionf"
	\li \ref CICEAttributeDataArray2DRotationf "CICEAttributeDataArray2DRotationf"
	\li \ref CICEAttributeDataArray2DMatrix3f "CICEAttributeDataArray2DMatrix3f"
	\li \ref CICEAttributeDataArray2DMatrix4f "CICEAttributeDataArray2DMatrix4f"
	\li \ref CICEAttributeDataArray2DColor4f "CICEAttributeDataArray2DColor4f"
	\li \ref CICEAttributeDataArray2DShape "CICEAttributeDataArray2DShape"


	\section CICEAttributeDataArray2DFloat CICEAttributeDataArray2DFloat Type
	\code typedef XSI::CICEAttributeDataArray2D< float > CICEAttributeDataArray2DFloat \endcode
	A CICEAttributeDataArray2D class of type \c float.
	\since 7.0

	\section CICEAttributeDataArray2DLong CICEAttributeDataArray2DLong Type
	\code typedef XSI::CICEAttributeDataArray2D< LONG > CICEAttributeDataArray2DLong \endcode
	A CICEAttributeDataArray2D class of type \c LONG.
	\since 7.0

	\section CICEAttributeDataArray2DBool CICEAttributeDataArray2DBool Type
	\code typedef XSI::CICEAttributeDataArray2D< bool > CICEAttributeDataArray2DBool \endcode
	A CICEAttributeDataArray2D class of type \c bool.
	\since 7.0

	\section CICEAttributeDataArray2DVector2f CICEAttributeDataArray2DVector2f Type
	\code typedef XSI::CICEAttributeDataArray2D< CVector2f > CICEAttributeDataArray2DVector2f \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CVector2f CVector2f\endlink.
	\since 7.0

	\section CICEAttributeDataArray2DVector3f CICEAttributeDataArray2DVector3f Type
	\code typedef XSI::CICEAttributeDataArray2D< CVector3f > CICEAttributeDataArray2DVector3f \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CVector3f CVector3f\endlink.
	\since 7.0

	\section CICEAttributeDataArray2DVector4f CICEAttributeDataArray2DVector4f Type
	\code typedef XSI::CICEAttributeDataArray2D< CVector4f > CICEAttributeDataArray2DVector4f \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CVector4f CVector4f\endlink.
	\since 7.0

	\section CICEAttributeDataArray2DQuaternionf CICEAttributeDataArray2DQuaternionf Type
	\code typedef XSI::CICEAttributeDataArray2D< Quaternionf > CICEAttributeDataArray2DQuaternionf \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CQuaternionf CQuaternionf\endlink.
	\since 7.0

	\section CICEAttributeDataArray2DRotationf CICEAttributeDataArray2DRotationf Type
	\code typedef XSI::CICEAttributeDataArray2D< CRotationf > CICEAttributeDataArray2DRotationf \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CRotationf CRotationf\endlink.
	\since 7.0

	\section CICEAttributeDataArray2DMatrix3f CICEAttributeDataArray2DMatrix3f Type
	\code typedef XSI::CICEAttributeDataArray2D< CMatrix3f > CICEAttributeDataArray2DMatrix3f \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CMatrix3f CMatrix3f\endlink
	\since 7.0

	\section CICEAttributeDataArray2DMatrix4f CICEAttributeDataArray2DMatrix4f Type
	\code typedef XSI::CICEAttributeDataArray2D< CMatrix4f > CICEAttributeDataArray2DMatrix4f \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CMatrix4f CMatrix4f\endlink.
	\since 7.0

	\section CICEAttributeDataArray2DColor4f CICEAttributeDataArray2DColor4f Type
	\code typedef XSI::CICEAttributeDataArray2D< CColor4f > CICEAttributeDataArray2DColor4f \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CColor4f CColor4f\endlink.
	\since 7.0

	\section CICEAttributeDataArray2DShape CICEAttributeDataArray2DShape Type
	\code typedef XSI::CICEAttributeDataArray2D< CShape > CICEAttributeDataArray2DShape \endcode
	A CICEAttributeDataArray2D class of type \link MATH::CShape CShape\endlink.
	\since 7.0
*/
typedef XSI::CICEAttributeDataArray2D< float > CICEAttributeDataArray2DFloat;
typedef XSI::CICEAttributeDataArray2D< LONG > CICEAttributeDataArray2DLong;
typedef XSI::CICEAttributeDataArray2D< bool > CICEAttributeDataArray2DBool;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CVector2f > CICEAttributeDataArray2DVector2f;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CVector3f > CICEAttributeDataArray2DVector3f;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CVector4f > CICEAttributeDataArray2DVector4f;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CQuaternionf > CICEAttributeDataArray2DQuaternionf;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CRotationf > CICEAttributeDataArray2DRotationf;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CMatrix3f > CICEAttributeDataArray2DMatrix3f;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CMatrix4f > CICEAttributeDataArray2DMatrix4f;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CColor4f > CICEAttributeDataArray2DColor4f;
typedef XSI::CICEAttributeDataArray2D< XSI::MATH::CShape > CICEAttributeDataArray2DShape;

template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DBool::GetDefaultType( ){return siICENodeDataBool;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DFloat::GetDefaultType( ){return siICENodeDataFloat;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DLong::GetDefaultType( ){return siICENodeDataLong;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DVector2f::GetDefaultType( ){return siICENodeDataVector2;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DVector3f::GetDefaultType( ){return siICENodeDataVector3;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DVector4f::GetDefaultType( ){return siICENodeDataVector4;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DQuaternionf::GetDefaultType( ){return siICENodeDataQuaternion;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DMatrix3f::GetDefaultType( ){return siICENodeDataMatrix33;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DMatrix4f::GetDefaultType( ){return siICENodeDataMatrix44;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DColor4f::GetDefaultType( ){return siICENodeDataColor4;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DRotationf::GetDefaultType( ){return siICENodeDataRotation;}
template<> SICPPSDK_INLINE XSI::siICENodeDataType CICEAttributeDataArray2DShape::GetDefaultType( ){return siICENodeDataShape;}

};

#endif // __XSIICEATTRIBUTEDATAARRAY2D_H__
