//*****************************************************************************
/*!
   \file xsi_icenodedef.h
   \brief ICENodeDef class declaration.

    Copyright 1998-2007 Avid Technology, Inc. and its licensors. All rights
   reserved. This file contains confidential and proprietary information of
   Avid Technology, Inc., and is subject to the terms of the SOFTIMAGE|XSI
   end user license agreement (or EULA).
*/
//*****************************************************************************

#if (_MSC_VER > 1000) || defined(SGI_COMPILER)
#pragma once
#endif

#ifndef __XSIICENODEDEF_H__
#define __XSIICENODEDEF_H__

#include <xsi_base.h>
#include <xsi_value.h>

namespace XSI {

//*****************************************************************************
/*! \class ICENodeDef xsi_icenodedef.h
	\brief %ICENodeDef objects are used for describing a unique custom ICENode object.
	Instances of this object are used to register custom ICENode objects with
	PluginRegistrar::RegisterICENode.

	\sa ICENode, PluginRegistrar::RegisterICENode, \xt cb_icenodes %ICENode Callbacks \endxt
	\since 7.0
*/
//*****************************************************************************

class SICPPSDKDECL ICENodeDef : public CBase
{
public:

	/*! Default constructor. */
	ICENodeDef();

	/*! Default destructor. */
	~ICENodeDef();

	/*! Constructor.
	\param in_ref constant reference object.
	*/
	ICENodeDef(const CRef& in_ref);

	/*! Copy constructor.
	\param in_obj constant class object.
	*/
	ICENodeDef(const ICENodeDef& in_obj);

	/*! Returns true if a given class type is compatible with this API class.
	\param in_ClassID class type.
	\return true if the class is compatible, false otherwise.
	*/
	bool IsA( siClassID in_ClassID) const;

	/*! Returns the type of the API class.
	\return The class type.
	*/
	siClassID GetClassID() const;

	/*! Creates an object from another object.
	\param in_obj constant class object.
	\return The new ICENodeDef object.
	*/
	ICENodeDef& operator=(const ICENodeDef& in_obj);

	/*! Creates an object from a reference object. The newly created object is
	set to empty if the input reference object is not compatible.
	\param in_ref constant class object.
	\return The new ICENodeDef object.
	*/
	ICENodeDef& operator=(const CRef& in_ref);

	/*! Sets this ICENode threading model as single or multi threading. By default ICENode objects
	are evaluated in a multi-threading process where the evaluation is performed in several passes.
	Single thread processing on the other hand performs an evaluation in one single pass which allows
	the node to get all the input data in one single chunk.

	\param in_nModel Threading model value.
	\return CStatus::OK Success.
	\return CStatus::Fail Operation failed.
	\sa ICENodeDef::GetThreadingModel
	*/
	CStatus PutThreadingModel( siICENodeThreadingModel in_nModel );

	/*! Returns the threading model for this ICENode.
	\return ICENode threading model.
	\sa ICENodeDef::PutThreadingModel
	*/
	siICENodeThreadingModel GetThreadingModel( ) const;

	/*! Adds a port group to this ICENode definition. %Port groups must be defined with a unique identifier.

	\param in_uniqueGroupId The port group unique identifier.
	\param in_nMin Minimum number of objects required for a connection.
	\param in_nMax Maximum number of objects allowed to be connected.
	\param in_strPrompt Prompt to display during picking session.
	\return The returned status code (CStatus::OK for success).
	*/
	CStatus	AddPortGroup(	ULONG in_uniqueGroupId,
							ULONG in_nMin=1,
							ULONG in_nMax=1,
							const CString in_strPrompt=CString() );

	/*! Adds an input port to this ICENode definition. Ports must be defined with a unique identifier.
	\param in_uniquePortId The port unique identifier.
	\param in_uniqueGroupId The port group unique identifier.
	\param in_nDataType The port data type (see \link siICENodeDataType \endlink).
	\param in_nStructType The structure type of the port data (see \link siICENodeStructureType \endlink).
	\param in_nContextType The context type of the port data (see \link siICENodeContextType \endlink).
	\param in_strName The port name.
	\param in_strScriptName The port scripting name.
	\param in_defaultVal The port default value.
	\param in_typeMapId The type map id for this port.
	\param in_structMapId The struct map id for this port.
	\param in_contextMapId The context map id for this port.
	\return The returned status code (CStatus::OK for success).
	*/
	CStatus	AddInputPort(	ULONG in_uniquePortId,
							ULONG in_uniqueGroupId,
							ULONG in_nDataType,
							ULONG in_nStructType,
							ULONG in_nContextType,
							const CString& in_strName,
							const CString& in_strScriptName,
							const CValue& in_defaultVal = CValue(),
							ULONG in_typeMapId = ULONG_MAX,
							ULONG in_structMapId = ULONG_MAX,
							ULONG in_contextMapId = ULONG_MAX );

	/*! Adds an output port to this ICENode definition. Ports must be defined with a unique identifier.
	\param in_uniquePortId The port unique identifier.
	\param in_uniqueGroupId The port group unique identifier.
	\param in_nDataType The port data type (see \link siICENodeDataType \endlink).
	\param in_nStructType The structure type of the port data (see \link siICENodeStructureType \endlink).
	\param in_nContextType The context type of the port data (see \link siICENodeContextType \endlink).
	\param in_strName The port name.
	\param in_strScriptName The port scripting name.
	\param in_typeMapId The type map id for this port.
	\param in_structMapId The struct map id for this port.
	\param in_contextMapId The context map id for this port.
	\return The returned status code (CStatus::OK for success).
	*/
	CStatus	AddOutputPort(	ULONG in_uniquePortId,
							ULONG in_uniqueGroupId,
							ULONG in_nDataType,
							ULONG in_nStructType,
							ULONG in_nContextType,
							const CString& in_strName,
							const CString& in_strScriptName,
							ULONG in_typeMapId = ULONG_MAX,
							ULONG in_structMapId = ULONG_MAX,
							ULONG in_contextMapId = ULONG_MAX );

	private:
	ICENodeDef * operator&() const;
	ICENodeDef * operator&();
};

};
#endif // __XSIICENODEDEF_H__
