@echo ==============================================
@echo -
@echo -XSICryExporter Addon Packer and files Updater
@echo -
@echo ==============================================

@set CRY_ADDON_ROOT=C:\users\%USERNAME%\Autodesk\Softimage_7.5\Addons\Crytek Addon
@set XSI_ADDONS_ROOT=C:\users\%USERNAME%\Autodesk\Softimage_7.5\Addons

@echo ----------------------------------------------
@echo Deleting old files...
@echo ----------------------------------------------

del /F "..\..\..\tools\Crytek Addon.xsiaddon"
del /F "%XSI_ADDONS_ROOT%\Crytek Addon.xsiaddon"
del /F "%XSI_ADDONS_ROOT%\Crytek Addon\Application\Plugins\XSICryExport*.dll"
del /F "%XSI_ADDONS_ROOT%\Crytek Addon\Application\Plugins\XSICryExport*.pdb"

@if exist "%XSI_ADDONS_ROOT%\Crytek Addon\Application\Plugins\XSICryExport.64.dll" goto XSIrunning
@if exist "%XSI_ADDONS_ROOT%\Crytek Addon\Application\Plugins\XSICryExport.dll" goto XSIrunning

@echo ----------------------------------------------
@echo Create tree in the XSI plugin folder...
@echo ----------------------------------------------

rd /Q /S "%CRY_ADDON_ROOT%"
md "%CRY_ADDON_ROOT%"
md "%CRY_ADDON_ROOT%\Application"
md "%CRY_ADDON_ROOT%\Application\bin"
md "%CRY_ADDON_ROOT%\Application\bin\nt-x86"
md "%CRY_ADDON_ROOT%\Application\bin\nt-x86-64"
md "%CRY_ADDON_ROOT%\Application\CommandMaps"
md "%CRY_ADDON_ROOT%\Application\plugins"
md "%CRY_ADDON_ROOT%\Application\spdl"
md "%CRY_ADDON_ROOT%\Data"
md "%CRY_ADDON_ROOT%\Data\DSPresets"
md "%CRY_ADDON_ROOT%\Data\DSPResets\Shaders"
md "%CRY_ADDON_ROOT%\Data\DSPResets\Shaders\Material"
md "%CRY_ADDON_ROOT%\Data\DSPResets\Shaders\RealTime"

@echo ----------------------------------------------
@echo Copying files...
@echo ----------------------------------------------

xcopy /R /Y "Result\Win32\Release\XSICryExport.dll"  "%CRY_ADDON_ROOT%\Application\Plugins\"
xcopy /R /Y "Result\x64\Release\XSICryExport.64.dll" "%CRY_ADDON_ROOT%\Application\Plugins\"

xcopy /R /Y "..\XSICrytekRTS\Application\bin\nt-x86\CrytekRTS.dll" "%CRY_ADDON_ROOT%\Application\bin\nt-x86\"
xcopy /R /Y "..\XSICrytekRTS\Application\bin\nt-x86-64\CrytekRTS.dll" "%CRY_ADDON_ROOT%\Application\bin\nt-x86-64\"

xcopy /R /Y "..\XSICryExport\shader\CryShader.spdl" "%CRY_ADDON_ROOT%\Application\spdl"
xcopy /R /Y "..\XSICryExport\shader\CrytekVertexColor.spdl" "%CRY_ADDON_ROOT%\Application\spdl"

xcopy /R /Y "..\XSICryExport\shader\CryShader.spdl" "%CRY_ADDON_ROOT%\Data\DSPresets\Shaders\Material"
xcopy /R /Y "..\XSICryExport\shader\CryShader.Preset" "%CRY_ADDON_ROOT%\Data\DSPresets\Shaders\Material"
xcopy /R /Y "..\XSICryExport\shader\CrytekVertexColor.spdl" "%CRY_ADDON_ROOT%\Data\DSPresets\Shaders\RealTime"

@echo ----------------------------------------------
@echo Packing xsiaddon...
@echo ----------------------------------------------

@if exist pack.vbs del /F pack.vbs
@echo Application.LogMessage "Packaging started."  > pack.vbs
@echo PackageAddon "%XSI_ADDONS_ROOT%\Crytek Addon\", "%XSI_ADDONS_ROOT%", True, "src;Debug;Ship" >> pack.vbs
@echo Application.LogMessage "Packaging finished." >> pack.vbs
call C:\Softimage\Softimage_7.5_x64\Application\bin\XSIbatch.bat -script pack.vbs
@if exist pack.vbs del /F pack.vbs

@if exist "%XSI_ADDONS_ROOT%\Crytek Addon.xsiaddon" goto step2

:failedToPack
@echo Cannot create Crytek Addon.xsiaddon, probably because of lack of XSI network licenses.
@pause
@goto done

:XSIrunning
@echo Cannot create Crytek Addon.xsiaddon. Looks like an XSI session is opened. Close XSI and check that you have no XSI.exe in the task manager.
@pause
@goto done

:step2
xcopy /R /Y "%XSI_ADDONS_ROOT%\Crytek Addon.xsiaddon" ..\..\..\tools
xcopy /R /Y "Result\Win32\Release\XSICryExport.pdb"  "%XSI_ADDONS_ROOT%\Crytek Addon\Application\Plugins\"
xcopy /R /Y "Result\x64\Release\XSICryExport.64.pdb" "%XSI_ADDONS_ROOT%\Crytek Addon\Application\Plugins\"

:done
@echo Done.