//------------------------------------------------------------------------------
/*
	@brief		DDS File Type Plugin for Paint.NET

	@note		Copyright (c) 2006 Dean Ashton         http://www.dmashton.co.uk

	Permission is hereby granted, free of charge, to any person obtaining
	a copy of this software and associated documentation files (the 
	"Software"), to	deal in the Software without restriction, including
	without limitation the rights to use, copy, modify, merge, publish,
	distribute, sublicense, and/or sell copies of the Software, and to 
	permit persons to whom the Software is furnished to do so, subject to 
	the following conditions:

	The above copyright notice and this permission notice shall be included
	in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
	MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
	CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
	TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
**/
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

namespace DdsFileTypePlugin
{
	class DdsSaveConfigWidget : PaintDotNet.SaveConfigWidget
	{
		private System.Windows.Forms.RadioButton rangeFit;
		private System.Windows.Forms.RadioButton clusterFit;
		private System.Windows.Forms.RadioButton iterativeFit;
		private System.Windows.Forms.RadioButton uniformMetric;
		private System.Windows.Forms.RadioButton perceptualMetric;
		private System.Windows.Forms.CheckBox weightColourByAlpha;
		private System.Windows.Forms.ComboBox fileFormatList;
		private System.Windows.Forms.CheckBox generateMipMaps;
		private PaintDotNet.HeaderLabel compressorTypeLabel;
		private PaintDotNet.HeaderLabel	errorMetricLabel;
		private PaintDotNet.HeaderLabel additionalOptionsLabel;
		private System.Windows.Forms.Panel compressorTypePanel;
		private System.Windows.Forms.Panel errorMetricPanel;
		private	System.Windows.Forms.Panel additionalOptionsPanel;
	
		public DdsSaveConfigWidget()
        {
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
        }

        protected override void InitFileType()
        {
            this.fileType = new DdsFileType();
        }

        protected override void InitTokenFromWidget()
        {
			((DdsSaveConfigToken)this.token).m_fileFormat			= ( DdsFileFormat)this.fileFormatList.SelectedIndex;
			if ( this.clusterFit.Checked )
				((DdsSaveConfigToken)this.token).m_compressorType = 0;
			else
			if ( this.rangeFit.Checked )
				((DdsSaveConfigToken)this.token).m_compressorType = 1;
			else
				((DdsSaveConfigToken)this.token).m_compressorType = 2;

			((DdsSaveConfigToken)this.token).m_errorMetric			= this.perceptualMetric.Checked ? 0 : 1;
			((DdsSaveConfigToken)this.token).m_weightColourByAlpha	= this.weightColourByAlpha.Checked;
			((DdsSaveConfigToken)this.token).m_generateMipMaps		= this.generateMipMaps.Checked;
        }

        protected override void InitWidgetFromToken(SaveConfigToken token)
        {
			if (token is DdsSaveConfigToken)
			{
				DdsSaveConfigToken ddsToken = (DdsSaveConfigToken)token;
				this.fileFormatList.SelectedIndex	= ( int )ddsToken.m_fileFormat;

				this.clusterFit.Checked				= ( ddsToken.m_compressorType == 0 );
				this.rangeFit.Checked				= ( ddsToken.m_compressorType == 1 );
				this.iterativeFit.Checked			= ( ddsToken.m_compressorType == 2 );

				this.perceptualMetric.Checked		= ( ddsToken.m_errorMetric == 0 );
				this.uniformMetric.Checked			= !this.perceptualMetric.Checked;

				this.weightColourByAlpha.Checked	= ddsToken.m_weightColourByAlpha;

				this.generateMipMaps.Checked		= ddsToken.m_generateMipMaps;
			}
			else
			{
				this.fileFormatList.SelectedIndex	= 0;

				this.clusterFit.Checked				= true;
				this.rangeFit.Checked				= false;
				this.iterativeFit.Checked			= false;

				this.perceptualMetric.Checked		= true;
				this.uniformMetric.Checked			= false;

				this.weightColourByAlpha.Checked	= false;

				this.generateMipMaps.Checked		= false;
			}
		}

		private void InitializeComponent()
		{
			this.rangeFit = new System.Windows.Forms.RadioButton();
			this.clusterFit = new System.Windows.Forms.RadioButton();
			this.iterativeFit = new System.Windows.Forms.RadioButton();
			this.uniformMetric = new System.Windows.Forms.RadioButton();
			this.perceptualMetric = new System.Windows.Forms.RadioButton();
			this.generateMipMaps = new System.Windows.Forms.CheckBox();
			this.weightColourByAlpha = new System.Windows.Forms.CheckBox();
			this.fileFormatList = new System.Windows.Forms.ComboBox();
			this.compressorTypeLabel = new PaintDotNet.HeaderLabel();
			this.errorMetricLabel = new PaintDotNet.HeaderLabel();
			this.additionalOptionsLabel = new PaintDotNet.HeaderLabel();
			this.compressorTypePanel = new System.Windows.Forms.Panel();
			this.errorMetricPanel = new System.Windows.Forms.Panel();
			this.additionalOptionsPanel = new System.Windows.Forms.Panel();
			this.compressorTypePanel.SuspendLayout();
			this.errorMetricPanel.SuspendLayout();
			this.additionalOptionsPanel.SuspendLayout();
			this.SuspendLayout();
			// 
			// rangeFit
			// 
			this.rangeFit.AutoSize = true;
			this.rangeFit.Location = new System.Drawing.Point(0, 0);
			this.rangeFit.Name = "rangeFit";
			this.rangeFit.Size = new System.Drawing.Size(116, 17);
			this.rangeFit.TabIndex = 1;
			this.rangeFit.TabStop = true;
			this.rangeFit.Text = "Range fit (Fast/LQ)";
			this.rangeFit.UseVisualStyleBackColor = true;
			this.rangeFit.CheckedChanged += new System.EventHandler(this.rangeFit_CheckedChanged);
			// 
			// clusterFit
			// 
			this.clusterFit.AutoSize = true;
			this.clusterFit.Location = new System.Drawing.Point(0, 23);
			this.clusterFit.Name = "clusterFit";
			this.clusterFit.Size = new System.Drawing.Size(121, 17);
			this.clusterFit.TabIndex = 0;
			this.clusterFit.TabStop = true;
			this.clusterFit.Text = "Cluster fit (Slow/HQ)";
			this.clusterFit.UseVisualStyleBackColor = true;
			this.clusterFit.CheckedChanged += new System.EventHandler(this.clusterFit_CheckedChanged);
			// 
			// iterativeFit
			// 
			this.iterativeFit.AutoSize = true;
			this.iterativeFit.Location = new System.Drawing.Point(0, 46);
			this.iterativeFit.Name = "iterativeFit";
			this.iterativeFit.Size = new System.Drawing.Size(141, 17);
			this.iterativeFit.TabIndex = 2;
			this.iterativeFit.TabStop = true;
			this.iterativeFit.Text = "Iterative fit (Slowest/HQ)";
			this.iterativeFit.UseVisualStyleBackColor = true;
			this.iterativeFit.CheckedChanged += new System.EventHandler(this.iterativeFit_CheckedChanged);
			// 
			// uniformMetric
			// 
			this.uniformMetric.AutoSize = true;
			this.uniformMetric.Location = new System.Drawing.Point(0, 0);
			this.uniformMetric.Name = "uniformMetric";
			this.uniformMetric.Size = new System.Drawing.Size(61, 17);
			this.uniformMetric.TabIndex = 1;
			this.uniformMetric.TabStop = true;
			this.uniformMetric.Text = "Uniform";
			this.uniformMetric.UseVisualStyleBackColor = true;
			this.uniformMetric.CheckedChanged += new System.EventHandler(this.uniformMetric_CheckedChanged);
			// 
			// perceptualMetric
			// 
			this.perceptualMetric.AutoSize = true;
			this.perceptualMetric.Location = new System.Drawing.Point(0, 23);
			this.perceptualMetric.Name = "perceptualMetric";
			this.perceptualMetric.Size = new System.Drawing.Size(76, 17);
			this.perceptualMetric.TabIndex = 0;
			this.perceptualMetric.TabStop = true;
			this.perceptualMetric.Text = "Perceptual";
			this.perceptualMetric.UseVisualStyleBackColor = true;
			this.perceptualMetric.CheckedChanged += new System.EventHandler(this.perceptualMetric_CheckedChanged);
			// 
			// generateMipMaps
			// 
			this.generateMipMaps.AutoSize = true;
			this.generateMipMaps.Location = new System.Drawing.Point(0, 23);
			this.generateMipMaps.Name = "generateMipMaps";
			this.generateMipMaps.Size = new System.Drawing.Size(119, 17);
			this.generateMipMaps.TabIndex = 1;
			this.generateMipMaps.Text = "Generate Mip Maps";
			this.generateMipMaps.UseVisualStyleBackColor = true;
			this.generateMipMaps.CheckedChanged += new System.EventHandler(this.generateMipLevels_CheckedChanged);
			// 
			// weightColourByAlpha
			// 
			this.weightColourByAlpha.AutoSize = true;
			this.weightColourByAlpha.Location = new System.Drawing.Point(0, 0);
			this.weightColourByAlpha.Name = "weightColourByAlpha";
			this.weightColourByAlpha.Size = new System.Drawing.Size(138, 17);
			this.weightColourByAlpha.TabIndex = 0;
			this.weightColourByAlpha.Text = "Weight Colour By Alpha";
			this.weightColourByAlpha.UseVisualStyleBackColor = true;
			this.weightColourByAlpha.CheckedChanged += new System.EventHandler(this.weightColourByAlpha_CheckedChanged);
			// 
			// fileFormatList
			// 
			this.fileFormatList.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.fileFormatList.FormattingEnabled = true;
			this.fileFormatList.Items.AddRange(new object[] {
            "DXT1 (Opaque/1-bit Alpha)",
            "DXT3 (Explicit Alpha)",
            "DXT5 (Interpolated Alpha)",
            "A8R8G8B8",
            "X8R8G8B8",
            "A8B8G8R8",
            "X8B8G8R8",
            "A1R5G5B5",
            "A4R4G4B4",
            "R8G8B8",
            "R5G6B5"});
			this.fileFormatList.Location = new System.Drawing.Point(4, 0);
			this.fileFormatList.Name = "fileFormatList";
			this.fileFormatList.Size = new System.Drawing.Size(168, 21);
			this.fileFormatList.TabIndex = 4;
			this.fileFormatList.SelectedIndexChanged += new System.EventHandler(this.fileFormatList_SelectedIndexChanged);
			// 
			// compressorTypeLabel
			// 
			this.compressorTypeLabel.Location = new System.Drawing.Point(5, 27);
			this.compressorTypeLabel.Name = "compressorTypeLabel";
			this.compressorTypeLabel.Size = new System.Drawing.Size(144, 14);
			this.compressorTypeLabel.TabIndex = 5;
			this.compressorTypeLabel.TabStop = false;
			this.compressorTypeLabel.Text = "Compressor Type";
			// 
			// errorMetricLabel
			// 
			this.errorMetricLabel.Location = new System.Drawing.Point(5, 111);
			this.errorMetricLabel.Name = "errorMetricLabel";
			this.errorMetricLabel.Size = new System.Drawing.Size(144, 14);
			this.errorMetricLabel.TabIndex = 6;
			this.errorMetricLabel.TabStop = false;
			this.errorMetricLabel.Text = "Error Metric";
			// 
			// additionalOptionsLabel
			// 
			this.additionalOptionsLabel.Location = new System.Drawing.Point(4, 171);
			this.additionalOptionsLabel.Name = "additionalOptionsLabel";
			this.additionalOptionsLabel.Size = new System.Drawing.Size(144, 14);
			this.additionalOptionsLabel.TabIndex = 7;
			this.additionalOptionsLabel.TabStop = false;
			this.additionalOptionsLabel.Text = "Additional Options";
			// 
			// compressorTypePanel
			// 
			this.compressorTypePanel.Controls.Add(this.rangeFit);
			this.compressorTypePanel.Controls.Add(this.clusterFit);
			this.compressorTypePanel.Controls.Add(this.iterativeFit);
			this.compressorTypePanel.Location = new System.Drawing.Point(16, 42);
			this.compressorTypePanel.Name = "compressorTypePanel";
			this.compressorTypePanel.Size = new System.Drawing.Size(138, 63);
			this.compressorTypePanel.TabIndex = 5;
			// 
			// errorMetricPanel
			// 
			this.errorMetricPanel.Controls.Add(this.uniformMetric);
			this.errorMetricPanel.Controls.Add(this.perceptualMetric);
			this.errorMetricPanel.Location = new System.Drawing.Point(16, 125);
			this.errorMetricPanel.Name = "errorMetricPanel";
			this.errorMetricPanel.Size = new System.Drawing.Size(138, 45);
			this.errorMetricPanel.TabIndex = 0;
			// 
			// additionalOptionsPanel
			// 
			this.additionalOptionsPanel.Controls.Add(this.generateMipMaps);
			this.additionalOptionsPanel.Controls.Add(this.weightColourByAlpha);
			this.additionalOptionsPanel.Location = new System.Drawing.Point(16, 191);
			this.additionalOptionsPanel.Name = "additionalOptionsPanel";
			this.additionalOptionsPanel.Size = new System.Drawing.Size(138, 43);
			this.additionalOptionsPanel.TabIndex = 0;
			// 
			// DdsSaveConfigWidget
			// 
			this.AutoScaleDimensions = new System.Drawing.SizeF(96F, 96F);
			this.Controls.Add(this.fileFormatList);
			this.Controls.Add(this.compressorTypePanel);
			this.Controls.Add(this.compressorTypeLabel);
			this.Controls.Add(this.errorMetricPanel);
			this.Controls.Add(this.errorMetricLabel);
			this.Controls.Add(this.additionalOptionsPanel);
			this.Controls.Add(this.additionalOptionsLabel);
			this.Name = "DdsSaveConfigWidget";
			this.Size = new System.Drawing.Size(175, 238);
			this.compressorTypePanel.ResumeLayout(false);
			this.compressorTypePanel.PerformLayout();
			this.errorMetricPanel.ResumeLayout(false);
			this.errorMetricPanel.PerformLayout();
			this.additionalOptionsPanel.ResumeLayout(false);
			this.additionalOptionsPanel.PerformLayout();
			this.ResumeLayout(false);

		}

		private void CommonCompressorTypeChangeHandling(object sender, EventArgs e)
		{
			this.clusterFit.Enabled = ( this.fileFormatList.SelectedIndex < 3 );
			this.rangeFit.Enabled = ( this.fileFormatList.SelectedIndex < 3 );
			this.iterativeFit.Enabled = ( this.fileFormatList.SelectedIndex < 3 );
			this.weightColourByAlpha.Enabled = ( this.clusterFit.Checked || this.iterativeFit.Checked ) && ( this.fileFormatList.SelectedIndex < 3 );
			this.uniformMetric.Enabled = ( this.fileFormatList.SelectedIndex < 3 );
			this.perceptualMetric.Enabled = ( this.fileFormatList.SelectedIndex < 3 );
			this.UpdateToken();
		}

		private void fileFormatList_SelectedIndexChanged(object sender, EventArgs e)
		{
			CommonCompressorTypeChangeHandling( sender, e );
		}

		private void clusterFit_CheckedChanged(object sender, EventArgs e)
		{
			CommonCompressorTypeChangeHandling( sender, e );
		}

		private void rangeFit_CheckedChanged(object sender, EventArgs e)
		{
			CommonCompressorTypeChangeHandling( sender, e );
		}

		private void iterativeFit_CheckedChanged(object sender, EventArgs e)
		{
			CommonCompressorTypeChangeHandling( sender, e );
		}

		private void perceptualMetric_CheckedChanged(object sender, EventArgs e)
		{
			this.UpdateToken();
		}

		private void uniformMetric_CheckedChanged(object sender, EventArgs e)
		{
			this.UpdateToken();
		}

		private void weightColourByAlpha_CheckedChanged(object sender, EventArgs e)
		{
			this.UpdateToken();
		}

		private void generateMipLevels_CheckedChanged(object sender, EventArgs e)
		{
			this.UpdateToken();
		}
	}
}
