﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;
using StatsDataSource.Core;
using System.Drawing;

namespace SamplePlugin
{
	class Explosion
	{
		public PointF Position;
		public GameEvent Event;

		public override string ToString()
		{
			GameState nameState = Event.Group.Node.FindState("name");
			return string.Format("{0} [{1}, {2}]", nameState != null ? nameState.Value : "unknown", Position.X, Position.Y);
		}
	}

	class ExplodeCollectVisitor : IStatsVisitor
	{
		int explodeId;

		public List<Explosion> Explosions = new List<Explosion>();

		public ExplodeCollectVisitor(StatsRepository repo)
		{
			StatDesc desc = repo.Registry.GetEventDesc("explode");
			explodeId = desc != null ? desc.ID : -1;
		}

		public bool VisitScope(GameScope scope)
		{
			return true;
		}

		public void LeaveScope(GameScope scope) { }

		public bool VisitElement(GameElement elem)
		{
			return true;
		}

		public void LeaveElement(GameElement elem) { }

		public bool VisitState(GameState state)
		{
			return false;
		}

		public void LeaveState(GameState state) { }

		public bool StartEventGroups(GameNode node)
		{
			return true;
		}

		public bool VisitEventGroup(GameEventGroup evntGroup)
		{
			if (evntGroup.Desc.ID == explodeId)
			{
				foreach (GameEvent e in evntGroup.Events)
				{
					float x = float.Parse(e.Parameters["x"]);
					float y = float.Parse(e.Parameters["y"]);

					Explosions.Add(new Explosion { Position = new PointF(x, y), Event = e });
				}
			}

			return false;
		}

		public void LeaveEventGroup(GameEventGroup evntGroup) { }

		public void EndEventGroups(GameNode node) { }

		public void VisitEvent(GameEvent evnt) { }
	}
}
